/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.strategy;

import java.io.Serializable;
import java.util.ArrayList;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.strategy.IContributionTypeStrategy;
import org.lamsfoundation.lams.lesson.LearnerProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexActivityStrategy
implements Serializable,
IContributionTypeStrategy {
    public boolean areChildrenCompleted(LearnerProgress learnerProgress) {
        ComplexActivity complexActivity = this.getComplexActivity();
        int numOfCompletedActivities = 0;
        if (complexActivity != null) {
            for (Activity currentActivity : complexActivity.getActivities()) {
                if (!learnerProgress.getCompletedActivities().contains(currentActivity)) continue;
                ++numOfCompletedActivities;
            }
        }
        return this.isComplete(numOfCompletedActivities);
    }

    protected abstract boolean isComplete(int var1);

    public abstract Activity getNextActivityByParent(ComplexActivity var1, Activity var2);

    protected abstract ComplexActivity getComplexActivity();

    protected Activity getActivity() {
        return this.getComplexActivity();
    }

    @Override
    public Integer[] getContributionType() {
        ArrayList<Integer> contributionTypes = new ArrayList<Integer>();
        this.setUpContributionType(contributionTypes);
        return contributionTypes.toArray(new Integer[contributionTypes.size()]);
    }

    protected void setUpContributionType(ArrayList<Integer> contributionTypes) {
    }
}

