/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;

public class Role
implements Serializable,
Comparable {
    public static final String LEARNER = "LEARNER";
    public static final String MONITOR = "MONITOR";
    public static final String AUTHOR = "AUTHOR";
    public static final String AUTHOR_ADMIN = "AUTHOR ADMIN";
    public static final String GROUP_MANAGER = "GROUP MANAGER";
    public static final String GROUP_ADMIN = "GROUP ADMIN";
    public static final String SYSADMIN = "SYSADMIN";
    public static final Integer ROLE_SYSADMIN = new Integer(1);
    public static final Integer ROLE_GROUP_MANAGER = new Integer(2);
    public static final Integer ROLE_AUTHOR = new Integer(3);
    public static final Integer ROLE_MONITOR = new Integer(4);
    public static final Integer ROLE_LEARNER = new Integer(5);
    public static final Integer ROLE_GROUP_ADMIN = new Integer(6);
    public static final Integer ROLE_AUTHOR_ADMIN = new Integer(7);
    private Integer roleId;
    private String name;
    private String description;
    private Set userOrganisationRoles;
    private Set rolePrivileges;

    public Role(String name, String description, Set userOrganisationRoles) {
        this.name = name;
        this.description = description;
        this.userOrganisationRoles = userOrganisationRoles;
    }

    public Role() {
    }

    public Role(String name, Set userOrganisationRoles) {
        this.name = name;
        this.userOrganisationRoles = userOrganisationRoles;
    }

    public Integer getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Integer roleId) {
        this.roleId = roleId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set getUserOrganisationRoles() {
        return this.userOrganisationRoles;
    }

    public void setUserOrganisationRoles(Set userOrganisationRoles) {
        this.userOrganisationRoles = userOrganisationRoles;
    }

    public Set getRolePrivileges() {
        return this.rolePrivileges;
    }

    public void setRolePrivileges(Set rolePrivileges) {
        this.rolePrivileges = rolePrivileges;
    }

    public void addUserOrganisationRole(UserOrganisationRole userOrganisationRole) {
        if (this.userOrganisationRoles == null) {
            this.userOrganisationRoles = new HashSet();
        }
        this.userOrganisationRoles.add(userOrganisationRole);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("roleId", (Object)this.getRoleId()).toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Role)) {
            return false;
        }
        Role castOther = (Role)other;
        return new EqualsBuilder().append((Object)this.getRoleId(), (Object)castOther.getRoleId()).isEquals();
    }

    public int compareTo(Object role) {
        Role r = (Role)role;
        return this.name.compareTo(r.getName());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getRoleId()).toHashCode();
    }

    public boolean isAuthor() {
        return this.roleId.equals(ROLE_AUTHOR);
    }

    public boolean isGroupManager() {
        return this.roleId.equals(ROLE_GROUP_MANAGER);
    }

    public boolean isGroupAdmin() {
        return this.roleId.equals(ROLE_GROUP_ADMIN);
    }

    public boolean isMonitor() {
        return this.roleId.equals(ROLE_MONITOR);
    }

    public boolean isSysAdmin() {
        return this.roleId.equals(ROLE_SYSADMIN);
    }

    public boolean isAuthorAdmin() {
        return this.roleId.equals(ROLE_AUTHOR_ADMIN);
    }
}

