/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.wddx;

import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxDeserializer;
import com.allaire.wddx.WddxSerializer;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;
import org.xml.sax.InputSource;

public class WDDXProcessor {
    private static Logger logger = Logger.getLogger((String)WDDXProcessor.class.getName());
    WDDXProcessor m_theRealMe = null;

    private WDDXProcessor() {
    }

    WDDXProcessor getInstance() {
        if (this.m_theRealMe == null) {
            this.m_theRealMe = new WDDXProcessor();
        }
        return this.m_theRealMe;
    }

    public static String replaceNewline(String inputPacket) {
        String ret = null;
        if (inputPacket != null) {
            ret = inputPacket.replace("%0D%0A", "\r\n");
            ret = ret.replace("<char code='0a'/>", "\n");
            ret = ret.replace("<char code=\"0a\"/>", "\n");
        }
        return ret;
    }

    public static Object deserialize(String wddxPacket) throws WddxDeserializationException {
        Object result;
        String replacedString = WDDXProcessor.replaceNewline(wddxPacket);
        InputSource tempSource = new InputSource(new StringReader(replacedString));
        WddxDeserializer tempDeserializer = new WddxDeserializer("org.apache.xerces.parsers.SAXParser");
        try {
            result = tempDeserializer.deserialize(tempSource);
        }
        catch (IOException e) {
            throw new WddxDeserializationException((Exception)e);
        }
        return result;
    }

    public static String serialize(Object data) throws IOException {
        WddxSerializer tempws = new WddxSerializer();
        StringWriter tempsw = new StringWriter();
        tempws.serialize(data, (Writer)tempsw);
        return tempsw.toString();
    }

    public static Integer convertToInteger(Hashtable table, String key) throws WDDXProcessorConversionException {
        if (table.containsKey(key)) {
            return WDDXProcessor.convertToInteger(key, table.get(key));
        }
        return null;
    }

    public static Long convertToLong(Hashtable table, String key) throws WDDXProcessorConversionException {
        if (table.containsKey(key)) {
            return WDDXProcessor.convertToLong(key, table.get(key));
        }
        return null;
    }

    public static String convertToString(Hashtable table, String key) throws WDDXProcessorConversionException {
        if (table.containsKey(key)) {
            return WDDXProcessor.convertToString(key, table.get(key));
        }
        return null;
    }

    public static Boolean convertToBoolean(Hashtable table, String key) throws WDDXProcessorConversionException {
        if (table.containsKey(key)) {
            return WDDXProcessor.convertToBoolean(key, table.get(key));
        }
        return null;
    }

    public static Date convertToDate(Hashtable table, String key) throws WDDXProcessorConversionException {
        if (table.containsKey(key)) {
            return WDDXProcessor.convertToDate(key, table.get(key));
        }
        return null;
    }

    public static int convertToInt(String identifier, Object value) throws WDDXProcessorConversionException {
        int result = -255;
        if (value == null || WDDXProcessor.isNull(value)) {
            throw new WDDXProcessorConversionException(identifier + " is null, cannot convert to an int");
        }
        try {
            result = ((Number)value).intValue();
            return result;
        }
        catch (Exception e) {
            try {
                String textValue = (String)value;
                if (textValue.length() == 0) {
                    return -1;
                }
                double dTemp = Double.parseDouble(textValue);
                result = (int)dTemp;
            }
            catch (Exception e2) {
                throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to an int");
            }
            return result;
        }
    }

    public static Integer nullSafeCovertToInteger(String identifier, Object value) throws WDDXProcessorConversionException {
        if (value == null || WDDXProcessor.isNull(value)) {
            throw new IllegalArgumentException("[" + identifier + "] is null. We can't convert null value to integer");
        }
        return WDDXProcessor.convertToInteger(identifier, value);
    }

    public static Integer convertToInteger(String identifier, Object value) throws WDDXProcessorConversionException {
        Integer result = null;
        if (value == null || WDDXProcessor.isNull(value)) {
            return null;
        }
        try {
            return new Integer(((Number)value).intValue());
        }
        catch (Exception e) {
            try {
                String textValue = (String)value;
                if (textValue.length() == 0) {
                    return null;
                }
                int posPeriod = textValue.indexOf(46);
                if (posPeriod > 0) {
                    textValue = textValue.substring(0, posPeriod);
                }
                result = new Integer(textValue);
            }
            catch (Exception e2) {
                throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to an int");
            }
            return result;
        }
    }

    public static Long convertToLong(String identifier, Object value) throws WDDXProcessorConversionException {
        Long result = null;
        if (value == null || WDDXProcessor.isNull(value)) {
            return null;
        }
        try {
            return new Long(((Number)value).intValue());
        }
        catch (Exception e) {
            try {
                String textValue = (String)value;
                if (textValue.length() == 0) {
                    return null;
                }
                int posPeriod = textValue.indexOf(46);
                if (posPeriod > 0) {
                    textValue = textValue.substring(0, posPeriod);
                }
                result = new Long(textValue);
            }
            catch (Exception e2) {
                throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to an int");
            }
            return result;
        }
    }

    public static Boolean convertToBoolean(String identifier, Object value) throws WDDXProcessorConversionException {
        Boolean result = null;
        if (value == null || WDDXProcessor.isNull(value)) {
            return null;
        }
        try {
            return (Boolean)value;
        }
        catch (Exception e) {
            try {
                String textValue = (String)value;
                if (textValue.length() == 0) {
                    return null;
                }
                result = new Boolean(textValue);
                logger.debug((Object)("identifier " + identifier + " was String value " + value + " becomes " + result));
                return result;
            }
            catch (Exception e2) {
                throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to a Boolean");
            }
        }
    }

    public static String convertToString(String identifier, Object value) throws WDDXProcessorConversionException {
        if (value == null || WDDXProcessor.isNull(value)) {
            return null;
        }
        try {
            return (String)value;
        }
        catch (Exception e2) {
            throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to an String");
        }
    }

    public static Date convertToDate(String identifier, Object value) throws WDDXProcessorConversionException {
        Date result = null;
        if (value == null || WDDXProcessor.isNull(value)) {
            return null;
        }
        try {
            return (Date)value;
        }
        catch (Exception e) {
            try {
                String textValue = (String)value;
                if (textValue.length() == 0) {
                    return null;
                }
                result = DateUtil.convertFromString(textValue);
                logger.debug((Object)("identifier " + identifier + " was String value " + value + " becomes date " + result));
                return result;
            }
            catch (Exception e2) {
                throw new WDDXProcessorConversionException("Unable to convert value " + identifier + ":" + value + " to a Date");
            }
        }
    }

    public static boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.equals("string_null_value")) {
            return true;
        }
        if (obj.equals("boolean_null_value")) {
            return true;
        }
        if (obj.equals(WDDXTAGS.NUMERIC_NULL_VALUE_DOUBLE)) {
            return true;
        }
        if (obj.equals(WDDXTAGS.NUMERIC_NULL_VALUE_LONG)) {
            return true;
        }
        if (obj.equals(WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER)) {
            return true;
        }
        return obj.equals(WDDXTAGS.DATE_NULL_VALUE);
    }
}

