/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class LearnerProgressDAO
extends HibernateDaoSupport
implements ILearnerProgressDAO {
    protected Logger log = Logger.getLogger(LearnerProgressDAO.class);
    private static final String LOAD_PROGRESS_BY_LEARNER = "from LearnerProgress p where p.user.id = :learnerId and p.lesson.id = :lessonId";
    private static final String LOAD_PROGRESS_REFFERING_TO_ACTIVITY = "from LearnerProgress p where p.previousActivity = :activity or p.currentActivity = :activity or p.nextActivity = :activity ";
    private static final String LOAD_COMPLETED_PROGRESS_BY_LESSON = "from LearnerProgress p where p.lessonComplete > 0 and p.lesson.id = :lessonId";
    private static final String LOAD_LEARNERS_LATEST_COMPLETED_BY_LESSON = "SELECT p.user FROM LearnerProgress p WHERE p.lessonComplete > 0 and p.lesson.id = :lessonId ORDER BY p.finishDate DESC";
    private static final String COUNT_COMPLETED_PROGRESS_BY_LESSON = "select count(*) from LearnerProgress p  where p.lessonComplete > 0 and p.lesson.id = :lessonId";
    private static final String COUNT_ATTEMPTED_ACTIVITY = "select count(*) from LearnerProgress prog,  Activity act join prog.attemptedActivities attAct  where act.id = :activityId and  index(attAct) = act";
    private static final String COUNT_COMPLETED_ACTIVITY = "select count(*) from LearnerProgress prog,  Activity act join prog.completedActivities compAct  where act.id = :activityId and  index(compAct) = act";
    private static final String COUNT_CURRENT_ACTIVITY = "select count(*) from LearnerProgress prog WHERE  prog.currentActivity = :activity";
    private static final String LOAD_PROGRESS_BY_LESSON = "from LearnerProgress p  where p.lesson.id = :lessonId order by p.user.lastName, p.user.firstName, p.user.userId";
    private static final String LOAD_PROGRESS_BY_LESSON_AND_USER_IDS = "from LearnerProgress p  where p.lesson.id = :lessonId AND p.user.userId IN (:userIds) order by p.user.lastName, p.user.firstName, p.user.userId";
    private static final String LOAD_PROGRESSES_BY_LESSON_LIST = "FROM LearnerProgress progress WHERE  progress.lesson.lessonId IN (:lessonIds)";
    private static final String LOAD_LEARNERS_LATEST_BY_ACTIVITY = "SELECT u.* FROM lams_learner_progress AS prog JOIN lams_progress_attempted AS att USING (learner_progress_id) JOIN lams_user AS u USING (user_id) WHERE prog.current_activity_id = :activityId AND att.activity_id = :activityId ORDER BY att.start_date_time DESC";
    private static final String LOAD_LEARNERS_BY_ACTIVITIES = "SELECT p.user FROM LearnerProgress p WHERE  p.currentActivity.id IN (:activityIds)";
    private static final String LOAD_LEARNERS_BY_LESSON = "FROM LearnerProgress prog WHERE prog.lesson.id = :lessonId";

    @Override
    public LearnerProgress getLearnerProgress(Long learnerProgressId) {
        return (LearnerProgress)this.getHibernateTemplate().get(LearnerProgress.class, (Serializable)learnerProgressId);
    }

    @Override
    public void saveLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().save((Object)learnerProgress);
    }

    @Override
    public void deleteLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().delete((Object)learnerProgress);
    }

    @Override
    public LearnerProgress getLearnerProgressByLearner(final Integer learnerId, final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (LearnerProgress)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_LEARNER).setInteger("learnerId", learnerId.intValue()).setLong("lessonId", lessonId.longValue()).uniqueResult();
            }
        });
    }

    @Override
    public void updateLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().update((Object)learnerProgress);
    }

    @Override
    public List<LearnerProgress> getLearnerProgressReferringToActivity(final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_REFFERING_TO_ACTIVITY).setEntity("activity", (Object)activity).list();
            }
        });
    }

    @Override
    public List<User> getLearnersLatestByActivity(final Long activityId, final Integer limit, final Integer offset) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createSQLQuery(LearnerProgressDAO.LOAD_LEARNERS_LATEST_BY_ACTIVITY).addEntity(User.class).setLong("activityId", activityId.longValue());
                if (limit != null) {
                    query.setMaxResults(limit.intValue());
                }
                if (offset != null) {
                    query.setFirstResult(offset.intValue());
                }
                return query.list();
            }
        });
    }

    @Override
    public List<User> getLearnersByActivities(final Long[] activityIds, final Integer limit, final Integer offset) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(LearnerProgressDAO.LOAD_LEARNERS_BY_ACTIVITIES).setParameterList("activityIds", (Object[])activityIds);
                if (limit != null) {
                    query.setMaxResults(limit.intValue());
                }
                if (offset != null) {
                    query.setFirstResult(offset.intValue());
                }
                return query.list();
            }
        });
    }

    @Override
    public List<User> getLearnersLatestCompletedForLesson(final Long lessonId, final Integer limit, final Integer offset) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(LearnerProgressDAO.LOAD_LEARNERS_LATEST_COMPLETED_BY_LESSON).setLong("lessonId", lessonId.longValue());
                if (limit != null) {
                    query.setMaxResults(limit.intValue());
                }
                if (offset != null) {
                    query.setFirstResult(offset.intValue());
                }
                return query.list();
            }
        });
    }

    @Override
    public List<User> getLearnersByLesson(final Long lessonId, String searchPhrase, boolean orderByCompletion, final Integer limit, final Integer offset) {
        final String queryText = LearnerProgressDAO.buildLearnersByLessonQuery(false, searchPhrase, orderByCompletion);
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(queryText).setLong("lessonId", lessonId.longValue());
                if (limit != null) {
                    query.setMaxResults(limit.intValue());
                }
                if (offset != null) {
                    query.setFirstResult(offset.intValue());
                }
                return query.list();
            }
        });
    }

    private static String buildLearnersByLessonQuery(boolean count, String searchPhrase, Boolean orderByCompletion) {
        StringBuilder queryText = new StringBuilder("SELECT ").append(count ? "COUNT(*) " : "prog.user ").append(LOAD_LEARNERS_BY_LESSON);
        if (!StringUtils.isBlank((String)searchPhrase)) {
            String[] tokens;
            for (String token : tokens = searchPhrase.trim().split("\\s+")) {
                queryText.append(" AND (prog.user.firstName LIKE '%").append(token).append("%' OR prog.user.lastName LIKE '%").append(token).append("%' OR prog.user.login LIKE '%").append(token).append("%')");
            }
        }
        if (!count && orderByCompletion != null) {
            queryText.append(" ORDER BY");
            if (orderByCompletion.booleanValue()) {
                queryText.append(" prog.lessonComplete DESC, prog.completedActivities.size DESC,");
            }
            queryText.append(" prog.user.firstName ASC, prog.user.lastName ASC");
        }
        return queryText.toString();
    }

    @Override
    public List<LearnerProgress> getCompletedLearnerProgressForLesson(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_COMPLETED_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).list();
            }
        });
    }

    @Override
    public List<LearnerProgress> getLearnerProgressForLesson(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).list();
            }
        });
    }

    @Override
    public List<LearnerProgress> getLearnerProgressForLesson(final Long lessonId, final List<Integer> userIds) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_LESSON_AND_USER_IDS).setLong("lessonId", lessonId.longValue()).setParameterList("userIds", (Collection)userIds).list();
            }
        });
    }

    @Override
    public List<LearnerProgress> getLearnerProgressForLessons(final List<Long> lessonIds) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESSES_BY_LESSON_LIST).setParameterList("lessonIds", (Collection)lessonIds).list();
            }
        });
    }

    @Override
    public List<User> getLearnersHaveAttemptedActivity(final Activity activity) {
        List learners = null;
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        learners = (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("usersAttemptedActivity").setLong("activityId", activity.getActivityId().longValue()).list();
            }
        });
        return learners;
    }

    @Override
    public Integer getNumUsersAttemptedActivity(final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        Integer attempted = (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object value = session.createQuery(LearnerProgressDAO.COUNT_ATTEMPTED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
        return new Integer(attempted + this.getNumUsersCompletedActivity(activity));
    }

    @Override
    public Integer getNumUsersCompletedActivity(final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object value = session.createQuery(LearnerProgressDAO.COUNT_COMPLETED_ACTIVITY).setLong("activityId", activity.getActivityId().longValue()).uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
    }

    @Override
    public Integer getNumUsersByLesson(final Long lessonId, String searchPhrase) {
        final String queryText = LearnerProgressDAO.buildLearnersByLessonQuery(true, searchPhrase, null);
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object value = session.createQuery(queryText).setLong("lessonId", lessonId.longValue()).uniqueResult();
                return ((Number)value).intValue();
            }
        });
    }

    @Override
    public Integer getNumUsersCompletedLesson(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object value = session.createQuery(LearnerProgressDAO.COUNT_COMPLETED_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).uniqueResult();
                return ((Number)value).intValue();
            }
        });
    }

    @Override
    public Integer getNumUsersCurrentActivity(final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object value = session.createQuery(LearnerProgressDAO.COUNT_CURRENT_ACTIVITY).setEntity("activity", (Object)activity).uniqueResult();
                return ((Number)value).intValue();
            }
        });
    }
}

