/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import java.util.List;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;

public class OrganisationDAO
extends BaseDAO
implements IOrganisationDAO {
    private static final String GET_ALL_ACTIVE_COURSE_IDS = "select o.organisationId from Organisation o where o.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " and o.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " order by name";
    private static final String GET_ACTIVE_COURSE_IDS_BY_USER = "select uo.organisation.organisationId, uoc.collapsed from Organisation o, UserOrganisation uo left join uo.userOrganisationCollapsed uoc where uo.organisation.organisationId = o.organisationId and o.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " and o.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " and uo.user.userId = :userId" + " order by name";
    private static final String GET_ALL_ARCHIVED_COURSE_IDS = "select distinct o1.organisationId from Organisation o1, Organisation o2  where (o1.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " and o1.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " and o2.organisationType.organisationTypeId = " + OrganisationType.CLASS_TYPE + " and o2.organisationState.organisationStateId = " + OrganisationState.ARCHIVED + " and o1.organisationId = o2.parentOrganisation.organisationId)" + " or (o1.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " and o1.organisationState.organisationStateId = " + OrganisationState.ARCHIVED + ")" + " order by o1.name";
    private static final String GET_ARCHIVED_COURSE_IDS_BY_USER = "select distinct o1.organisationId, uoc.collapsed from UserOrganisation uo1, Organisation o1, Organisation o2 left join uo1.userOrganisationCollapsed uoc where (uo1.user.userId = :userId and uo1.organisation.organisationId = o1.organisationId and o1.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " and o1.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " and o2.organisationType.organisationTypeId = " + OrganisationType.CLASS_TYPE + " and o2.organisationState.organisationStateId = " + OrganisationState.ARCHIVED + " and o1.organisationId = o2.parentOrganisation.organisationId)" + " or (uo1.organisation.organisationId = o1.organisationId" + " and o1.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " and o1.organisationState.organisationStateId = " + OrganisationState.ARCHIVED + " and uo1.user.userId = :userId)" + " order by o1.name";

    @Override
    public List getActiveCourseIdsByUser(Integer userId, boolean isSysadmin) {
        return isSysadmin ? this.getSession().createQuery(GET_ALL_ACTIVE_COURSE_IDS).list() : this.getSession().createQuery(GET_ACTIVE_COURSE_IDS_BY_USER).setInteger("userId", userId.intValue()).list();
    }

    @Override
    public List getArchivedCourseIdsByUser(Integer userId, boolean isSysadmin) {
        return isSysadmin ? this.getSession().createQuery(GET_ALL_ARCHIVED_COURSE_IDS).list() : this.getSession().createQuery(GET_ARCHIVED_COURSE_IDS_BY_USER).setInteger("userId", userId.intValue()).list();
    }

    @Override
    public List<Organisation> getPagedCourses(Integer parentOrgId, Integer typeId, Integer stateId, int page, int size, String sortBy, String sortOrder, String searchString) {
        String GET_ORGS = "SELECT o FROM " + Organisation.class.getName() + " o " + " WHERE o.organisationType.organisationTypeId =:typeId " + " AND o.organisationState.organisationStateId =:stateId " + " AND o.parentOrganisation.organisationId =:parentOrgId" + " AND (o.name LIKE CONCAT('%', :searchString, '%')) " + " ORDER BY ";
        String sortByParam = "o.name";
        if (sortBy == null) {
            sortByParam = "o.name";
        } else if (sortBy.equals("id")) {
            sortByParam = "o.organisationId";
        } else if (sortBy.equals("name")) {
            sortByParam = "o.name";
        } else if (sortBy.equals("code")) {
            sortByParam = "o.code";
        } else if (sortBy.equals("description")) {
            sortByParam = "o.description";
        }
        Query query = this.getSession().createQuery(GET_ORGS + sortByParam + " " + sortOrder);
        query.setInteger("typeId", typeId.intValue());
        query.setInteger("stateId", stateId.intValue());
        query.setInteger("parentOrgId", parentOrgId.intValue());
        searchString = searchString == null ? "" : searchString;
        query.setString("searchString", searchString);
        query.setFirstResult(page * size);
        query.setMaxResults(size);
        return query.list();
    }

    @Override
    public int getCountCoursesByParentCourseAndTypeAndState(Integer parentOrgId, Integer typeId, Integer stateId, String searchString) {
        String GET_ORGS = "SELECT count(*) FROM Organisation o  WHERE o.parentOrganisation.organisationId =:parentOrgId  AND o.organisationType.organisationTypeId =:typeId  AND o.organisationState.organisationStateId =:stateId  AND (o.name LIKE CONCAT('%', :searchString, '%')) ";
        Query query = this.getSession().createQuery("SELECT count(*) FROM Organisation o  WHERE o.parentOrganisation.organisationId =:parentOrgId  AND o.organisationType.organisationTypeId =:typeId  AND o.organisationState.organisationStateId =:stateId  AND (o.name LIKE CONCAT('%', :searchString, '%')) ");
        query.setInteger("parentOrgId", parentOrgId.intValue());
        query.setInteger("typeId", typeId.intValue());
        query.setInteger("stateId", stateId.intValue());
        searchString = searchString == null ? "" : searchString;
        query.setString("searchString", searchString);
        List list = query.list();
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }
}

