/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.svg;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;

public class ActivityTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;

    public ActivityTreeNode() {
    }

    public ActivityTreeNode(AuthoringActivityDTO activity) {
        super(activity);
    }

    public AuthoringActivityDTO getActivity() {
        return (AuthoringActivityDTO)this.userObject;
    }

    public List<ActivityTreeNode> getChildren() {
        Enumeration<TreeNode> enumeration = this.children();
        return Collections.list(enumeration);
    }

    public AuthoringActivityDTO getParentActivity() {
        if (this.parent != null) {
            ActivityTreeNode parentNode = (ActivityTreeNode)this.parent;
            return (AuthoringActivityDTO)parentNode.getUserObject();
        }
        return null;
    }

    public boolean isOptionalActivityChild() {
        ActivityTreeNode parentNode;
        AuthoringActivityDTO parentActivity;
        boolean isOptionalActivityChild = false;
        AuthoringActivityDTO activity = this.getActivity();
        if (activity.getParentActivityID() != null && (parentActivity = (parentNode = (ActivityTreeNode)this.parent).getActivity()).getActivityTypeID().equals(7)) {
            isOptionalActivityChild = true;
        }
        return isOptionalActivityChild;
    }

    public boolean isOptionalSequenceActivityChild() {
        ActivityTreeNode parentNode;
        AuthoringActivityDTO parentActivity;
        boolean isOptionalSequenceActivityChild = false;
        AuthoringActivityDTO activity = (AuthoringActivityDTO)this.userObject;
        if (activity.getParentActivityID() != null && (parentActivity = (parentNode = (ActivityTreeNode)this.parent).getActivity()).getActivityTypeID().equals(8)) {
            isOptionalSequenceActivityChild = true;
        }
        return isOptionalSequenceActivityChild;
    }

    public String getActivityColor() {
        String color = "";
        switch (this.getActivity().getActivityCategoryID()) {
            case 1: {
                color = ";fill:#d0defd";
                break;
            }
            case 2: {
                color = ";fill:#fffccb";
                break;
            }
            case 3: {
                color = ";fill:#ece9f7";
                break;
            }
            case 4: {
                color = ";fill:#fdf1d3";
                break;
            }
            case 5: {
                color = ";fill:#FFFFFF";
                break;
            }
            case 6: {
                color = ";fill:#e9f9c0";
            }
        }
        return color;
    }

    public String getActivityCss() {
        String style;
        AuthoringActivityDTO activity = (AuthoringActivityDTO)this.userObject;
        String STROKE_CSS = "stroke:black;stroke-width:1;opacity:1;";
        switch (activity.getActivityTypeID()) {
            case 3: 
            case 4: 
            case 5: 
            case 14: {
                if (this.isOptionalSequenceActivityChild() || this.isOptionalActivityChild()) {
                    style = "stroke:black;stroke-width:1;opacity:1;fill:#d0defd";
                    break;
                }
                style = "fill:red;stroke:#000000;stroke-width:0.5px";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                style = "stroke:black;stroke-width:1;opacity:1;fill:#d0defd";
                break;
            }
            case 8: {
                String color;
                ActivityTreeNode parentNode = (ActivityTreeNode)this.getParent();
                int indexInSiblings = parentNode.getIndex(this) % 6;
                switch (indexInSiblings) {
                    case 1: {
                        color = "BCD0FF";
                        break;
                    }
                    case 2: {
                        color = "C7F9AE";
                        break;
                    }
                    case 3: {
                        color = "FFEDC3";
                        break;
                    }
                    case 4: {
                        color = "EDDDF9";
                        break;
                    }
                    case 5: {
                        color = "E9E9E9";
                        break;
                    }
                    default: {
                        color = "FFFFB3";
                    }
                }
                style = "stroke:#E1F0FD;stroke-width:.4;opacity:1;fill:#" + color;
                break;
            }
            case 7: 
            case 13: 
            case 15: {
                style = "fill:#d0defd;";
                if (!this.isOptionalSequenceActivityChild() && !this.isOptionalActivityChild()) break;
                style = style + "stroke:black;stroke-width:1;opacity:1;";
                break;
            }
            default: {
                style = "stroke:black;stroke-width:1;opacity:1;" + this.getActivityColor();
            }
        }
        return style;
    }

    public Dimension getActivityDimension() {
        int height;
        int width;
        AuthoringActivityDTO activity = (AuthoringActivityDTO)this.userObject;
        int childrenSize = this.getChildCount();
        if (this.isOptionalSequenceActivityChild()) {
            width = 60;
            height = 43;
        } else if (this.isOptionalActivityChild()) {
            width = 125;
            height = 50;
        } else {
            switch (activity.getActivityTypeID()) {
                case 3: 
                case 4: 
                case 5: 
                case 14: {
                    width = 30;
                    height = 30;
                    break;
                }
                case 6: {
                    width = 141;
                    height = 172;
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    width = 165;
                    height = 100;
                    break;
                }
                case 13: {
                    width = this.getOptionalSequenceActivityWidth();
                    height = 57 * childrenSize + 49;
                    break;
                }
                case 8: {
                    ActivityTreeNode parentNode = (ActivityTreeNode)this.getParent();
                    width = parentNode.getOptionalSequenceActivityWidth() - 8;
                    height = 53;
                    break;
                }
                case 7: {
                    width = 141;
                    height = 63 * childrenSize + 53;
                    break;
                }
                case 15: {
                    width = 132 * childrenSize + 11;
                    height = 116;
                    break;
                }
                default: {
                    width = 125;
                    height = 50;
                }
            }
        }
        return new Dimension(width, height);
    }

    public Point getActivityCoordinates() {
        AuthoringActivityDTO activity = this.getActivity();
        int x = activity.getxCoord() == null ? 0 : activity.getxCoord();
        int y = activity.getyCoord() == null ? 0 : activity.getyCoord();
        return new Point(x, y);
    }

    private int getOptionalSequenceActivityWidth() {
        int maxChildren = 0;
        for (ActivityTreeNode childNode : this.getChildren()) {
            int childrenSize = childNode.getChildCount();
            if (childrenSize <= maxChildren) continue;
            maxChildren = childrenSize;
        }
        maxChildren = maxChildren < 2 ? 2 : maxChildren;
        int width = 60 * maxChildren + 20;
        return width;
    }
}

