/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.filter;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.log4j.Logger;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.lamsfoundation.lams.util.ITransactionRetryService;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.transaction.UnexpectedRollbackException;

public class TransactionRetryInterceptor
implements MethodInterceptor {
    private static final Logger log = Logger.getLogger(TransactionRetryInterceptor.class);
    private ITransactionRetryService transactionRetryService;
    private SessionFactory sessionFactory;
    private static final int MAX_ATTEMPTS = 5;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        MutableInt attempt = new MutableInt(1);
        Throwable exception = null;
        do {
            try {
                if (attempt.intValue() == 1) {
                    return invocation.proceed();
                }
                return this.transactionRetryService.retry(invocation);
            }
            catch (DataIntegrityViolationException e) {
                exception = e;
                this.processException((Exception)((Object)e), invocation, attempt);
            }
            catch (ConstraintViolationException e) {
                exception = e;
                this.processException((Exception)((Object)e), invocation, attempt);
            }
            catch (CannotAcquireLockException e) {
                exception = e;
                this.processException((Exception)((Object)e), invocation, attempt);
            }
            catch (LockAcquisitionException e) {
                exception = e;
                this.processException((Exception)((Object)e), invocation, attempt);
            }
            catch (UnexpectedRollbackException e) {
                exception = e;
                this.processException((Exception)((Object)e), invocation, attempt);
            }
        } while (attempt.intValue() <= 5);
        throw exception;
    }

    private void processException(Exception e, MethodInvocation invocation, MutableInt attempt) {
        StringBuilder message = new StringBuilder("When invoking method \"").append(invocation.getMethod().getName()).append("\" caught \"").append(e.getMessage()).append("\". Attempt #").append(attempt);
        attempt.increment();
        if (attempt.intValue() <= 5) {
            message.append(". Retrying.");
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            session.setFlushMode(FlushMode.AUTO);
        } else {
            message.append(". Giving up.");
        }
        log.warn((Object)message);
    }

    public void setTransactionRetryService(ITransactionRetryService transactionRetryService) {
        this.transactionRetryService = transactionRetryService;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

