/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.IObjectExtractor;
import org.lamsfoundation.lams.authoring.ObjectExtractorException;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Competence;
import org.lamsfoundation.lams.learningdesign.CompetenceMapping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.ConditionGateActivity;
import org.lamsfoundation.lams.learningdesign.FloatingActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.SystemGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IBranchActivityEntryDAO;
import org.lamsfoundation.lams.learningdesign.dao.ICompetenceDAO;
import org.lamsfoundation.lams.learningdesign.dao.ICompetenceMappingDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.ITransitionDAO;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectExtractor
implements IObjectExtractor {
    private static final Integer DEFAULT_COORD = new Integer(10);
    protected IBaseDAO baseDAO = null;
    protected ILearningDesignDAO learningDesignDAO = null;
    protected IActivityDAO activityDAO = null;
    protected ICompetenceDAO competenceDAO = null;
    protected ICompetenceMappingDAO competenceMappingDAO = null;
    protected ITransitionDAO transitionDAO = null;
    protected ILearningLibraryDAO learningLibraryDAO = null;
    protected ILicenseDAO licenseDAO = null;
    protected IGroupingDAO groupingDAO = null;
    protected IToolDAO toolDAO = null;
    protected ISystemToolDAO systemToolDAO = null;
    protected IGroupDAO groupDAO = null;
    protected IToolSessionDAO toolSessionDAO = null;
    protected IBranchActivityEntryDAO branchActivityEntryDAO = null;
    private Integer mode = null;
    protected HashMap<Integer, Activity> newActivityMap = new HashMap();
    protected HashMap<Integer, List<ToolSession>> toolSessionMap = new HashMap();
    protected List<BranchActivityEntry> oldbranchActivityEntryList = new ArrayList<BranchActivityEntry>();
    protected HashMap<Integer, Activity> oldActivityMap = new HashMap();
    protected HashMap<Integer, Grouping> groupings = new HashMap();
    protected HashMap<Integer, Group> groups = new HashMap();
    protected HashMap<Integer, BranchActivityEntry> branchEntries = new HashMap();
    protected HashMap<Integer, ComplexActivity> defaultActivityMap = new HashMap();
    protected HashMap<Integer, Grouping> groupingsToDelete = new HashMap();
    protected LearningDesign learningDesign = null;
    protected Date modificationDate = null;
    protected HashMap<Long, SystemTool> systemTools = new HashMap();
    protected Logger log = Logger.getLogger(ObjectExtractor.class);

    public ObjectExtractor() {
        this.modificationDate = new Date();
    }

    public ObjectExtractor(IBaseDAO baseDAO, ILearningDesignDAO learningDesignDAO, IActivityDAO activityDAO, ILearningLibraryDAO learningLibraryDAO, ILicenseDAO licenseDAO, IGroupingDAO groupingDAO, IToolDAO toolDAO, ISystemToolDAO systemToolDAO, IGroupDAO groupDAO, ITransitionDAO transitionDAO, IToolSessionDAO toolSessionDAO) {
        this.baseDAO = baseDAO;
        this.learningDesignDAO = learningDesignDAO;
        this.activityDAO = activityDAO;
        this.learningLibraryDAO = learningLibraryDAO;
        this.licenseDAO = licenseDAO;
        this.groupingDAO = groupingDAO;
        this.toolDAO = toolDAO;
        this.systemToolDAO = systemToolDAO;
        this.groupDAO = groupDAO;
        this.transitionDAO = transitionDAO;
        this.toolSessionDAO = toolSessionDAO;
        this.modificationDate = new Date();
    }

    public IActivityDAO getActivityDAO() {
        return this.activityDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public ICompetenceDAO getCompetenceDAO() {
        return this.competenceDAO;
    }

    public void setCompetenceDAO(ICompetenceDAO competenceDAO) {
        this.competenceDAO = competenceDAO;
    }

    public ICompetenceMappingDAO getCompetenceMappingDAO() {
        return this.competenceMappingDAO;
    }

    public void setCompetenceMappingDAO(ICompetenceMappingDAO competenceMappingDAO) {
        this.competenceMappingDAO = competenceMappingDAO;
    }

    public IGroupDAO getGroupDAO() {
        return this.groupDAO;
    }

    public void setGroupDAO(IGroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public IGroupingDAO getGroupingDAO() {
        return this.groupingDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public ILearningDesignDAO getLearningDesignDAO() {
        return this.learningDesignDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public ILearningLibraryDAO getLearningLibraryDAO() {
        return this.learningLibraryDAO;
    }

    public void setLearningLibraryDAO(ILearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public ILicenseDAO getLicenseDAO() {
        return this.licenseDAO;
    }

    public void setLicenseDAO(ILicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public IToolSessionDAO getToolSessionDAODAO() {
        return this.toolSessionDAO;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public HashMap<Integer, Activity> getNewActivityMap() {
        return this.newActivityMap;
    }

    public void setNewActivityMap(HashMap<Integer, Activity> newActivityMap) {
        this.newActivityMap = newActivityMap;
    }

    public IToolDAO getToolDAO() {
        return this.toolDAO;
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public ISystemToolDAO getSystemToolDAO() {
        return this.systemToolDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public ITransitionDAO getTransitionDAO() {
        return this.transitionDAO;
    }

    public void setTransitionDAO(ITransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public IBaseDAO getBaseDAO() {
        return this.baseDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public IBranchActivityEntryDAO getBranchActivityEntryDAO() {
        return this.branchActivityEntryDAO;
    }

    public void setBranchActivityEntryDAO(IBranchActivityEntryDAO branchActivityEntryDAO) {
        this.branchActivityEntryDAO = branchActivityEntryDAO;
    }

    @Override
    public LearningDesign extractSaveLearningDesign(Hashtable table, LearningDesign existingLearningDesign, WorkspaceFolder workspaceFolder, User user) throws WDDXProcessorConversionException, ObjectExtractorException {
        this.learningDesign = existingLearningDesign != null ? existingLearningDesign : new LearningDesign();
        Integer copyTypeID = WDDXProcessor.convertToInteger((Hashtable)table, (String)"copyTypeID");
        if (copyTypeID == null) {
            copyTypeID = 1;
        }
        if (this.learningDesign != null && this.learningDesign.getCopyTypeID() != null && !this.learningDesign.getCopyTypeID().equals(copyTypeID) && !this.learningDesign.getEditOverrideLock().booleanValue()) {
            throw new ObjectExtractorException("Unable to save learning design.  Cannot change copy type on existing design.");
        }
        if (!copyTypeID.equals(1) && !this.learningDesign.getEditOverrideLock().booleanValue()) {
            throw new ObjectExtractorException("Unable to save learning design.  Learning design is read-only");
        }
        this.learningDesign.setCopyTypeID(copyTypeID);
        this.learningDesign.setWorkspaceFolder(workspaceFolder);
        this.learningDesign.setUser(user);
        this.initialiseGroupings();
        this.intialiseBranchActivityMappings();
        this.initialiseToolSessionMap(this.learningDesign);
        this.learningDesign.setValidDesign(Boolean.FALSE);
        if (this.keyExists(table, "learningDesignUIID")) {
            this.learningDesign.setLearningDesignUIID(WDDXProcessor.convertToInteger((Hashtable)table, (String)"learningDesignUIID"));
        }
        if (this.keyExists(table, "description")) {
            this.learningDesign.setDescription(WDDXProcessor.convertToString((Hashtable)table, (String)"description"));
        }
        if (this.keyExists(table, "title")) {
            this.learningDesign.setTitle(WDDXProcessor.convertToString((Hashtable)table, (String)"title"));
        }
        if (this.keyExists(table, "maxID")) {
            this.learningDesign.setMaxID(WDDXProcessor.convertToInteger((Hashtable)table, (String)"maxID"));
        }
        if (this.keyExists(table, "validDesign")) {
            this.learningDesign.setValidDesign(WDDXProcessor.convertToBoolean((Hashtable)table, (String)"validDesign"));
        }
        if (this.keyExists(table, "readOnly")) {
            this.learningDesign.setReadOnly(WDDXProcessor.convertToBoolean((Hashtable)table, (String)"readOnly"));
        }
        if (this.keyExists(table, "editOverrideLock")) {
            this.learningDesign.setEditOverrideLock(WDDXProcessor.convertToBoolean((Hashtable)table, (String)"editOverrideLock"));
        }
        if (this.keyExists(table, "dateReadOnly")) {
            this.learningDesign.setDateReadOnly(WDDXProcessor.convertToDate((Hashtable)table, (String)"dateReadOnly"));
        }
        if (this.keyExists(table, "offlineInstructions")) {
            this.learningDesign.setOfflineInstructions(WDDXProcessor.convertToString((Hashtable)table, (String)"offlineInstructions"));
        }
        if (this.keyExists(table, "onlineInstructions")) {
            this.learningDesign.setOnlineInstructions(WDDXProcessor.convertToString((Hashtable)table, (String)"onlineInstructions"));
        }
        if (this.keyExists(table, "helpText")) {
            this.learningDesign.setHelpText(WDDXProcessor.convertToString((Hashtable)table, (String)"helpText"));
        }
        this.learningDesign.setVersion(Configuration.get((String)ConfigurationKeys.SERVER_VERSION_NUMBER));
        if (this.keyExists(table, "duration")) {
            this.learningDesign.setDuration(WDDXProcessor.convertToLong((Hashtable)table, (String)"duration"));
        }
        if (this.keyExists(table, "duration")) {
            this.learningDesign.setDuration(WDDXProcessor.convertToLong((Hashtable)table, (String)"duration"));
        }
        if (this.keyExists(table, "contentFolderID")) {
            this.learningDesign.setContentFolderID(WDDXProcessor.convertToString((Hashtable)table, (String)"contentFolderID"));
        }
        if (this.keyExists(table, "saveMode")) {
            this.mode = WDDXProcessor.convertToInteger((Hashtable)table, (String)"saveMode");
        }
        if (this.learningDesign.getCreateDateTime() == null) {
            this.learningDesign.setCreateDateTime(this.modificationDate);
        }
        this.learningDesign.setLastModifiedDateTime(this.modificationDate);
        if (this.keyExists(table, "licenseID")) {
            Long licenseID = WDDXProcessor.convertToLong((Hashtable)table, (String)"licenseID");
            if (licenseID != null) {
                License license = this.licenseDAO.getLicenseByID(licenseID);
                this.learningDesign.setLicense(license);
            } else {
                this.learningDesign.setLicense(null);
            }
        }
        if (this.keyExists(table, "licenseText")) {
            this.learningDesign.setLicenseText(WDDXProcessor.convertToString((Hashtable)table, (String)"licenseText"));
        }
        if (this.keyExists(table, "originalLearningDesignID")) {
            Long parentLearningDesignID = WDDXProcessor.convertToLong((Hashtable)table, (String)"originalLearningDesignID");
            if (parentLearningDesignID != null) {
                LearningDesign parent = this.learningDesignDAO.getLearningDesignById(parentLearningDesignID);
                this.learningDesign.setOriginalLearningDesign(parent);
            } else {
                this.learningDesign.setOriginalLearningDesign(null);
            }
        }
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
        this.parseCompetences((Vector)table.get("competences"), this.learningDesign);
        this.parseGroupings((Vector)table.get("groupings"));
        this.parseActivities((Vector)table.get("activities"));
        this.parseActivitiesToMatchUpParentandInputActivities((Vector)table.get("activities"));
        this.parseTransitions((Vector)table.get("transitions"));
        this.parseBranchMappings((Vector)table.get("branchMappings"));
        this.progressDefaultChildActivities();
        this.learningDesign.setFirstActivity(this.learningDesign.calculateFirstActivity());
        this.learningDesign.setFloatingActivity(this.learningDesign.calculateFloatingActivity());
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
        this.deleteUnwantedGroupings();
        this.deleteUnwantedToolSessions(this.learningDesign);
        this.parseCompetenceMappings((Vector)table.get("activities"));
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
        return this.learningDesign;
    }

    private void progressDefaultChildActivities() throws WDDXProcessorConversionException {
        if (this.defaultActivityMap.size() > 0) {
            for (Integer defaultChildUIID : this.defaultActivityMap.keySet()) {
                Activity nextActivity2;
                ComplexActivity complex = this.defaultActivityMap.get(defaultChildUIID);
                Activity defaultActivity = this.newActivityMap.get(defaultChildUIID);
                if (defaultActivity == null) {
                    String msg = "Unable to find the default child activity (" + defaultChildUIID + ") for the activity (" + complex + ") referred to in First Child to Sequence map.";
                    throw new WDDXProcessorConversionException(msg);
                }
                complex.setDefaultActivity(defaultActivity);
                if (!complex.isSequenceActivity()) continue;
                TreeSet unprocessedChildren = new TreeSet(new ActivityOrderComparator());
                unprocessedChildren.addAll(complex.getActivities());
                unprocessedChildren.remove(defaultActivity);
                defaultActivity.setOrderId(Integer.valueOf(1));
                int nextOrderId = 2;
                Activity activity = nextActivity2 = defaultActivity.getTransitionFrom() != null ? defaultActivity.getTransitionFrom().getToActivity() : null;
                while (nextActivity2 != null) {
                    boolean removed = unprocessedChildren.remove(nextActivity2);
                    if (!removed) {
                        this.log.error((Object)("Next activity should be a child of the current sequence, but it isn't. Could we have a loop in the transitions? Aborting the ordering of ids based on transitions. Sequence activity " + complex + " next activity " + nextActivity2));
                        break;
                    }
                    nextActivity2.setOrderId(Integer.valueOf(nextOrderId++));
                    nextActivity2 = nextActivity2.getTransitionFrom() != null ? nextActivity2.getTransitionFrom().getToActivity() : null;
                }
                if (unprocessedChildren.size() <= 0) continue;
                for (Activity nextActivity2 : unprocessedChildren) {
                    nextActivity2.setOrderId(Integer.valueOf(nextOrderId++));
                }
            }
        }
    }

    private void initialiseGroupings() {
        List dbGroupings = this.groupingDAO.getGroupingsByLearningDesign(this.learningDesign.getLearningDesignId());
        for (Grouping grouping : dbGroupings) {
            this.groupings.put(grouping.getGroupingUIID(), grouping);
            this.groupingsToDelete.put(grouping.getGroupingUIID(), grouping);
        }
    }

    private void intialiseBranchActivityMappings() {
        this.oldbranchActivityEntryList = this.branchActivityEntryDAO.getEntriesByLearningDesign(this.learningDesign.getLearningDesignId());
    }

    private void initialiseToolSessionMap(LearningDesign learningDesign) {
        if (learningDesign.getEditOverrideLock().booleanValue() && learningDesign.getEditOverrideUser() != null) {
            for (Activity activity : learningDesign.getActivities()) {
                this.oldActivityMap.put(activity.getActivityUIID(), activity);
                List toolSessions = this.toolSessionDAO.getToolSessionByActivity(activity);
                if (toolSessions == null || toolSessions.size() <= 0) continue;
                this.toolSessionMap.put(activity.getActivityUIID(), toolSessions);
            }
        }
    }

    private void deleteUnwantedGroupings() {
        for (Grouping grouping : this.groupingsToDelete.values()) {
            this.groupingDAO.delete((Object)grouping);
        }
    }

    private void deleteUnwantedToolSessions(LearningDesign learningDesign) throws ObjectExtractorException {
        if (learningDesign.getEditOverrideLock().booleanValue() && learningDesign.getEditOverrideUser() != null) {
            for (Integer uiid : this.toolSessionMap.keySet()) {
                List<ToolSession> toolSessions;
                if (this.newActivityMap.containsKey(uiid) || (toolSessions = this.toolSessionMap.get(uiid)) == null) continue;
                Activity activity = this.oldActivityMap.get(uiid);
                if (toolSessions.size() > 1) {
                    throw new ObjectExtractorException("More than one tool session exists for activity " + activity.getTitle() + " (" + uiid + ") but this shouldn't be possible. Cannot delete this tool session so editing is not allowed!");
                }
                if (toolSessions.size() != 1) continue;
                ToolSession toolSession = toolSessions.get(0);
                if (activity.isGroupingActivity()) {
                    throw new ObjectExtractorException("Activity " + activity.getTitle() + " (" + activity.getActivityUIID() + ") has a tool session but it is grouped. Cannot delete this tool session so editing is not allowed!");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Removing tool session for activity " + activity.getTitle() + " (" + activity.getActivityUIID() + ")"));
                }
                this.toolSessionDAO.removeToolSession(toolSession);
            }
        }
    }

    private void parseGroupings(List groupingsList) throws WDDXProcessorConversionException {
        if (groupingsList != null) {
            for (Hashtable groupingDetails : groupingsList) {
                if (groupingDetails == null) continue;
                Grouping grouping = this.extractGroupingObject(groupingDetails);
                this.groupingDAO.insertOrUpdate((Object)grouping);
                this.groupings.put(grouping.getGroupingUIID(), grouping);
            }
        }
    }

    public Grouping extractGroupingObject(Hashtable groupingDetails) throws WDDXProcessorConversionException {
        Integer groupingUUID = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"groupingUIID");
        Integer groupingTypeID = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"groupingTypeID");
        if (groupingTypeID == null) {
            throw new WDDXProcessorConversionException("groupingTypeID is missing");
        }
        Grouping grouping = this.groupings.get(groupingUUID);
        if (grouping != null) {
            if (grouping.getGroupingTypeId().equals(groupingTypeID)) {
                this.groupingsToDelete.remove(groupingUUID);
            } else {
                this.groupings.remove(grouping.getGroupingUIID());
                grouping = null;
            }
        }
        if (grouping == null) {
            Object object = Grouping.getGroupingInstance((Integer)groupingTypeID);
            grouping = (Grouping)object;
            if (this.keyExists(groupingDetails, "groupingUIID")) {
                grouping.setGroupingUIID(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"groupingUIID"));
            }
        }
        if (grouping.isRandomGrouping()) {
            this.createRandomGrouping((RandomGrouping)grouping, groupingDetails);
        } else if (grouping.isChosenGrouping()) {
            this.createChosenGrouping((ChosenGrouping)grouping, groupingDetails);
        } else if (grouping.isLearnerChoiceGrouping()) {
            this.createLearnerChoiceGrouping((LearnerChoiceGrouping)grouping, groupingDetails);
        } else {
            this.createLessonClass((LessonClass)grouping, groupingDetails);
        }
        if (this.keyExists(groupingDetails, "maxNumberOfGroups")) {
            grouping.setMaxNumberOfGroups(WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"maxNumberOfGroups"));
        }
        HashSet groupsToDelete = new HashSet(grouping.getGroups());
        Vector groupsList = (Vector)groupingDetails.get("groups");
        if (groupsList != null && groupsList.size() > 0) {
            for (Hashtable groupDetails : groupsList) {
                Group group = this.extractGroupObject(groupDetails, grouping);
                this.groups.put(group.getGroupUIID(), group);
                groupsToDelete.remove(group);
            }
        }
        if (groupsToDelete.size() > 0) {
            for (Group group : groupsToDelete) {
                if (group.getBranchActivities() != null) {
                    for (BranchActivityEntry entry : group.getBranchActivities()) {
                        entry.setGroup(null);
                    }
                    group.getBranchActivities().clear();
                }
                grouping.getGroups().remove(group);
            }
        }
        return grouping;
    }

    private Group extractGroupObject(Hashtable groupDetails, Grouping grouping) throws WDDXProcessorConversionException {
        Group group = null;
        Integer groupUIID = WDDXProcessor.convertToInteger((Hashtable)groupDetails, (String)"groupUIID");
        if (groupUIID == null) {
            throw new WDDXProcessorConversionException("Group is missing its UUID. Group " + groupDetails + " grouping " + grouping);
        }
        Long groupID = WDDXProcessor.convertToLong((Hashtable)groupDetails, (String)"groupID");
        if (grouping.getGroups() != null && grouping.getGroups().size() > 0) {
            Group uiid_match = null;
            Group id_match = null;
            Iterator iter = grouping.getGroups().iterator();
            while (uiid_match == null && iter.hasNext()) {
                Group possibleGroup = (Group)iter.next();
                if (groupUIID.equals(possibleGroup.getGroupUIID())) {
                    uiid_match = possibleGroup;
                }
                if (groupID == null || !groupID.equals(possibleGroup.getGroupId())) continue;
                id_match = possibleGroup;
            }
            Group group2 = group = uiid_match != null ? uiid_match : id_match;
        }
        if (group == null) {
            group = new Group();
            grouping.getGroups().add(group);
        }
        group.setGroupName(WDDXProcessor.convertToString((Hashtable)groupDetails, (String)"groupName"));
        group.setGrouping(grouping);
        group.setGroupUIID(groupUIID);
        if (this.keyExists(groupDetails, "orderID")) {
            group.setOrderId(WDDXProcessor.convertToInteger((Hashtable)groupDetails, (String)"orderID").intValue());
        } else {
            group.setOrderId(0);
        }
        return group;
    }

    private void createRandomGrouping(RandomGrouping randomGrouping, Hashtable groupingDetails) throws WDDXProcessorConversionException {
        Integer numLearnersPerGroup = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"learnersPerGroup");
        if (numLearnersPerGroup != null && numLearnersPerGroup > 0) {
            randomGrouping.setLearnersPerGroup(numLearnersPerGroup);
            randomGrouping.setNumberOfGroups(null);
        } else {
            Integer numGroups = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"numberOfGroups");
            if (numGroups != null && numGroups > 0) {
                randomGrouping.setNumberOfGroups(numGroups);
            } else {
                randomGrouping.setNumberOfGroups(null);
            }
            randomGrouping.setLearnersPerGroup(null);
        }
    }

    private void createChosenGrouping(ChosenGrouping chosenGrouping, Hashtable groupingDetails) throws WDDXProcessorConversionException {
    }

    private void parseActivities(List activitiesList) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (activitiesList != null) {
            for (Hashtable activityDetails : activitiesList) {
                Activity activity = this.extractActivityObject(activityDetails);
                this.activityDAO.insertOrUpdate((Object)activity);
                if (activity.isToolActivity()) {
                    this.extractEvaluationObject(activityDetails, (ToolActivity)activity);
                }
                this.newActivityMap.put(activity.getActivityUIID(), activity);
            }
        }
        this.learningDesign.getActivities().clear();
        this.learningDesign.getActivities().addAll(this.newActivityMap.values());
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
    }

    private void extractEvaluationObject(Hashtable activityDetails, ToolActivity toolActivity) throws WDDXProcessorConversionException, ObjectExtractorException {
        HashSet<ActivityEvaluation> activityEvaluations = toolActivity.getActivityEvaluations();
        ActivityEvaluation activityEvaluation = activityEvaluations != null && activityEvaluations.size() >= 1 ? (ActivityEvaluation)activityEvaluations.iterator().next() : new ActivityEvaluation();
        if (this.keyExists(activityDetails, "gradebookToolOutputDefinitionName") && WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"gradebookToolOutputDefinitionName") != null && !WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"gradebookToolOutputDefinitionName").equals("")) {
            activityEvaluations = new HashSet<ActivityEvaluation>();
            activityEvaluation.setActivity((Activity)toolActivity);
            activityEvaluation.setToolOutputDefinition(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"gradebookToolOutputDefinitionName"));
            activityEvaluations.add(activityEvaluation);
            toolActivity.setActivityEvaluations(activityEvaluations);
            this.baseDAO.insertOrUpdate((Object)activityEvaluation);
            toolActivity.setActivityEvaluations(activityEvaluations);
            this.activityDAO.insertOrUpdate((Object)toolActivity);
        } else if (activityEvaluation.getUid() != null) {
            toolActivity.setActivityEvaluations(new HashSet());
            this.activityDAO.insertOrUpdate((Object)toolActivity);
            this.baseDAO.delete((Object)activityEvaluation);
        }
    }

    private void parseCompetenceMappings(List activitiesList) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (activitiesList != null) {
            for (Hashtable activityDetails : activitiesList) {
                int actType;
                if (this.keyExists(activityDetails, "activityTypeID") && (actType = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityTypeID").intValue()) != 1) continue;
                ToolActivity toolActivity = null;
                if (!this.keyExists(activityDetails, "activityUIID")) continue;
                Activity activity = this.activityDAO.getActivityByUIID(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID"), this.learningDesign);
                toolActivity = (ToolActivity)activity;
                if (!this.keyExists(activityDetails, "competenceMappings")) continue;
                Vector competenceMappingsList = (Vector)activityDetails.get("competenceMappings");
                for (String competenceMappingEntry : competenceMappingsList) {
                    Competence competence;
                    if (toolActivity.getActivityId() != null) {
                        CompetenceMapping competenceMapping;
                        competence = this.competenceDAO.getCompetence(toolActivity.getLearningDesign(), competenceMappingEntry);
                        if (competence == null || (competenceMapping = this.competenceMappingDAO.getCompetenceMapping(toolActivity, competence)) != null) continue;
                        CompetenceMapping newMapping = new CompetenceMapping();
                        newMapping.setCompetence(competence);
                        newMapping.setToolActivity(toolActivity);
                        this.competenceMappingDAO.saveOrUpdate(newMapping);
                        continue;
                    }
                    competence = this.competenceDAO.getCompetence(this.learningDesign, competenceMappingEntry);
                    CompetenceMapping newMapping = new CompetenceMapping();
                    newMapping.setCompetence(competence);
                    newMapping.setToolActivity(toolActivity);
                    this.competenceMappingDAO.saveOrUpdate(newMapping);
                }
                Set existingMappings = toolActivity.getCompetenceMappings();
                if (existingMappings == null) continue;
                HashSet<CompetenceMapping> removeCompetenceMappings = new HashSet<CompetenceMapping>();
                if (competenceMappingsList != null && competenceMappingsList.size() > 0) {
                    for (CompetenceMapping competenceMapping : existingMappings) {
                        boolean remove = true;
                        for (String competenceMappingEntry : competenceMappingsList) {
                            if (!competenceMappingEntry.equals(competenceMapping.getCompetence().getTitle())) continue;
                            remove = false;
                            break;
                        }
                        if (!remove) continue;
                        removeCompetenceMappings.add(competenceMapping);
                    }
                } else {
                    removeCompetenceMappings.addAll(existingMappings);
                }
                this.competenceMappingDAO.deleteAll(removeCompetenceMappings);
                toolActivity.getCompetenceMappings().removeAll(removeCompetenceMappings);
            }
        }
    }

    private void parseCompetences(List<Hashtable> competenceList, LearningDesign learningDesign) throws WDDXProcessorConversionException, ObjectExtractorException {
        Set existingCompetences = learningDesign.getCompetences();
        if (competenceList != null) {
            for (Hashtable competenceTable : competenceList) {
                String title = (String)competenceTable.get("title");
                String description = (String)competenceTable.get("description");
                if (this.getComptenceFromSet(existingCompetences, title) != null) {
                    Competence updateCompetence = this.getComptenceFromSet(existingCompetences, title);
                    updateCompetence.setDescription(description);
                    this.competenceDAO.saveOrUpdate(updateCompetence);
                    continue;
                }
                Competence newCompetence = new Competence();
                newCompetence.setTitle(title);
                newCompetence.setDescription(description);
                newCompetence.setLearningDesign(learningDesign);
                this.competenceDAO.saveOrUpdate(newCompetence);
            }
            HashSet<Competence> removeCompetences = new HashSet<Competence>();
            if (existingCompetences != null) {
                if (competenceList != null && competenceList.size() > 0) {
                    for (Competence existingCompetence : existingCompetences) {
                        boolean remove = true;
                        for (Hashtable competenceTable : competenceList) {
                            if (!existingCompetence.getTitle().equals(competenceTable.get("title"))) continue;
                            remove = false;
                            break;
                        }
                        if (!remove) continue;
                        removeCompetences.add(existingCompetence);
                    }
                } else {
                    removeCompetences.addAll(existingCompetences);
                }
                learningDesign.getCompetences().removeAll(removeCompetences);
            }
        }
    }

    private Competence getComptenceFromSet(Set<Competence> competences, String title) {
        if (competences != null) {
            for (Competence competence : competences) {
                if (!competence.getTitle().equals(title)) continue;
                return competence;
            }
        }
        return null;
    }

    private void parseActivitiesToMatchUpParentandInputActivities(List activitiesList) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (activitiesList != null) {
            for (Hashtable activityDetails : activitiesList) {
                Integer activityUUID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID");
                Activity existingActivity = this.newActivityMap.get(activityUUID);
                if (this.keyExists(activityDetails, "parentUIID")) {
                    Integer parentUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"parentUIID");
                    if (parentUIID != null) {
                        Activity parentActivity = this.newActivityMap.get(parentUIID);
                        if (parentActivity == null) {
                            throw new ObjectExtractorException("Parent activity " + parentUIID + " missing for activity " + existingActivity.getTitle() + ": " + existingActivity.getActivityUIID());
                        }
                        existingActivity.setParentActivity(parentActivity);
                        existingActivity.setParentUIID(parentUIID);
                        if (parentActivity.isComplexActivity()) {
                            ((ComplexActivity)parentActivity).addActivity(existingActivity);
                            this.activityDAO.update((Object)parentActivity);
                        }
                    } else {
                        existingActivity.setParentActivity(null);
                        existingActivity.setParentUIID(null);
                        existingActivity.setOrderId(null);
                    }
                }
                existingActivity.getInputActivities().clear();
                Integer inputActivityUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"toolActivityUIID");
                if (inputActivityUIID != null) {
                    Activity inputActivity = this.newActivityMap.get(inputActivityUIID);
                    if (inputActivity == null) {
                        throw new ObjectExtractorException("Input activity " + inputActivityUIID + " missing for activity " + existingActivity.getTitle() + ": " + existingActivity.getActivityUIID());
                    }
                    existingActivity.getInputActivities().add(inputActivity);
                }
                this.activityDAO.update((Object)existingActivity);
            }
        }
    }

    private void parseTransitions(List transitionsList) throws WDDXProcessorConversionException {
        HashMap<Integer, Transition> newMap = new HashMap<Integer, Transition>();
        if (transitionsList != null) {
            for (Hashtable transitionDetails : transitionsList) {
                Transition transition = this.extractTransitionObject(transitionDetails);
                if (transition == null) continue;
                this.transitionDAO.insertOrUpdate((Object)transition);
                newMap.put(transition.getTransitionUIID(), transition);
            }
        }
        for (Transition element : this.learningDesign.getTransitions()) {
            Integer uiID = element.getTransitionUIID();
            Transition match = (Transition)newMap.get(uiID);
            if (match != null) continue;
            this.cleanupTransition(element);
        }
        this.learningDesign.getTransitions().clear();
        this.learningDesign.getTransitions().addAll(newMap.values());
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
    }

    public Activity extractActivityObject(Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        Integer activityUUID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID");
        Activity activity = null;
        Integer activityTypeID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityTypeID");
        if (activityTypeID == null) {
            throw new ObjectExtractorException("activityTypeID missing");
        }
        Activity existingActivity = this.activityDAO.getActivityByUIID(activityUUID, this.learningDesign);
        if (existingActivity != null && !existingActivity.getActivityTypeId().equals(activityTypeID)) {
            existingActivity = null;
        }
        activity = existingActivity != null ? existingActivity : Activity.getActivityInstance((int)activityTypeID);
        this.processActivityType(activity, activityDetails);
        if (this.keyExists(activityDetails, "activityTypeID")) {
            activity.setActivityTypeId(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityTypeID"));
        }
        if (this.keyExists(activityDetails, "activityUIID")) {
            activity.setActivityUIID(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityUIID"));
        }
        if (this.keyExists(activityDetails, "description")) {
            activity.setDescription(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"description"));
        }
        if (this.keyExists(activityDetails, "activityTitle")) {
            activity.setTitle(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"activityTitle"));
        }
        if (this.keyExists(activityDetails, "helpText")) {
            activity.setHelpText(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"helpText"));
        }
        activity.setXcoord(this.getCoord(activityDetails, "xCoord"));
        activity.setYcoord(this.getCoord(activityDetails, "yCoord"));
        if (this.keyExists(activityDetails, "groupingUIID")) {
            Integer groupingUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"groupingUIID");
            if (groupingUIID != null) {
                Grouping grouping = this.groupings.get(groupingUIID);
                if (grouping != null) {
                    this.setGrouping(activity, grouping, groupingUIID);
                } else {
                    this.log.warn((Object)("Unable to find matching grouping for groupingUIID" + groupingUIID + ". Activity UUID" + activityUUID + " will not be grouped."));
                    this.clearGrouping(activity);
                }
            } else {
                this.clearGrouping(activity);
            }
        } else {
            this.clearGrouping(activity);
        }
        if (this.keyExists(activityDetails, "orderID")) {
            activity.setOrderId(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"orderID"));
        }
        if (this.keyExists(activityDetails, "defineLater")) {
            activity.setDefineLater(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"defineLater"));
        }
        activity.setLearningDesign(this.learningDesign);
        if (this.keyExists(activityDetails, "learningLibraryID")) {
            Long learningLibraryID = WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"learningLibraryID");
            if (learningLibraryID != null) {
                LearningLibrary library = this.learningLibraryDAO.getLearningLibraryById(learningLibraryID);
                activity.setLearningLibrary(library);
            } else {
                activity.setLearningLibrary(null);
            }
        }
        if (activity.getCreateDateTime() == null) {
            activity.setCreateDateTime(this.modificationDate);
        }
        if (this.keyExists(activityDetails, "runOffline")) {
            activity.setRunOffline(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"runOffline"));
        }
        if (this.keyExists(activityDetails, "activityCategoryID")) {
            activity.setActivityCategoryID(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"activityCategoryID"));
        }
        if (this.keyExists(activityDetails, "libraryActivityUIImage")) {
            activity.setLibraryActivityUiImage(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"libraryActivityUIImage"));
        }
        if (this.keyExists(activityDetails, "groupingSupportType")) {
            activity.setGroupingSupportType(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"groupingSupportType"));
        }
        if (this.keyExists(activityDetails, "stopAfterActivity")) {
            activity.setStopAfterActivity(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"stopAfterActivity"));
        }
        return activity;
    }

    private Integer getCoord(Hashtable details, String wddxtag) throws WDDXProcessorConversionException {
        Integer coord = null;
        if (this.keyExists(details, wddxtag)) {
            coord = WDDXProcessor.convertToInteger((Hashtable)details, (String)wddxtag);
        }
        return coord == null || coord >= 0 ? coord : DEFAULT_COORD;
    }

    private void clearGrouping(Activity activity) {
        activity.setGrouping(null);
        activity.setGroupingUIID(null);
        activity.setApplyGrouping(Boolean.valueOf(false));
    }

    private void setGrouping(Activity activity, Grouping grouping, Integer groupingUIID) {
        activity.setGrouping(grouping);
        activity.setGroupingUIID(groupingUIID);
        activity.setApplyGrouping(Boolean.valueOf(true));
    }

    private void processActivityType(Activity activity, Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (activity.isGroupingActivity()) {
            this.buildGroupingActivity((GroupingActivity)activity, activityDetails);
        } else if (activity.isToolActivity()) {
            this.buildToolActivity((ToolActivity)activity, activityDetails);
        } else if (activity.isGateActivity()) {
            this.buildGateActivity(activity, activityDetails);
        } else {
            this.buildComplexActivity((ComplexActivity)activity, activityDetails);
        }
    }

    private void buildComplexActivity(ComplexActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        activity.getActivities().clear();
        activity.setDefaultActivity(null);
        Integer defaultActivityMapUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"defaultActivityUIID");
        if (defaultActivityMapUIID != null) {
            this.defaultActivityMap.put(defaultActivityMapUIID, activity);
        }
        if (activity instanceof OptionsActivity) {
            this.buildOptionsActivity((OptionsActivity)activity, activityDetails);
        } else if (activity instanceof ParallelActivity) {
            this.buildParallelActivity((ParallelActivity)activity, activityDetails);
        } else if (activity instanceof BranchingActivity) {
            this.buildBranchingActivity((BranchingActivity)activity, activityDetails);
        } else if (activity instanceof FloatingActivity) {
            this.buildFloatingActivity((FloatingActivity)activity, activityDetails);
        } else {
            this.buildSequenceActivity((SequenceActivity)activity, activityDetails);
        }
    }

    private void buildFloatingActivity(FloatingActivity floatingActivity, Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (this.keyExists(activityDetails, "maxActivities")) {
            floatingActivity.setMaxNumberOfActivities(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"maxActivities"));
        }
        SystemTool systemTool = this.getSystemTool(SystemTool.FLOATING_ACTIVITIES);
        floatingActivity.setSystemTool(systemTool);
    }

    private void buildBranchingActivity(BranchingActivity branchingActivity, Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        if (branchingActivity.isChosenBranchingActivity()) {
            branchingActivity.setSystemTool(this.getSystemTool(SystemTool.TEACHER_CHOSEN_BRANCHING));
        } else if (branchingActivity.isGroupBranchingActivity()) {
            branchingActivity.setSystemTool(this.getSystemTool(SystemTool.GROUP_BASED_BRANCHING));
        } else if (branchingActivity.isToolBranchingActivity()) {
            branchingActivity.setSystemTool(this.getSystemTool(SystemTool.TOOL_BASED_BRANCHING));
        }
        branchingActivity.setStartXcoord(this.getCoord(activityDetails, "startXCoord"));
        branchingActivity.setStartYcoord(this.getCoord(activityDetails, "startYCoord"));
        branchingActivity.setEndXcoord(this.getCoord(activityDetails, "endXCoord"));
        branchingActivity.setEndYcoord(this.getCoord(activityDetails, "endYCoord"));
    }

    private void buildGroupingActivity(GroupingActivity groupingActivity, Hashtable activityDetails) throws WDDXProcessorConversionException, ObjectExtractorException {
        Integer createGroupingUIID = WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"createGroupingUIID");
        Grouping grouping = this.groupings.get(createGroupingUIID);
        if (grouping != null) {
            groupingActivity.setCreateGrouping(grouping);
            groupingActivity.setCreateGroupingUIID(createGroupingUIID);
        }
        SystemTool systemTool = this.getSystemTool(SystemTool.GROUPING);
        groupingActivity.setSystemTool(systemTool);
    }

    private void buildOptionsActivity(OptionsActivity optionsActivity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (this.keyExists(activityDetails, "maxOptions")) {
            optionsActivity.setMaxNumberOfOptions(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"maxOptions"));
        }
        if (this.keyExists(activityDetails, "minOptions")) {
            optionsActivity.setMinNumberOfOptions(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"minOptions"));
        }
        if (this.keyExists(activityDetails, "optionsInstructions")) {
            optionsActivity.setOptionsInstructions(WDDXProcessor.convertToString((Hashtable)activityDetails, (String)"optionsInstructions"));
        }
    }

    private void buildParallelActivity(ParallelActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
    }

    private void buildSequenceActivity(SequenceActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        activity.setSystemTool(this.getSystemTool(SystemTool.SEQUENCE));
    }

    private void buildToolActivity(ToolActivity toolActivity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("In tool activity UUID" + activityDetails.get("activityUIID") + " tool content id=" + activityDetails.get("toolContentID")));
        }
        if (this.keyExists(activityDetails, "toolContentID")) {
            toolActivity.setToolContentId(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"toolContentID"));
        }
        if (this.keyExists(activityDetails, "toolID")) {
            Tool tool = this.toolDAO.getToolByID(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"toolID"));
            toolActivity.setTool(tool);
        }
    }

    private void buildGateActivity(Object activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        if (activity instanceof SynchGateActivity) {
            this.buildSynchGateActivity((SynchGateActivity)activity, activityDetails);
        } else if (activity instanceof PermissionGateActivity) {
            this.buildPermissionGateActivity((PermissionGateActivity)activity, activityDetails);
        } else if (activity instanceof SystemGateActivity) {
            this.buildSystemGateActivity((SystemGateActivity)activity, activityDetails);
        } else if (activity instanceof ConditionGateActivity) {
            this.buildConditionGateActivity((ConditionGateActivity)activity, activityDetails);
        } else {
            this.buildScheduleGateActivity((ScheduleGateActivity)activity, activityDetails);
        }
        GateActivity gateActivity = (GateActivity)activity;
        gateActivity.setGateActivityLevelId(WDDXProcessor.convertToInteger((Hashtable)activityDetails, (String)"gateActivityLevelID"));
        gateActivity.setGateOpen(WDDXProcessor.convertToBoolean((Hashtable)activityDetails, (String)"gateOpen"));
    }

    private void buildSynchGateActivity(SynchGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        activity.setSystemTool(this.getSystemTool(SystemTool.SYNC_GATE));
    }

    private void buildPermissionGateActivity(PermissionGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        activity.setSystemTool(this.getSystemTool(SystemTool.PERMISSION_GATE));
    }

    private void buildSystemGateActivity(SystemGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        activity.setSystemTool(this.getSystemTool(SystemTool.SYSTEM_GATE));
    }

    private void buildScheduleGateActivity(ScheduleGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        activity.setGateStartTimeOffset(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"gateStartTimeOffset"));
        activity.setGateEndTimeOffset(WDDXProcessor.convertToLong((Hashtable)activityDetails, (String)"gateEndTimeOffset"));
        SystemTool systemTool = this.getSystemTool(SystemTool.SCHEDULE_GATE);
        activity.setSystemTool(systemTool);
    }

    private void createLessonClass(LessonClass lessonClass, Hashtable groupingDetails) throws WDDXProcessorConversionException {
        Group group;
        if (this.keyExists(groupingDetails, "staffGroupID") && (group = this.groupDAO.getGroupById(WDDXProcessor.convertToLong((Hashtable)groupingDetails, (String)"staffGroupID"))) != null) {
            lessonClass.setStaffGroup(group);
        }
    }

    private Transition extractTransitionObject(Hashtable transitionDetails) throws WDDXProcessorConversionException {
        Integer transitionUUID = WDDXProcessor.convertToInteger((Hashtable)transitionDetails, (String)"transitionUIID");
        if (transitionUUID == null) {
            throw new WDDXProcessorConversionException("Transition is missing its UUID " + transitionDetails);
        }
        Integer toUIID = WDDXProcessor.convertToInteger((Hashtable)transitionDetails, (String)"toUIID");
        if (toUIID == null) {
            throw new WDDXProcessorConversionException("Transition is missing its toUUID " + transitionDetails);
        }
        Integer fromUIID = WDDXProcessor.convertToInteger((Hashtable)transitionDetails, (String)"fromUIID");
        if (fromUIID == null) {
            throw new WDDXProcessorConversionException("Transition is missing its fromUUID " + transitionDetails);
        }
        Transition transition = null;
        Transition existingTransition = this.findTransition(transitionUUID, toUIID, fromUIID);
        transition = existingTransition == null ? new Transition() : existingTransition;
        transition.setTransitionUIID(transitionUUID);
        Activity toActivity = this.newActivityMap.get(toUIID);
        if (toActivity != null) {
            transition.setToActivity(toActivity);
            transition.setToUIID(toUIID);
            toActivity.setTransitionTo(transition);
        } else {
            transition.setToActivity(null);
            transition.setToUIID(null);
        }
        Activity fromActivity = this.newActivityMap.get(fromUIID);
        if (fromActivity != null) {
            transition.setFromActivity(fromActivity);
            transition.setFromUIID(fromUIID);
            fromActivity.setTransitionFrom(transition);
        } else {
            transition.setFromActivity(null);
            transition.setFromUIID(null);
        }
        transition.setDescription(WDDXProcessor.convertToString((Hashtable)transitionDetails, (String)"description"));
        transition.setTitle(WDDXProcessor.convertToString((Hashtable)transitionDetails, (String)"title"));
        if (transition.getCreateDateTime() == null) {
            transition.setCreateDateTime(this.modificationDate);
        }
        if (transition.getToActivity() != null && transition.getFromActivity() != null) {
            transition.setLearningDesign(this.learningDesign);
            return transition;
        }
        this.cleanupTransition(transition);
        transition.setLearningDesign(null);
        return null;
    }

    private void cleanupTransition(Transition transition) {
        if (transition.getFromActivity().getTransitionFrom().equals((Object)transition)) {
            transition.getFromActivity().setTransitionFrom(null);
        }
        if (transition.getToActivity().getTransitionTo().equals((Object)transition)) {
            transition.getToActivity().setTransitionTo(null);
        }
    }

    private Transition findTransition(Integer transitionUUID, Integer toUIID, Integer fromUIID) {
        Transition existingTransition = null;
        Set transitions = this.learningDesign.getTransitions();
        Iterator iter = transitions.iterator();
        while (existingTransition == null && iter.hasNext()) {
            Transition element = (Transition)iter.next();
            if (transitionUUID != null && transitionUUID.equals(element.getTransitionUIID())) {
                existingTransition = element;
                continue;
            }
            if (toUIID == null || !toUIID.equals(element.getToUIID()) || fromUIID == null || !fromUIID.equals(element.getFromUIID())) continue;
            existingTransition = element;
        }
        return existingTransition;
    }

    private boolean keyExists(Hashtable table, String key) {
        return table.containsKey(key);
    }

    @Override
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Override
    public Integer getMode() {
        return this.mode;
    }

    private void parseBranchMappings(List branchMappingsList) throws WDDXProcessorConversionException {
        if (branchMappingsList != null) {
            Iterator iterator = branchMappingsList.iterator();
            while (iterator.hasNext()) {
                this.extractBranchActivityEntry((Hashtable)iterator.next());
            }
        }
        for (BranchActivityEntry oldEntry : this.oldbranchActivityEntryList) {
            SequenceActivity sequenceActivity = oldEntry.getBranchSequenceActivity();
            if (sequenceActivity == null) {
                oldEntry.getBranchingActivity().getBranchActivityEntries().remove(oldEntry);
            } else {
                sequenceActivity.getBranchEntries().remove(oldEntry);
            }
            Group group = oldEntry.getGroup();
            if (group != null) {
                group.getBranchActivities().remove(oldEntry);
            }
            this.activityDAO.delete((Object)oldEntry);
        }
    }

    private BranchActivityEntry extractBranchActivityEntry(Hashtable details) throws WDDXProcessorConversionException {
        Long entryId = WDDXProcessor.convertToLong((Hashtable)details, (String)"entryID");
        Integer entryUIID = WDDXProcessor.convertToInteger((Hashtable)details, (String)"entryUIID");
        if (entryUIID == null) {
            throw new WDDXProcessorConversionException("Group based branch mapping entry is missing its UUID. Entry " + details);
        }
        Integer sequenceActivityUIID = WDDXProcessor.convertToInteger((Hashtable)details, (String)"sequenceActivityUIID");
        Boolean gateOpenWhenConditionMet = WDDXProcessor.convertToBoolean((Hashtable)details, (String)"gateOpenWhenConditionMet");
        Integer branchingActivityUIID = null;
        branchingActivityUIID = gateOpenWhenConditionMet != null ? WDDXProcessor.convertToInteger((Hashtable)details, (String)"gateActivityUIID") : WDDXProcessor.convertToInteger((Hashtable)details, (String)"branchingActivityUIID");
        Activity branchingActivity = this.newActivityMap.get(branchingActivityUIID);
        if (branchingActivity == null) {
            throw new WDDXProcessorConversionException("Branching Activity listed in the branch mapping list is missing. Mapping entry UUID " + entryUIID + " branchingActivityUIID " + branchingActivityUIID);
        }
        if (!branchingActivity.isBranchingActivity() && !branchingActivity.isConditionGate()) {
            throw new WDDXProcessorConversionException("Activity listed in the branch mapping list is not a branching activity nor a condition gate. Mapping entry UUID " + entryUIID + " branchingActivityUIID " + branchingActivityUIID);
        }
        SequenceActivity sequenceActivity = null;
        if (!branchingActivity.isConditionGate()) {
            Activity activity = this.newActivityMap.get(sequenceActivityUIID);
            if (activity == null) {
                throw new WDDXProcessorConversionException("Sequence Activity listed in the branch mapping list is missing. Mapping entry UUID " + entryUIID + " sequenceActivityUIID " + sequenceActivityUIID);
            }
            if (!activity.isSequenceActivity()) {
                throw new WDDXProcessorConversionException("Activity listed in the branch mapping list is not a sequence activity. Mapping entry UUID " + entryUIID + " sequenceActivityUIID " + sequenceActivityUIID);
            }
            sequenceActivity = (SequenceActivity)activity;
        }
        BranchActivityEntry uiid_match = null;
        BranchActivityEntry id_match = null;
        Iterator iter = null;
        if (sequenceActivity == null) {
            ConditionGateActivity conditionGateActitivity = (ConditionGateActivity)branchingActivity;
            if (conditionGateActitivity.getBranchActivityEntries() != null) {
                iter = conditionGateActitivity.getBranchActivityEntries().iterator();
            }
        } else if (sequenceActivity.getBranchEntries() != null) {
            iter = sequenceActivity.getBranchEntries().iterator();
        }
        if (iter != null) {
            while (uiid_match == null && iter.hasNext()) {
                BranchActivityEntry possibleEntry = (BranchActivityEntry)iter.next();
                if (entryUIID.equals(possibleEntry.getEntryUIID())) {
                    uiid_match = possibleEntry;
                }
                if (entryId == null || !entryId.equals(possibleEntry.getEntryId())) continue;
                id_match = possibleEntry;
            }
        }
        BranchActivityEntry entry = uiid_match != null ? uiid_match : id_match;
        this.oldbranchActivityEntryList.remove(entry);
        BranchCondition condition = this.extractCondition((Hashtable)details.get("condition"), entry);
        Integer groupUIID = WDDXProcessor.convertToInteger((Hashtable)details, (String)"groupUIID");
        Group group = null;
        if (groupUIID != null && (group = this.groups.get(groupUIID)) == null) {
            throw new WDDXProcessorConversionException("Group listed in the branch mapping list is missing. Mapping entry UUID " + entryUIID + " groupUIID " + groupUIID);
        }
        if (condition == null && group == null) {
            throw new WDDXProcessorConversionException("Branch mapping has neither a group or a condition. Not a valid mapping. " + details);
        }
        if (entry == null) {
            entry = condition != null ? condition.allocateBranchToCondition(entryUIID, sequenceActivity, branchingActivity, gateOpenWhenConditionMet) : group.allocateBranchToGroup(entryUIID, sequenceActivity, (BranchingActivity)branchingActivity);
        } else {
            entry.setEntryUIID(entryUIID);
            entry.setBranchSequenceActivity(sequenceActivity);
            entry.setBranchingActivity(branchingActivity);
            entry.setGateOpenWhenConditionMet(gateOpenWhenConditionMet);
        }
        entry.setGroup(group);
        entry.setCondition(condition);
        if (branchingActivity.isConditionGate()) {
            ConditionGateActivity conditionGateActitivity = (ConditionGateActivity)branchingActivity;
            if (conditionGateActitivity.getBranchActivityEntries() == null) {
                conditionGateActitivity.setBranchActivityEntries(new HashSet());
            }
            conditionGateActitivity.getBranchActivityEntries().add(entry);
        } else {
            if (sequenceActivity.getBranchEntries() == null) {
                sequenceActivity.setBranchEntries(new HashSet());
            }
            sequenceActivity.getBranchEntries().add(entry);
            this.activityDAO.update((Object)sequenceActivity);
        }
        if (group != null) {
            this.groupingDAO.update((Object)group);
        }
        return entry;
    }

    private BranchCondition extractCondition(Hashtable conditionTable, BranchActivityEntry entry) throws WDDXProcessorConversionException {
        BranchCondition condition = null;
        if (conditionTable != null && conditionTable.size() > 0) {
            Integer conditionUIID;
            Long conditionID = WDDXProcessor.convertToLong((Hashtable)conditionTable, (String)"conditionID");
            if (entry != null) {
                condition = entry.getCondition();
            }
            if (condition != null && conditionID != null && !condition.getConditionId().equals(conditionID)) {
                this.log.warn((Object)("Unexpected behaviour: condition supplied in WDDX packet has a different ID to matching branch activity entry in the database. Dropping old database condition. Old db condition " + condition + " new entry in WDDX " + conditionTable));
                condition = null;
            }
            if ((conditionUIID = WDDXProcessor.convertToInteger((Hashtable)conditionTable, (String)"conditionUIID")) == null) {
                throw new WDDXProcessorConversionException("Condition is missing its UUID: " + conditionTable);
            }
            String conditionType = WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"type");
            if ("OUTPUT_COMPLEX".equals(conditionType) || "OUTPUT_STRING".equals(conditionType)) {
                Long newConditionID = condition == null ? WDDXProcessor.convertToLong((Hashtable)conditionTable, (String)"conditionId") : condition.getConditionId();
                BranchCondition originalCondition = this.branchActivityEntryDAO.getConditionByID(newConditionID);
                if (originalCondition == null) {
                    this.log.error((Object)("Could not find condition with given ID: " + conditionID));
                } else {
                    condition = condition == null ? (BranchCondition)originalCondition.clone() : originalCondition;
                    condition.setConditionUIID(conditionUIID);
                }
            } else if (condition == null) {
                condition = new BranchCondition(null, conditionUIID, WDDXProcessor.convertToInteger((Hashtable)conditionTable, (String)"orderID"), WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"name"), WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"displayName"), WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"type"), WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"startValue"), WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"endValue"), WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"exactMatchValue"));
            } else {
                condition.setConditionUIID(conditionUIID);
                condition.setDisplayName(WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"displayName"));
                condition.setEndValue(WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"endValue"));
                condition.setExactMatchValue(WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"exactMatchValue"));
                condition.setName(WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"name"));
                condition.setOrderId(WDDXProcessor.convertToInteger((Hashtable)conditionTable, (String)"orderID"));
                condition.setStartValue(WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"startValue"));
                condition.setType(WDDXProcessor.convertToString((Hashtable)conditionTable, (String)"type"));
            }
        }
        return condition;
    }

    private SystemTool getSystemTool(Long systemToolId) {
        SystemTool tool = this.systemTools.get(systemToolId);
        if (tool == null) {
            tool = this.systemToolDAO.getSystemToolByID(systemToolId);
            if (tool != null) {
                this.systemTools.put(systemToolId, tool);
            } else {
                this.log.error((Object)("ObjectExtractor: Unable to find matching system tool for id " + systemToolId));
            }
        }
        return tool;
    }

    private void createLearnerChoiceGrouping(LearnerChoiceGrouping learnerChoiceGrouping, Hashtable groupingDetails) throws WDDXProcessorConversionException {
        Integer numLearnersPerGroup = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"learnersPerGroup");
        if (numLearnersPerGroup != null && numLearnersPerGroup > 0) {
            learnerChoiceGrouping.setLearnersPerGroup(numLearnersPerGroup);
            learnerChoiceGrouping.setNumberOfGroups(null);
            learnerChoiceGrouping.setEqualNumberOfLearnersPerGroup(null);
        } else {
            Integer numGroups = WDDXProcessor.convertToInteger((Hashtable)groupingDetails, (String)"numberOfGroups");
            if (numGroups != null && numGroups > 0) {
                learnerChoiceGrouping.setNumberOfGroups(numGroups);
            } else {
                learnerChoiceGrouping.setNumberOfGroups(null);
            }
            learnerChoiceGrouping.setLearnersPerGroup(null);
            Boolean equalNumberOfLearnersPerGroup = WDDXProcessor.convertToBoolean((Hashtable)groupingDetails, (String)"equalNumberOfLearnersPerGroup");
            if (equalNumberOfLearnersPerGroup != null) {
                learnerChoiceGrouping.setEqualNumberOfLearnersPerGroup(equalNumberOfLearnersPerGroup);
            }
        }
        Boolean viewStudentsBeforeSelection = WDDXProcessor.convertToBoolean((Hashtable)groupingDetails, (String)"viewStudentsBeforeSelection");
        learnerChoiceGrouping.setViewStudentsBeforeSelection(viewStudentsBeforeSelection);
    }

    private void buildConditionGateActivity(ConditionGateActivity activity, Hashtable activityDetails) throws WDDXProcessorConversionException {
        activity.setSystemTool(this.getSystemTool(SystemTool.CONDITION_GATE));
    }
}

