/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.IObjectExtractor;
import org.lamsfoundation.lams.authoring.service.EditOnFlyProcessor;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Competence;
import org.lamsfoundation.lams.learningdesign.CompetenceMapping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.FloatingActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.CompetenceDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.CompetenceMappingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.GroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.TransitionDAO;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.DesignDetailDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.LicenseDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.planner.dao.PedagogicalPlannerDAO;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolContentIDGenerator;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.dao.hibernate.SystemToolDAO;
import org.lamsfoundation.lams.tool.dao.hibernate.ToolDAO;
import org.lamsfoundation.lams.tool.dto.ToolOutputDefinitionDTO;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringService
implements IAuthoringService,
BeanFactoryAware {
    protected Logger log = Logger.getLogger(AuthoringService.class);
    protected LearningDesignDAO learningDesignDAO;
    protected LearningLibraryDAO learningLibraryDAO;
    protected ActivityDAO activityDAO;
    protected BaseDAO baseDAO;
    protected TransitionDAO transitionDAO;
    protected ToolDAO toolDAO;
    protected LicenseDAO licenseDAO;
    protected GroupingDAO groupingDAO;
    protected GroupDAO groupDAO;
    protected CompetenceDAO competenceDAO;
    protected CompetenceMappingDAO competenceMappingDAO;
    protected SystemToolDAO systemToolDAO;
    protected PedagogicalPlannerDAO pedagogicalPlannerDAO;
    protected ILamsCoreToolService lamsCoreToolService;
    protected ILearningDesignService learningDesignService;
    protected MessageService messageService;
    protected ILessonService lessonService;
    protected IMonitoringService monitoringService;
    protected IWorkspaceManagementService workspaceManagementService;
    protected ToolContentIDGenerator contentIDGenerator;
    protected BeanFactory beanFactory;

    public void setPedagogicalPlannerDAO(PedagogicalPlannerDAO pedagogicalPlannerDAO) {
        this.pedagogicalPlannerDAO = pedagogicalPlannerDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setGroupDAO(GroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setGroupingDAO(GroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public CompetenceDAO getCompetenceDAO() {
        return this.competenceDAO;
    }

    public void setCompetenceDAO(CompetenceDAO competenceDAO) {
        this.competenceDAO = competenceDAO;
    }

    public CompetenceMappingDAO getCompetenceMappingDAO() {
        return this.competenceMappingDAO;
    }

    public void setCompetenceMappingDAO(CompetenceMappingDAO competenceMappingDAO) {
        this.competenceMappingDAO = competenceMappingDAO;
    }

    public void setTransitionDAO(TransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public void setLearningDesignDAO(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setLearningLibraryDAO(LearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setBaseDAO(BaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setActivityDAO(ActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setToolDAO(ToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public void setSystemToolDAO(SystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public void setLicenseDAO(LicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public ILamsCoreToolService getLamsCoreToolService() {
        return this.lamsCoreToolService;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsCoreToolService) {
        this.lamsCoreToolService = lamsCoreToolService;
    }

    public ILearningDesignService getLearningDesignService() {
        return this.learningDesignService;
    }

    public void setLearningDesignService(ILearningDesignService learningDesignService) {
        this.learningDesignService = learningDesignService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    public ILessonService getLessonService() {
        return this.lessonService;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public void setMonitoringService(IMonitoringService monitoringService) {
        this.monitoringService = monitoringService;
    }

    public void setWorkspaceManagementService(IWorkspaceManagementService workspaceManagementService) {
        this.workspaceManagementService = workspaceManagementService;
    }

    public void setContentIDGenerator(ToolContentIDGenerator contentIDGenerator) {
        this.contentIDGenerator = contentIDGenerator;
    }

    @Override
    public LearningDesign getLearningDesign(Long learningDesignID) {
        return this.learningDesignDAO.getLearningDesignById(learningDesignID);
    }

    @Override
    public void saveLearningDesign(LearningDesign learningDesign) {
        this.learningDesignDAO.insertOrUpdate((Object)learningDesign);
    }

    @Override
    public List getAllLearningDesigns() {
        return this.learningDesignDAO.getAllLearningDesigns();
    }

    @Override
    public List getAllLearningLibraries() {
        return this.learningLibraryDAO.getAllLearningLibraries();
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public static Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO learner = (UserDTO)ss.getAttribute("user");
        return learner != null ? learner.getUserID() : null;
    }

    @Override
    public String getToolOutputDefinitions(Long toolContentID) throws IOException {
        SortedMap defns = this.lamsCoreToolService.getOutputDefinitionsFromTool(toolContentID);
        ArrayList<ToolOutputDefinitionDTO> defnDTOList = new ArrayList<ToolOutputDefinitionDTO>(defns != null ? defns.size() : 0);
        if (defns != null) {
            for (ToolOutputDefinition defn : defns.values()) {
                defnDTOList.add(new ToolOutputDefinitionDTO(defn));
            }
        }
        FlashMessage flashMessage = new FlashMessage("getToolOutputDefinitions", defnDTOList);
        return flashMessage.serializeMessage();
    }

    @Override
    public String getLearningDesignDetails(Long learningDesignID, String languageCode) throws IOException {
        FlashMessage flashMessage = null;
        LearningDesignDTO learningDesignDTO = this.learningDesignService.getLearningDesignDTO(learningDesignID, languageCode);
        flashMessage = learningDesignDTO == null ? FlashMessage.getNoSuchLearningDesignExists((String)"getLearningDesignDetails", (Long)learningDesignID) : new FlashMessage("getLearningDesignDetails", (Object)learningDesignDTO);
        return flashMessage.serializeMessage();
    }

    @Override
    public boolean isLearningDesignAvailable(LearningDesign design, Integer userID) throws LearningDesignException, IOException {
        if (design == null) {
            throw new LearningDesignException(FlashMessage.getNoSuchLearningDesignExists((String)"getLearningDesignDetails", (Long)design.getLearningDesignId()).serializeMessage());
        }
        if (design.getEditOverrideUser() != null && design.getEditOverrideLock() != null) {
            return design.getEditOverrideUser().getUserId().equals(userID) ? true : design.getEditOverrideLock() == false;
        }
        return true;
    }

    private void setLessonLock(LearningDesign design, boolean lock) {
        Lesson lesson2 = null;
        Set lessons = design.getLessons();
        for (Lesson lesson2 : lessons) {
            lesson2.setLockedForEdit(Boolean.valueOf(lock));
        }
    }

    @Override
    public boolean setupEditOnFlyLock(Long learningDesignID, Integer userID) throws LearningDesignException, UserException, IOException {
        LearningDesign design;
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        LearningDesign learningDesign = design = learningDesignID != null ? this.getLearningDesign(learningDesignID) : null;
        if (this.isLearningDesignAvailable(design, userID)) {
            if (design.getLessons().isEmpty()) {
                throw new LearningDesignException("There are no lessons attached to the design.");
            }
            if (user == null) {
                throw new UserException(this.messageService.getMessage("no.such.user.exist", new Object[]{userID}));
            }
            this.setLessonLock(design, true);
            design.setEditOverrideLock(Boolean.valueOf(true));
            design.setEditOverrideUser(user);
            this.learningDesignDAO.update((Object)design);
            return true;
        }
        return false;
    }

    @Override
    public String setupEditOnFlyGate(Long learningDesignID, Integer userID) throws UserException, IOException {
        LearningDesign design;
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        LearningDesign learningDesign = design = learningDesignID != null ? this.getLearningDesign(learningDesignID) : null;
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user.exist", new Object[]{userID}));
        }
        EditOnFlyProcessor processor = new EditOnFlyProcessor(design, (IActivityDAO)this.activityDAO);
        processor.parseLearningDesign();
        ArrayList<Activity> activities = processor.getLastReadOnlyActivity();
        this.addSystemGateAfterActivity(activities, design);
        this.setLessonLock(design, false);
        this.learningDesignDAO.update((Object)design);
        return new FlashMessage("setupEditOnFlyGate", (Object)true).serializeMessage();
    }

    @Override
    public String finishEditOnFly(Long learningDesignID, Integer userID, boolean cancelled) throws IOException {
        FlashMessage flashMessage = null;
        Lesson lesson2 = null;
        LearningDesign design = learningDesignID != null ? this.learningDesignDAO.getLearningDesignById(learningDesignID) : null;
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            flashMessage = FlashMessage.getNoSuchUserExists((String)"finishEditOnFly", (Integer)userID);
        }
        if (design != null) {
            if (design.getEditOverrideUser().equals((Object)user)) {
                design.setEditOverrideLock(Boolean.valueOf(false));
                design.setEditOverrideUser(null);
                Set lessons = design.getLessons();
                for (Lesson lesson2 : lessons) {
                    lesson2.setLockedForEdit(Boolean.valueOf(false));
                }
                EditOnFlyProcessor processor = new EditOnFlyProcessor(design, (IActivityDAO)this.activityDAO);
                processor.parseLearningDesign();
                ArrayList<Activity> activities = processor.getLastReadOnlyActivity();
                GateActivity gate = null;
                if (activities != null && !activities.isEmpty() && activities.get(0).isGateActivity()) {
                    gate = (GateActivity)activities.get(0);
                }
                if (gate != null) {
                    design = this.removeTempSystemGate(gate, design);
                }
                if (!cancelled) {
                    this.lessonService.performMarkLessonUncompleted(lesson2.getLessonId());
                }
                this.initialiseToolActivityForRuntime(design, lesson2);
                this.learningDesignDAO.insertOrUpdate((Object)design);
                flashMessage = new FlashMessage("finishEditOnFly", (Object)lesson2.getLessonId());
            } else {
                flashMessage = FlashMessage.getNoSuchUserExists((String)"finishEditOnFly", (Integer)userID);
            }
        } else {
            flashMessage = FlashMessage.getNoSuchLearningDesignExists((String)"finishEditOnFly", (Long)learningDesignID);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public LearningDesign removeTempSystemGate(GateActivity gate, LearningDesign design) {
        Transition toTransition = gate.getTransitionTo();
        Transition fromTransition = gate.getTransitionFrom();
        if (toTransition != null && fromTransition != null) {
            toTransition.setToActivity(fromTransition.getToActivity());
            toTransition.setToUIID(toTransition.getToActivity().getActivityUIID());
            design.getTransitions().remove(fromTransition);
            this.transitionDAO.update((Object)toTransition);
        } else if (toTransition != null && fromTransition == null) {
            design.getTransitions().remove(toTransition);
        } else if (toTransition == null && fromTransition != null) {
            design.setFirstActivity(fromTransition.getToActivity());
            design.getTransitions().remove(fromTransition);
        }
        design.getActivities().remove(gate);
        design.setDesignVersion(Integer.valueOf(design.getDesignVersion() + 1));
        this.lessonService.removeProgressReferencesToActivity((Activity)gate);
        return design;
    }

    public void addSystemGateAfterActivity(ArrayList<Activity> activities, LearningDesign design) {
        GateActivity gate = null;
        Integer syncType = new Integer(9);
        Integer activityType = new Integer(9);
        Integer maxId = design.getMaxID();
        String title = "System Gate";
        SystemTool systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.SYSTEM_GATE);
        Activity activity = activities.isEmpty() ? null : activities.get(0);
        try {
            Transition fromTransition;
            gate = (GateActivity)Activity.getActivityInstance((int)syncType);
            gate.setActivityTypeId(Integer.valueOf(activityType));
            gate.setActivityCategoryID(Integer.valueOf(1));
            gate.setSystemTool(systemTool);
            maxId = maxId + 1;
            gate.setActivityUIID(maxId);
            gate.setTitle(title != null ? title : "Gate");
            gate.setGateOpen(Boolean.valueOf(false));
            gate.setWaitingLearners(null);
            gate.setGateActivityLevelId(Integer.valueOf(1));
            gate.setApplyGrouping(Boolean.valueOf(false));
            gate.setGroupingSupportType(Integer.valueOf(2));
            gate.setOrderId(null);
            gate.setDefineLater(Boolean.FALSE);
            gate.setCreateDateTime(new Date());
            gate.setRunOffline(Boolean.FALSE);
            gate.setReadOnly(Boolean.TRUE);
            gate.setLearningDesign(design);
            design.getActivities().add(gate);
            this.baseDAO.insert((Object)gate);
            Transition newTransition = new Transition();
            Activity toActivity = null;
            if (activity != null) {
                fromTransition = activity.getTransitionFrom();
                if (fromTransition != null) {
                    toActivity = fromTransition.getToActivity();
                    fromTransition.setToActivity((Activity)gate);
                    fromTransition.setToUIID(gate.getActivityUIID());
                    maxId = maxId + 1;
                    newTransition.setTransitionUIID(maxId);
                    newTransition.setFromActivity((Activity)gate);
                    newTransition.setFromUIID(gate.getActivityUIID());
                    newTransition.setToActivity(toActivity);
                    newTransition.setToUIID(toActivity.getActivityUIID());
                    newTransition.setLearningDesign(design);
                    gate.setTransitionFrom(newTransition);
                    toActivity.setTransitionTo(newTransition);
                    Integer x1 = activity.getXcoord() != null ? activity.getXcoord() : 0;
                    Integer x2 = toActivity.getXcoord() != null ? toActivity.getXcoord() : 0;
                    gate.setXcoord(new Integer((x1 + 123 + x2) / 2 - 13));
                    Integer y1 = activity.getYcoord() != null ? activity.getYcoord() : 0;
                    Integer y2 = toActivity.getYcoord() != null ? toActivity.getYcoord() : 0;
                    gate.setYcoord(new Integer((y1 + 50 + y2) / 2));
                } else {
                    maxId = maxId + 1;
                    newTransition.setTransitionUIID(maxId);
                    newTransition.setFromActivity(activity);
                    newTransition.setFromUIID(activity.getActivityUIID());
                    newTransition.setToActivity((Activity)gate);
                    newTransition.setToUIID(gate.getActivityUIID());
                    newTransition.setLearningDesign(design);
                    activity.setTransitionFrom(fromTransition);
                    gate.setTransitionTo(fromTransition);
                    Integer x1 = activity.getTransitionTo() != null ? activity.getTransitionTo().getFromActivity().getXcoord() : 0;
                    Integer x2 = activity.getXcoord() != null ? activity.getXcoord() : 0;
                    if (x1 != null && x2 != null) {
                        gate.setXcoord(x2 >= x1 ? new Integer(x2 + 123 + 13 + 20) : new Integer(x2 - 13 - 20));
                    } else {
                        gate.setXcoord(new Integer(x2 + 123 + 13 + 20));
                    }
                    gate.setYcoord(Integer.valueOf(activity.getYcoord() + 25));
                }
            } else {
                Integer x2;
                fromTransition = newTransition;
                toActivity = design.getFirstActivity();
                maxId = maxId + 1;
                newTransition.setTransitionUIID(maxId);
                newTransition.setToActivity(toActivity);
                newTransition.setToUIID(toActivity.getActivityUIID());
                newTransition.setFromActivity((Activity)gate);
                newTransition.setFromUIID(gate.getActivityUIID());
                newTransition.setLearningDesign(design);
                gate.setTransitionFrom(fromTransition);
                toActivity.setTransitionTo(fromTransition);
                gate.setGateOpen(Boolean.valueOf(false));
                design.setFirstActivity((Activity)gate);
                Integer x1 = toActivity.getXcoord() != null ? toActivity.getXcoord() : 0;
                Integer n = x2 = toActivity.getTransitionFrom() != null ? toActivity.getTransitionFrom().getToActivity().getXcoord() : null;
                if (x1 != null && x2 != null) {
                    gate.setXcoord(x2 >= x1 ? new Integer(x1 - 13 - 20) : new Integer(x1 + 123 + 13 + 20));
                } else {
                    gate.setXcoord(new Integer(x1 - 13 - 20));
                }
                gate.setYcoord(Integer.valueOf(toActivity.getYcoord() + 25));
            }
            design.getTransitions().add(newTransition);
            design.setMaxID(maxId);
            design.setDesignVersion(Integer.valueOf(design.getDesignVersion() + 1));
            if (gate != null) {
                this.activityDAO.update((Object)gate);
            }
            if (activity != null) {
                this.activityDAO.update((Object)activity);
            }
            if (toActivity != null) {
                this.activityDAO.update((Object)toActivity);
            }
            if (fromTransition != null && !fromTransition.equals((Object)newTransition)) {
                this.baseDAO.update((Object)fromTransition);
            }
            if (newTransition != null) {
                this.baseDAO.insert((Object)newTransition);
            }
            if (design != null) {
                this.learningDesignDAO.insertOrUpdate((Object)design);
            }
        }
        catch (NullPointerException npe) {
            this.log.error((Object)npe.getMessage(), (Throwable)npe);
        }
    }

    @Override
    public Activity getFirstUnattemptedActivity(LearningDesign design) throws LearningDesignException {
        Activity activity = design.getFirstActivity();
        while (activity.getReadOnly().booleanValue() && activity.getTransitionFrom() != null) {
            activity = activity.getTransitionFrom().getToActivity();
        }
        return activity;
    }

    private void initialiseToolActivityForRuntime(LearningDesign design, Lesson lesson) throws MonitoringServiceException {
        Date now = new Date();
        Set activities = design.getActivities();
        for (Activity activity : activities) {
            Long newContentId;
            ToolActivity toolActivity;
            if (activity.isInitialised().booleanValue()) {
                if (activity.isActivityReadOnly() || !activity.isToolActivity()) continue;
                toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
                newContentId = this.lamsCoreToolService.notifyToolOfStatusFlags(toolActivity);
                toolActivity.setToolContentId(newContentId);
                continue;
            }
            if (activity.isToolActivity()) {
                toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
                newContentId = this.lamsCoreToolService.notifyToolToCopyContent(toolActivity, true, null);
                toolActivity.setToolContentId(newContentId);
                this.monitoringService.initToolSessionIfSuitable(toolActivity, lesson);
            } else {
                Integer newMaxId = this.monitoringService.startSystemActivity(activity, design.getMaxID(), now, lesson.getLessonName());
                if (newMaxId != null) {
                    design.setMaxID(newMaxId);
                }
            }
            activity.setInitialised(Boolean.TRUE);
            this.activityDAO.update((Object)activity);
        }
    }

    @Override
    public LearningDesign copyLearningDesign(Long originalDesignID, Integer copyType, Integer userID, Integer workspaceFolderID, boolean setOriginalDesign) throws UserException, LearningDesignException, WorkspaceFolderException, IOException {
        LearningDesign originalDesign = this.learningDesignDAO.getLearningDesignById(originalDesignID);
        if (originalDesign == null) {
            throw new LearningDesignException(this.messageService.getMessage("no.such.learningdesign.exist", new Object[]{originalDesignID}));
        }
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user.exist", new Object[]{userID}));
        }
        WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
        if (workspaceFolder == null) {
            throw new WorkspaceFolderException(this.messageService.getMessage("no.such.workspace.exist", new Object[]{workspaceFolderID}));
        }
        if (!this.workspaceManagementService.isUserAuthorizedToModifyFolderContents(workspaceFolder.getWorkspaceFolderId(), user.getUserId())) {
            throw new UserAccessDeniedException("User with user_id of " + user.getUserId() + " is not authorized to copy a learning design into the workspace folder " + workspaceFolder.getWorkspaceFolderId());
        }
        return this.copyLearningDesign(originalDesign, copyType, user, workspaceFolder, setOriginalDesign, null, null);
    }

    @Override
    public LearningDesign copyLearningDesign(LearningDesign originalLearningDesign, Integer copyType, User user, WorkspaceFolder workspaceFolder, boolean setOriginalDesign, String newDesignName, String customCSV) {
        String newTitle = newDesignName;
        if (newTitle == null) {
            newTitle = this.getUniqueNameForLearningDesign(originalLearningDesign.getTitle(), workspaceFolder != null ? workspaceFolder.getWorkspaceFolderId() : null);
        }
        LearningDesign newLearningDesign = LearningDesign.createLearningDesignCopy((LearningDesign)originalLearningDesign, (Integer)copyType, (boolean)setOriginalDesign);
        newLearningDesign.setTitle(newTitle);
        newLearningDesign.setUser(user);
        newLearningDesign.setWorkspaceFolder(workspaceFolder);
        newLearningDesign.setEditOverrideLock(Boolean.valueOf(false));
        this.learningDesignDAO.insert((Object)newLearningDesign);
        this.updateDesignCompetences(originalLearningDesign, newLearningDesign, false);
        HashMap<Integer, Activity> newActivities = this.updateDesignActivities(originalLearningDesign, newLearningDesign, 0, customCSV);
        this.updateDesignTransitions(originalLearningDesign, newLearningDesign, newActivities, 0);
        newLearningDesign.setFirstActivity(newLearningDesign.calculateFirstActivity());
        newLearningDesign.setFloatingActivity(newLearningDesign.calculateFloatingActivity());
        newLearningDesign.setLearningDesignUIID(originalLearningDesign.getLearningDesignUIID());
        this.updateCompetenceMappings(newLearningDesign.getCompetences(), newActivities);
        this.updateEvaluations(newActivities);
        return newLearningDesign;
    }

    @Override
    public LearningDesign insertLearningDesign(Long originalDesignID, Long designToImportID, Integer userID, boolean createNewLearningDesign, String newDesignName, Integer workspaceFolderID, String customCSV) throws UserException, WorkspaceFolderException, IOException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user.exist", new Object[]{userID}));
        }
        LearningDesign mainDesign = this.learningDesignDAO.getLearningDesignById(originalDesignID);
        if (mainDesign == null) {
            throw new LearningDesignException(this.messageService.getMessage("no.such.learningdesign.exist", new Object[]{originalDesignID}));
        }
        LearningDesign designToImport = this.learningDesignDAO.getLearningDesignById(designToImportID);
        if (designToImport == null) {
            throw new LearningDesignException(this.messageService.getMessage("no.such.learningdesign.exist", new Object[]{designToImportID}));
        }
        if (createNewLearningDesign) {
            WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
            if (workspaceFolder == null) {
                throw new WorkspaceFolderException(this.messageService.getMessage("no.such.workspace.exist", new Object[]{workspaceFolderID}));
            }
            if (!this.workspaceManagementService.isUserAuthorizedToModifyFolderContents(workspaceFolder.getWorkspaceFolderId(), user.getUserId())) {
                throw new UserAccessDeniedException("User with user_id of " + user.getUserId() + " is not authorized to store a copy a learning design into the workspace folder " + workspaceFolder);
            }
            mainDesign = this.copyLearningDesign(mainDesign, 1, user, workspaceFolder, false, newDesignName, customCSV);
        } else {
            boolean authorised = this.workspaceManagementService.isUserAuthorizedToModifyFolderContents(mainDesign.getWorkspaceFolder().getWorkspaceFolderId(), user.getUserId());
            if (!authorised) {
                boolean bl = authorised = mainDesign.getEditOverrideLock() != null && mainDesign.getEditOverrideLock() != false && userID.equals(mainDesign.getEditOverrideUser().getUserId());
            }
            if (!authorised) {
                throw new UserAccessDeniedException("User with user_id of " + user.getUserId() + " is not authorized to update a learning design into the workspace folder " + mainDesign.getWorkspaceFolder());
            }
        }
        int uiidOffset = mainDesign.getMaxID();
        this.updateDesignCompetences(designToImport, mainDesign, true);
        HashMap<Integer, Activity> newActivities = this.updateDesignActivities(designToImport, mainDesign, uiidOffset, customCSV);
        this.updateDesignTransitions(designToImport, mainDesign, newActivities, uiidOffset);
        mainDesign.setMaxID(LearningDesign.addOffset((Integer)designToImport.getMaxID(), (int)uiidOffset));
        mainDesign.setValidDesign(Boolean.FALSE);
        mainDesign.setLastModifiedDateTime(new Date());
        this.learningDesignDAO.update((Object)mainDesign);
        this.insertCompetenceMappings(mainDesign.getCompetences(), designToImport.getCompetences(), newActivities);
        this.updateEvaluations(newActivities);
        return mainDesign;
    }

    private LearningDesign copyLearningDesignToolContent(LearningDesign design, LearningDesign originalLearningDesign, Integer copyType, String customCSV) throws LearningDesignException {
        for (Activity currentActivity : design.getActivities()) {
            if (!currentActivity.isToolActivity()) continue;
            this.copyActivityToolContent(currentActivity, design.getCopyTypeID(), originalLearningDesign.getLearningDesignId(), customCSV);
        }
        return design;
    }

    private void copyActivityToolContent(Activity activity, Integer ldCopyType, Long originalLearningDesignId, String customCSV) {
        try {
            ToolActivity toolActivity = (ToolActivity)activity;
            Long newContentId = this.lamsCoreToolService.notifyToolToCopyContent(toolActivity, ldCopyType != 3, customCSV);
            toolActivity.setToolContentId(newContentId);
            toolActivity.setReadOnly(Boolean.valueOf(false));
        }
        catch (DataMissingException e) {
            String error = "Unable to copy a design / initialise the lesson. Data is missing for activity " + activity.getActivityUIID() + " in learning design " + originalLearningDesignId + " default content may be missing for the tool. Error was " + e.getMessage();
            this.log.error((Object)error, (Throwable)e);
            throw new LearningDesignException(error, (Throwable)e);
        }
        catch (ToolException e) {
            String error = "Unable to copy a design / initialise the lesson. Tool encountered an error copying the data is missing for activity " + activity.getActivityUIID() + " in learning design " + originalLearningDesignId + " default content may be missing for the tool. Error was " + e.getMessage();
            this.log.error((Object)error, (Throwable)e);
            throw new LearningDesignException(error, (Throwable)e);
        }
    }

    private HashMap<Integer, Activity> updateDesignActivities(LearningDesign originalLearningDesign, LearningDesign newLearningDesign, int uiidOffset, String customCSV) {
        HashMap<Integer, Activity> newActivities = new HashMap<Integer, Activity>();
        HashMap<Integer, Grouping> newGroupings = new HashMap<Integer, Grouping>();
        HashMap firstChildUIIDToSequence = new HashMap();
        HashSet oldParentActivities = originalLearningDesign.getParentActivities();
        if (oldParentActivities != null) {
            Iterator iterator = oldParentActivities.iterator();
            while (iterator.hasNext()) {
                this.processActivity((Activity)iterator.next(), newLearningDesign, newActivities, newGroupings, null, originalLearningDesign.getLearningDesignId(), uiidOffset, customCSV);
            }
        }
        Collection activities = newActivities.values();
        for (Activity activity : activities) {
            if (activity.getGroupingUIID() == null) continue;
            activity.setGrouping(newGroupings.get(activity.getGroupingUIID()));
        }
        for (Activity activity : activities) {
            SequenceActivity newSequenceActivity;
            ComplexActivity newComplex;
            Activity oldDefaultActivity;
            if (activity.isComplexActivity() && (oldDefaultActivity = (newComplex = (ComplexActivity)activity).getDefaultActivity()) != null) {
                Activity newDefaultActivity = newActivities.get(LearningDesign.addOffset((Integer)oldDefaultActivity.getActivityUIID(), (int)uiidOffset));
                newComplex.setDefaultActivity(newDefaultActivity);
            }
            if (activity.isSequenceActivity() && (newSequenceActivity = (SequenceActivity)activity).getBranchEntries() != null && newSequenceActivity.getBranchEntries().size() > 0) {
                Activity parentActivity = newSequenceActivity.getParentActivity();
                if (parentActivity.isChosenBranchingActivity() || parentActivity.isGroupBranchingActivity() && parentActivity.getDefineLater() != null && parentActivity.getDefineLater().booleanValue()) {
                    newSequenceActivity.getBranchEntries().clear();
                } else {
                    for (BranchActivityEntry entry : newSequenceActivity.getBranchEntries()) {
                        Grouping oldGrouping;
                        Grouping newGrouping;
                        BranchingActivity oldBranchingActivity = (BranchingActivity)entry.getBranchingActivity();
                        entry.setBranchingActivity(newActivities.get(LearningDesign.addOffset((Integer)oldBranchingActivity.getActivityUIID(), (int)uiidOffset)));
                        Group oldGroup = entry.getGroup();
                        if (oldGroup == null || (newGrouping = newGroupings.get(LearningDesign.addOffset((Integer)(oldGrouping = oldGroup.getGrouping()).getGroupingUIID(), (int)uiidOffset))) == null) continue;
                        entry.setGroup(newGrouping.getGroup(LearningDesign.addOffset((Integer)oldGroup.getGroupUIID(), (int)uiidOffset)));
                    }
                }
            }
            if (activity.getInputActivities() == null || activity.getInputActivities().size() <= 0) continue;
            HashSet<Activity> newInputActivities = new HashSet<Activity>();
            for (Activity elem : activity.getInputActivities()) {
                newInputActivities.add(newActivities.get(LearningDesign.addOffset((Integer)elem.getActivityUIID(), (int)uiidOffset)));
            }
            activity.getInputActivities().clear();
            activity.getInputActivities().addAll(newInputActivities);
        }
        if (uiidOffset == 0) {
            newLearningDesign.getActivities().clear();
        }
        newLearningDesign.getActivities().addAll(activities);
        for (Activity activity : activities) {
            if (!activity.isBranchingActivity()) continue;
            this.activityDAO.insert((Object)activity);
        }
        return newActivities;
    }

    private void processActivity(Activity activity, LearningDesign newLearningDesign, Map<Integer, Activity> newActivities, Map<Integer, Grouping> newGroupings, Activity parentActivity, Long originalLearningDesignId, int uiidOffset, String customCSV) {
        HashSet oldChildActivities;
        Activity newActivity = this.getActivityCopy(activity, newGroupings, uiidOffset);
        newActivity.setActivityUIID(newActivity.getActivityUIID());
        newActivity.setLearningDesign(newLearningDesign);
        newActivity.setReadOnly(Boolean.valueOf(false));
        if (parentActivity != null) {
            newActivity.setParentActivity(parentActivity);
            newActivity.setParentUIID(parentActivity.getActivityUIID());
        }
        if (!newActivity.isFloatingActivity() || newLearningDesign.getFloatingActivity() == null) {
            newActivities.put(newActivity.getActivityUIID(), newActivity);
        }
        if (newActivity.isToolActivity()) {
            this.copyActivityToolContent(newActivity, newLearningDesign.getCopyTypeID(), originalLearningDesignId, customCSV);
        }
        if ((oldChildActivities = this.getChildActivities(activity)) != null) {
            for (Activity childActivity : oldChildActivities) {
                FloatingActivity fParentActivity = null;
                Activity refParentActivity = null;
                if (childActivity.isFloating() && newLearningDesign.getFloatingActivity() != null) {
                    fParentActivity = newLearningDesign.getFloatingActivity();
                } else {
                    refParentActivity = newActivity;
                }
                if (childActivity.isFloating() && fParentActivity != null) {
                    childActivity.setOrderId(Integer.valueOf(fParentActivity.getActivities().size() + childActivity.getOrderId() + 1));
                }
                FloatingActivity pActivity = fParentActivity != null ? fParentActivity : refParentActivity;
                this.processActivity(childActivity, newLearningDesign, newActivities, newGroupings, (Activity)pActivity, originalLearningDesignId, uiidOffset, customCSV);
            }
        }
    }

    public void updateDesignTransitions(LearningDesign originalLearningDesign, LearningDesign newLearningDesign, HashMap<Integer, Activity> newActivities, int uiidOffset) {
        HashSet<Transition> newTransitions = new HashSet<Transition>();
        Set oldTransitions = originalLearningDesign.getTransitions();
        for (Transition transition : oldTransitions) {
            Transition newTransition = Transition.createCopy((Transition)transition, (int)uiidOffset);
            Activity toActivity = null;
            Activity fromActivity = null;
            if (newTransition.getToUIID() != null) {
                toActivity = newActivities.get(newTransition.getToUIID());
                toActivity.setTransitionTo(newTransition);
            }
            if (newTransition.getFromUIID() != null) {
                fromActivity = newActivities.get(newTransition.getFromUIID());
                fromActivity.setTransitionFrom(newTransition);
            }
            newTransition.setToActivity(toActivity);
            newTransition.setFromActivity(fromActivity);
            newTransition.setLearningDesign(newLearningDesign);
            this.transitionDAO.insert((Object)newTransition);
            newTransitions.add(newTransition);
        }
        if (newLearningDesign.getTransitions() != null) {
            if (uiidOffset == 0) {
                newLearningDesign.getTransitions().clear();
            }
            newLearningDesign.getTransitions().addAll(newTransitions);
        } else {
            newLearningDesign.setTransitions(newTransitions);
        }
    }

    public void updateDesignCompetences(LearningDesign originalLearningDesign, LearningDesign newLearningDesign, boolean insert) {
        HashSet<Competence> newCompeteces = new HashSet<Competence>();
        Set oldCompetences = originalLearningDesign.getCompetences();
        if (oldCompetences != null) {
            for (Competence competence : oldCompetences) {
                Competence newCompetence = competence.createCopy(competence);
                newCompetence.setLearningDesign(newLearningDesign);
                if (this.competenceDAO.getCompetence(newLearningDesign, newCompetence.getTitle()) == null) {
                    this.competenceDAO.saveOrUpdate(newCompetence);
                }
                newCompeteces.add(newCompetence);
            }
        }
        if (newLearningDesign.getCompetences() != null) {
            if (!insert) {
                newLearningDesign.getCompetences().clear();
                newLearningDesign.getCompetences().addAll(newCompeteces);
            } else {
                for (Competence newCompetence : newCompeteces) {
                    boolean alreadyExistsInLD = false;
                    for (Competence existingCompetence : originalLearningDesign.getCompetences()) {
                        if (!newCompetence.getTitle().equals(existingCompetence.getTitle())) continue;
                        alreadyExistsInLD = true;
                        break;
                    }
                    if (alreadyExistsInLD) continue;
                    newLearningDesign.getCompetences().add(newCompetence);
                }
            }
        } else {
            newLearningDesign.setCompetences(newCompeteces);
        }
    }

    public void insertCompetenceMappings(Set<Competence> oldCompetences, Set<Competence> newCompetences, HashMap<Integer, Activity> newActivities) {
        for (Integer activityKey : newActivities.keySet()) {
            Activity activity = newActivities.get(activityKey);
            if (!activity.isToolActivity()) continue;
            HashSet<CompetenceMapping> newCompetenceMappings = new HashSet<CompetenceMapping>();
            ToolActivity newToolActivity = (ToolActivity)activity;
            if (newToolActivity.getCompetenceMappings() != null) {
                for (CompetenceMapping competenceMapping : newToolActivity.getCompetenceMappings()) {
                    CompetenceMapping newMapping = new CompetenceMapping();
                    newMapping.setToolActivity(newToolActivity);
                    if (oldCompetences != null && oldCompetences.size() > 0 && this.getCompetenceFromSet(oldCompetences, competenceMapping.getCompetence().getTitle()) != null) {
                        newMapping.setCompetence(this.getCompetenceFromSet(oldCompetences, competenceMapping.getCompetence().getTitle()));
                        this.competenceMappingDAO.insert((Object)newMapping);
                        newCompetenceMappings.add(newMapping);
                        continue;
                    }
                    if (newCompetences == null || newCompetences.size() <= 0 || this.getCompetenceFromSet(newCompetences, competenceMapping.getCompetence().getTitle()) == null) continue;
                    newMapping.setCompetence(this.getCompetenceFromSet(newCompetences, competenceMapping.getCompetence().getTitle()));
                    this.competenceMappingDAO.insert((Object)newMapping);
                    newCompetenceMappings.add(newMapping);
                }
            }
            newToolActivity.getCompetenceMappings().addAll(newCompetenceMappings);
        }
    }

    public Competence getCompetenceFromSet(Set<Competence> competences, String title) {
        Competence ret = null;
        for (Competence competence : competences) {
            if (!competence.getTitle().equals(title)) continue;
            ret = competence;
            break;
        }
        return ret;
    }

    public void updateCompetenceMappings(Set<Competence> newCompetences, HashMap<Integer, Activity> newActivities) {
        for (Integer activityKey : newActivities.keySet()) {
            Activity activity = newActivities.get(activityKey);
            if (!activity.isToolActivity()) continue;
            HashSet<CompetenceMapping> newCompetenceMappings = new HashSet<CompetenceMapping>();
            ToolActivity newToolActivity = (ToolActivity)activity;
            if (newToolActivity.getCompetenceMappings() != null) {
                for (CompetenceMapping competenceMapping : newToolActivity.getCompetenceMappings()) {
                    CompetenceMapping newMapping = new CompetenceMapping();
                    if (newCompetences == null) continue;
                    for (Competence newCompetence : newCompetences) {
                        if (!competenceMapping.getCompetence().getTitle().equals(newCompetence.getTitle())) continue;
                        newMapping.setToolActivity(newToolActivity);
                        newMapping.setCompetence(newCompetence);
                        this.competenceMappingDAO.insert((Object)newMapping);
                        newCompetenceMappings.add(newMapping);
                    }
                }
            }
            newToolActivity.getCompetenceMappings().addAll(newCompetenceMappings);
        }
    }

    private void updateEvaluations(HashMap<Integer, Activity> newActivities) {
        for (Integer key : newActivities.keySet()) {
            Set newActivityEvaluations;
            Activity activity = newActivities.get(key);
            if (!activity.isToolActivity() || (newActivityEvaluations = ((ToolActivity)activity).getActivityEvaluations()) == null) continue;
            this.baseDAO.insertOrUpdateAll((Collection)newActivityEvaluations);
        }
    }

    private Activity getActivityCopy(Activity activity, Map<Integer, Grouping> newGroupings, int uiidOffset) {
        if (2 == activity.getActivityTypeId()) {
            GroupingActivity newGroupingActivity = (GroupingActivity)activity.createCopy(uiidOffset);
            Grouping grouping = newGroupingActivity.getCreateGrouping();
            grouping.setGroupingUIID(grouping.getGroupingUIID());
            if (grouping != null) {
                this.groupingDAO.insert((Object)grouping);
                newGroupings.put(grouping.getGroupingUIID(), grouping);
            }
            return newGroupingActivity;
        }
        return activity.createCopy(uiidOffset);
    }

    private HashSet getChildActivities(Activity parentActivity) {
        HashSet childActivities = new HashSet();
        List list = this.activityDAO.getActivitiesByParentActivityId(parentActivity.getActivityId());
        if (list != null) {
            childActivities.addAll(list);
        }
        return childActivities;
    }

    @Override
    public Long storeLearningDesignDetails(String wddxPacket) throws Exception {
        Long learningDesignId;
        LearningDesign existingLearningDesign;
        Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)wddxPacket);
        Integer workspaceFolderID = WDDXProcessor.convertToInteger((Hashtable)table, (String)"workspaceFolderID");
        User user = null;
        Integer userID = AuthoringService.getUserId();
        if (userID != null) {
            user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        }
        if (user == null) {
            throw new UserException("UserID missing or user not found.");
        }
        WorkspaceFolder workspaceFolder = null;
        boolean authorised = false;
        if (workspaceFolderID != null) {
            workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
            authorised = this.workspaceManagementService.isUserAuthorizedToModifyFolderContents(workspaceFolderID, userID);
        }
        LearningDesign learningDesign = existingLearningDesign = (learningDesignId = WDDXProcessor.convertToLong((Hashtable)table, (String)"learningDesignID")) != null ? this.learningDesignDAO.getLearningDesignById(learningDesignId) : null;
        if (!authorised && existingLearningDesign != null && Boolean.TRUE.equals(existingLearningDesign.getEditOverrideLock())) {
            authorised = userID.equals(existingLearningDesign.getEditOverrideUser().getUserId());
        }
        if (!authorised) {
            throw new UserException("User with user_id of " + userID + " is not authorized to store a design in this workspace folder " + workspaceFolderID);
        }
        IObjectExtractor extractor = (IObjectExtractor)this.beanFactory.getBean("ObjectExtractor");
        LearningDesign design = extractor.extractSaveLearningDesign(table, existingLearningDesign, workspaceFolder, user);
        if (extractor.getMode() == 1) {
            String customCSV = null;
            if (table.containsKey("customCSV")) {
                customCSV = WDDXProcessor.convertToString((Hashtable)table, (String)"customCSV");
            }
            this.copyLearningDesignToolContent(design, design, design.getCopyTypeID(), customCSV);
        }
        return design.getLearningDesignId();
    }

    @Override
    public Vector<ValidationErrorDTO> validateLearningDesign(Long learningDesignId) {
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignId);
        Vector listOfValidationErrorDTOs = this.learningDesignService.validateLearningDesign(learningDesign);
        Boolean valid = listOfValidationErrorDTOs.size() > 0 ? Boolean.FALSE : Boolean.TRUE;
        learningDesign.setValidDesign(valid);
        this.learningDesignDAO.insertOrUpdate((Object)learningDesign);
        return listOfValidationErrorDTOs;
    }

    @Override
    public Vector<AuthoringActivityDTO> getToolActivities(Long learningDesignId, String languageCode) {
        LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignId);
        Vector<AuthoringActivityDTO> listOfAuthoringActivityDTOs = new Vector<AuthoringActivityDTO>();
        for (Activity currentActivity : learningDesign.getActivities()) {
            if (!currentActivity.isToolActivity()) continue;
            try {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(currentActivity.getActivityId());
                AuthoringActivityDTO activityDTO = new AuthoringActivityDTO((Activity)toolActivity, null, languageCode);
                listOfAuthoringActivityDTOs.add(activityDTO);
            }
            catch (ToolException e) {
                String error = "" + e.getMessage();
                this.log.error((Object)error, (Throwable)e);
                throw new LearningDesignException(error, (Throwable)e);
            }
        }
        return listOfAuthoringActivityDTOs;
    }

    @Override
    public String getAllLearningDesignDetails() throws IOException {
        Iterator iterator = this.getAllLearningDesigns().iterator();
        ArrayList arrayList = this.createDesignDetailsPacket(iterator);
        FlashMessage flashMessage = new FlashMessage("getAllLearningDesignDetails", (Object)arrayList);
        return flashMessage.serializeMessage();
    }

    private ArrayList createDesignDetailsPacket(Iterator iterator) {
        ArrayList<DesignDetailDTO> arrayList = new ArrayList<DesignDetailDTO>();
        while (iterator.hasNext()) {
            LearningDesign learningDesign = (LearningDesign)iterator.next();
            DesignDetailDTO designDetailDTO = learningDesign.getDesignDetailDTO();
            arrayList.add(designDetailDTO);
        }
        return arrayList;
    }

    @Override
    public String getLearningDesignsForUser(Long userID) throws IOException {
        List list = this.learningDesignDAO.getLearningDesignByUserId(userID);
        ArrayList arrayList = this.createDesignDetailsPacket(list.iterator());
        FlashMessage flashMessage = new FlashMessage("getLearningDesignsForUser", (Object)arrayList);
        return flashMessage.serializeMessage();
    }

    @Override
    public String getAllLearningLibraryDetails(String languageCode) throws IOException {
        FlashMessage flashMessage = new FlashMessage("getAllLearningLibraryDetails", (Object)this.learningDesignService.getAllLearningLibraryDetails(languageCode));
        return flashMessage.serializeMessage();
    }

    @Override
    public String getToolContentID(Long toolID) throws IOException {
        Tool tool = this.toolDAO.getToolByID(toolID);
        if (tool == null) {
            this.log.error((Object)("The toolID " + toolID + " is not valid. A Tool with tool id " + toolID + " does not exist on the database."));
            return FlashMessage.getNoSuchTool((String)"getToolContentID", (Long)toolID).serializeMessage();
        }
        Long newContentID = this.contentIDGenerator.getNextToolContentIDFor(tool);
        FlashMessage flashMessage = new FlashMessage("getToolContentID", (Object)newContentID);
        return flashMessage.serializeMessage();
    }

    @Override
    public String copyToolContent(Long toolContentID, String customCSV) throws IOException {
        Long newContentID = this.lamsCoreToolService.notifyToolToCopyContent(toolContentID, customCSV);
        FlashMessage flashMessage = new FlashMessage("copyToolContent", (Object)newContentID);
        return flashMessage.serializeMessage();
    }

    @Override
    public String copyMultipleToolContent(Integer userId, List<Long> toolContentIds, String customCSV) {
        StringBuffer idMap = new StringBuffer();
        for (Long oldToolContentId : toolContentIds) {
            if (oldToolContentId == null) continue;
            Long newToolContentId = this.lamsCoreToolService.notifyToolToCopyContent(oldToolContentId, customCSV);
            idMap.append(oldToolContentId);
            idMap.append('=');
            idMap.append(newToolContentId);
            idMap.append(',');
        }
        return idMap.length() > 0 ? idMap.substring(0, idMap.length() - 1) : "";
    }

    @Override
    public Vector getAvailableLicenses() {
        List licenses = this.licenseDAO.findAll(License.class);
        Vector<LicenseDTO> licenseDTOList = new Vector<LicenseDTO>(licenses.size());
        for (License element : licenses) {
            licenseDTOList.add(element.getLicenseDTO(Configuration.get((String)ConfigurationKeys.SERVER_URL)));
        }
        return licenseDTOList;
    }

    @Override
    public void deleteLearningDesign(LearningDesign design) {
        if (design == null) {
            this.log.error((Object)"deleteLearningDesign: unable to delete learning design as design is null.");
            return;
        }
        Set acts = design.getActivities();
        for (Activity activity : acts) {
            if (!activity.isToolActivity()) continue;
            try {
                ToolActivity toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId());
                this.lamsCoreToolService.notifyToolToDeleteContent(toolActivity);
            }
            catch (ToolException e) {
                this.log.error((Object)("Unable to delete tool content for activity" + activity + " as activity threw an exception"), (Throwable)e);
            }
        }
        this.learningDesignDAO.delete((Object)design);
    }

    @Override
    public String generateUniqueContentFolder() throws FileUtilException, IOException {
        String newUniqueContentFolderID = FileUtil.generateUniqueContentFolderID();
        FlashMessage flashMessage = new FlashMessage("createUniqueContentFolder", (Object)newUniqueContentFolderID);
        return flashMessage.serializeMessage();
    }

    @Override
    public String getHelpURL() throws Exception {
        FlashMessage flashMessage = null;
        String helpURL = Configuration.get((String)ConfigurationKeys.HELP_URL);
        if (helpURL == null) {
            throw new Exception();
        }
        flashMessage = new FlashMessage("getHelpURL", (Object)helpURL);
        return flashMessage.serializeMessage();
    }

    @Override
    public String getUniqueNameForLearningDesign(String originalTitle, Integer workspaceFolderId) {
        String newName = originalTitle;
        if (workspaceFolderId != null) {
            List ldTitleList = this.learningDesignDAO.getLearningDesignTitlesByWorkspaceFolder(workspaceFolderId);
            int idx = 1;
            Calendar calendar = Calendar.getInstance();
            int mth = calendar.get(2) + 1;
            String mthStr = new Integer(mth).toString();
            if (mth < 10) {
                mthStr = "0" + mthStr;
            }
            int day = calendar.get(5);
            String dayStr = new Integer(day).toString();
            if (day < 10) {
                dayStr = "0" + dayStr;
            }
            String nameMid = dayStr + mthStr + calendar.get(1);
            while (ldTitleList.contains(newName)) {
                newName = originalTitle + "_" + nameMid + "_" + idx;
                ++idx;
            }
        }
        return newName;
    }

    @Override
    public Grouping getGroupingById(Long groupingID) {
        return this.groupingDAO.getGroupingById(groupingID);
    }
}

