/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.service;

import java.util.ArrayList;
import org.apache.commons.collections.ArrayStack;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningDesignProcessor;
import org.lamsfoundation.lams.learningdesign.SimpleActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditOnFlyProcessor
extends LearningDesignProcessor {
    private static Logger log = Logger.getLogger(EditOnFlyProcessor.class);
    ArrayList<Activity> mainActivityList = new ArrayList();
    ArrayList<Activity> currentActivityList;
    ArrayStack activityListStack = new ArrayStack(5);

    public EditOnFlyProcessor(LearningDesign design, IActivityDAO activityDAO) {
        super(design, activityDAO);
        this.currentActivityList = this.mainActivityList;
    }

    public boolean startComplexActivity(ComplexActivity activity) throws LearningDesignProcessorException {
        this.activityListStack.push(this.currentActivityList);
        this.currentActivityList = new ArrayList();
        return true;
    }

    public void endComplexActivity(ComplexActivity activity) throws LearningDesignProcessorException {
        this.currentActivityList = (ArrayList)this.activityListStack.pop();
        if (!activity.isActivityReadOnly()) {
            return;
        }
        if (activity != null) {
            if (!this.currentActivityList.isEmpty()) {
                this.currentActivityList.remove(this.currentActivityList.size() - 1);
            }
            this.currentActivityList.add((Activity)activity);
        }
    }

    public void startSimpleActivity(SimpleActivity activity) throws LearningDesignProcessorException {
    }

    public void endSimpleActivity(SimpleActivity activity) throws LearningDesignProcessorException {
        if (!activity.isActivityReadOnly()) {
            return;
        }
        if (activity != null) {
            if (!this.currentActivityList.isEmpty()) {
                this.currentActivityList.remove(this.currentActivityList.size() - 1);
            }
            this.currentActivityList.add((Activity)activity);
        }
    }

    public ArrayList<Activity> getLastReadOnlyActivity() {
        return this.mainActivityList;
    }
}

