/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.service;

import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.MessageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IAuthoringService {
    public static final String STORE_LD_MESSAGE_KEY = "storeLearningDesignDetails";
    public static final String INSERT_LD_MESSAGE_KEY = "insertLearningDesign";
    public static final String START_EDIT_ON_FLY_MESSAGE_KEY = "startEditOnFly";
    public static final String COPY_TOOL_CONTENT_MESSAGE_KEY = "copyMultipleToolContent";

    public LearningDesign getLearningDesign(Long var1);

    public LearningDesign copyLearningDesign(LearningDesign var1, Integer var2, User var3, WorkspaceFolder var4, boolean var5, String var6, String var7);

    public LearningDesign copyLearningDesign(Long var1, Integer var2, Integer var3, Integer var4, boolean var5) throws UserException, LearningDesignException, WorkspaceFolderException, IOException;

    public LearningDesign insertLearningDesign(Long var1, Long var2, Integer var3, boolean var4, String var5, Integer var6, String var7) throws UserException, LearningDesignException, WorkspaceFolderException, IOException;

    public List getAllLearningDesigns();

    public List getAllLearningLibraries();

    public String getLearningDesignDetails(Long var1, String var2) throws IOException;

    public Long storeLearningDesignDetails(String var1) throws Exception;

    public Vector<ValidationErrorDTO> validateLearningDesign(Long var1);

    public Vector<AuthoringActivityDTO> getToolActivities(Long var1, String var2);

    public String getToolOutputDefinitions(Long var1) throws IOException;

    public String getAllLearningDesignDetails() throws IOException;

    public void saveLearningDesign(LearningDesign var1);

    public String getLearningDesignsForUser(Long var1) throws IOException;

    public String getAllLearningLibraryDetails(String var1) throws IOException;

    public String getToolContentID(Long var1) throws IOException;

    public String copyToolContent(Long var1, String var2) throws IOException;

    public String copyMultipleToolContent(Integer var1, List<Long> var2, String var3);

    public Vector getAvailableLicenses();

    public void deleteLearningDesign(LearningDesign var1);

    public String generateUniqueContentFolder() throws FileUtilException, IOException;

    public String setupEditOnFlyGate(Long var1, Integer var2) throws UserException, LearningDesignException, IOException;

    public boolean setupEditOnFlyLock(Long var1, Integer var2) throws LearningDesignException, UserException, IOException;

    public String finishEditOnFly(Long var1, Integer var2, boolean var3) throws IOException;

    public LearningDesign removeTempSystemGate(GateActivity var1, LearningDesign var2);

    public Activity getFirstUnattemptedActivity(LearningDesign var1) throws LearningDesignException;

    public boolean isLearningDesignAvailable(LearningDesign var1, Integer var2) throws LearningDesignException, IOException;

    public String getHelpURL() throws Exception;

    public MessageService getMessageService();

    public String getUniqueNameForLearningDesign(String var1, Integer var2);

    public Grouping getGroupingById(Long var1);
}

