/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AuthoringAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(AuthoringAction.class);
    private static IAuditService auditService;

    public IAuthoringService getAuthoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IAuthoringService)webContext.getBean("authoringService");
    }

    private Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    private String getUserLanguage() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getLocaleLanguage() : "";
    }

    private ActionForward outputPacket(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, String wddxPacket, String parameterName) throws IOException {
        response.addHeader("Cache-Control", "no-cache");
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getToolOutputDefinitions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String wddxPacket;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID", (boolean)false);
            wddxPacket = authoringService.getToolOutputDefinitions(toolContentID);
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getToolOutputDefinitions", authoringService, true).serializeMessage();
        }
        return this.outputPacket(mapping, request, response, wddxPacket, "definitions");
    }

    public ActionForward getLearningDesignDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String wddxPacket;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            Long learningDesignID = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID", (boolean)false);
            wddxPacket = authoringService.getLearningDesignDetails(learningDesignID, this.getUserLanguage());
            log.debug((Object)("LD wddx packet: " + wddxPacket));
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getLearningDesignDetails", authoringService, true).serializeMessage();
        }
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward finishLearningDesignEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String wddxPacket2;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            Long learningDesignID = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID", (boolean)false);
            boolean cancelled = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"cancelled", (boolean)false);
            wddxPacket2 = authoringService.finishEditOnFly(learningDesignID, this.getUserId(), cancelled);
        }
        catch (Exception e) {
            String wddxPacket2 = this.handleException(e, "getLearningDesignDetails", authoringService, true).serializeMessage();
            return this.outputPacket(mapping, request, response, wddxPacket2, "details");
        }
        return this.outputPacket(mapping, request, response, wddxPacket2, "details");
    }

    public ActionForward getLearningDesignsForUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String wddxPacket;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            Long userID = new Long(this.getUserId().intValue());
            wddxPacket = authoringService.getLearningDesignsForUser(userID);
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getLearningDesignsForUser", authoringService, true).serializeMessage();
        }
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getAllLearningDesignDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String wddxPacket;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            wddxPacket = authoringService.getAllLearningDesignDetails();
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getAllLearningDesignDetails", authoringService, true).serializeMessage();
        }
        log.debug((Object)("getAllLearningDesignDetails: returning " + wddxPacket));
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getAllLearningLibraryDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String wddxPacket;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            wddxPacket = authoringService.getAllLearningLibraryDetails(this.getUserLanguage());
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getAllLearningLibraryDetails", authoringService, true).serializeMessage();
        }
        log.debug((Object)("getAllLearningLibraryDetails: returning " + wddxPacket));
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getToolContentID(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String wddxPacket;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            Long toolID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolID", (boolean)false);
            wddxPacket = authoringService.getToolContentID(toolID);
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getAllLearningLibraryDetails", authoringService, true).serializeMessage();
        }
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward copyToolContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String wddxPacket;
        IAuthoringService authoringService = this.getAuthoringService();
        String customCSV = WebUtil.readStrParam((HttpServletRequest)request, (String)"customCSV", (boolean)true);
        try {
            long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID", (boolean)false);
            wddxPacket = authoringService.copyToolContent(toolContentID, customCSV);
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "copyToolContent", authoringService, true).serializeMessage();
        }
        return this.outputPacket(mapping, request, response, wddxPacket, "details");
    }

    public ActionForward getAvailableLicenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        FlashMessage flashMessage = null;
        try {
            IAuthoringService authoringService = this.getAuthoringService();
            Vector licenses = authoringService.getAvailableLicenses();
            flashMessage = new FlashMessage("getAvailableLicenses", (Object)licenses);
        }
        catch (Exception e) {
            log.error((Object)"getAvailableLicenses: License details unavailable due to system error.", (Throwable)e);
            flashMessage = new FlashMessage("getAvailableLicenses", (Object)("License details unavailable due to system error :" + e.getMessage()), 1);
            this.getAuditService().log(AuthoringAction.class.getName(), e.toString());
        }
        PrintWriter writer = response.getWriter();
        writer.println(flashMessage.serializeMessage());
        return null;
    }

    public ActionForward createUniqueContentFolder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        String wddxPacket;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            wddxPacket = authoringService.generateUniqueContentFolder();
        }
        catch (FileUtilException fue) {
            wddxPacket = this.handleException((Exception)((Object)fue), "createUniqueContentFolder", authoringService, false).serializeMessage();
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "createUniqueContentFolder", authoringService, false).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getHelpURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        String wddxPacket;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            wddxPacket = authoringService.getHelpURL();
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getHelpURL", authoringService, true).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    private FlashMessage handleException(Exception e, String methodKey, IAuthoringService authoringService, boolean useCriticalError) {
        log.error((Object)("Exception thrown " + methodKey), (Throwable)e);
        this.getAuditService().log(AuthoringAction.class.getName() + ":" + methodKey, e.toString());
        Object[] msg = new String[]{e.getMessage()};
        return new FlashMessage(methodKey, (Object)authoringService.getMessageService().getMessage("error.system.error", msg), useCriticalError ? 2 : 1);
    }

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }
}

