/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CompetenceServlet
extends AbstractStoreWDDXPacketServlet {
    protected Logger log = Logger.getLogger(CompetenceServlet.class);
    private long learningDesignID;

    protected String process(String lessonPackage, HttpServletRequest request) throws Exception {
        Integer userID;
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Integer n = userID = user != null ? user.getUserID() : null;
        if (userID == null) {
            this.log.error((Object)"Can not find valid login user information");
            FlashMessage flashMessage = new FlashMessage("createLesson", (Object)"Can not find valid login user information", 1);
            return flashMessage.serializeMessage();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("InitializeLessonServlet process received packet " + lessonPackage));
        }
        try {
            IAuthoringService authoringService = this.getAuthoringService();
            Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)lessonPackage);
            LearningDesign ld = authoringService.getLearningDesign(this.learningDesignID);
            authoringService.saveLearningDesign(ld);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception thrown while creating lesson class.", (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"initializeLesson", (String)e.getMessage());
            return flashMessage.serializeMessage();
        }
        return "duh";
    }

    protected String getMessageKey(String packet, HttpServletRequest request) {
        return "duh";
    }

    public IAuthoringService getAuthoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IAuthoringService)webContext.getBean("authoringService");
    }
}

