/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CopyMultipleToolContentServlet
extends AbstractStoreWDDXPacketServlet {
    private static Logger log = Logger.getLogger(CopyMultipleToolContentServlet.class);

    private Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    public IAuthoringService getAuthoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IAuthoringService)webContext.getBean("authoringService");
    }

    protected String process(String wddxPacket, HttpServletRequest request) throws Exception {
        String returnPacket = null;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)wddxPacket);
            String customCSV = WDDXProcessor.convertToString((Hashtable)table, (String)"customCSV");
            String toolContentIdList = WDDXProcessor.convertToString((Hashtable)table, (String)"toolContentIDs");
            if (toolContentIdList != null) {
                String[] stringIds = toolContentIdList.split(",");
                ArrayList<Long> longIds = new ArrayList<Long>();
                for (int i = 0; i < stringIds.length; ++i) {
                    String id = stringIds[i].trim();
                    if (id.length() <= 0) continue;
                    longIds.add(new Long(stringIds[i]));
                }
                String idMap = authoringService.copyMultipleToolContent(this.getUserId(), longIds, customCSV);
                return new FlashMessage(this.getMessageKey(wddxPacket, request), (Object)idMap).serializeMessage();
            }
            return new FlashMessage(this.getMessageKey(wddxPacket, request), (Object)"").serializeMessage();
        }
        catch (Exception e) {
            log.error((Object)("Authoring error. input packet was " + wddxPacket), (Throwable)e);
            FlashMessage flashMessage = new FlashMessage(this.getMessageKey(wddxPacket, request), (Object)authoringService.getMessageService().getMessage("invalid.wddx.packet", new Object[]{e.getMessage()}), 1);
            returnPacket = flashMessage.serializeMessage();
            return returnPacket;
        }
    }

    protected String getMessageKey(String designDetails, HttpServletRequest request) {
        return "copyMultipleToolContent";
    }
}

