/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EditOnFlyServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(EditOnFlyServlet.class);
    private static IAuditService auditService;
    private Integer userID = null;
    private Long learningDesignID = null;

    public IAuthoringService getAuthoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IAuthoringService)webContext.getBean("authoringService");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String returnPacket = null;
        PrintWriter writer = null;
        auditService = this.getAuditService();
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        this.userID = this.getUserID(request);
        this.learningDesignID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID"));
        try {
            writer = response.getWriter();
            returnPacket = this.doSetup(request, response);
        }
        catch (Exception e) {
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)this.getMessageKey(), (String)(e.getMessage() != null ? e.getMessage() : e.getClass().getName()));
            if (writer == null) {
                writer = response.getWriter();
            }
            writer.write(flashMessage.serializeMessage());
            auditService.log(EditOnFlyServlet.class.getName(), "Exception triggered: " + e.toString());
            return;
        }
        if (writer != null && returnPacket != null) {
            writer.println(returnPacket);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String doSetup(HttpServletRequest request, HttpServletResponse response) throws ServletException, UserException, IOException {
        String packet = null;
        IAuthoringService service = this.getAuthoringService();
        try {
            packet = service.setupEditOnFlyLock(this.learningDesignID, this.userID) ? service.setupEditOnFlyGate(this.learningDesignID, this.userID) : new FlashMessage("setupEditOnFlyLock", (Object)false, 3).serializeMessage();
        }
        catch (Exception e) {
            packet = FlashMessage.getExceptionOccured((String)"doSetup", (String)e.getMessage()).serializeMessage();
        }
        return packet;
    }

    private Integer getUserID(HttpServletRequest request) {
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)true);
        if (userId == null) {
            HttpSession session = SessionManager.getSession();
            UserDTO userDto = (UserDTO)session.getAttribute("user");
            userId = userDto.getUserID();
        }
        return userId;
    }

    protected String getMessageKey() {
        return "startEditOnFly";
    }

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }
}

