/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class LamsAuthoringFinishAction
extends Action {
    private static Logger log = Logger.getLogger(LamsAuthoringFinishAction.class);
    private static final String ACTION_NAME = "action";
    private static final String ACTION_MODE = "mode";
    private static final String CUSTOMISE_SESSION_ID = "customiseSessionID";
    private static final String TOOL_SIGNATURE = "signature";
    private static final String CONFIRM_ACTION = "confirm";
    private static final String CANCEL_ACTION = "cancel";
    private static final String RE_EDIT_URL = "reEditUrl";
    private static final String PARAM_DEFINE_LATER = "defineLater";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String action = request.getParameter(ACTION_NAME);
        String modeStr = request.getParameter(ACTION_MODE);
        String cSessionID = request.getParameter(CUSTOMISE_SESSION_ID);
        if (StringUtils.equals((String)ToolAccessMode.LEARNER.toString(), (String)modeStr)) {
            this.clearSession(cSessionID, request.getSession(), ToolAccessMode.LEARNER);
        } else if (StringUtils.equals((String)ToolAccessMode.TEACHER.toString(), (String)modeStr)) {
            this.clearSession(cSessionID, request.getSession(), ToolAccessMode.TEACHER);
        } else {
            this.clearSession(cSessionID, request.getSession(), ToolAccessMode.AUTHOR);
        }
        if (StringUtils.equals((String)action, (String)CONFIRM_ACTION)) {
            String reeditUrl;
            String nextUrl = this.getLamsUrl() + "authoringConfirm.jsp";
            String signature = request.getParameter(TOOL_SIGNATURE);
            Long toolContentId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
            String contentFolderID = "TODO_remove-change_optional_to_false";
            contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID", (boolean)true);
            IToolVO tool = this.getToolService().getToolBySignature(signature);
            String defineLater = request.getParameter(PARAM_DEFINE_LATER);
            if (StringUtils.equalsIgnoreCase((String)defineLater, (String)"yes") || StringUtils.equalsIgnoreCase((String)defineLater, (String)"true")) {
                reeditUrl = WebUtil.appendParameterToURL((String)(this.getLamsUrl() + tool.getDefineLaterUrl()), (String)"toolContentID", (String)toolContentId.toString());
                reeditUrl = WebUtil.appendParameterToURL((String)reeditUrl, (String)"contentFolderID", (String)contentFolderID);
            } else {
                reeditUrl = WebUtil.appendParameterToURL((String)(this.getLamsUrl() + tool.getAuthorUrl()), (String)"toolContentID", (String)toolContentId.toString());
                reeditUrl = WebUtil.appendParameterToURL((String)reeditUrl, (String)"contentFolderID", (String)contentFolderID);
            }
            nextUrl = WebUtil.appendParameterToURL((String)nextUrl, (String)RE_EDIT_URL, (String)URLEncoder.encode(reeditUrl, "UTF-8"));
            response.sendRedirect(nextUrl);
        }
        if (StringUtils.equals((String)action, (String)CANCEL_ACTION)) {
            // empty if block
        }
        return null;
    }

    public abstract void clearSession(String var1, HttpSession var2, ToolAccessMode var3);

    private String getLamsUrl() {
        String serverURL = Configuration.get((String)ConfigurationKeys.SERVER_URL);
        if (StringUtils.isBlank((String)serverURL)) {
            log.warn((Object)"ServerURLTag unable to write out server URL as it is missing from the configuration file.");
        }
        return serverURL;
    }

    public ILamsToolService getToolService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ILamsToolService)webContext.getBean("lamsToolService");
    }
}

