/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DatabaseAuthenticator {
    private String dsJndiName;
    private String principalsQuery;

    public DatabaseAuthenticator(String dsJndiName, String principalsQuery) {
        this.dsJndiName = dsJndiName;
        this.principalsQuery = principalsQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String inputPassword) {
        boolean isValid = false;
        if (inputPassword == null && inputPassword.trim().length() == 0) {
            return isValid;
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        String databasePassword = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(this.principalsQuery);
            ps.setString(1, username);
            rs = ps.executeQuery();
            if (!rs.next()) {
                isValid = false;
            }
            if (inputPassword.equals((databasePassword = rs.getString(1)).trim())) {
                isValid = true;
            }
        }
        catch (NamingException ex) {
            System.out.println(ex);
        }
        catch (SQLException ex) {
            System.out.println(ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
        return isValid;
    }
}

