/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.LdapService;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.util.HttpSessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LDAPAuthenticator {
    private static Logger log = Logger.getLogger(LDAPAuthenticator.class);
    private static UserManagementService service;
    private static LdapService ldapService;
    private static final String INITIAL_CONTEXT_FACTORY_VALUE = "com.sun.jndi.ldap.LdapCtxFactory";
    private Attributes attrs = null;

    private UserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
            service = (UserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }

    private LdapService getLdapService() {
        if (ldapService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
            ldapService = (LdapService)ctx.getBean("ldapService");
        }
        return ldapService;
    }

    public Attributes getAttrs() {
        return this.attrs;
    }

    public void setAttrs(Attributes attrs) {
        this.attrs = attrs;
    }

    public boolean authenticate(String username, String inputPassword) {
        return this.authentication(username, inputPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authentication(String username, Object credential) {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY_VALUE);
        env.setProperty("java.naming.security.authentication", Configuration.get((String)ConfigurationKeys.LDAP_SECURITY_AUTHENTICATION));
        env.setProperty("java.naming.provider.url", Configuration.get((String)ConfigurationKeys.LDAP_PROVIDER_URL));
        String securityProtocol = Configuration.get((String)ConfigurationKeys.LDAP_SECURITY_PROTOCOL);
        if (StringUtils.equals((String)"ssl", (String)securityProtocol)) {
            env.setProperty("java.naming.security.protocol", securityProtocol);
        }
        if (StringUtils.isNotBlank((String)Configuration.get((String)ConfigurationKeys.LDAP_BIND_USER_DN))) {
            env.setProperty("java.naming.security.principal", Configuration.get((String)ConfigurationKeys.LDAP_BIND_USER_DN));
            env.setProperty("java.naming.security.credentials", Configuration.get((String)ConfigurationKeys.LDAP_BIND_USER_PASSWORD));
        }
        String login = "";
        String dn = "";
        boolean isValid = false;
        InitialLdapContext ctx = null;
        try {
            User user;
            ctx = new InitialLdapContext(env, null);
            SearchControls ctrl = new SearchControls();
            ctrl.setSearchScope(2);
            String filter = Configuration.get((String)ConfigurationKeys.LDAP_SEARCH_FILTER);
            String baseDN = Configuration.get((String)ConfigurationKeys.LDAP_BASE_DN);
            Object[] filterArgs = new Object[]{username};
            NamingEnumeration<SearchResult> results = ctx.search(baseDN, filter, filterArgs, ctrl);
            while (results.hasMore()) {
                Object attrValue;
                SearchResult result = results.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"===> found matching object...");
                    log.debug((Object)("name: " + result.getName()));
                    log.debug((Object)("namespace name: " + result.getNameInNamespace()));
                }
                Attributes attrs = result.getAttributes();
                Attribute attr = attrs.get(Configuration.get((String)ConfigurationKeys.LDAP_LOGIN_ATTR));
                login = this.getLdapService().getSingleAttributeString(attr);
                if (attr != null && (attrValue = attr.get()) != null) {
                    login = attrValue.toString();
                }
                if (!StringUtils.equals((String)login, (String)username)) continue;
                dn = result.getNameInNamespace();
                this.setAttrs(attrs);
                ctx.close();
                break;
            }
            if (StringUtils.isBlank((String)login)) {
                log.error((Object)("===> No LDAP user found with username: " + username + ". This could mean that the user doesn't exist or that an initial bind user is required."));
            }
            env.setProperty("java.naming.security.principal", dn);
            env.setProperty("java.naming.security.credentials", credential.toString());
            ctx = new InitialLdapContext(env, null);
            log.debug((Object)("===> LDAP context created using DN: " + dn));
            isValid = true;
            if (log.isDebugEnabled()) {
                NamingEnumeration<? extends Attribute> enumAttrs = this.attrs.getAll();
                while (enumAttrs.hasMoreElements()) {
                    log.debug((Object)enumAttrs.next());
                }
            }
            if (this.getLdapService().getDisabledBoolean(this.attrs)) {
                log.debug((Object)"===> User is disabled in LDAP.");
                user = this.getService().getUserByLogin(username);
                if (user != null) {
                    this.getService().disableUser(user.getUserId());
                }
                boolean attrs = false;
                return attrs;
            }
            if (Configuration.getAsBoolean((String)ConfigurationKeys.LDAP_UPDATE_ON_LOGIN) && (user = this.getService().getUserByLogin(username)) != null) {
                this.getLdapService().updateLDAPUser(user, this.attrs);
                this.getLdapService().addLDAPUser(this.attrs, user.getUserId());
            }
            boolean bl = true;
            return bl;
        }
        catch (AuthenticationNotSupportedException e) {
            log.error((Object)("===> Authentication mechanism not supported.  Check your " + ConfigurationKeys.LDAP_SECURITY_AUTHENTICATION + " parameter: " + Configuration.get((String)ConfigurationKeys.LDAP_SECURITY_AUTHENTICATION)));
        }
        catch (AuthenticationException e) {
            log.info((Object)("===> Incorrect username (" + dn + ") or password. " + e.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)("===> LDAP exception: " + e), (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception e) {
                log.error((Object)("===> gettting problem when closing context. Exception: " + e));
            }
        }
        return isValid;
    }
}

