/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.security.DatabaseAuthenticator;
import org.lamsfoundation.lams.security.LDAPAuthenticator;
import org.lamsfoundation.lams.security.SimpleGroup;
import org.lamsfoundation.lams.security.UsernamePasswordLoginModule;
import org.lamsfoundation.lams.security.WebAuthAuthenticator;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.themes.dto.CSSThemeBriefDTO;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.LdapService;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.HttpSessionManager;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UniversalLoginModule
extends UsernamePasswordLoginModule {
    private static Logger log = Logger.getLogger(UniversalLoginModule.class);
    protected String dsJndiName;
    protected String rolesQuery;
    protected String principalsQuery;
    private IThemeService themeService;
    private UserManagementService service;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        this.principalsQuery = (String)options.get("principalsQuery");
        this.rolesQuery = (String)options.get("rolesQuery");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid = false;
        if (inputPassword == null) return isValid;
        if (inputPassword.length() == 0) {
            return false;
        }
        try {
            CSSThemeBriefDTO userFlashTheme;
            boolean themeExists;
            CSSThemeBriefDTO userCSSTheme;
            String username = this.getUsername();
            log.debug((Object)("===> authenticating user: " + username));
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
            if (this.service == null) {
                this.service = (UserManagementService)ctx.getBean("userManagementService");
            }
            User user = this.service.getUserByLogin(username);
            if (this.themeService == null) {
                this.themeService = (IThemeService)ctx.getBean("themeService");
            }
            if (user == null) {
                LdapService ldapService;
                if (!Configuration.getAsBoolean((String)ConfigurationKeys.LDAP_PROVISIONING_ENABLED)) return false;
                try {
                    ldapService = (LdapService)ctx.getBean("ldapService");
                }
                catch (NoSuchBeanDefinitionException e) {
                    log.error((Object)"NoSuchBeanDefinitionException while getting ldapService bean, will try another method...", (Throwable)e);
                    ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/lamsfoundation/lams/usermanagement/ldapContext.xml");
                    ldapService = (LdapService)context.getBean("ldapService");
                }
                log.debug((Object)"===> LDAP provisioning is enabled, checking username against LDAP server...");
                LDAPAuthenticator ldap = new LDAPAuthenticator();
                isValid = ldap.authenticate(username, inputPassword);
                if (!isValid) return false;
                log.info((Object)("===> Creating new user for LDAP username: " + username));
                if (ldapService.createLDAPUser(ldap.getAttrs())) {
                    user = this.service.getUserByLogin(username);
                    if (!ldapService.addLDAPUser(ldap.getAttrs(), user.getUserId())) {
                        log.error((Object)("===> Couldn't add LDAP user: " + username + " to organisation."));
                    }
                } else {
                    log.error((Object)("===> Couldn't create new user for LDAP username: " + username));
                    return false;
                }
            }
            if (this.service.isUserSysAdmin()) {
                isValid = true;
            }
            if (!isValid) {
                Object authenticator;
                String type = user.getAuthenticationMethod().getAuthenticationMethodType().getDescription();
                log.debug((Object)("===> authentication type: " + type));
                if ("LDAP".equals(type)) {
                    authenticator = new LDAPAuthenticator();
                    isValid = ((LDAPAuthenticator)authenticator).authenticate(username, inputPassword);
                    user = this.service.getUserByLogin(username);
                } else if ("LAMS".equals(type)) {
                    authenticator = new DatabaseAuthenticator(this.dsJndiName, this.principalsQuery);
                    if (!Configuration.getAsBoolean((String)ConfigurationKeys.LDAP_ENCRYPT_PASSWORD_FROM_BROWSER)) {
                        isValid = ((DatabaseAuthenticator)authenticator).authenticate(username, inputPassword);
                        if (!isValid) {
                            inputPassword = HashUtil.sha1((String)inputPassword);
                        }
                        isValid = ((DatabaseAuthenticator)authenticator).authenticate(username, inputPassword);
                    } else {
                        isValid = ((DatabaseAuthenticator)authenticator).authenticate(username, inputPassword);
                    }
                } else if ("WEB_AUTH".equals(type)) {
                    authenticator = new WebAuthAuthenticator();
                    isValid = ((WebAuthAuthenticator)authenticator).authenticate(username, inputPassword);
                } else {
                    log.error((Object)("===> Unexpected authentication type: " + type));
                    return false;
                }
            }
            if (user.getDisabledFlag().booleanValue()) {
                log.debug((Object)"===> user is disabled.");
                return false;
            }
            if (!isValid) return isValid;
            UserDTO userDTO = user.getUserDTO();
            CSSThemeBriefDTO userTheme = userDTO.getHtmlTheme();
            if (userTheme != null && (userCSSTheme = userDTO.getHtmlTheme()) != null) {
                themeExists = false;
                for (Theme theme : this.themeService.getAllCSSThemes()) {
                    if (!userCSSTheme.getId().equals(theme.getThemeId())) continue;
                    themeExists = true;
                    break;
                }
                if (!themeExists) {
                    userDTO.setHtmlTheme(new CSSThemeBriefDTO(this.themeService.getDefaultCSSTheme()));
                }
            }
            if ((userFlashTheme = userDTO.getFlashTheme()) != null) {
                themeExists = false;
                for (Theme theme : this.themeService.getAllFlashThemes()) {
                    if (!userFlashTheme.getId().equals(theme.getThemeId())) continue;
                    themeExists = true;
                    break;
                }
                if (!themeExists) {
                    userDTO.setFlashTheme(new CSSThemeBriefDTO(this.themeService.getDefaultFlashTheme()));
                }
            }
            HttpSession sharedsession = SessionManager.getSession();
            sharedsession.setAttribute("user", (Object)userDTO);
            return isValid;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("===> exception: " + e), (Throwable)e);
        }
        return isValid;
    }

    protected Group[] getRoleSets() throws LoginException {
        String username = this.getUsername();
        Connection conn = null;
        HashMap<String, Group> setsMap = new HashMap<String, Group>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(this.rolesQuery);
            try {
                ps.setString(1, username);
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
                // empty catch block
            }
            rs = ps.executeQuery();
            if (!rs.next()) {
                Group[] roleSets;
                if (this.getUnauthenticatedIdentity() == null) {
                    throw new FailedLoginException("No matching username found in Roles");
                }
                Group[] groupArray = roleSets = new Group[]{new SimpleGroup("Roles")};
                return groupArray;
            }
            ArrayList<String> groupMembers = new ArrayList<String>();
            do {
                Group group;
                String name = rs.getString(1);
                String groupName = rs.getString(2);
                if (groupName == null || groupName.length() == 0) {
                    groupName = "Roles";
                }
                if ((group = (Group)setsMap.get(groupName)) == null) {
                    group = new SimpleGroup(groupName);
                    setsMap.put(groupName, group);
                }
                try {
                    if (name == null) {
                        name = "LEARNER";
                        log.info((Object)"===> Found no roles");
                    }
                    Principal p = super.createIdentity(name);
                    if (!groupMembers.contains(name)) {
                        log.info((Object)("===> Assign user to role " + p.getName()));
                        group.addMember(p);
                        groupMembers.add(name);
                    }
                    if (!name.equals("SYSADMIN") && !name.equals("AUTHOR ADMIN")) continue;
                    p = super.createIdentity("AUTHOR");
                    log.info((Object)("===> Found " + name));
                    if (groupMembers.contains("AUTHOR")) continue;
                    log.info((Object)"===> Assign user to role AUTHOR");
                    group.addMember(p);
                    groupMembers.add("AUTHOR");
                }
                catch (Exception e) {
                    log.debug((Object)("===> Failed to create principal: " + name), (Throwable)e);
                }
            } while (rs.next());
        }
        catch (NamingException ex) {
            throw new LoginException(ex.toString(true));
        }
        catch (SQLException ex) {
            ((UsernamePasswordLoginModule)this).log.error((Object)"SQL failure", (Throwable)ex);
            throw new LoginException(ex.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    protected String getUsersPassword() throws LoginException {
        return "";
    }
}

