/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.SMTPAuthenticator;

public class Emailer {
    public static void sendFromSupportEmail(String subject, String to, String body) throws AddressException, MessagingException {
        String supportEmail = Configuration.get((String)ConfigurationKeys.LAMS_ADMIN_EMAIL);
        String smtpServer = Configuration.get((String)ConfigurationKeys.SMTP_SERVER);
        Properties properties = new Properties();
        properties.put("mail.smtp.host", smtpServer);
        Emailer.send(subject, to, supportEmail, body, properties);
    }

    public static Session getMailSession(Properties properties) {
        Session session;
        String smtpAuthUser = Configuration.get((String)ConfigurationKeys.SMTP_AUTH_USER);
        String smtpAuthPass = Configuration.get((String)ConfigurationKeys.SMTP_AUTH_PASSWORD);
        if (smtpAuthUser != null && !smtpAuthUser.trim().equals("")) {
            properties.setProperty("mail.smtp.submitter", smtpAuthUser);
            properties.setProperty("mail.smtp.auth", "true");
            SMTPAuthenticator auth = new SMTPAuthenticator(smtpAuthUser, smtpAuthPass);
            session = Session.getInstance((Properties)properties, (Authenticator)auth);
        } else {
            session = Session.getInstance((Properties)properties);
        }
        return session;
    }

    public static void send(String subject, String to, String from, String body, Properties mailServerConfig) throws AddressException, MessagingException {
        Session session = Emailer.getMailSession(mailServerConfig);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(from));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        message.setSubject(subject);
        message.setText(body);
        Transport.send((Message)message);
    }
}

