/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.index.IndexLessonBean;
import org.lamsfoundation.lams.index.IndexLinkBean;
import org.lamsfoundation.lams.index.IndexOrgBean;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.LessonService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.IndexUtils;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayGroupAction
extends Action {
    private static Logger log = Logger.getLogger(DisplayGroupAction.class);
    private static IUserManagementService service;
    private static LessonService lessonService;
    private Integer stateId = OrganisationState.ACTIVE;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String display = WebUtil.readStrParam((HttpServletRequest)request, (String)"display", (boolean)false);
        this.stateId = WebUtil.readIntParam((HttpServletRequest)request, (String)"stateId", (boolean)false);
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)false);
        Organisation org = null;
        if (orgId != null) {
            org = (Organisation)this.getService().findById(Organisation.class, (Serializable)orgId);
        }
        String forwardPath = "group";
        if (org != null) {
            IndexOrgBean iob;
            boolean allowSorting = false;
            ArrayList<Integer> roles = new ArrayList<Integer>();
            List userOrganisationRoles = this.getService().getUserOrganisationRoles(orgId, request.getRemoteUser());
            for (UserOrganisationRole userOrganisationRole : userOrganisationRoles) {
                Integer roleId = userOrganisationRole.getRole().getRoleId();
                roles.add(roleId);
                if (!roleId.equals(Role.ROLE_GROUP_MANAGER) && !roleId.equals(Role.ROLE_MONITOR)) continue;
                allowSorting = true;
            }
            if (StringUtils.equals((String)display, (String)"contents")) {
                iob = new IndexOrgBean(org.getOrganisationId(), org.getName(), org.getOrganisationType().getOrganisationTypeId());
                iob = this.populateContentsOrgBean(iob, org, roles, request.getRemoteUser(), request.isUserInRole("SYSADMIN"));
                forwardPath = "groupContents";
            } else if (StringUtils.equals((String)display, (String)"header")) {
                iob = this.createHeaderOrgBean(org, roles, request.getRemoteUser(), request.isUserInRole("SYSADMIN"), false);
                forwardPath = "groupHeader";
            } else {
                iob = this.createHeaderOrgBean(org, roles, request.getRemoteUser(), request.isUserInRole("SYSADMIN"), true);
            }
            request.setAttribute("orgBean", (Object)iob);
            request.setAttribute("allowSorting", (Object)allowSorting);
        }
        return mapping.findForward(forwardPath);
    }

    private IndexOrgBean createHeaderOrgBean(Organisation org, List<Integer> roles, String username, boolean isSysAdmin, boolean includeContents) throws SQLException, NamingException {
        String link;
        IndexOrgBean orgBean = new IndexOrgBean(org.getOrganisationId(), org.getName(), org.getOrganisationType().getOrganisationTypeId());
        ArrayList<IndexLinkBean> links = new ArrayList<IndexLinkBean>();
        ArrayList<IndexLinkBean> moreLinks = new ArrayList<IndexLinkBean>();
        if (isSysAdmin && this.stateId.equals(OrganisationState.ACTIVE) && orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
            moreLinks.add(new IndexLinkBean("index.classman", "javascript:openOrgManagement(" + org.getOrganisationId() + ")", "manage-group-button", null));
        }
        if (org.getEnableGradebookForLearners().booleanValue() && this.contains(roles, Role.ROLE_LEARNER)) {
            link = "javascript:openGradebookLearnerPopup('" + org.getName() + "','" + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/gradebook/gradebookLearning.do?dispatch=courseLearner&organisationID=" + org.getOrganisationId() + "'," + "750,400,0,0);";
            links.add(new IndexLinkBean("index.coursegradebook.learner", link, "my-grades-button", null));
        }
        if ((this.contains(roles, Role.ROLE_GROUP_ADMIN) || this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR)) && this.stateId.equals(OrganisationState.ACTIVE)) {
            if (orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
                if (!isSysAdmin && (this.contains(roles, Role.ROLE_GROUP_ADMIN) || this.contains(roles, Role.ROLE_GROUP_MANAGER))) {
                    moreLinks.add(new IndexLinkBean("index.classman", "javascript:openOrgManagement(" + org.getOrganisationId() + ")", "manage-group-button", null));
                }
                if (this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR)) {
                    links.add(new IndexLinkBean("index.addlesson", Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/home.do?method=addLesson&courseID=" + org.getOrganisationId() + "&classID=" + "" + "&KeepThis=true&TB_iframe=true&height=480&width=610", "add-lesson-button thickbox" + org.getOrganisationId(), null));
                }
                moreLinks.add(new IndexLinkBean("index.searchlesson", Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/findUserLessons.do?dispatch=getResults&courseID=" + org.getOrganisationId() + "&KeepThis=true&TB_iframe=true&height=400&width=600", "search-lesson thickbox" + org.getOrganisationId(), "index.searchlesson.tooltip"));
                if (org.getEnableGradebookForMonitors().booleanValue() && (this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR))) {
                    link = "javascript:openGradebookCourseMonitorPopup('" + org.getName() + "','" + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/gradebook/gradebookMonitoring.do?dispatch=courseMonitor&organisationID=" + org.getOrganisationId() + "'," + "850,400,0,0);";
                    moreLinks.add(new IndexLinkBean("index.coursegradebook", link, "course-gradebook-button", "index.coursegradebook.tooltip"));
                }
            } else if (this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR)) {
                links.add(new IndexLinkBean("index.addlesson", Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/home.do?method=addLesson&courseID=" + org.getParentOrganisation().getOrganisationId() + "&classID=" + org.getOrganisationId() + "&KeepThis=true&TB_iframe=true&height=480&width=610", "add-lesson-button thickbox" + org.getOrganisationId(), null));
            }
        }
        orgBean.setLinks(links);
        orgBean.setMoreLinks(moreLinks);
        if (this.stateId.equals(OrganisationState.ARCHIVED) && org.getOrganisationState().getOrganisationStateId().equals(OrganisationState.ARCHIVED)) {
            orgBean.setArchivedDate(org.getArchivedDate());
        }
        if (includeContents) {
            orgBean = this.populateContentsOrgBean(orgBean, org, roles, username, isSysAdmin);
        }
        return orgBean;
    }

    private IndexOrgBean populateContentsOrgBean(IndexOrgBean orgBean, Organisation org, List<Integer> roles, String username, boolean isSysAdmin) throws SQLException, NamingException {
        User user = (User)this.getService().findByProperty(User.class, "login", (Object)username).get(0);
        List<IndexLessonBean> lessonBeans = null;
        try {
            Map<Long, IndexLessonBean> map = this.populateLessonBeans(user.getUserId(), org.getOrganisationId(), roles);
            lessonBeans = IndexUtils.sortLessonBeans(org.getOrderedLessonIds(), map);
        }
        catch (Exception e) {
            log.error((Object)("Failed retrieving user's lessons from database: " + e), (Throwable)e);
        }
        orgBean.setLessons(lessonBeans);
        if (orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
            Set children = org.getChildOrganisations();
            ArrayList<IndexOrgBean> childOrgBeans = new ArrayList<IndexOrgBean>();
            for (Organisation organisation : children) {
                if (!organisation.getOrganisationState().getOrganisationStateId().equals(this.stateId)) continue;
                ArrayList<Integer> classRoles = new ArrayList<Integer>();
                List userOrganisationRoles = this.getService().getUserOrganisationRoles(organisation.getOrganisationId(), username);
                if ((userOrganisationRoles == null || userOrganisationRoles.isEmpty()) && !this.contains(roles, Role.ROLE_GROUP_ADMIN) && !this.contains(roles, Role.ROLE_GROUP_MANAGER) && !isSysAdmin) continue;
                for (UserOrganisationRole userOrganisationRole : userOrganisationRoles) {
                    classRoles.add(userOrganisationRole.getRole().getRoleId());
                }
                if (this.contains(roles, Role.ROLE_GROUP_MANAGER)) {
                    classRoles.add(Role.ROLE_GROUP_MANAGER);
                }
                childOrgBeans.add(this.createHeaderOrgBean(organisation, classRoles, username, isSysAdmin, true));
            }
            Collections.sort(childOrgBeans);
            orgBean.setChildIndexOrgBeans(childOrgBeans);
        }
        return orgBean;
    }

    private Map<Long, IndexLessonBean> populateLessonBeans(Integer userId, Integer orgId, List<Integer> roles) throws SQLException, NamingException {
        Map map = this.getLessonService().getLessonsByOrgAndUserWithCompletedFlag(userId, orgId, false);
        for (IndexLessonBean bean : map.values()) {
            ArrayList<IndexLinkBean> lessonLinks = new ArrayList<IndexLinkBean>();
            String url = null;
            Integer lessonStateId = bean.getState();
            if (this.stateId.equals(OrganisationState.ACTIVE)) {
                if (this.contains(roles, Role.ROLE_LEARNER) && (lessonStateId.equals(Lesson.STARTED_STATE) || lessonStateId.equals(Lesson.FINISHED_STATE))) {
                    url = "javascript:openLearner(" + bean.getId() + ")";
                }
            } else if (this.stateId.equals(OrganisationState.ARCHIVED) && this.contains(roles, Role.ROLE_LEARNER) && (lessonStateId.equals(Lesson.STARTED_STATE) || lessonStateId.equals(Lesson.FINISHED_STATE))) {
                lessonLinks.add(new IndexLinkBean("label.export.portfolio", "javascript:openExportPortfolio(" + bean.getId() + ")"));
            }
            if (lessonLinks.size() <= 0 && url == null) continue;
            bean.setUrl(url);
            bean.setLinks(lessonLinks);
        }
        Organisation org = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        Organisation parent = org.getParentOrganisation();
        Map staffMap = this.getLessonService().getLessonsByOrgAndUserWithCompletedFlag(userId, orgId, true);
        for (IndexLessonBean bean : staffMap.values()) {
            ArrayList<IndexLinkBean> lessonLinks;
            if (map.containsKey(bean.getId())) {
                bean = (IndexLessonBean)map.get(bean.getId());
            }
            if ((lessonLinks = bean.getLinks()) == null) {
                lessonLinks = new ArrayList<IndexLinkBean>();
            }
            if (this.stateId.equals(OrganisationState.ACTIVE)) {
                if (this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR)) {
                    lessonLinks.add(new IndexLinkBean("index.monitor", "javascript:openMonitorLesson(" + bean.getId() + ")", "mycourses-monitor-img", ""));
                }
            } else if (this.stateId.equals(OrganisationState.ARCHIVED) && this.contains(roles, Role.ROLE_GROUP_MANAGER)) {
                lessonLinks.add(new IndexLinkBean("index.monitor", "javascript:openMonitorLesson(" + bean.getId() + ")", "mycourses-monitor-img", ""));
            }
            if ((this.contains(roles, Role.ROLE_GROUP_MANAGER) || this.contains(roles, Role.ROLE_MONITOR)) && org.getEnableGradebookForMonitors().booleanValue() || parent != null && parent.getEnableGradebookForMonitors().booleanValue()) {
                String link = "javascript:openGradebookLessonMonitorPopup('" + org.getName() + "','" + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/gradebook/gradebookMonitoring.do?lessonID=" + bean.getId() + "'," + "850,700,0,0);";
                lessonLinks.add(new IndexLinkBean("index.coursegradebookmonitor", link, "mycourses-mark-img", ""));
            }
            if (lessonLinks.size() > 0) {
                bean.setLinks(lessonLinks);
            }
            map.put(bean.getId(), bean);
        }
        return map;
    }

    private boolean contains(List<Integer> roles, Integer roleId) {
        for (int i = 0; i < roles.size(); ++i) {
            if (!roleId.equals(roles.get(i))) continue;
            return true;
        }
        return false;
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }

    private LessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (LessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }
}

