/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUserLessonsAction
extends DispatchAction {
    private static final Logger logger = Logger.getLogger(FindUserLessonsAction.class);
    private static IUserManagementService userManagementService;
    private static ILessonService lessonService;
    private static ILearnerService learnerService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (userManagementService == null || lessonService == null) {
            this.setupService();
        }
        return super.execute(mapping, form, request, response);
    }

    public ActionForward getResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String query = WebUtil.readStrParam((HttpServletRequest)request, (String)"query", (boolean)true);
        Integer courseID = WebUtil.readIntParam((HttpServletRequest)request, (String)"courseID", (boolean)true);
        Integer classID = WebUtil.readIntParam((HttpServletRequest)request, (String)"classID", (boolean)true);
        if (courseID == null) {
            throw new ServletException();
        }
        if (query != null) {
            Organisation group = (Organisation)userManagementService.findById(Organisation.class, (Serializable)courseID);
            Set<User> users = this.getUserSet(query, group);
            User viewer = userManagementService.getUserByLogin(request.getRemoteUser());
            HashMap userLessonsMap = new HashMap();
            for (User user : users) {
                List lessons = lessonService.getLessonsByGroupAndUser(user.getUserId(), group.getOrganisationId());
                ArrayList<LessonDTO> lessonDTOs = new ArrayList<LessonDTO>();
                for (Lesson lesson : lessons) {
                    LessonDTO dto = new LessonDTO(lesson);
                    dto.setDisplayMonitor(Boolean.valueOf(lesson.getLessonClass().isStaffMember(viewer)));
                    lessonDTOs.add(dto);
                }
                userLessonsMap.put(user, lessonDTOs);
            }
            request.setAttribute("userLessonsMap", userLessonsMap);
        }
        request.setAttribute("courseID", (Object)courseID);
        request.setAttribute("classID", (Object)classID);
        request.setAttribute("originalQuery", (Object)query);
        return mapping.findForward("success-getResults");
    }

    private Set<Organisation> getOrgSet(Organisation rootOrg) {
        HashSet<Organisation> orgSet = new HashSet<Organisation>();
        orgSet.add(rootOrg);
        orgSet.addAll(rootOrg.getChildOrganisations());
        return orgSet;
    }

    private Set<User> getUserSet(String query, Organisation rootOrg) {
        String[] tokens;
        HashSet<User> userSet = new HashSet<User>();
        for (String token : tokens = query.trim().split("\\s+")) {
            userSet.addAll(userManagementService.searchUserSingleTerm(token, rootOrg.getOrganisationId(), true));
        }
        return userSet;
    }

    public ActionForward autocomplete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String query = WebUtil.readStrParam((HttpServletRequest)request, (String)"q", (boolean)true);
        Integer courseID = WebUtil.readIntParam((HttpServletRequest)request, (String)"courseID", (boolean)true);
        Organisation rootOrg = (Organisation)userManagementService.findById(Organisation.class, (Serializable)courseID);
        Set<User> userSet = this.getUserSet(query, rootOrg);
        LinkedList<String> list = new LinkedList<String>();
        for (User user : userSet) {
            list.add(user.getFirstName() + " " + user.getLastName());
        }
        request.setAttribute("results", list);
        return mapping.findForward("success-autocomplete");
    }

    private void setupService() {
        WebApplicationContext ctx;
        if (userManagementService == null) {
            ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        if (lessonService == null) {
            ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        if (learnerService == null) {
            ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            learnerService = (ILearnerService)ctx.getBean("learnerService");
        }
    }
}

