/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.web.HomeAction;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;

public class FlashCrashDumpServlet
extends AbstractStoreWDDXPacketServlet {
    private static Logger log = Logger.getLogger(HomeAction.class);
    private static final String MESSAGE_KEY = "flashCrashDump";
    private static final String PREFIX = "Flash_";

    protected String process(String wddxPacket, HttpServletRequest request) throws Exception {
        UserDTO user;
        HttpSession ss = SessionManager.getSession();
        UserDTO userDTO = user = ss != null ? (UserDTO)ss.getAttribute("user") : null;
        if (user == null) {
            log.warn((Object)"FlashCrashDumpServlet: Attempt to dump file by someone not logged in.");
            return new FlashMessage(MESSAGE_KEY, (Object)"User not logged in - unable to dump file.", 1).serializeMessage();
        }
        String id = PREFIX + user.getLogin();
        try {
            Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)wddxPacket);
            String batch = (String)table.get("crashDataBatch");
            log.debug((Object)("FlashCrashDumpServlet: batch value is " + batch));
            if (batch != null) {
                batch = StringUtils.deleteWhitespace((String)batch);
                id = id + "_" + batch;
            }
        }
        catch (Exception e) {
            log.warn((Object)("FlashCrashDumpServlet: Unable to deserialize packet - invalid data. Just writing out packet " + id), (Throwable)e);
        }
        String filename = FileUtil.createDumpFile((byte[])wddxPacket.getBytes(), (String)id, (String)"xml");
        FlashMessage flashMessage = new FlashMessage(MESSAGE_KEY, (Object)filename);
        return flashMessage.serializeMessage();
    }

    protected String getMessageKey(String designDetails, HttpServletRequest request) {
        return MESSAGE_KEY;
    }
}

