/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.id.Configurable;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.type.Type;
import org.lamsfoundation.lams.usermanagement.ForgotPasswordRequest;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.Emailer;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ForgotPasswordServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(ForgotPasswordServlet.class);
    public static String SMTP_SERVER_NOT_SET = "error.support.email.not.set";
    public static String USER_NOT_FOUND = "error.user.not.found";
    public static String PASSWORD_REQUEST_EXPIRED = "error.password.request.expired";
    public static String SUCCESS_REQUEST_EMAIL = "forgot.password.email.sent";
    public static String SUCCESS_CHANGE_PASS = "heading.password.changed.screen";
    public static String EMAIL_NOT_FOUND = "error.email.not.found";
    public static String MULTIPLE_EMAILS = "error.multiple.emails";
    public static String EMAIL_FAILED = "error.email.not.sent";
    public static String REQUEST_KEY_NOT_FOUND = "error.forgot.password.incorrect.key";
    private static int MILLISECONDS_IN_A_DAY = 86400000;
    private static String STATE = "&state=";
    private static String LANGUAGE_KEY = "&languageKey=";
    private static String EMAIL_SENT = "&emailSent=";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getParameter("method");
        if (method.equals("requestEmail")) {
            String selectType = request.getParameter("selectType");
            Boolean findByEmail = false;
            String param = "";
            if (selectType.equals("radioEmail")) {
                findByEmail = true;
                param = request.getParameter("email");
            } else {
                param = request.getParameter("login");
            }
            this.handleEmailRequest(findByEmail, param.trim(), response);
        } else if (method.equals("requestPasswordChange")) {
            String newPassword = request.getParameter("newPassword");
            String key = request.getParameter("key");
            this.handlePasswordChange(newPassword, key, response);
        } else {
            response.sendError(400);
        }
    }

    public void handleEmailRequest(Boolean findByEmail, String param, HttpServletResponse response) throws ServletException, IOException {
        int success = 0;
        String languageKey = "";
        boolean err = false;
        if (param == null || param.equals("")) {
            response.sendError(400);
            return;
        }
        String SMPTServer = Configuration.get((String)"SMTPServer");
        String supportEmail = Configuration.get((String)"LamsSupportEmail");
        User user = null;
        if (SMPTServer == null || SMPTServer.equals("") || supportEmail == null || supportEmail.equals("")) {
            languageKey = SMTP_SERVER_NOT_SET;
        } else {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            IUserManagementService userService = (IUserManagementService)ctx.getBean("userManagementService");
            MessageService messageService = (MessageService)ctx.getBean("centralMessageService");
            if (!findByEmail.booleanValue()) {
                if (userService.getUserByLogin(param) != null) {
                    user = userService.getUserByLogin(param);
                } else {
                    languageKey = USER_NOT_FOUND;
                    err = true;
                }
            } else {
                List users = userService.getAllUsersWithEmail(param);
                if (users.size() == 1) {
                    user = (User)users.get(0);
                } else if (users.size() == 0) {
                    languageKey = EMAIL_NOT_FOUND;
                    err = true;
                } else {
                    languageKey = MULTIPLE_EMAILS;
                    err = true;
                }
            }
            if (!err) {
                String key = ForgotPasswordServlet.generateUniqueKey();
                ForgotPasswordRequest fp = new ForgotPasswordRequest();
                fp.setRequestDate(new Date());
                fp.setUserId(user.getUserId());
                fp.setRequestKey(key);
                userService.save((Object)fp);
                String body = messageService.getMessage("forgot.password.email.body") + "\n\n" + Configuration.get((String)"ServerURL") + "forgotPasswordChange.jsp?key=" + key;
                try {
                    Emailer.sendFromSupportEmail(messageService.getMessage("forgot.password.email.subject"), user.getEmail(), body);
                    languageKey = SUCCESS_REQUEST_EMAIL;
                    success = 1;
                }
                catch (AddressException e) {
                    log.error((Object)("Problem sending email to: " + user.getLogin() + " with email: " + user.getEmail()), (Throwable)e);
                    languageKey = EMAIL_FAILED;
                    success = 0;
                }
                catch (MessagingException e) {
                    log.error((Object)("Problem sending email to: " + user.getLogin() + " with email: " + user.getEmail()), (Throwable)e);
                    languageKey = EMAIL_FAILED;
                    success = 0;
                }
                catch (Exception e) {
                    log.error((Object)("Problem sending email to: " + user.getLogin() + " with email: " + user.getEmail()), (Throwable)e);
                    languageKey = EMAIL_FAILED;
                    success = 0;
                }
            }
        }
        String redirectStr = Configuration.get((String)"ServerURL") + "forgotPasswordProc.jsp?" + STATE + success + LANGUAGE_KEY + languageKey;
        if (success == 1 && user.getEmail() != null) {
            redirectStr = redirectStr + EMAIL_SENT + URLEncoder.encode(user.getEmail(), "UTF-8");
        }
        response.sendRedirect(redirectStr);
    }

    public void handlePasswordChange(String newPassword, String key, HttpServletResponse response) throws ServletException, IOException {
        int success = 0;
        String languageKey = "";
        if (key == null || key.equals("") || newPassword == null || newPassword.equals("")) {
            response.sendError(400);
            return;
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        IUserManagementService userService = (IUserManagementService)ctx.getBean("userManagementService");
        ForgotPasswordRequest fp = userService.getForgotPasswordRequest(key);
        if (fp == null) {
            response.sendRedirect(Configuration.get((String)"ServerURL") + "forgotPasswordProc.jsp?" + STATE + 0 + LANGUAGE_KEY + REQUEST_KEY_NOT_FOUND);
            return;
        }
        long cutoffTime = fp.getRequestDate().getTime() + (long)MILLISECONDS_IN_A_DAY;
        Date now = new Date();
        long nowLong = now.getTime();
        if (nowLong < cutoffTime) {
            User user = (User)userService.findById(User.class, (Serializable)fp.getUserId());
            userService.updatePassword(user.getLogin(), newPassword);
            userService.auditPasswordChanged(user, "central");
            languageKey = SUCCESS_CHANGE_PASS;
            success = 1;
        } else {
            languageKey = PASSWORD_REQUEST_EXPIRED;
        }
        userService.delete((Object)fp);
        response.sendRedirect(Configuration.get((String)"ServerURL") + "forgotPasswordProc.jsp?" + STATE + success + LANGUAGE_KEY + languageKey);
    }

    public static String generateUniqueKey() {
        Object newUniqueContentFolderID = null;
        Properties props = new Properties();
        UUIDHexGenerator uuidGen = new UUIDHexGenerator();
        ((Configurable)uuidGen).configure((Type)Hibernate.STRING, props, null);
        return ((String)((Object)uuidGen.generate(null, null))).toLowerCase();
    }
}

