/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LaunchLearnerAction
extends LamsAction {
    private static Logger log = Logger.getLogger(LaunchLearnerAction.class);
    private static ILessonService lessonService;

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Lesson lesson;
            Long lessonId = WebUtil.readLongParam((HttpServletRequest)req, (String)"lessonID");
            Lesson lesson2 = lesson = lessonId != null ? this.getLessonService().getLesson(lessonId) : null;
            if (lesson != null) {
                // empty if block
            }
            req.setAttribute("name", (Object)lesson.getLessonName());
            req.setAttribute("description", (Object)lesson.getLessonDescription());
            req.setAttribute("status", (Object)lesson.getLessonStateId());
            req.setAttribute("lessonID", (Object)lessonId);
            return mapping.findForward("learner");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load learner", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    private ActionForward displayMessage(ActionMapping mapping, HttpServletRequest req, String messageKey) {
        req.setAttribute("messageKey", (Object)messageKey);
        return mapping.findForward("message");
    }
}

