/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.lamscommunity;

import java.net.URLEncoder;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.lamsfoundation.lams.config.Registration;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LamsCommunityUtil {
    public static final String LAMS_COMMUNITY_URL = "http://lamscommunity.org";
    public static final String LAMS_COMMUNITY_SSO_URL = "http://lamscommunity.org/lams/x/sso";
    public static final String LAMS_COMMUNITY_AUTH_URL = "http://lamscommunity.org/lams/x/auth";
    public static final String LAMS_COMMUNITY_IMPORT_URL = "http://lamscommunity.org/lams/x/auth";
    public static final String LAMS_COMMUNITY_EXPORT_URL = "http://lamscommunity.org/lams/x/auth";
    public static final String PARAM_HASH = "hs";
    public static final String PARAM_SERVER_ID = "sid";
    public static final String PARAM_TIMESTAMP = "ts";
    public static final String PARAM_LC_USERNAME = "un";
    public static final String PARAM_LC_PASSWORD = "ps";
    public static final String PARAM_LC_USER_TOKEN = "tk";
    public static final String PARAM_DEST = "dest";
    public static final String PARAM_RETURN_URL = "returnURL";

    public static String createAuthenticationHash(String timestamp, String username, String password, String serverId, String serverKey) {
        String hash = "";
        if (serverId != null && serverKey != null) {
            hash = LamsCommunityUtil.hash(timestamp + username + serverId + password + serverKey);
        }
        return hash;
    }

    public static String hash(String string) {
        return HashUtil.sha1((String)string);
    }

    public static String encryptAuthenticationInfo(String timestamp, String username, String password, String serverId, String serverKey) throws Exception {
        String hash = "";
        if (serverId != null && serverKey != null) {
            hash = LamsCommunityUtil.encrypt(timestamp + "," + username + "," + URLEncoder.encode(password, "UTF8"), serverKey);
        }
        return hash;
    }

    public static String encrypt(String text, String password) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] keyBytes = new byte[16];
        byte[] b = password.getBytes("UTF-8");
        int len = b.length;
        if (len > keyBytes.length) {
            len = keyBytes.length;
        }
        System.arraycopy(b, 0, keyBytes, 0, len);
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(keyBytes);
        cipher.init(1, (Key)keySpec, ivSpec);
        byte[] results = cipher.doFinal(text.getBytes("UTF-8"));
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(results);
    }

    public static String appendAuthInfoToURL(String url, User user) throws Exception {
        Registration reg = Configuration.getRegistration();
        if (reg == null || reg.getServerID() == null || reg.getServerKey() == null) {
            throw new Exception("Attempt to authenticate in lams community without registration");
        }
        String serverID = reg.getServerID();
        String serverKey = reg.getServerKey();
        String timestamp = "" + new Date().getTime();
        String hash = LamsCommunityUtil.createAuthenticationHash(timestamp, user.getLamsCommunityUsername(), user.getLamsCommunityToken(), serverID, serverKey);
        url = url + "&un=" + URLEncoder.encode(user.getLamsCommunityUsername(), "UTF8");
        url = url + "&hs=" + hash;
        url = url + "&sid=" + serverID;
        url = url + "&ts=" + timestamp;
        return url;
    }

    public static HashMap<String, String> getAuthParams() throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        Registration reg = Configuration.getRegistration();
        if (reg == null || reg.getServerID() == null || reg.getServerKey() == null) {
            throw new Exception("Attempt to authenticate in lams community without registration");
        }
        String serverID = reg.getServerID();
        String serverKey = reg.getServerKey();
        UserDTO userDTO = (UserDTO)SessionManager.getSession().getAttribute("user");
        String timestamp = "" + new Date().getTime();
        String hash = LamsCommunityUtil.createAuthenticationHash(timestamp, userDTO.getLamsCommunityUsername(), userDTO.getLamsCommunityToken(), serverID, serverKey);
        ret.put(PARAM_LC_USERNAME, URLEncoder.encode(userDTO.getLamsCommunityUsername(), "UTF8"));
        ret.put(PARAM_HASH, hash);
        ret.put(PARAM_SERVER_ID, serverID);
        ret.put(PARAM_TIMESTAMP, timestamp);
        return ret;
    }
}

