/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.planner;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.ToolContentHandler;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.planner.PedagogicalPlannerSequenceNode;
import org.lamsfoundation.lams.planner.dao.PedagogicalPlannerDAO;
import org.lamsfoundation.lams.planner.dto.PedagogicalPlannerActivityDTO;
import org.lamsfoundation.lams.planner.dto.PedagogicalPlannerSequenceNodeDTO;
import org.lamsfoundation.lams.planner.dto.PedagogicalPlannerTemplateDTO;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.CentralToolContentHandler;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.planner.PedagogicalPlannerGroupingForm;
import org.lamsfoundation.lams.web.planner.PedagogicalPlannerSequenceNodeForm;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PedagogicalPlannerAction
extends LamsDispatchAction {
    private static final String FILE_EXTENSION_ZIP = ".zip";
    private static final String FILE_EXTENSION_LAS = ".las";
    private static final String FORWARD_TEMPLATE = "template";
    private static final String FORWARD_PREVIEW = "preview";
    private static final String FORWARD_SEQUENCE_CHOOSER = "sequenceChooser";
    public static final String FORWARD_GROUPING = "grouping";
    private static final String CHAR_QUESTION_MARK = "?";
    private static final String CHAR_AMPERSAND = "&";
    private static final char CHAR_EQUALS = '=';
    private static final String STRING_OK = "OK";
    private static IUserManagementService userManagementService;
    private static IExportToolContentService exportService;
    private static IAuthoringService authoringService;
    private static IMonitoringService monitoringService;
    private static MessageService messageService;
    private static PedagogicalPlannerDAO pedagogicalPlannerDAO;
    private static ActivityDAO activityDAO;
    private static ToolContentHandler contentHandler;
    private static final String PEDAGOGICAL_PLANNER_DAO_BEAN_NAME = "pedagogicalPlannerDAO";
    private static final String ACTIVITY_DAO_BEAN_NAME = "activityDAO";
    private static final String ERROR_KEY_TOOL_ERRORS = "error.planner.tools.";
    private static final String ERROR_KEY_NODE_TITLE_BLANK = "error.planner.node.title.blank";
    private static final String ERROR_KEY_REPOSITORY = "error.planner.repository";
    private static final String ERROR_KEY_FILE_BAD_EXTENSION = "error.planner.file.bad.extension";
    private static final String ERROR_KEY_FILE_EMPTY = "error.planner.file.empty";
    private static final String ERROR_KEY_FILE_OPEN = "error.planner.file.open";
    private static final String ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED = "error.planner.learning.design.retrieve";
    private static final String ERROR_KEY_EDITOR = "error.planner.editor";
    private static final String ERROR_KEY_EXPORT = "error.planner.export";
    private static final String ERROR_KEY_IMPORT = "error.planner.import";
    private static final String ERROR_KEY_FILTER_PARSE = "error.planner.filter.parse";
    private static final String ERROR_KEY_EXPORT_TEMPLATE = "error.planner.export.template";
    private static final String ERROR_USER_NOT_FOUND = "User not found.";
    private static final String ERROR_NOT_PROPER_FILE = "The sequence template does not exist or is not a proper file.";
    private static final String ERROR_TOO_MANY_OPTIONS = "Number of options in options activity is limited to 4 in Pedagogical Planner.";
    private static final String ERROR_NESTED_OPTIONS = "Nested optional activities are not allowed in Pedagogical Planner.";
    private static final String ERROR_NESTED_BRANCHING = "Nested branching activities are not allowed in Pedagogical Planner.";
    private static final String ERROR_NESTED_PARALLEL = "Nested parallel activities are not allowed in Pedagogical Planner.";
    private static final String ERROR_TOO_MANY_BRANCHES = "Number of branches in branching activity is limited to 4 in Pedagogical Planner.";
    private static final String ERROR_TOO_MANY_PARALLEL_ACTIVITIES = "Number of parallel activities is limited to 4 in Pedagogical Planner.";
    private static Logger log;
    private static final String IMAGE_PATH_GATE = "images/stop.gif";
    private static final String PATH_ACTIVITY_NO_PLANNER_SUPPORT = "/pedagogical_planner/defaultActivityForm.jsp";
    private static final String IMAGE_PATH_GROUPING = "images/grouping.gif";
    private static final String NODE_FILE_NAME = "node.xml";
    private static final String DIR_CONTENT = "content";
    private static final String DIR_TEMPLATES = "template";
    private static final String EXPORT_NODE_FOLDER_SUFFIX = "export_node";
    private static final String EXPORT_NODE_CONTENT_ZIP_PREFIX = "content_";
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final String DIR_UPLOADED_NODE_SUFFIX = "_uploaded_node";
    private static final String EXPORT_NODE_ZIP_PREFIX = "lams_planner_node_";
    private static final int FILE_COPY_BUFFER_SIZE = 1024;
    private static final String FIELD_NAME_TITLE = "title";
    private static final String FIELD_NAME_BRIEF_DESCRIPTION = "briefDescription";
    private static final String FIELD_NAME_FULL_DESCRIPTION = "fullDescription";
    private static final String FIELD_NAME_ANCESTOR_UID = "ancestorUid";
    private static final Map<String, String> filterLanguageMap;
    private static final Map<String, String[]> filterStopWordsMap;
    private static final String PAGE_STRING_START_PLANNER = "StPed";
    private static final String ATTR_PAGE_STR = "pageString";
    private static final String ATTR_DO_NOT_SHOW_AGAIN = "doNotShowAgain";
    private static final String ATTR_SHOW_TUTORIAL = "showTutorial";
    private static final String PARAM_USER_ID = "userId";
    private static final int PLANNER_RECENT_LD_MAX_COUNT = 10;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = SessionManager.getSession();
        UserDTO userDto = (UserDTO)session.getAttribute("user");
        boolean doNotShowAgain = false;
        boolean showTutorial = false;
        request.setAttribute(ATTR_PAGE_STR, (Object)PAGE_STRING_START_PLANNER);
        request.setAttribute(ATTR_SHOW_TUTORIAL, (Object)showTutorial);
        request.setAttribute(ATTR_DO_NOT_SHOW_AGAIN, (Object)doNotShowAgain);
        return this.openSequenceNode(mapping, form, request, response);
    }

    public ActionForward openNewTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ActionMessages errors = new ActionMessages();
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid");
        PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
        LearningDesign learningDesign = this.importLearningDesign(node.getFileUuid(), node.getFileName(), errors);
        if (errors.isEmpty()) {
            errors = this.openTemplate(request, learningDesign);
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return this.openSequenceNode(mapping, form, request, nodeUid);
        }
        return mapping.findForward("template");
    }

    public ActionForward openExistingTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId");
        LearningDesign learningDesign = this.getAuthoringService().getLearningDesign(learningDesignId);
        ActionMessages errors = this.openTemplate(request, learningDesign);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return this.openSequenceNode(mapping, form, request, (Long)null);
        }
        return mapping.findForward("template");
    }

    public ActionMessages openTemplate(HttpServletRequest request, LearningDesign learningDesign) throws ServletException {
        ActionMessages errors = new ActionMessages();
        ArrayList<PedagogicalPlannerActivityDTO> activities = new ArrayList<PedagogicalPlannerActivityDTO>();
        Activity activity = learningDesign.getFirstActivity();
        log.debug((Object)"Parsing learning design activities");
        try {
            while (activity != null) {
                this.addActivityToPlanner(learningDesign, activities, activity);
                Transition transitionFrom = activity.getTransitionFrom();
                if (transitionFrom == null) {
                    activity = null;
                    continue;
                }
                activity = transitionFrom.getToActivity();
            }
        }
        catch (ServletException e) {
            log.error((Object)e, (Throwable)e);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
            return errors;
        }
        int activitySupportingPlannerCount = 0;
        for (PedagogicalPlannerActivityDTO activityDTO : activities) {
            if (!activityDTO.getSupportsPlanner().booleanValue()) continue;
            ++activitySupportingPlannerCount;
        }
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        PedagogicalPlannerTemplateDTO planner = new PedagogicalPlannerTemplateDTO();
        planner.setActivitySupportingPlannerCount(Integer.valueOf(activitySupportingPlannerCount));
        planner.setSequenceTitle(learningDesign.getTitle());
        planner.setActivities(activities);
        planner.setLearningDesignID(learningDesign.getLearningDesignId());
        planner.setNodeUid(nodeUid);
        planner.setSendInPortions(Boolean.valueOf(false));
        planner.setSubmitDelay(Integer.valueOf(5000));
        planner.setActivitiesPerPortion(Integer.valueOf(2));
        request.setAttribute("planner", (Object)planner);
        this.updateRecentLearningDesignList(learningDesign.getLearningDesignId());
        return errors;
    }

    private PedagogicalPlannerActivityDTO addActivityToPlanner(LearningDesign learningDesign, List<PedagogicalPlannerActivityDTO> activities, Activity activity) throws ServletException {
        log.debug((Object)("Parsing activity: " + activity.getTitle()));
        boolean isNested = activity.getParentActivity() != null && (activity.getParentActivity().isBranchingActivity() || activity.isOptionsActivity());
        PedagogicalPlannerActivityDTO addedDTO = null;
        activity = this.getActivityDAO().getActivityByActivityId(activity.getActivityId());
        if (activity.isToolActivity()) {
            ToolActivity toolActivity = (ToolActivity)activity;
            String pedagogicalPlannerUrl = toolActivity.getTool().getPedagogicalPlannerUrl();
            if (pedagogicalPlannerUrl == null) {
                addedDTO = new PedagogicalPlannerActivityDTO(toolActivity.getTool().getToolDisplayName(), activity.getTitle(), Boolean.valueOf(false), PATH_ACTIVITY_NO_PLANNER_SUPPORT, activity.getLibraryActivityUiImage(), null, null);
            } else {
                pedagogicalPlannerUrl = pedagogicalPlannerUrl + (pedagogicalPlannerUrl.contains(CHAR_QUESTION_MARK) ? CHAR_AMPERSAND : CHAR_QUESTION_MARK);
                pedagogicalPlannerUrl = pedagogicalPlannerUrl + "toolContentID=" + toolActivity.getToolContentId();
                addedDTO = new PedagogicalPlannerActivityDTO(toolActivity.getTool().getToolDisplayName(), activity.getTitle(), Boolean.valueOf(true), pedagogicalPlannerUrl + CHAR_AMPERSAND + "contentFolderID" + '=' + learningDesign.getContentFolderID(), activity.getLibraryActivityUiImage(), pedagogicalPlannerUrl + CHAR_AMPERSAND + "command" + '=' + "checkEditingAdvice" + CHAR_AMPERSAND + "activityIndex" + '=' + (activities.size() + 1), pedagogicalPlannerUrl + CHAR_AMPERSAND + "command" + '=' + "getEditingAdvice");
            }
            activities.add(addedDTO);
        } else if (activity.isGroupingActivity()) {
            GroupingActivity groupingActivity = (GroupingActivity)activity;
            addedDTO = new PedagogicalPlannerActivityDTO(null, activity.getTitle(), Boolean.valueOf(true), groupingActivity.getSystemTool().getPedagogicalPlannerUrl() + CHAR_AMPERSAND + "toolContentID" + '=' + groupingActivity.getCreateGrouping().getGroupingId(), IMAGE_PATH_GROUPING, null, null);
            activities.add(addedDTO);
        } else if (activity.isGateActivity()) {
            addedDTO = new PedagogicalPlannerActivityDTO(null, activity.getTitle(), Boolean.valueOf(false), PATH_ACTIVITY_NO_PLANNER_SUPPORT, IMAGE_PATH_GATE, null, null);
            activities.add(addedDTO);
        } else if (activity.isBranchingActivity()) {
            if (isNested) {
                throw new ServletException(ERROR_NESTED_BRANCHING);
            }
            BranchingActivity branchingActivity = (BranchingActivity)activity;
            SequenceActivity defaultSequence = (SequenceActivity)branchingActivity.getDefaultActivity();
            Set sequenceActivities = branchingActivity.getActivities();
            short branch = 1;
            for (SequenceActivity sequenceActivity : sequenceActivities) {
                if (branch > 4) {
                    throw new ServletException(ERROR_TOO_MANY_BRANCHES);
                }
                Object nestedActivity = sequenceActivity.getDefaultActivity();
                boolean defaultBranch = sequenceActivity.equals((Object)defaultSequence);
                if (nestedActivity == null) {
                    String path = "/pedagogical_planner/defaultActivityForm.jsp?formMessage=" + this.getMessageService().getMessage("label.planner.branch.empty");
                    addedDTO = new PedagogicalPlannerActivityDTO(null, null, Boolean.valueOf(false), path, null, null, null);
                    addedDTO.setParentActivityTitle(activity.getTitle());
                    addedDTO.setGroup(Short.valueOf(branch));
                    addedDTO.setDefaultBranch(Boolean.valueOf(defaultBranch));
                    addedDTO.setComplexActivityType(Short.valueOf((short)1));
                    activities.add(addedDTO);
                } else {
                    do {
                        addedDTO = this.addActivityToPlanner(learningDesign, activities, (Activity)nestedActivity);
                        Transition transitionFrom = nestedActivity.getTransitionFrom();
                        nestedActivity = transitionFrom == null ? null : transitionFrom.getToActivity();
                        addedDTO.setParentActivityTitle(activity.getTitle());
                        addedDTO.setGroup(Short.valueOf(branch));
                        addedDTO.setDefaultBranch(Boolean.valueOf(defaultBranch));
                        addedDTO.setComplexActivityType(Short.valueOf((short)1));
                    } while (nestedActivity != null);
                }
                branch = (short)(branch + 1);
            }
            addedDTO.setLastNestedActivity(Boolean.valueOf(true));
        } else if (activity.isOptionsActivity()) {
            if (isNested) {
                throw new ServletException(ERROR_NESTED_OPTIONS);
            }
            OptionsActivity optionsActivity = (OptionsActivity)activity;
            Set nestedActivities = optionsActivity.getActivities();
            short option = 1;
            for (Object nestedActivity : nestedActivities) {
                if (option > 4) {
                    throw new ServletException(ERROR_TOO_MANY_OPTIONS);
                }
                if (nestedActivity.isSequenceActivity()) {
                    nestedActivity = ((SequenceActivity)nestedActivity).getDefaultActivity();
                    do {
                        addedDTO = this.addActivityToPlanner(learningDesign, activities, (Activity)nestedActivity);
                        Transition transitionTo = nestedActivity.getTransitionTo();
                        nestedActivity = transitionTo == null ? null : transitionTo.getToActivity();
                        addedDTO.setParentActivityTitle(activity.getTitle());
                        addedDTO.setGroup(Short.valueOf(option));
                        addedDTO.setComplexActivityType(Short.valueOf((short)2));
                    } while (nestedActivity != null);
                } else {
                    addedDTO = this.addActivityToPlanner(learningDesign, activities, (Activity)nestedActivity);
                    addedDTO.setParentActivityTitle(activity.getTitle());
                    addedDTO.setGroup(Short.valueOf(option));
                    addedDTO.setComplexActivityType(Short.valueOf((short)2));
                }
                option = (short)(option + 1);
            }
            addedDTO.setLastNestedActivity(Boolean.valueOf(true));
        } else if (activity.isParallelActivity()) {
            if (isNested) {
                throw new ServletException(ERROR_NESTED_PARALLEL);
            }
            ParallelActivity parallelActivity = (ParallelActivity)activity;
            Set nestedActivities = parallelActivity.getActivities();
            short option = 1;
            for (Activity nestedActivity : nestedActivities) {
                if (option > 4) {
                    throw new ServletException(ERROR_TOO_MANY_PARALLEL_ACTIVITIES);
                }
                addedDTO = this.addActivityToPlanner(learningDesign, activities, nestedActivity);
                addedDTO.setParentActivityTitle(activity.getTitle());
                addedDTO.setGroup(Short.valueOf(option));
                addedDTO.setComplexActivityType(Short.valueOf((short)3));
                option = (short)(option + 1);
            }
            addedDTO.setLastNestedActivity(Boolean.valueOf(true));
        } else {
            addedDTO = new PedagogicalPlannerActivityDTO(null, activity.getTitle(), Boolean.valueOf(false), PATH_ACTIVITY_NO_PLANNER_SUPPORT, activity.getLibraryActivityUiImage(), null, null);
            activities.add(addedDTO);
        }
        return addedDTO;
    }

    public ActionForward startPreview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Long learningDesignID = WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId", (boolean)true);
        if (learningDesignID == null) {
            Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid");
            PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
            ActionMessages errors = new ActionMessages();
            LearningDesign learningDesign = this.importLearningDesign(node.getFileUuid(), node.getFileName(), errors);
            if (!errors.isEmpty()) {
                ActionMessage error = (ActionMessage)errors.get().next();
                String errorMessage = this.getMessageService().getMessage(error.getKey());
                throw new ServletException(errorMessage);
            }
            learningDesignID = learningDesign.getLearningDesignId();
        }
        HttpSession session = SessionManager.getSession();
        UserDTO userDto = (UserDTO)session.getAttribute("user");
        log.debug((Object)("Opening preview for learnind design id: " + learningDesignID));
        Lesson lesson = this.getMonitoringService().initializeLessonForPreview("Preview", null, learningDesignID.longValue(), userDto.getUserID(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        this.getMonitoringService().createPreviewClassForLesson(userDto.getUserID().intValue(), lesson.getLessonId().longValue());
        this.getMonitoringService().startLesson(lesson.getLessonId().longValue(), userDto.getUserID());
        String newPath = mapping.findForward(FORWARD_PREVIEW).getPath();
        newPath = newPath + CHAR_AMPERSAND + "lessonID" + '=' + lesson.getLessonId() + CHAR_AMPERSAND + "mode" + '=' + FORWARD_PREVIEW;
        return new ActionForward(newPath, true);
    }

    public ActionForward openSequenceNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        return this.openSequenceNode(mapping, form, request, nodeUid);
    }

    public ActionForward openSequenceNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, Long nodeUid) throws ServletException {
        String filterText = WebUtil.readStrParam((HttpServletRequest)request, (String)"filterText", (boolean)true);
        PedagogicalPlannerSequenceNode node = null;
        node = nodeUid == null ? this.getPedagogicalPlannerDAO().getRootNode() : this.getPedagogicalPlannerDAO().getByUid(nodeUid);
        log.debug((Object)("Opening sequence node with UID: " + nodeUid));
        Boolean hasRole = this.hasRole(request, nodeUid);
        Boolean edit = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"edit", (boolean)false);
        edit = edit & hasRole;
        PedagogicalPlannerSequenceNodeDTO dto = null;
        if (filterText != null) {
            try {
                Set<Long> filteredNodeUids = this.filterSubnodes(node, filterText);
                if (filteredNodeUids != null) {
                    request.setAttribute("filterText", (Object)filterText);
                    LinkedHashSet<PedagogicalPlannerSequenceNode> filteredNodes = new LinkedHashSet<PedagogicalPlannerSequenceNode>(filteredNodeUids.size());
                    for (Long filteredUid : filteredNodeUids) {
                        PedagogicalPlannerSequenceNode subnode = this.getPedagogicalPlannerDAO().getByUid(filteredUid);
                        filteredNodes.add(subnode);
                    }
                    dto = new PedagogicalPlannerSequenceNodeDTO(node, filteredNodes, Boolean.valueOf(request.isUserInRole("SYSADMIN")), this.getPedagogicalPlannerDAO());
                    for (PedagogicalPlannerSequenceNodeDTO subnodeDTO : dto.getSubnodes()) {
                        List titlePath = this.getPedagogicalPlannerDAO().getTitlePath(subnodeDTO.getUid());
                        subnodeDTO.setTitlePath(titlePath);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                ActionMessages errors = new ActionMessages();
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILTER_PARSE));
                this.saveErrors(request, errors);
            }
        }
        if (dto == null) {
            dto = new PedagogicalPlannerSequenceNodeDTO(node, node.getSubnodes(), Boolean.valueOf(request.isUserInRole("SYSADMIN")), this.getPedagogicalPlannerDAO());
            if (nodeUid == null) {
                dto.setRecentlyModifiedNodes(this.getRecentlyModifiedLearnindDesignsAsNodes());
            }
        }
        List titlePath = this.getPedagogicalPlannerDAO().getTitlePath(nodeUid);
        Boolean createSubnode = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"createSubnode", (boolean)false);
        Boolean importNode = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"importNode", (boolean)false);
        dto.setCreateSubnode(createSubnode);
        dto.setEdit(edit);
        dto.setHasRole(hasRole);
        dto.setImportNode(importNode);
        dto.setTitlePath(titlePath);
        request.setAttribute("node", (Object)dto);
        if (edit.booleanValue()) {
            PedagogicalPlannerSequenceNodeForm nodeForm = (PedagogicalPlannerSequenceNodeForm)form;
            if (createSubnode.booleanValue()) {
                if (node.getContentFolderId() == null) {
                    String contentFolderId = FileUtil.generateUniqueContentFolderID();
                    nodeForm.setContentFolderId(contentFolderId);
                } else {
                    nodeForm.setContentFolderId(node.getContentFolderId());
                }
            } else if (!importNode.booleanValue()) {
                nodeForm.setNodeType(node.getFileName() == null ? "subnodes" : "template");
                nodeForm.setRemoveFile(false);
                nodeForm.setTitle(dto.getTitle());
                nodeForm.setBriefDescription(dto.getBriefDescription());
                nodeForm.setFullDescription(dto.getFullDescription());
                nodeForm.setFileUuid(node.getFileUuid());
            }
        }
        return mapping.findForward(FORWARD_SEQUENCE_CHOOSER);
    }

    public ActionForward saveSequenceNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        PedagogicalPlannerSequenceNode node = null;
        PedagogicalPlannerSequenceNodeForm nodeForm = (PedagogicalPlannerSequenceNodeForm)form;
        boolean newRootNode = false;
        if (nodeUid == null) {
            Long parentUid;
            node = new PedagogicalPlannerSequenceNode();
            Long l = parentUid = nodeForm.getParentUid() == 0L ? null : nodeForm.getParentUid();
            if (parentUid != null) {
                PedagogicalPlannerSequenceNode parent = this.getPedagogicalPlannerDAO().getByUid(parentUid);
                node.setParent(parent);
            } else {
                newRootNode = true;
            }
            node.setOrder(this.getPedagogicalPlannerDAO().getNextOrderId(parentUid));
        } else {
            node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
            nodeUid = node.getUid();
        }
        if (!this.hasRole(request, nodeUid).booleanValue()) {
            log.debug((Object)"Unauthorised attempt to saveSequenceNode");
            throw new UserAccessDeniedException();
        }
        log.debug((Object)("Saving sequence node with UID: " + nodeUid));
        String title = nodeForm.getTitle();
        String briefDescription = nodeForm.getBriefDescription();
        String fullDescription = nodeForm.getFullDescription();
        String nodeType = nodeForm.getNodeType();
        ActionMessages errors = this.validateNodeForm(node, nodeForm);
        if (errors.isEmpty()) {
            try {
                node.setTitle(title);
                node.setBriefDescription(briefDescription);
                node.setFullDescription(fullDescription);
                node.setContentFolderId(nodeForm.getContentFolderId());
                if ("subnodes".equals(nodeForm.getNodeType())) {
                    if (node.getFileUuid() != null) {
                        this.getContentHandler().deleteFile(node.getFileUuid());
                        node.setFileName(null);
                        node.setFileUuid(null);
                    }
                    node.setFullDescription(fullDescription);
                } else if (Boolean.TRUE.equals(nodeForm.getRemoveFile())) {
                    this.getContentHandler().deleteFile(node.getFileUuid());
                    node.setFileName(null);
                    node.setFileUuid(null);
                } else if (nodeForm.getFile() != null && nodeForm.getFile().getFileSize() > 0) {
                    FormFile file = nodeForm.getFile();
                    InputStream inputStream = file.getInputStream();
                    String fileName = file.getFileName();
                    String type = file.getContentType();
                    log.debug((Object)("Uploading to repository file: " + fileName));
                    NodeKey nodeKey = this.getContentHandler().uploadFile(inputStream, fileName, type, "OFFLINE");
                    if (node.getFileUuid() != null) {
                        this.getContentHandler().deleteFile(node.getFileUuid());
                    }
                    Iterator subnodeIter = node.getSubnodes().iterator();
                    while (subnodeIter.hasNext()) {
                        PedagogicalPlannerSequenceNode subnode = (PedagogicalPlannerSequenceNode)subnodeIter.next();
                        subnodeIter.remove();
                        this.getPedagogicalPlannerDAO().removeNode(subnode);
                    }
                    node.setFileUuid(nodeKey.getUuid());
                    node.setFileName(fileName);
                }
                this.getPedagogicalPlannerDAO().saveOrUpdateNode(node);
                nodeUid = node.getUid();
                if (newRootNode) {
                    try {
                        HttpSession s = SessionManager.getSession();
                        UserDTO u = (UserDTO)s.getAttribute("user");
                        this.getPedagogicalPlannerDAO().saveNodeRole(u.getUserID(), nodeUid, Role.ROLE_AUTHOR_ADMIN);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error saving role for newly created root node: " + e.getMessage()));
                    }
                }
            }
            catch (RepositoryCheckedException e) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_REPOSITORY));
                log.error((Object)e, (Throwable)e);
            }
        }
        boolean createSubnode = false;
        if (nodeUid == null) {
            nodeUid = node.getParent() == null ? null : node.getParent().getUid();
            createSubnode = true;
        }
        this.openSequenceNode(mapping, form, request, nodeUid);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            nodeForm.setTitle(title);
            nodeForm.setBriefDescription(briefDescription);
            nodeForm.setFullDescription(fullDescription);
            nodeForm.setNodeType(nodeType);
            if (createSubnode) {
                PedagogicalPlannerSequenceNodeDTO dto = (PedagogicalPlannerSequenceNodeDTO)request.getAttribute("node");
                dto.setCreateSubnode(Boolean.valueOf(true));
            }
        }
        return mapping.findForward(FORWARD_SEQUENCE_CHOOSER);
    }

    private ActionMessages validateNodeForm(PedagogicalPlannerSequenceNode node, PedagogicalPlannerSequenceNodeForm form) {
        ActionMessages errors = new ActionMessages();
        if (StringUtils.isEmpty((String)form.getTitle())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_NODE_TITLE_BLANK));
        }
        if ("template".equals(form.getNodeType()) && node.getFileName() == null) {
            errors.add(this.validateFormFile(form));
        }
        return errors;
    }

    private ActionMessages validateFormFile(PedagogicalPlannerSequenceNodeForm form) {
        ActionMessages errors = new ActionMessages();
        if (form.getFile() == null || form.getFile().getFileSize() == 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILE_EMPTY));
        } else {
            String fileName = form.getFile().getFileName();
            boolean badExtension = false;
            if (fileName.length() >= 4) {
                String extension = fileName.substring(fileName.length() - 4);
                if (!extension.equalsIgnoreCase(FILE_EXTENSION_LAS) && !extension.equalsIgnoreCase(FILE_EXTENSION_ZIP)) {
                    badExtension = true;
                }
            } else {
                badExtension = true;
            }
            if (badExtension) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILE_BAD_EXTENSION));
            }
        }
        return errors;
    }

    public ActionForward removeSequenceNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, UserAccessDeniedException {
        Long parentUid;
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid");
        PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
        Long l = parentUid = node.getParent() == null ? null : node.getParent().getUid();
        if (!this.hasRole(request, nodeUid).booleanValue()) {
            log.debug((Object)"Unauthorised attempt to removeSequenceNode");
            throw new UserAccessDeniedException();
        }
        log.debug((Object)("Removing sequence node with UID" + nodeUid));
        this.getPedagogicalPlannerDAO().removeNode(node);
        return this.openSequenceNode(mapping, form, request, parentUid);
    }

    public ActionForward moveNodeUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return this.moveNode(mapping, form, request, -1);
    }

    public ActionForward moveNodeDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return this.moveNode(mapping, form, request, 1);
    }

    private ActionForward moveNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, Integer orderDelta) throws IOException, ServletException {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid");
        PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
        Long parentUid = node.getParent() == null ? null : node.getParent().getUid();
        PedagogicalPlannerSequenceNode neighbourNode = this.getPedagogicalPlannerDAO().getNeighbourNode(node, orderDelta);
        neighbourNode.setOrder(Integer.valueOf(0));
        this.getPedagogicalPlannerDAO().saveOrUpdateNode(neighbourNode);
        node.setOrder(Integer.valueOf(node.getOrder() + orderDelta));
        this.getPedagogicalPlannerDAO().saveOrUpdateNode(node);
        neighbourNode.setOrder(Integer.valueOf(node.getOrder() - orderDelta));
        this.getPedagogicalPlannerDAO().saveOrUpdateNode(neighbourNode);
        return this.openSequenceNode(mapping, form, request, parentUid);
    }

    public ActionForward exportNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid");
        ActionMessages errors = new ActionMessages();
        log.debug((Object)("Exporting sequence node with UID" + nodeUid));
        String zipFilePath = null;
        String filename = null;
        try {
            zipFilePath = this.exportNode(nodeUid);
            String zipfile = FileUtil.getFileName((String)zipFilePath);
            zipfile = zipfile.replaceAll(" ", "_");
            filename = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)zipfile);
            log.debug((Object)("Final filename to export: " + filename));
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_EXPORT));
            this.saveErrors(request, errors);
            return this.openSequenceNode(mapping, form, request, nodeUid);
        }
        this.writeOutFile(response, zipFilePath);
        return null;
    }

    private String exportNode(Long nodeUid) throws ZipFileUtilException, FileUtilException, IOException, RepositoryCheckedException {
        if (nodeUid != null) {
            String rootDir = FileUtil.createTempDirectory((String)EXPORT_NODE_FOLDER_SUFFIX);
            String contentDir = FileUtil.getFullPath((String)rootDir, (String)DIR_CONTENT);
            FileUtil.createDirectory((String)contentDir);
            String nodeFileName = FileUtil.getFullPath((String)contentDir, (String)NODE_FILE_NAME);
            OutputStreamWriter nodeFile = new OutputStreamWriter((OutputStream)new FileOutputStream(nodeFileName), ENCODING_UTF_8);
            PedagogicalPlannerSequenceNode node = this.getPedagogicalPlannerDAO().getByUid(nodeUid);
            XStream designXml = new XStream();
            designXml.toXML((Object)node, (Writer)nodeFile);
            ((Writer)nodeFile).close();
            log.debug((Object)"Node xml export success");
            File templateDir = new File(contentDir, "template");
            this.exportSubnodeTemplates(node, templateDir);
            String targetZipFileName = EXPORT_NODE_CONTENT_ZIP_PREFIX + node.getContentFolderId() + FILE_EXTENSION_ZIP;
            String secureDir = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure";
            String nodeContentDir = FileUtil.getFullPath((String)secureDir, (String)node.getContentFolderId());
            if (!FileUtil.isEmptyDirectory((String)nodeContentDir, (boolean)true)) {
                log.debug((Object)("Create export node content target zip file. File name is " + targetZipFileName));
                ZipFileUtil.createZipFile((String)targetZipFileName, (String)nodeContentDir, (String)contentDir);
            } else {
                log.debug((Object)("No such directory (or empty directory): " + nodeContentDir));
            }
            targetZipFileName = EXPORT_NODE_ZIP_PREFIX + node.getTitle() + FILE_EXTENSION_ZIP;
            log.debug((Object)("Create export node content zip file. File name is " + targetZipFileName));
            return ZipFileUtil.createZipFile((String)targetZipFileName, (String)contentDir, (String)rootDir);
        }
        return null;
    }

    public ActionForward importNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (!this.hasRole(request, null).booleanValue()) {
            log.debug((Object)"Unauthorised access to importNode");
            throw new UserAccessDeniedException();
        }
        PedagogicalPlannerSequenceNodeForm nodeForm = (PedagogicalPlannerSequenceNodeForm)form;
        ActionMessages errors = this.validateFormFile(nodeForm);
        if (errors.isEmpty()) {
            try {
                String uploadPath = FileUtil.createTempDirectory((String)DIR_UPLOADED_NODE_SUFFIX);
                String fileName = nodeForm.getFile().getFileName();
                File importFile = new File(uploadPath + fileName);
                log.debug((Object)("Importing a node from file: " + fileName));
                InputStream inputStream = nodeForm.getFile().getInputStream();
                this.copyFileFromRepository(inputStream, importFile);
                nodeForm.setFile(null);
                String rootPath = ZipFileUtil.expandZip((InputStream)new FileInputStream(importFile), (String)fileName);
                String nodeFilePath = FileUtil.getFullPath((String)rootPath, (String)NODE_FILE_NAME);
                PedagogicalPlannerSequenceNode node = (PedagogicalPlannerSequenceNode)FileUtil.getObjectFromXML(null, (String)nodeFilePath);
                String contentZipFileName = EXPORT_NODE_CONTENT_ZIP_PREFIX + node.getContentFolderId() + FILE_EXTENSION_ZIP;
                String secureDir = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + "secure" + File.separator + node.getContentFolderId();
                File contentZipFile = new File(FileUtil.getFullPath((String)rootPath, (String)contentZipFileName));
                if (contentZipFile.exists()) {
                    FileInputStream is = new FileInputStream(contentZipFile);
                    ZipFileUtil.expandZipToFolder((InputStream)is, (String)secureDir);
                }
                File templateDir = new File(rootPath, "template");
                this.importSubnodeTemplates(node, templateDir);
                Integer order = this.getPedagogicalPlannerDAO().getNextOrderId(null);
                node.setOrder(order);
                this.getPedagogicalPlannerDAO().saveOrUpdateNode(node);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_IMPORT));
            }
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
        }
        return this.openSequenceNode(mapping, form, request, (Long)null);
    }

    private LearningDesign importLearningDesign(Long fileUuid, String fileName, ActionMessages errors) throws ServletException {
        File designFile = null;
        try {
            designFile = new File(FileUtil.getTempDir(), fileName);
            InputStream inputStream = this.getContentHandler().getFileNode(fileUuid).getFile();
            this.copyFileFromRepository(inputStream, designFile);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILE_OPEN));
            return null;
        }
        if (!designFile.exists() || designFile.isDirectory()) {
            log.error((Object)ERROR_NOT_PROPER_FILE);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_FILE_OPEN));
            return null;
        }
        HttpSession session = SessionManager.getSession();
        UserDTO userDto = (UserDTO)session.getAttribute("user");
        User user = (User)this.getUserManagementService().findById(User.class, (Serializable)userDto.getUserID());
        if (user == null) {
            throw new ServletException(ERROR_USER_NOT_FOUND);
        }
        List toolsErrorMsgs = new ArrayList();
        Long learningDesignID = null;
        LearningDesign learningDesign = null;
        List learningDesignErrorMsgs = new ArrayList();
        try {
            Object[] ldResults = this.getExportService().importLearningDesign(designFile, user, null, toolsErrorMsgs, "");
            designFile.delete();
            learningDesignID = (Long)ldResults[0];
            learningDesignErrorMsgs = (List)ldResults[1];
            toolsErrorMsgs = (List)ldResults[2];
            learningDesign = this.getAuthoringService().getLearningDesign(learningDesignID);
        }
        catch (ImportToolContentException e) {
            log.error((Object)e, (Throwable)e);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
        }
        if ((learningDesignID == null || learningDesignID == -1L) && learningDesignErrorMsgs.size() == 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
            return null;
        }
        if (learningDesignErrorMsgs.size() > 0) {
            for (String error : learningDesignErrorMsgs) {
                log.error((Object)error);
            }
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
            return null;
        }
        if (toolsErrorMsgs.size() > 0) {
            for (String error : toolsErrorMsgs) {
                log.error((Object)error);
            }
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_TOOL_ERRORS));
            return null;
        }
        return learningDesign;
    }

    private void exportSubnodeTemplates(PedagogicalPlannerSequenceNode node, File outputDir) throws RepositoryCheckedException, IOException {
        if (node != null) {
            if (node.getFileUuid() == null) {
                if (node.getSubnodes() != null) {
                    for (PedagogicalPlannerSequenceNode subnode : node.getSubnodes()) {
                        this.exportSubnodeTemplates(subnode, outputDir);
                    }
                }
            } else {
                File uuidDir = new File(outputDir, node.getFileUuid().toString());
                uuidDir.mkdirs();
                File targetFile = new File(uuidDir, node.getFileName());
                InputStream inputStream = this.getContentHandler().getFileNode(node.getFileUuid()).getFile();
                log.debug((Object)("Preparing for zipping the template file: " + node.getFileName()));
                this.copyFileFromRepository(inputStream, targetFile);
            }
        }
    }

    private void importSubnodeTemplates(PedagogicalPlannerSequenceNode node, File inputDir) throws RepositoryCheckedException, IOException {
        if (node != null) {
            node.setUid(null);
            if (node.getFileUuid() == null) {
                if (node.getSubnodes() != null) {
                    for (PedagogicalPlannerSequenceNode subnode : node.getSubnodes()) {
                        this.importSubnodeTemplates(subnode, inputDir);
                        subnode.setParent(node);
                    }
                }
            } else {
                File uuidDir = new File(inputDir, node.getFileUuid().toString());
                File file = new File(uuidDir, node.getFileName());
                FileInputStream inputStream = new FileInputStream(file);
                String fileName = node.getFileName();
                log.debug((Object)("Uploading into repository a template file: " + fileName));
                NodeKey nodeKey = this.getContentHandler().uploadFile((InputStream)inputStream, fileName, "application/x-download", "OFFLINE");
                node.setFileUuid(nodeKey.getUuid());
            }
        }
    }

    private void copyFileFromRepository(InputStream inputStream, File targetFile) throws RepositoryCheckedException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(targetFile);
        byte[] data = new byte[1024];
        int read = 0;
        do {
            if ((read = inputStream.read(data)) <= 0) continue;
            fileOutputStream.write(data, 0, read);
        } while (read > 0);
        fileOutputStream.close();
        inputStream.close();
    }

    private Set<Long> filterSubnodes(PedagogicalPlannerSequenceNode node, String filterText) throws ParseException, CorruptIndexException, IOException {
        Set<Document> docs;
        LinkedHashSet<Long> matchingSubnodeUids = new LinkedHashSet<Long>();
        if (!StringUtils.isEmpty((String)filterText) && !(docs = this.extractSubnodeDocuments(node)).isEmpty()) {
            Analyzer analyzer = this.getAnalyzer();
            MultiFieldQueryParser queryParser = new MultiFieldQueryParser(new String[]{FIELD_NAME_TITLE, FIELD_NAME_FULL_DESCRIPTION, FIELD_NAME_BRIEF_DESCRIPTION}, analyzer);
            Query query = queryParser.parse(filterText);
            RAMDirectory dir = new RAMDirectory();
            IndexWriter indexWriter = new IndexWriter((Directory)dir, analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
            for (Document doc : docs) {
                indexWriter.addDocument(doc);
            }
            indexWriter.optimize();
            indexWriter.close();
            IndexSearcher searcher = new IndexSearcher((Directory)dir);
            TopDocs topDocs = searcher.search(query, null, docs.size());
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document doc = searcher.doc(scoreDoc.doc);
                String ancestorUid = doc.get(FIELD_NAME_ANCESTOR_UID);
                Long uid = new Long(ancestorUid);
                matchingSubnodeUids.add(uid);
            }
        }
        return matchingSubnodeUids;
    }

    private Set<Document> extractSubnodeDocuments(PedagogicalPlannerSequenceNode node) {
        HashSet<Document> docs = new HashSet<Document>();
        if (node != null && node.getSubnodes() != null) {
            for (PedagogicalPlannerSequenceNode subnode : node.getSubnodes()) {
                String fullDesc;
                Document doc = new Document();
                Field titleField = new Field(FIELD_NAME_TITLE, subnode.getTitle(), Field.Store.NO, Field.Index.ANALYZED);
                titleField.setBoost(10.0f);
                doc.add((Fieldable)titleField);
                String briefDesc = WebUtil.removeHTMLtags((String)subnode.getBriefDescription());
                if (briefDesc != null) {
                    Field briefDescField = new Field(FIELD_NAME_BRIEF_DESCRIPTION, briefDesc, Field.Store.NO, Field.Index.ANALYZED);
                    doc.add((Fieldable)briefDescField);
                }
                if ((fullDesc = WebUtil.removeHTMLtags((String)subnode.getFullDescription())) != null) {
                    Field fullDescField = new Field(FIELD_NAME_FULL_DESCRIPTION, fullDesc, Field.Store.NO, Field.Index.ANALYZED);
                    doc.add((Fieldable)fullDescField);
                }
                Field uidField = new Field(FIELD_NAME_ANCESTOR_UID, subnode.getUid().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
                doc.add((Fieldable)uidField);
                docs.add(doc);
                Set<Document> subnodeDocs = this.extractSubnodeDocuments(subnode);
                docs.addAll(subnodeDocs);
            }
        }
        return docs;
    }

    private Analyzer getAnalyzer() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        String languageCode = user == null ? null : user.getLocaleLanguage();
        String language = filterLanguageMap.get(languageCode);
        if (language == null) {
            return new SimpleAnalyzer();
        }
        String[] stopWords = filterStopWordsMap.get(language);
        if (stopWords == null) {
            return new SnowballAnalyzer(language);
        }
        return new SnowballAnalyzer(language, stopWords);
    }

    public ActionForward initGrouping(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PedagogicalPlannerGroupingForm plannerForm = (PedagogicalPlannerGroupingForm)form;
        Long groupingId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        Grouping grouping = this.getAuthoringService().getGroupingById(groupingId);
        plannerForm.fillForm(grouping);
        return mapping.findForward(FORWARD_GROUPING);
    }

    public ActionForward saveOrUpdateGroupingForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.debug((Object)"Saving grouping activity");
        PedagogicalPlannerGroupingForm plannerForm = (PedagogicalPlannerGroupingForm)form;
        ActionMessages errors = plannerForm.validate();
        if (errors.isEmpty()) {
            Grouping grouping = this.getAuthoringService().getGroupingById(plannerForm.getToolContentID());
            if (grouping.isRandomGrouping()) {
                RandomGrouping randomGrouping = (RandomGrouping)grouping;
                Integer number = StringUtils.isEmpty((String)plannerForm.getNumberOfGroups()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getNumberOfGroups()));
                randomGrouping.setNumberOfGroups(number);
                number = StringUtils.isEmpty((String)plannerForm.getLearnersPerGroup()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getLearnersPerGroup()));
                randomGrouping.setLearnersPerGroup(number);
            } else if (grouping.isLearnerChoiceGrouping()) {
                LearnerChoiceGrouping learnerChoiceGrouping = (LearnerChoiceGrouping)grouping;
                Integer number = StringUtils.isEmpty((String)plannerForm.getNumberOfGroups()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getNumberOfGroups()));
                learnerChoiceGrouping.setNumberOfGroups(number);
                number = StringUtils.isEmpty((String)plannerForm.getLearnersPerGroup()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getLearnersPerGroup()));
                learnerChoiceGrouping.setLearnersPerGroup(number);
                learnerChoiceGrouping.setEqualNumberOfLearnersPerGroup(plannerForm.getEqualGroupSizes());
                learnerChoiceGrouping.setViewStudentsBeforeSelection(plannerForm.getViewStudentsBeforeSelection());
            } else {
                Integer number = StringUtils.isEmpty((String)plannerForm.getNumberOfGroups()) ? null : Integer.valueOf(Integer.parseInt(plannerForm.getNumberOfGroups()));
                grouping.setMaxNumberOfGroups(number);
            }
        } else {
            this.saveMessages(request, errors);
        }
        return mapping.findForward(FORWARD_GROUPING);
    }

    private List<PedagogicalPlannerSequenceNodeDTO> getRecentlyModifiedLearnindDesignsAsNodes() {
        HttpSession session = SessionManager.getSession();
        UserDTO userDto = (UserDTO)session.getAttribute("user");
        User user = (User)this.getUserManagementService().findById(User.class, (Serializable)userDto.getUserID());
        Set recentLDs = user.getRecentlyModifiedLearningDesigns();
        LinkedList<PedagogicalPlannerSequenceNodeDTO> recentNodes = new LinkedList<PedagogicalPlannerSequenceNodeDTO>();
        for (Long learningDesignId : recentLDs) {
            LearningDesign learningDesign = this.getAuthoringService().getLearningDesign(learningDesignId);
            PedagogicalPlannerSequenceNodeDTO node = new PedagogicalPlannerSequenceNodeDTO();
            node.setTitle(learningDesign.getTitle());
            node.setLearningDesignId(learningDesignId);
            recentNodes.add(node);
        }
        return recentNodes;
    }

    private void updateRecentLearningDesignList(Long learningDesignId) {
        HttpSession session = SessionManager.getSession();
        UserDTO userDto = (UserDTO)session.getAttribute("user");
        User user = (User)this.getUserManagementService().findById(User.class, (Serializable)userDto.getUserID());
        Set recentLDs = user.getRecentlyModifiedLearningDesigns();
        boolean ldFound = false;
        Iterator iter = recentLDs.iterator();
        while (iter.hasNext()) {
            Long recentLD = (Long)iter.next();
            if (!recentLD.equals(learningDesignId)) continue;
            iter.remove();
            this.getUserManagementService().save((Object)user);
            ldFound = true;
            break;
        }
        if (!ldFound && recentLDs.size() >= 10) {
            iter.remove();
        }
        recentLDs.add(learningDesignId);
        this.getUserManagementService().save((Object)user);
    }

    public ActionForward saveSequenceDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug((Object)"Saving sequence title");
        String sequenceTitle = WebUtil.readStrParam((HttpServletRequest)request, (String)"sequenceTitle", (boolean)true);
        Long learningDesignID = WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId");
        Integer callAttemptedID = WebUtil.readIntParam((HttpServletRequest)request, (String)"callAttemptedID");
        String responseSuffix = CHAR_AMPERSAND + callAttemptedID;
        if (StringUtils.isEmpty((String)sequenceTitle)) {
            String blankTitleError = this.getMessageService().getMessage("error.planner.title.blank");
            this.writeAJAXResponse(response, blankTitleError + responseSuffix);
        } else {
            LearningDesign learningDesign = this.getAuthoringService().getLearningDesign(learningDesignID);
            learningDesign.setTitle(sequenceTitle);
            this.getAuthoringService().saveLearningDesign(learningDesign);
            this.writeAJAXResponse(response, STRING_OK + responseSuffix);
        }
        return null;
    }

    public ActionForward exportTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)"ldId");
        ArrayList toolsErrorMsgs = new ArrayList();
        ActionMessages errors = new ActionMessages();
        String zipFilePath = null;
        boolean valid = false;
        try {
            zipFilePath = this.getExportService().exportLearningDesign(learningDesignId, toolsErrorMsgs, 1, null);
            if (toolsErrorMsgs.isEmpty()) {
                String zipfile = FileUtil.getFileName((String)zipFilePath);
                zipfile = zipfile.replaceAll(" ", "_");
                String filename = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)zipfile);
                log.debug((Object)("Final filename to export: " + filename));
                response.setContentType("application/x-download");
                response.setHeader("Content-Disposition", "attachment;filename=" + filename);
                valid = true;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        if (!valid) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_KEY_EXPORT_TEMPLATE));
            this.saveErrors(request, errors);
            for (String error : toolsErrorMsgs) {
                log.error((Object)error);
            }
            LearningDesign learningDesign = this.getAuthoringService().getLearningDesign(learningDesignId);
            errors = this.openTemplate(request, learningDesign);
            if (!errors.isEmpty()) {
                throw new ServletException(this.getMessageService().getMessage(ERROR_KEY_LEARNING_DESIGN_COULD_NOT_BE_RETRIEVED));
            }
            return mapping.findForward("template");
        }
        this.writeOutFile(response, zipFilePath);
        return null;
    }

    public ActionForward addRemoveEditors(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        if (this.hasRole(request, nodeUid).booleanValue()) {
            List existingUsers = this.getPedagogicalPlannerDAO().getNodeUsers(nodeUid, Role.ROLE_AUTHOR_ADMIN);
            Integer orgId = this.getUserManagementService().getRootOrganisation().getOrganisationId();
            Vector potentialUsersVector = this.getUserManagementService().getUsersFromOrganisationByRole(orgId, "AUTHOR ADMIN", false, true);
            Set allInheritedUsers = this.getPedagogicalPlannerDAO().getInheritedNodeUsers(nodeUid, Role.ROLE_AUTHOR_ADMIN);
            ArrayList<User> filteredInheritedUsers = new ArrayList<User>();
            for (Object o : allInheritedUsers) {
                User u = (User)o;
                if (existingUsers.contains(u)) continue;
                filteredInheritedUsers.add(u);
            }
            ArrayList<User> potentialUsers = new ArrayList<User>();
            for (Object o : potentialUsersVector) {
                User u = (User)o;
                if (existingUsers.contains(u) || allInheritedUsers.contains(u) || StringUtils.equals((String)u.getLogin(), (String)request.getRemoteUser())) continue;
                potentialUsers.add(u);
            }
            request.setAttribute("existingUsers", (Object)existingUsers);
            request.setAttribute("potentialUsers", potentialUsers);
            request.setAttribute("inheritedUsers", filteredInheritedUsers);
            return mapping.findForward("editAuthors");
        }
        log.debug((Object)"Unauthorised attempt to access add/remove editors page.");
        throw new UserAccessDeniedException();
    }

    public ActionForward addEditor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)PARAM_USER_ID, (boolean)false);
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)true);
        if (this.hasRole(request, nodeUid).booleanValue()) {
            this.getPedagogicalPlannerDAO().saveNodeRole(userId, nodeUid, Role.ROLE_AUTHOR_ADMIN);
        } else {
            log.debug((Object)"Unauthorised attempt to add editor to node.");
        }
        return null;
    }

    public ActionForward removeEditor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer userId = WebUtil.readIntParam((HttpServletRequest)request, (String)PARAM_USER_ID, (boolean)false);
        Long nodeUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"uid", (boolean)false);
        if (this.hasRole(request, nodeUid).booleanValue()) {
            this.getPedagogicalPlannerDAO().removeNodeRole(userId, nodeUid, Role.ROLE_AUTHOR_ADMIN);
        } else {
            log.debug((Object)"Unauthorised attempt to remove editor from node.");
        }
        return null;
    }

    private Boolean hasRole(HttpServletRequest request, Long nodeUid) {
        if (request.isUserInRole("SYSADMIN")) {
            return true;
        }
        if (nodeUid == null) {
            return this.getUserManagementService().isUserGlobalAuthorAdmin();
        }
        return this.isNodeEditor(request, nodeUid);
    }

    private Boolean isNodeEditor(HttpServletRequest request, Long nodeUid) {
        User user = this.getUserManagementService().getUserByLogin(request.getRemoteUser());
        return this.getPedagogicalPlannerDAO().isEditor(user.getUserId(), nodeUid, Role.ROLE_AUTHOR_ADMIN);
    }

    private IExportToolContentService getExportService() {
        if (exportService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            exportService = (IExportToolContentService)ctx.getBean("exportToolContentService");
        }
        return exportService;
    }

    private IAuthoringService getAuthoringService() {
        if (authoringService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            authoringService = (IAuthoringService)ctx.getBean("authoringService");
        }
        return authoringService;
    }

    private IMonitoringService getMonitoringService() {
        if (monitoringService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            monitoringService = (IMonitoringService)ctx.getBean("monitoringService");
        }
        return monitoringService;
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private MessageService getMessageService() {
        if (messageService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            messageService = (MessageService)ctx.getBean("centralMessageService");
        }
        return messageService;
    }

    private PedagogicalPlannerDAO getPedagogicalPlannerDAO() {
        if (pedagogicalPlannerDAO == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            pedagogicalPlannerDAO = (PedagogicalPlannerDAO)wac.getBean(PEDAGOGICAL_PLANNER_DAO_BEAN_NAME);
        }
        return pedagogicalPlannerDAO;
    }

    private ActivityDAO getActivityDAO() {
        if (activityDAO == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            activityDAO = (ActivityDAO)wac.getBean(ACTIVITY_DAO_BEAN_NAME);
        }
        return activityDAO;
    }

    private ToolContentHandler getContentHandler() {
        if (contentHandler == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            contentHandler = (CentralToolContentHandler)((Object)wac.getBean("centralToolContentHandler"));
        }
        return contentHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutFile(HttpServletResponse response, String zipFilePath) throws IOException {
        InputStream in = null;
        ServletOutputStream out = null;
        try {
            int ch;
            in = new BufferedInputStream(new FileInputStream(zipFilePath));
            out = response.getOutputStream();
            int count = 0;
            while ((ch = in.read()) != -1) {
                out.write((int)((char)ch));
                ++count;
            }
            log.debug((Object)("Wrote out " + count + " bytes"));
            response.setContentLength(count);
            out.flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    static {
        log = Logger.getLogger(PedagogicalPlannerAction.class);
        filterLanguageMap = new TreeMap<String, String>();
        filterStopWordsMap = new TreeMap<String, String[]>();
        filterLanguageMap.put("en", "English");
        filterLanguageMap.put("nl", "Dutch");
        filterLanguageMap.put("da", "Danish");
        filterLanguageMap.put("nl", "Finnish");
        filterLanguageMap.put("fr", "French");
        filterLanguageMap.put("de", "German");
        filterLanguageMap.put("hu", "Hungarian");
        filterLanguageMap.put("it", "Italian");
        filterLanguageMap.put("no", "Norwegian");
        filterLanguageMap.put("pt", "Portuguese");
        filterLanguageMap.put("ru", "Russian");
        filterLanguageMap.put("es", "Spanish");
        filterLanguageMap.put("sv", "Swedish");
        filterLanguageMap.put("tr", "Turkish");
        filterStopWordsMap.put("English", StopAnalyzer.ENGLISH_STOP_WORDS);
    }
}

