/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.TimeZone;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.themes.dto.CSSThemeBriefDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.session.SessionManager;

public class UserTag
extends TagSupport {
    private static final long serialVersionUID = -2801719186682639858L;
    private static final Logger log = Logger.getLogger(UserTag.class);
    private String property = null;

    public int doStartTag() throws JspException {
        HttpSession ss = SessionManager.getSession();
        if (ss != null) {
            UserDTO user = (UserDTO)ss.getAttribute("user");
            if (user != null) {
                this.processProperty(user);
            } else {
                log.warn((Object)("UserTag unable to access user details as userDTO is missing. Session is " + ss));
            }
        } else {
            log.warn((Object)"UserTag unable to access user details as shared session is missing");
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    private void processProperty(UserDTO user) throws JspException {
        block8: {
            try {
                if (this.property == null) break block8;
                Object value = null;
                try {
                    if (this.property.equals("timeZoneDisplayName")) {
                        String indexLbl = ((TimeZone)PropertyUtils.getProperty((Object)user, (String)"timeZone")).getID();
                        value = URLEncoder.encode(indexLbl, "UTF8");
                    } else {
                        value = PropertyUtils.getProperty((Object)user, (String)this.property);
                    }
                    if (this.property.equals("flashTheme") || this.property.equals("htmlTheme")) {
                        CSSThemeBriefDTO cssTheme = (CSSThemeBriefDTO)value;
                        value = cssTheme.getName();
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("UserTag unable to write out user details due to exception while accessing property value. User id " + user.getUserID()), (Throwable)e);
                }
                if (value != null) {
                    JspWriter writer = this.pageContext.getOut();
                    writer.print(value);
                }
            }
            catch (IOException e) {
                log.error((Object)("UserTag unable to write out user details due to IOException. User id " + user.getUserID()), (Throwable)e);
                throw new JspException((Throwable)e);
            }
        }
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

