/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

public class WebAppURLTag
extends TagSupport {
    private static final long serialVersionUID = -3773379475085729642L;
    private static final Logger log = Logger.getLogger(WebAppURLTag.class);

    public int doStartTag() throws JspException {
        ServletRequest sr = this.pageContext.getRequest();
        if (HttpServletRequest.class.isInstance(sr)) {
            HttpServletRequest request = (HttpServletRequest)sr;
            String protocol = request.getProtocol();
            protocol = protocol.startsWith("HTTPS") ? "https://" : "http://";
            String path = protocol + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            try {
                JspWriter writer = this.pageContext.getOut();
                writer.print(path);
            }
            catch (IOException e) {
                log.error((Object)"ServerURLTag unable to write out server URL due to IOException. ", (Throwable)e);
                throw new JspException((Throwable)e);
            }
        } else {
            log.warn((Object)"ServerURLTag unable to write out server URL as the servlet request is not an HttpServletRequest.");
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }
}

