/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.presence.model.PresenceChatMessage;
import org.lamsfoundation.lams.presence.service.IPresenceChatLoggerService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.util.HttpSessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceChatLoggerAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(PresenceChatLoggerAction.class);

    public ActionForward getConversationHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String roomName = WebUtil.readStrParam((HttpServletRequest)request, (String)"roomName");
            String from = WebUtil.readStrParam((HttpServletRequest)request, (String)"from");
            String to = WebUtil.readStrParam((HttpServletRequest)request, (String)"to");
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
            IPresenceChatLoggerService presenceChatLoggerService = (IPresenceChatLoggerService)ctx.getBean("presenceChatLoggerService");
            List messages = presenceChatLoggerService.getMessagesByConversation(from, to, roomName);
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            this.writeAJAXResponse(response, this.buildConversationXML(to, messages));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public ActionForward getGroupHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String roomName = WebUtil.readStrParam((HttpServletRequest)request, (String)"roomName");
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
            IPresenceChatLoggerService presenceChatLoggerService = (IPresenceChatLoggerService)ctx.getBean("presenceChatLoggerService");
            List messages = presenceChatLoggerService.getMessagesByRoomName(roomName);
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            this.writeAJAXResponse(response, this.buildGroupHistoryXML(messages));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public ActionForward saveMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String roomName = WebUtil.readStrParam((HttpServletRequest)request, (String)"roomName");
            String from = WebUtil.readStrParam((HttpServletRequest)request, (String)"from");
            String to = WebUtil.readStrParam((HttpServletRequest)request, (String)"to");
            String message = WebUtil.readStrParam((HttpServletRequest)request, (String)"message");
            if (to.compareTo("null") == 0) {
                to = null;
            }
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionManager.getInstance().getServletContext());
            IPresenceChatLoggerService presenceChatLoggerService = (IPresenceChatLoggerService)ctx.getBean("presenceChatLoggerService");
            presenceChatLoggerService.createPresenceChatMessage(roomName, from, to, new Date(), message);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    private String buildConversationXML(String nick, List<PresenceChatMessage> messages) {
        String xmlOutput = "<conversation><nick>" + nick + "</nick>";
        XStream xstream = new XStream();
        xstream.alias("clause", PresenceChatMessage.class);
        for (PresenceChatMessage message : messages) {
            xmlOutput = xmlOutput + xstream.toXML((Object)message);
        }
        xmlOutput = xmlOutput + "</conversation>";
        return xmlOutput;
    }

    private String buildGroupHistoryXML(List<PresenceChatMessage> messages) {
        String xmlOutput = "<groupHistory>";
        XStream xstream = new XStream();
        xstream.alias("clause", PresenceChatMessage.class);
        for (PresenceChatMessage message : messages) {
            xmlOutput = xmlOutput + xstream.toXML((Object)message);
        }
        xmlOutput = xmlOutput + "</groupHistory>";
        return xmlOutput;
    }
}

