/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSDoAction;
import com.flagstone.transform.FSImport;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.FSSetBackgroundColor;
import com.flagstone.transform.FSShowFrame;
import com.flagstone.translate.ASParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class WhiteboardToSwfServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(WhiteboardToSwfServlet.class);
    private int swfVersion = 6;
    private ASParser parser = new ASParser();
    private String FILEPATH = "c:\\test\\";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        PrintWriter out = null;
        String dir = System.getProperty("java.io.tmpdir");
        try {
            out = response.getWriter();
            String trace = request.getParameter("trace");
            String courseId = request.getParameter("courseId");
            String nTotal = request.getParameter("nTotal");
            String nPages = request.getParameter("nPages");
            String author = request.getParameter("author");
            String bgName = request.getParameter("bgName");
            String bgColor = request.getParameter("bgColor");
            String bgClip = request.getParameter("bgClip");
            String nFigures = request.getParameter("nFigures");
            String nShapes = request.getParameter("nShapes");
            String nTexts = request.getParameter("nTexts");
            String nLines = request.getParameter("nLines");
            String vFigure = request.getParameter("vFigure");
            String vShape = request.getParameter("vShape");
            String vText = request.getParameter("vText");
            String vLine = request.getParameter("vLine");
            String xMaxInTwips = request.getParameter("xMaxInTwips");
            String yMaxInTwips = request.getParameter("yMaxInTwips");
            String bgColorR = request.getParameter("bgColorR");
            String bgColorB = request.getParameter("bgColorB");
            String bgColorG = request.getParameter("bgColorG");
            Random r = new Random();
            String filename = Long.toString(Math.abs(r.nextLong()), 50);
            String completeFilename = this.FILEPATH + filename + ".as";
            try {
                BufferedWriter outFile = new BufferedWriter(new FileWriter(completeFilename));
                String fromFlashToFile = trace + author + bgName + bgColor + nPages + nTexts + nLines + nShapes + nFigures + vText + vLine + vShape + vFigure;
                String correctedFlashToFile = fromFlashToFile.replace("//,", "");
                String correctedFlashToFileSecond = correctedFlashToFile.replace("//", "");
                outFile.write(correctedFlashToFileSecond);
                outFile.close();
                log.debug((Object)correctedFlashToFileSecond);
                out.write(correctedFlashToFileSecond);
            }
            catch (IOException e) {
                // empty catch block
            }
            FSMovie movie = new FSMovie();
            movie.setFrameSize(new FSBounds(0, 0, Integer.valueOf(xMaxInTwips).intValue(), Integer.valueOf(yMaxInTwips).intValue()));
            movie.add((FSMovieObject)new FSSetBackgroundColor(new FSColor(Integer.valueOf(bgColorR).intValue(), Integer.valueOf(bgColorG).intValue(), Integer.valueOf(bgColorB).intValue())));
            movie.setFrameRate(12.0f);
            movie.setVersion(this.swfVersion);
            this.importSwfFiles(movie, bgClip, Integer.parseInt(nTotal));
            String readFromFlash = this.readFile(completeFilename);
            byte[] actionsFromFlash = this.parser.parse(readFromFlash).encode(this.swfVersion);
            FSDoAction frameFromFlash = new FSDoAction(actionsFromFlash);
            movie.add((FSMovieObject)frameFromFlash);
            movie.add((FSMovieObject)new FSShowFrame());
            String readFromDrawAs = this.readFile(this.FILEPATH + "draw.as");
            byte[] actionsFromDrawAs = this.parser.parse(readFromDrawAs).encode(this.swfVersion);
            FSDoAction frameFromDrawAs = new FSDoAction(actionsFromDrawAs);
            movie.add((FSMovieObject)frameFromDrawAs);
            movie.add((FSMovieObject)new FSShowFrame());
            this.writeFile(movie, this.FILEPATH, "test.swf");
        }
        catch (IOException e) {
            log.error((Object)("print writer threw exception, " + e));
        }
        catch (Exception e) {
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    private void importSwfFiles(FSMovie movie, String bgClip, int nTotal) {
        movie.add((FSMovieObject)new FSImport(this.FILEPATH + "logo.swf", movie.newIdentifier(), "logo"));
        movie.add((FSMovieObject)new FSImport(this.FILEPATH + bgClip + ".swf", movie.newIdentifier(), "background"));
        movie.add((FSMovieObject)new FSImport(this.FILEPATH + "right.swf", movie.newIdentifier(), "right"));
        movie.add((FSMovieObject)new FSImport(this.FILEPATH + "left.swf", movie.newIdentifier(), "left"));
        for (int i = 1; i <= nTotal; ++i) {
            movie.add((FSMovieObject)new FSImport(this.FILEPATH + "shape" + i + ".swf", movie.newIdentifier(), "shape" + i));
        }
    }

    private String readFile(String filename) {
        String readText = new String();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String line = in.readLine();
            while (line != null) {
                readText = readText + line;
                line = in.readLine();
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return readText;
    }

    private void writeFile(FSMovie movie, String path, String fileName) {
        try {
            movie.encodeToFile(path + fileName);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open file: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Cannot write to file: " + e.getMessage());
        }
    }
}

