/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessonJoinServlet
extends HttpServlet {
    private static final long serialVersionUID = -8013072844129192750L;
    private static Logger log = Logger.getLogger(LessonJoinServlet.class);
    private static ILessonService lessonService = null;
    private static IUserManagementService userService = null;
    private static IMonitoringService monitoringService = null;
    private static IntegrationService integrationService = null;

    public void init() throws ServletException {
        lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("lessonService");
        userService = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("userManagementService");
        monitoringService = (IMonitoringService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("monitoringService");
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF8");
        String serverId = request.getParameter("serverId");
        String datetime = request.getParameter("datetime");
        String hashValue = request.getParameter("hashValue");
        String username = request.getParameter("username");
        String orgId = request.getParameter("courseId");
        String ldId = request.getParameter("ldId");
        String learnerSize = request.getParameter("learnerSize");
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Node document = null;
        Element element = null;
        factory = DocumentBuilderFactory.newInstance();
        builder = factory.newDocumentBuilder();
        document = builder.newDocument();
        element = document.createElement("status");
        if (StringUtils.isBlank((String)username)) {
            log.debug((Object)"Missing parameter: username");
            element.setAttribute("resultCode", "0");
            element.setAttribute("resultText", "Missing parameter: username");
        } else if (StringUtils.isBlank((String)orgId)) {
            log.debug((Object)"Missing parameter: courseId");
            element.setAttribute("resultCode", "0");
            element.setAttribute("resultText", "Missing parameter: courseId");
        } else if (StringUtils.isBlank((String)ldId)) {
            log.debug((Object)"Missing parameter: ldId");
            element.setAttribute("resultCode", "0");
            element.setAttribute("resultText", "Missing parameter: ldId");
        } else if (StringUtils.isBlank((String)learnerSize)) {
            log.debug((Object)"Missing parameter: learnerSize");
            element.setAttribute("resultCode", "0");
            element.setAttribute("resultText", "Missing parameter: learnerSize");
        }
        ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
        Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)hashValue);
        User user = userService.getUserByLogin(username);
        if (user != null) {
            this.addUserToOrg(user, Integer.valueOf(orgId));
            List lessons = lessonService.getLessonsByOriginalLearningDesign(Long.valueOf(ldId), Integer.valueOf(orgId));
            if (lessons != null && lessons.size() > 0) {
                String resultCode;
                if (this.addUserToLesson(lessons, Integer.valueOf(learnerSize), Integer.valueOf(orgId), user).booleanValue()) {
                    element.setAttribute("resultCode", "1");
                }
                if (StringUtils.isBlank((String)(resultCode = element.getAttribute("resultCode"))) && this.createNewLesson(lessons, Long.valueOf(ldId), Integer.valueOf(orgId), user).booleanValue()) {
                    element.setAttribute("resultCode", "1");
                }
            }
        } else {
            log.debug((Object)("Couldn't find user with username '" + username + "'."));
            element.setAttribute("resultCode", "0");
            element.setAttribute("resultText", "no username");
        }
        String resultCode = element.getAttribute("resultCode");
        if (StringUtils.isBlank((String)resultCode)) {
            element.setAttribute("resultCode", "0");
        }
        if (document == null) return;
        document.appendChild(element);
        try {
            DOMSource domSource = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            out.write(writer.toString());
            return;
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        catch (TransformerException e) {
            log.error((Object)e, (Throwable)e);
        }
        return;
        catch (ParserConfigurationException e) {
            log.error((Object)e, (Throwable)e);
            if (document == null) return;
            document.appendChild(element);
            try {
                DOMSource domSource = new DOMSource(document);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
                out.write(writer.toString());
                return;
            }
            catch (TransformerConfigurationException e2) {
                log.error((Object)e2, (Throwable)e2);
                return;
            }
            catch (TransformerException e3) {
                log.error((Object)e3, (Throwable)e3);
            }
            return;
        }
        catch (AuthenticationException e2) {
            log.debug((Object)e2);
            element.setAttribute("resultCode", "0");
            element.setAttribute("resultText", "server authentication error");
            if (document == null) return;
            {
                catch (Throwable throwable) {
                    if (document == null) throw throwable;
                    document.appendChild(element);
                    try {
                        DOMSource domSource = new DOMSource(document);
                        StringWriter writer = new StringWriter();
                        StreamResult result = new StreamResult(writer);
                        TransformerFactory tf = TransformerFactory.newInstance();
                        Transformer transformer = tf.newTransformer();
                        transformer.transform(domSource, result);
                        out.write(writer.toString());
                        throw throwable;
                    }
                    catch (TransformerConfigurationException e4) {
                        log.error((Object)e4, (Throwable)e4);
                        throw throwable;
                    }
                    catch (TransformerException e5) {
                        log.error((Object)e5, (Throwable)e5);
                    }
                    throw throwable;
                }
            }
            document.appendChild(element);
            try {
                DOMSource domSource = new DOMSource(document);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
                out.write(writer.toString());
                return;
            }
            catch (TransformerConfigurationException e6) {
                log.error((Object)e6, (Throwable)e6);
                return;
            }
            catch (TransformerException e7) {
                log.error((Object)e7, (Throwable)e7);
            }
            return;
        }
    }

    private void addUserToOrg(User user, Integer orgId) {
        UserOrganisation uo = userService.getUserOrganisation(user.getUserId(), orgId);
        if (uo == null) {
            ArrayList<String> rolesList = new ArrayList<String>();
            rolesList.add(Role.ROLE_LEARNER.toString());
            userService.setRolesForUserOrganisation(user, orgId, rolesList);
        }
    }

    private Boolean addUserToLesson(List lessons, int learnerSize, Integer orgId, User user) {
        for (int i = 0; i < lessons.size(); ++i) {
            Organisation org;
            Lesson l = (Lesson)lessons.get(i);
            int size = l.getLessonClass().getLearnersGroup().getUsers().size();
            if (size >= learnerSize || !(org = l.getOrganisation()).getOrganisationId().equals(orgId)) continue;
            l.getLessonClass().addLearner(user);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added " + user.getLogin() + " to lesson (id: " + l.getLessonId() + ", name: '" + l.getLessonName() + "')"));
            }
            return true;
        }
        return false;
    }

    private Boolean createNewLesson(List lessons, long ldId, Integer orgId, User user) {
        List<User> staffList;
        String staffGroupName;
        String learnerGroupName;
        Integer ownerUserId;
        Boolean liveEditEnabled;
        Boolean learnerImAvailable;
        Boolean learnerPresenceAvailable;
        Boolean learnerExportAvailable;
        String lessonDescription;
        String lessonName;
        Organisation org = (Organisation)userService.findById(Organisation.class, (Serializable)orgId);
        ArrayList<User> learnerList = new ArrayList<User>();
        learnerList.add(user);
        if (lessons.size() > 0) {
            Lesson l = (Lesson)lessons.get(lessons.size() - 1);
            lessonName = this.incrementLessonName(l.getLessonName());
            lessonDescription = l.getLessonDescription();
            learnerExportAvailable = l.getLearnerExportAvailable();
            learnerPresenceAvailable = l.getLearnerPresenceAvailable();
            learnerImAvailable = l.getLearnerImAvailable();
            liveEditEnabled = l.getLiveEditEnabled();
            ownerUserId = l.getUser().getUserId();
            learnerGroupName = l.getLessonClass().getLearnersGroup().getGroupName();
            staffGroupName = l.getLessonClass().getStaffGroup().getGroupName();
            staffList = this.getListFromSet(l.getLessonClass().getStaffGroup().getUsers());
        } else {
            LearningDesign ld = (LearningDesign)userService.findById(LearningDesign.class, (Serializable)Long.valueOf(ldId));
            lessonName = ld.getTitle();
            lessonDescription = ld.getDescription();
            learnerExportAvailable = true;
            learnerPresenceAvailable = false;
            learnerImAvailable = false;
            liveEditEnabled = false;
            ownerUserId = ld.getUser().getUserId();
            learnerGroupName = org.getName() + " Learners";
            staffGroupName = org.getName() + " Staff";
            Vector userDTOs = userService.getUsersFromOrganisationByRole(orgId, "MONITOR", false, false);
            staffList = this.getUsersFromDTOs(userDTOs);
        }
        Lesson lesson = monitoringService.initializeLesson(lessonName, lessonDescription, learnerExportAvailable, ldId, orgId, ownerUserId, null, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled);
        monitoringService.createLessonClassForLesson(lesson.getLessonId().longValue(), org, learnerGroupName, learnerList, staffGroupName, staffList, ownerUserId);
        monitoringService.startLesson(lesson.getLessonId().longValue(), ownerUserId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started new lesson (id: " + lesson.getLessonId() + ", name: '" + lesson.getLessonName() + "') with '" + user.getLogin() + "' as learner."));
        }
        return true;
    }

    private String incrementLessonName(String name) {
        String newName = name;
        if (!StringUtils.isBlank((String)name)) {
            int i = name.lastIndexOf(32);
            if (i >= 0) {
                String counterStr = name.substring(i).trim();
                try {
                    int counterInt = Integer.parseInt(counterStr);
                    newName = name.substring(0, i) + " " + ++counterInt;
                }
                catch (NumberFormatException e) {
                    newName = name + " 2";
                }
            } else {
                newName = name + " 2";
            }
        }
        log.debug((Object)("Created new lesson name '" + newName + "' from original '" + name + "'"));
        return newName;
    }

    private List<User> getListFromSet(Set users) {
        ArrayList<User> list = new ArrayList<User>();
        for (User user : users) {
            list.add(user);
        }
        return list;
    }

    private List<User> getUsersFromDTOs(Vector userDTOs) {
        ArrayList<User> list = new ArrayList<User>();
        for (Object o : userDTOs) {
            UserDTO dto = (UserDTO)o;
            User user = (User)userService.findById(User.class, (Serializable)dto.getUserID());
            list.add(user);
        }
        return list;
    }
}

