/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemExistsException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignException;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.Workspace;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserFlashDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.workspace.WorkspaceFolderContent;
import org.lamsfoundation.lams.workspace.dto.FolderContentDTO;
import org.lamsfoundation.lams.workspace.dto.UpdateContentDTO;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceManagementService
implements IWorkspaceManagementService {
    protected Logger log = Logger.getLogger((String)WorkspaceManagementService.class.getName());
    public static final Integer AUTHORING = new Integer(1);
    public static final Integer MONITORING = new Integer(2);
    protected IBaseDAO baseDAO;
    protected ILearningDesignDAO learningDesignDAO;
    protected IAuthoringService authoringService;
    protected IRepositoryService repositoryService;
    protected IUserManagementService userMgmtService;
    protected MessageService messageService;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setAuthoringService(IAuthoringService authoringService) {
        this.authoringService = authoringService;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public void setUserMgmtService(IUserManagementService userMgmtService) {
        this.userMgmtService = userMgmtService;
    }

    @Override
    public String deleteResource(Long resourceID, String resourceType, Integer userID) throws IOException {
        String errorMessage = null;
        if (resourceID == null || resourceType == null || userID == null) {
            errorMessage = this.messageService.getMessage("delete.resource.error.value.miss");
        } else {
            if ("LearningDesign".equals(resourceType)) {
                return this.deleteLearningDesign(resourceID, userID);
            }
            if ("Folder".equals(resourceType)) {
                return this.deleteFolder(new Integer(resourceID.intValue()), userID);
            }
            if ("File".equals(resourceType)) {
                return this.deleteWorkspaceFolderContent(resourceID);
            }
            if ("Lesson".equals(resourceType)) {
                errorMessage = this.messageService.getMessage("delete.lesson.error");
            }
        }
        FlashMessage message = new FlashMessage("deleteResource", (Object)this.messageService.getMessage("delete.resource.error", new Object[]{errorMessage}), 1);
        return message.serializeMessage();
    }

    public String deleteFolder(Integer folderID, Integer userID) throws IOException {
        WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)folderID);
        User user = (User)this.userMgmtService.findById(User.class, (Serializable)userID);
        FlashMessage flashMessage = null;
        flashMessage = user != null ? this.deleteFolder(workspaceFolder, user, this.isSysAuthorAdmin(user)) : FlashMessage.getNoSuchUserExists((String)"deleteResource", (Integer)userID);
        return flashMessage.serializeMessage();
    }

    private FlashMessage deleteFolder(WorkspaceFolder workspaceFolder, User user, boolean isSysAuthorAdmin) throws IOException {
        if (!this.getPermissions(workspaceFolder, user).equals(WorkspaceFolder.OWNER_ACCESS)) {
            return FlashMessage.getUserNotAuthorized((String)"deleteResource", (Integer)user.getUserId());
        }
        if (workspaceFolder != null) {
            return this.deleteFolderContents(workspaceFolder, user, isSysAuthorAdmin);
        }
        return FlashMessage.getNoSuchWorkspaceFolderExsists((String)"deleteResource", (Integer)workspaceFolder.getWorkspaceFolderId());
    }

    private FlashMessage deleteFolderContents(WorkspaceFolder folder, User user, boolean isSysAuthorAdmin) throws IOException {
        FlashMessage flashMessage = null;
        boolean isDeleteSuccessful = true;
        Integer folderID = folder.getWorkspaceFolderId();
        if (!folder.isEmpty()) {
            if (folder.hasSubFolders()) {
                Set subFolders = folder.getChildWorkspaceFolders();
                for (WorkspaceFolder subFolder : subFolders) {
                    flashMessage = this.deleteFolder(subFolder, user, isSysAuthorAdmin);
                    if (flashMessage.getMessageType() == 3) continue;
                    return flashMessage;
                }
            } else {
                Set folderContents = folder.getFolderContent();
                for (WorkspaceFolderContent folderContent : folderContents) {
                    folderContent.setWorkspaceFolder(null);
                    folder.getFolderContent().remove(folderContent);
                }
                Set learningDesigns = folder.getLearningDesigns();
                for (LearningDesign learningDesign : learningDesigns) {
                    if (learningDesign == null || !isSysAuthorAdmin && !learningDesign.getUser().getUserId().equals(user.getUserId())) continue;
                    if (learningDesign.getReadOnly().booleanValue()) {
                        isDeleteSuccessful = false;
                        flashMessage = new FlashMessage("deleteResource", (Object)this.messageService.getMessage("delete.learningdesign.error", new Object[]{learningDesign.getLearningDesignId()}), 1);
                        continue;
                    }
                    folder.getLearningDesigns().remove(learningDesign);
                    learningDesign.setWorkspaceFolder(null);
                }
                this.baseDAO.update((Object)folder);
            }
        }
        if (isDeleteSuccessful) {
            this.baseDAO.delete((Object)folder);
            flashMessage = new FlashMessage("deleteResource", (Object)this.messageService.getMessage("folder.delete", new Object[]{folderID}));
        }
        return flashMessage;
    }

    @Override
    public WorkspaceFolder getWorkspaceFolder(Integer workspaceFolderID) {
        return (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
    }

    @Override
    public Vector<FolderContentDTO> getFolderContentsExcludeHome(Integer userID, WorkspaceFolder folder, Integer mode) throws UserAccessDeniedException, RepositoryCheckedException {
        User user;
        return this.getFolderContentsInternal(user, folder, mode, "getFolderContentsExcludeHome", (user = (User)this.baseDAO.find(User.class, (Serializable)userID)).getWorkspace() != null ? user.getWorkspace().getDefaultFolder() : null);
    }

    @Override
    public Vector<FolderContentDTO> getFolderContents(Integer userID, WorkspaceFolder folder, Integer mode) throws UserAccessDeniedException, RepositoryCheckedException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        return this.getFolderContentsInternal(user, folder, mode, "getFolderContents", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector<FolderContentDTO> getFolderContentsInternal(User user, WorkspaceFolder workspaceFolder, Integer mode, String methodName, WorkspaceFolder skipFolder) throws UserAccessDeniedException, RepositoryCheckedException {
        Vector<FolderContentDTO> repositoryContent;
        Vector<FolderContentDTO> contentDTO = new Vector<FolderContentDTO>();
        if (user == null) throw new UserAccessDeniedException(user);
        Integer permissions = this.getPermissions(workspaceFolder, user);
        if (permissions == WorkspaceFolder.NO_ACCESS) throw new UserAccessDeniedException(user);
        this.getFolderContent(workspaceFolder, permissions, mode, contentDTO, user);
        if (workspaceFolder.hasSubFolders()) {
            this.getSubFolderDetails(workspaceFolder, user, contentDTO, skipFolder);
        }
        if ((repositoryContent = this.getContentsFromRepository(workspaceFolder, permissions, user)) == null) return contentDTO;
        contentDTO.addAll(repositoryContent);
        return contentDTO;
    }

    private void getFolderContent(WorkspaceFolder workspaceFolder, Integer folderPermissions, Integer mode, Vector<FolderContentDTO> contentDTO, User user) {
        List designs = null;
        designs = AUTHORING.equals(mode) ? this.learningDesignDAO.getAllLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId()) : this.learningDesignDAO.getAllValidLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId());
        this.getFolderContentDTO(designs, folderPermissions, contentDTO, user);
    }

    private void getSubFolderDetails(WorkspaceFolder workspaceFolder, User user, Vector<FolderContentDTO> subFolderContent, WorkspaceFolder skipFolder) {
        Integer skipFolderID = skipFolder != null ? skipFolder.getWorkspaceFolderId() : null;
        for (WorkspaceFolder subFolder : workspaceFolder.getChildWorkspaceFolders()) {
            Integer permissions;
            if (skipFolderID != null && skipFolderID.equals(subFolder.getWorkspaceFolderId()) || (permissions = this.getPermissions(subFolder, user)) == WorkspaceFolder.NO_ACCESS) continue;
            subFolderContent.add(new FolderContentDTO(subFolder, permissions, user));
        }
    }

    public Integer getPermissions(WorkspaceFolder workspaceFolder, User user) {
        Integer permission = null;
        if (workspaceFolder == null || user == null) {
            this.log.debug((Object)"no access due to null value(s) in user or workspaceFolder");
            permission = WorkspaceFolder.NO_ACCESS;
        } else {
            permission = WorkspaceFolder.RUN_SEQUENCES.equals(workspaceFolder.getWorkspaceFolderType()) ? WorkspaceFolder.READ_ACCESS : (WorkspaceFolder.PUBLIC_SEQUENCES.equals(workspaceFolder.getWorkspaceFolderType()) ? WorkspaceFolder.MEMBERSHIP_ACCESS : (workspaceFolder.getUserID().equals(user.getUserId()) ? WorkspaceFolder.OWNER_ACCESS : (this.isSysAuthorAdmin(user) ? WorkspaceFolder.OWNER_ACCESS : (user.hasMemberAccess(workspaceFolder) ? WorkspaceFolder.MEMBERSHIP_ACCESS : WorkspaceFolder.NO_ACCESS))));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(user.getLogin() + " has " + permission + " access to " + workspaceFolder.getName()));
            }
        }
        return permission;
    }

    private boolean isSysAuthorAdmin(User user) {
        return this.userMgmtService.hasRoleInOrganisation(user, Role.ROLE_AUTHOR_ADMIN) || this.userMgmtService.hasRoleInOrganisation(user, Role.ROLE_SYSADMIN);
    }

    private Vector getFolderContentDTO(List designs, Integer folderPermissions, Vector<FolderContentDTO> folderContent, User user) {
        for (LearningDesign design : designs) {
            FolderContentDTO folder = design.getUser() != null && design.getUser().equals((Object)user) ? new FolderContentDTO(design, WorkspaceFolder.OWNER_ACCESS, user) : new FolderContentDTO(design, folderPermissions, user);
            folderContent.add(folder);
        }
        return folderContent;
    }

    @Override
    public String copyResource(Long resourceID, String resourceType, Integer copyType, Integer targetFolderID, Integer userID) throws IOException {
        String errorMessage = null;
        if (resourceID == null || targetFolderID == null || resourceType == null || userID == null) {
            errorMessage = this.messageService.getMessage("copy.resource.error.value.miss");
        } else {
            if ("LearningDesign".equals(resourceType)) {
                return this.copyLearningDesign(resourceID, targetFolderID, copyType, userID);
            }
            if ("Folder".equals(resourceType)) {
                return this.copyFolder(new Integer(resourceID.intValue()), targetFolderID, userID);
            }
            if ("File".equals(resourceType)) {
                errorMessage = this.messageService.getMessage("copy.no.support");
            } else if ("Lesson".equals(resourceType)) {
                errorMessage = this.messageService.getMessage("copy.no.support");
            }
        }
        FlashMessage message = new FlashMessage("copyResource", (Object)this.messageService.getMessage("copy.resource.error", new Object[]{errorMessage}), 1);
        return message.serializeMessage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String copyFolder(Integer folderID, Integer targetFolderID, Integer userID) throws IOException {
        FlashMessage flashMessage = null;
        try {
            if (this.isUserAuthorizedToModifyFolderContents(targetFolderID, userID)) {
                WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)folderID);
                if (workspaceFolder == null) throw new WorkspaceFolderException();
                WorkspaceFolder newFolder = this.createFolder(targetFolderID, workspaceFolder.getName(), userID);
                this.copyRootContent(workspaceFolder, newFolder, userID);
                if (workspaceFolder.hasSubFolders()) {
                    this.createSubFolders(workspaceFolder, newFolder, userID);
                }
                flashMessage = new FlashMessage("copyResource", (Object)newFolder.getWorkspaceFolderId());
                return flashMessage.serializeMessage();
            } else {
                flashMessage = FlashMessage.getUserNotAuthorized((String)"copyResource", (Integer)userID);
            }
            return flashMessage.serializeMessage();
        }
        catch (UserException ue) {
            flashMessage = FlashMessage.getNoSuchUserExists((String)"copyResource", (Integer)userID);
            return flashMessage.serializeMessage();
        }
        catch (WorkspaceFolderException we) {
            flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"copyResource", (Integer)folderID);
        }
        return flashMessage.serializeMessage();
    }

    public String copyLearningDesign(Long designID, Integer targetFolderID, Integer copyType, Integer userID) throws IOException {
        FlashMessage message = null;
        try {
            LearningDesign ld = this.authoringService.copyLearningDesign(designID, copyType != null ? copyType : new Integer(1), userID, targetFolderID, false);
            message = new FlashMessage("copyResource", (Object)ld.getLearningDesignId());
        }
        catch (Exception e) {
            this.log.error((Object)("copyLearningDesign() unable to copy learning design due to an error. designID=" + designID + "copyType=" + copyType + "targetFolderID=" + targetFolderID + "userID=" + userID), (Throwable)e);
            message = new FlashMessage("copyResource", (Object)this.messageService.getMessage("unable.copy", new Object[]{e.getMessage()}), 1);
        }
        return message.serializeMessage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isUserAuthorizedToModifyFolderContents(Integer folderID, Integer userID) throws UserException, WorkspaceFolderException {
        boolean authorized = false;
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) throw new UserException();
        WorkspaceFolder targetParent = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)folderID);
        if (targetParent == null) throw new WorkspaceFolderException();
        Integer permissions = this.getPermissions(targetParent, user);
        if (permissions.equals(WorkspaceFolder.NO_ACCESS)) return authorized;
        if (permissions.equals(WorkspaceFolder.READ_ACCESS)) return authorized;
        return true;
    }

    public void copyRootContent(WorkspaceFolder workspaceFolder, WorkspaceFolder targetWorkspaceFolder, Integer userID) throws UserException, LearningDesignException, UserAccessDeniedException, WorkspaceFolderException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user == null) {
            throw new UserException(this.messageService.getMessage("no.such.user", new Object[]{userID}));
        }
        List designs = this.learningDesignDAO.getAllLearningDesignsInFolder(workspaceFolder.getWorkspaceFolderId());
        if (designs != null && designs.size() != 0) {
            for (LearningDesign design : designs) {
                this.authoringService.copyLearningDesign(design, new Integer(1), user, targetWorkspaceFolder, false, null, null);
            }
        }
    }

    @Override
    public WorkspaceFolder createFolder(Integer parentFolderID, String name, Integer userID) throws UserException, WorkspaceFolderException {
        WorkspaceFolder parentFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)parentFolderID);
        User user = null;
        Workspace workspace = null;
        if (parentFolder != null) {
            boolean nameExists = true;
            while (nameExists && (nameExists = this.ifNameExists(parentFolder, name))) {
                name = name + "C";
            }
            user = (User)this.baseDAO.find(User.class, (Serializable)userID);
            if (user != null) {
                workspace = user.getWorkspace();
                WorkspaceFolder workspaceFolder = new WorkspaceFolder(name, workspace.getWorkspaceId(), parentFolder, userID, new Date(), new Date(), WorkspaceFolder.NORMAL);
                this.baseDAO.insert((Object)workspaceFolder);
                return workspaceFolder;
            }
            throw new UserException(this.messageService.getMessage("no.such.user", new Object[]{userID}));
        }
        throw new WorkspaceFolderException(this.messageService.getMessage("no.such.workspace", new Object[]{parentFolderID}));
    }

    @Override
    public String createFolderForFlash(Integer parentFolderID, String name, Integer userID) throws IOException {
        FlashMessage flashMessage = null;
        try {
            WorkspaceFolder newFolder = this.createFolder(parentFolderID, name, userID);
            Hashtable<String, Object> table = new Hashtable<String, Object>();
            table.put("folderID", newFolder.getWorkspaceFolderId());
            table.put("name", newFolder.getName());
            flashMessage = new FlashMessage("createFolderForFlash", table);
        }
        catch (WorkspaceFolderException we) {
            flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"createFolderForFlash", (Integer)parentFolderID);
        }
        catch (UserException ue) {
            flashMessage = FlashMessage.getNoSuchUserExists((String)"createFolderForFlash", (Integer)userID);
        }
        return flashMessage.serializeMessage();
    }

    private boolean ifNameExists(WorkspaceFolder targetFolder, String folderName) {
        List folders = this.baseDAO.findByProperty(WorkspaceFolder.class, "parentWorkspaceFolder.workspaceFolderId", (Object)targetFolder.getWorkspaceFolderId());
        if (folders != null && folders.size() != 0) {
            for (WorkspaceFolder folder : folders) {
                if (!folder.getName().equalsIgnoreCase(folderName)) continue;
                return true;
            }
        }
        return false;
    }

    public void createSubFolders(WorkspaceFolder workspaceFolder, WorkspaceFolder newFolder, Integer userID) throws UserException, WorkspaceFolderException {
        for (WorkspaceFolder subFolder : workspaceFolder.getChildWorkspaceFolders()) {
            WorkspaceFolder newSubFolder = this.createFolder(newFolder.getWorkspaceFolderId(), subFolder.getName(), userID);
            this.copyRootContent(subFolder, newSubFolder, userID);
            if (!subFolder.hasSubFolders()) continue;
            this.createSubFolders(subFolder, newSubFolder, userID);
        }
    }

    public String deleteLearningDesign(Long learningDesignID, Integer userID) throws IOException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        FlashMessage flashMessage = null;
        if (user != null) {
            LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignID);
            if (learningDesign != null) {
                if (learningDesign.getUser().getUserId().equals(user.getUserId()) || this.isSysAuthorAdmin(user)) {
                    if (learningDesign.getReadOnly().booleanValue()) {
                        flashMessage = new FlashMessage("deleteResource", (Object)this.messageService.getMessage("learningdesign.readonly", new Object[]{learningDesignID}), 1);
                    } else {
                        this.learningDesignDAO.delete((Object)learningDesign);
                        flashMessage = new FlashMessage("deleteResource", (Object)this.messageService.getMessage("learningdesign.delete", new Object[]{learningDesignID}));
                    }
                } else {
                    flashMessage = FlashMessage.getUserNotAuthorized((String)"deleteResource", (Integer)user.getUserId());
                }
            } else {
                flashMessage = FlashMessage.getNoSuchLearningDesignExists((String)"deleteResource", (Long)learningDesignID);
            }
        } else {
            flashMessage = FlashMessage.getNoSuchUserExists((String)"deleteResource", (Integer)user.getUserId());
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String moveResource(Long resourceID, Integer targetFolderID, String resourceType, Integer userID) throws IOException {
        String errorMessage = null;
        if (resourceID == null || targetFolderID == null || resourceType == null || userID == null) {
            errorMessage = this.messageService.getMessage("move.resrouce.error.value.miss");
        } else {
            if ("LearningDesign".equals(resourceType)) {
                return this.moveLearningDesign(resourceID, targetFolderID, userID);
            }
            if ("Folder".equals(resourceType)) {
                return this.moveFolder(new Integer(resourceID.intValue()), targetFolderID, userID);
            }
            if ("File".equals(resourceType)) {
                errorMessage = this.messageService.getMessage("unsupport.move");
            } else if ("Lesson".equals(resourceType)) {
                errorMessage = this.messageService.getMessage("unsupport.move");
            }
        }
        FlashMessage message = new FlashMessage("moveResource", (Object)this.messageService.getMessage("move.resource.error", new Object[]{errorMessage}), 1);
        return message.serializeMessage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String moveFolder(Integer currentFolderID, Integer targetFolderID, Integer userID) throws IOException {
        FlashMessage flashMessage = null;
        try {
            if (this.isUserAuthorizedToModifyFolderContents(targetFolderID, userID)) {
                WorkspaceFolder currentFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)currentFolderID);
                if (currentFolder == null) throw new WorkspaceFolderException();
                if (currentFolderID != targetFolderID) {
                    WorkspaceFolder targetFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)targetFolderID);
                    currentFolder.setParentWorkspaceFolder(targetFolder);
                    this.baseDAO.update((Object)currentFolder);
                }
                flashMessage = new FlashMessage("moveResource", (Object)targetFolderID);
                return flashMessage.serializeMessage();
            } else {
                flashMessage = FlashMessage.getUserNotAuthorized((String)"moveResource", (Integer)userID);
            }
            return flashMessage.serializeMessage();
        }
        catch (UserException ue) {
            flashMessage = FlashMessage.getNoSuchUserExists((String)"moveResource", (Integer)userID);
            return flashMessage.serializeMessage();
        }
        catch (WorkspaceFolderException we) {
            flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"moveResource", (Integer)targetFolderID);
        }
        return flashMessage.serializeMessage();
    }

    private void configureContentRepository(ICredentials cred) throws RepositoryCheckedException {
        try {
            this.repositoryService.createCredentials(cred);
            this.repositoryService.addWorkspace(cred, "FlashClientsWorkspace");
        }
        catch (ItemExistsException ie) {
            this.log.warn((Object)"Tried to configure repository but it  appears to be already configured.Workspace name FlashClientsWorkspace. Exception thrown by repository being ignored. ", (Throwable)ie);
        }
        catch (RepositoryCheckedException e) {
            this.log.error((Object)("Error occured while trying to configure repository.Workspace name FlashClientsWorkspace Unable to recover from error: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private ITicket getRepositoryLoginTicket() {
        SimpleCredentials credentials = new SimpleCredentials("workspaceManager", "flashClient".toCharArray());
        ITicket ticket = null;
        try {
            try {
                ticket = this.repositoryService.login((ICredentials)credentials, "FlashClientsWorkspace");
            }
            catch (WorkspaceNotFoundException we) {
                this.log.error((Object)"Content Repository workspace FlashClientsWorkspace not configured. Attempting to configure now.");
                this.configureContentRepository((ICredentials)credentials);
                ticket = this.repositoryService.login((ICredentials)credentials, "FlashClientsWorkspace");
            }
        }
        catch (RepositoryCheckedException e) {
            this.log.error((Object)"Unable to get ticket for workspace FlashClientsWorkspace", (Throwable)e);
            return null;
        }
        return ticket;
    }

    @Override
    public String createWorkspaceFolderContent(Integer contentTypeID, String name, String description, Integer workspaceFolderID, String mimeType, String path) throws Exception {
        FlashMessage flashMessage = null;
        WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
        if (workspaceFolder != null) {
            if (!this.contentAlreadyExists(workspaceFolder, name, mimeType)) {
                WorkspaceFolderContent workspaceFolderContent = new WorkspaceFolderContent(contentTypeID, name, description, new Date(), new Date(), mimeType, workspaceFolder);
                this.baseDAO.insert((Object)workspaceFolderContent);
                try {
                    FileInputStream stream = new FileInputStream(path);
                    NodeKey nodeKey = this.addFileToRepository(stream, name, mimeType);
                    workspaceFolderContent.setUuid(nodeKey.getUuid());
                    workspaceFolderContent.setVersionID(nodeKey.getVersion());
                    this.baseDAO.update((Object)workspaceFolderContent);
                    UpdateContentDTO contentDTO = new UpdateContentDTO(nodeKey.getUuid(), nodeKey.getVersion(), workspaceFolderContent.getFolderContentID());
                    flashMessage = new FlashMessage("createWorkspaceFolderContent", (Object)contentDTO);
                }
                catch (AccessDeniedException ae) {
                    flashMessage = new FlashMessage("createWorkspaceFolderContent", (Object)this.messageService.getMessage("creating.workspace.folder.error", new Object[]{ae.getMessage()}), 2);
                }
                catch (FileException fe) {
                    flashMessage = new FlashMessage("createWorkspaceFolderContent", (Object)this.messageService.getMessage("creating.workspace.folder.error", new Object[]{fe.getMessage()}), 2);
                }
                catch (InvalidParameterException ip) {
                    flashMessage = new FlashMessage("createWorkspaceFolderContent", (Object)this.messageService.getMessage("creating.workspace.folder.error", new Object[]{ip.getMessage()}), 2);
                }
            } else {
                flashMessage = new FlashMessage("createWorkspaceFolderContent", (Object)this.messageService.getMessage("resource.already.exist", new Object[]{name, workspaceFolderID}), 1);
            }
        } else {
            flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"createWorkspaceFolderContent", (Integer)workspaceFolderID);
        }
        return flashMessage.serializeMessage();
    }

    private boolean contentAlreadyExists(WorkspaceFolder workspaceFolder, String name, String mimeType) {
        Set contentsInFolder = workspaceFolder.getFolderContent();
        for (WorkspaceFolderContent existingFolderContent : contentsInFolder) {
            if (!existingFolderContent.getMimeType().equalsIgnoreCase(mimeType) || !existingFolderContent.getName().equalsIgnoreCase(name)) continue;
            this.log.error((Object)"Content already exists in the db");
            return true;
        }
        return false;
    }

    @Override
    public String updateWorkspaceFolderContent(Long folderContentID, String path) throws Exception {
        FlashMessage flashMessage = null;
        FileInputStream stream = new FileInputStream(path);
        WorkspaceFolderContent workspaceFolderContent = (WorkspaceFolderContent)this.baseDAO.find(WorkspaceFolderContent.class, (Serializable)folderContentID);
        if (workspaceFolderContent != null) {
            NodeKey nodeKey = this.updateFileInRepository(workspaceFolderContent, stream);
            UpdateContentDTO contentDTO = new UpdateContentDTO(nodeKey.getUuid(), nodeKey.getVersion(), folderContentID);
            flashMessage = new FlashMessage("updateWorkspaceFolderContent", (Object)contentDTO);
        } else {
            flashMessage = FlashMessage.getNoSuchWorkspaceFolderContentExsists((String)"updateWorkspaceFolderContent", (Long)folderContentID);
        }
        return flashMessage.serializeMessage();
    }

    private NodeKey addFileToRepository(InputStream stream, String fileName, String mimeType) throws AccessDeniedException, FileException, InvalidParameterException {
        ITicket ticket = this.getRepositoryLoginTicket();
        NodeKey nodeKey = this.repositoryService.addFileItem(ticket, stream, fileName, mimeType, null);
        return nodeKey;
    }

    private NodeKey updateFileInRepository(WorkspaceFolderContent workspaceFolderContent, InputStream stream) throws Exception {
        ITicket ticket = this.getRepositoryLoginTicket();
        NodeKey nodeKey = this.repositoryService.updateFileItem(ticket, workspaceFolderContent.getUuid(), workspaceFolderContent.getName(), stream, workspaceFolderContent.getMimeType(), null);
        workspaceFolderContent.setUuid(nodeKey.getUuid());
        workspaceFolderContent.setVersionID(nodeKey.getVersion());
        this.baseDAO.update((Object)workspaceFolderContent);
        return nodeKey;
    }

    @Override
    public String deleteContentWithVersion(Long uuid, Long versionToBeDeleted, Long folderContentID) throws Exception {
        FlashMessage flashMessage = null;
        WorkspaceFolderContent workspaceFolderContent = (WorkspaceFolderContent)this.baseDAO.find(WorkspaceFolderContent.class, (Serializable)folderContentID);
        if (workspaceFolderContent != null) {
            Long databaseVersion = workspaceFolderContent.getVersionID();
            ITicket ticket = this.getRepositoryLoginTicket();
            String[] files = null;
            try {
                files = this.repositoryService.deleteVersion(ticket, uuid, versionToBeDeleted);
                if (files != null && files.length > 0) {
                    String error = "Trying to delete content uuid=" + uuid + " unable to delete files ";
                    for (String filename : files) {
                        error = error + " " + filename;
                    }
                    this.log.warn((Object)error);
                }
            }
            catch (ItemNotFoundException ie) {
                flashMessage = new FlashMessage("deleteContentWithVersion", (Object)this.messageService.getMessage("no.such.content", new Object[]{versionToBeDeleted, folderContentID}), 1);
                return flashMessage.serializeMessage();
            }
            try {
                IVersionedNode latestAvailableNode = this.repositoryService.getFileItem(ticket, uuid, null);
                Long latestAvailableVersion = latestAvailableNode.getVersion();
                if (databaseVersion.equals(versionToBeDeleted)) {
                    workspaceFolderContent.setVersionID(latestAvailableVersion);
                    this.baseDAO.update((Object)workspaceFolderContent);
                }
                flashMessage = new FlashMessage("deleteContentWithVersion", (Object)this.messageService.getMessage("content.delete.success"));
            }
            catch (ItemNotFoundException ie) {
                this.baseDAO.delete((Object)workspaceFolderContent);
                flashMessage = new FlashMessage("deleteContentWithVersion", (Object)this.messageService.getMessage("content.delete.success"));
            }
        } else {
            flashMessage = new FlashMessage("deleteContentWithVersion", (Object)this.messageService.getMessage("content.delete.success"));
        }
        return flashMessage.serializeMessage();
    }

    public String deleteWorkspaceFolderContent(Long folderContentID) throws IOException {
        FlashMessage flashMessage = null;
        WorkspaceFolderContent workspaceFolderContent = (WorkspaceFolderContent)this.baseDAO.find(WorkspaceFolderContent.class, (Serializable)folderContentID);
        if (workspaceFolderContent != null) {
            this.baseDAO.delete((Object)workspaceFolderContent);
            flashMessage = new FlashMessage("deleteResource", (Object)"Content deleted");
        } else {
            flashMessage = FlashMessage.getNoSuchWorkspaceFolderContentExsists((String)"deleteResource", (Long)folderContentID);
        }
        return flashMessage.serializeMessage();
    }

    private Vector<FolderContentDTO> getContentsFromRepository(WorkspaceFolder workspaceFolder, Integer permissions, User user) throws RepositoryCheckedException {
        Set content;
        this.log.debug((Object)("Trying to get contents from folder " + workspaceFolder.getName()));
        Set children = workspaceFolder.getChildWorkspaceFolders();
        if (children != null) {
            this.log.debug((Object)(children.size() + "  child workspace folders"));
        }
        if ((content = workspaceFolder.getFolderContent()) == null || content.size() == 0) {
            return null;
        }
        ITicket ticket = this.getRepositoryLoginTicket();
        Vector<FolderContentDTO> repositoryContent = new Vector<FolderContentDTO>();
        for (WorkspaceFolderContent workspaceFolderContent : content) {
            SortedSet set = this.repositoryService.getVersionHistory(ticket, workspaceFolderContent.getUuid());
            repositoryContent.add(new FolderContentDTO(permissions, workspaceFolderContent, set, user));
        }
        return repositoryContent;
    }

    @Override
    public Vector getAccessibleOrganisationWorkspaceFolders(Integer userID) throws IOException {
        this.log.debug((Object)("User - " + userID));
        User user = (User)this.userMgmtService.findById(User.class, (Serializable)userID);
        return this.getAccessibleOrganisationWorkspaceFolders(user);
    }

    @Override
    public Vector getAccessibleOrganisationWorkspaceFolders(User user) throws IOException {
        Vector<FolderContentDTO> folders = new Vector<FolderContentDTO>();
        if (user != null) {
            Set userMemberships = user.getUserOrganisations();
            if (userMemberships != null) {
                for (UserOrganisation member : userMemberships) {
                    Integer permission;
                    Set roles;
                    WorkspaceFolder orgFolder;
                    Workspace workspace;
                    Integer orgStateId;
                    Organisation org = member.getOrganisation();
                    if (org == null || OrganisationState.HIDDEN.equals(orgStateId = org.getOrganisationState().getOrganisationStateId()) || OrganisationState.REMOVED.equals(orgStateId) || (workspace = org.getWorkspace()) == null || (orgFolder = workspace.getDefaultFolder()) == null || !this.hasWriteAccess(roles = member.getUserOrganisationRoles()) || (permission = this.getPermissions(orgFolder, user)).equals(WorkspaceFolder.NO_ACCESS)) continue;
                    folders.add(new FolderContentDTO(orgFolder, permission, user));
                }
            } else {
                this.log.warn((Object)("getAccessibleOrganisationWorkspaceFolders: Trying to get user memberships for user " + user.getUserId() + ". User doesn't belong to any organisations. Returning no folders."));
            }
        } else {
            this.log.warn((Object)("getAccessibleOrganisationWorkspaceFolders: User " + user.getUserId() + " does not exist. Returning no folders."));
        }
        return folders;
    }

    @Override
    public FolderContentDTO getUserWorkspaceFolder(Integer userID) throws IOException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user != null) {
            Workspace workspace = user.getWorkspace();
            if (workspace != null) {
                WorkspaceFolder privateFolder = workspace.getDefaultFolder();
                if (privateFolder != null) {
                    Integer permissions = this.getPermissions(privateFolder, user);
                    return new FolderContentDTO(privateFolder, permissions, user);
                }
                this.log.warn((Object)("getUserWorkspaceFolder: User " + userID + " does not have a root folder. Returning no folders."));
            } else {
                this.log.warn((Object)("getUserWorkspaceFolder: User " + userID + " does not have a workspace. Returning no folders."));
            }
        } else {
            this.log.warn((Object)("getUserWorkspaceFolder: User " + userID + " does not exist. Returning no folders."));
        }
        return null;
    }

    @Override
    public FolderContentDTO getPublicWorkspaceFolder(Integer userID) throws IOException {
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user != null) {
            WorkspaceFolder publicFolder = null;
            List list = this.baseDAO.findByProperty(WorkspaceFolder.class, "workspaceFolderType", (Object)WorkspaceFolder.PUBLIC_SEQUENCES);
            if (list != null && list.size() > 0) {
                publicFolder = (WorkspaceFolder)list.get(0);
            }
            if (publicFolder != null) {
                publicFolder.setName(this.messageService.getMessage("public.folder"));
                Integer permissions = this.getPermissions(publicFolder, user);
                return new FolderContentDTO(publicFolder, permissions, user);
            }
        }
        return null;
    }

    private boolean hasWriteAccess(Set roles) {
        for (UserOrganisationRole userOrganisationRole : roles) {
            Role role = userOrganisationRole.getRole();
            if (!role.isAuthor() && !role.isSysAdmin() && !role.isGroupManager() && !role.isAuthorAdmin()) continue;
            return true;
        }
        return false;
    }

    public String moveLearningDesign(Long learningDesignID, Integer targetWorkspaceFolderID, Integer userID) throws IOException {
        FlashMessage flashMessage = null;
        try {
            if (this.isUserAuthorizedToModifyFolderContents(targetWorkspaceFolderID, userID)) {
                LearningDesign learningDesign = this.learningDesignDAO.getLearningDesignById(learningDesignID);
                if (learningDesign != null) {
                    WorkspaceFolder workspaceFolder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)targetWorkspaceFolderID);
                    if (workspaceFolder != null) {
                        learningDesign.setWorkspaceFolder(workspaceFolder);
                        this.learningDesignDAO.update((Object)learningDesign);
                        flashMessage = new FlashMessage("moveResource", (Object)targetWorkspaceFolderID);
                    } else {
                        flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"moveResource", (Integer)targetWorkspaceFolderID);
                    }
                } else {
                    flashMessage = FlashMessage.getNoSuchLearningDesignExists((String)"moveResource", (Long)learningDesignID);
                }
            } else {
                flashMessage = FlashMessage.getUserNotAuthorized((String)"moveResource", (Integer)userID);
            }
        }
        catch (UserException ue) {
            flashMessage = FlashMessage.getNoSuchUserExists((String)"moveResource", (Integer)userID);
        }
        catch (WorkspaceFolderException we) {
            flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"moveResource", (Integer)targetWorkspaceFolderID);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String renameResource(Long resourceID, String resourceType, String newName, Integer userID) throws IOException {
        String errorMessage = null;
        if (resourceID == null || newName == null || resourceType == null || userID == null) {
            errorMessage = this.messageService.getMessage("rename.resource.error.miss.vaue");
        } else {
            if ("LearningDesign".equals(resourceType)) {
                return this.renameLearningDesign(resourceID, newName, userID);
            }
            if ("Folder".equals(resourceType)) {
                return this.renameWorkspaceFolder(new Integer(resourceID.intValue()), newName, userID);
            }
            if ("File".equals(resourceType)) {
                errorMessage = this.messageService.getMessage("rename.resource.unspport");
            } else if ("Lesson".equals(resourceType)) {
                errorMessage = this.messageService.getMessage("rename.resource.unspport");
            }
        }
        FlashMessage message = new FlashMessage("renameResource", (Object)this.messageService.getMessage("rename.resource.error", new Object[]{errorMessage}), 1);
        return message.serializeMessage();
    }

    public String renameWorkspaceFolder(Integer workspaceFolderID, String newName, Integer userID) throws IOException {
        FlashMessage flashMessage = null;
        try {
            WorkspaceFolder folder = (WorkspaceFolder)this.baseDAO.find(WorkspaceFolder.class, (Serializable)workspaceFolderID);
            if (folder != null) {
                WorkspaceFolder parent = folder.getParentWorkspaceFolder();
                if (parent != null && this.isUserAuthorizedToModifyFolderContents(workspaceFolderID, userID)) {
                    if (!this.ifNameExists(parent, newName)) {
                        folder.setName(newName);
                        this.baseDAO.update((Object)folder);
                        flashMessage = new FlashMessage("renameResource", (Object)newName);
                    } else {
                        flashMessage = new FlashMessage("renameResource", (Object)this.messageService.getMessage("folder.already.exist", new Object[]{newName}), 1);
                    }
                } else {
                    flashMessage = FlashMessage.getUserNotAuthorized((String)"renameResource", (Integer)userID);
                }
            } else {
                flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"renameResource", (Integer)workspaceFolderID);
            }
        }
        catch (UserException ue) {
            flashMessage = FlashMessage.getNoSuchUserExists((String)"renameResource", (Integer)userID);
        }
        catch (WorkspaceFolderException we) {
            flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"renameResource", (Integer)workspaceFolderID);
        }
        return flashMessage.serializeMessage();
    }

    public String renameLearningDesign(Long learningDesignID, String title, Integer userID) throws IOException {
        FlashMessage flashMessage = null;
        LearningDesign design = this.learningDesignDAO.getLearningDesignById(learningDesignID);
        Integer folderID = null;
        try {
            if (design != null) {
                folderID = design.getWorkspaceFolder().getWorkspaceFolderId();
                if (this.isUserAuthorizedToModifyFolderContents(folderID, userID)) {
                    design.setTitle(title);
                    this.learningDesignDAO.update((Object)design);
                    flashMessage = new FlashMessage("renameResource", (Object)title);
                } else {
                    flashMessage = FlashMessage.getUserNotAuthorized((String)"renameResource", (Integer)userID);
                }
            } else {
                flashMessage = FlashMessage.getNoSuchLearningDesignExists((String)"renameResource", (Long)learningDesignID);
            }
        }
        catch (UserException ue) {
            flashMessage = FlashMessage.getNoSuchUserExists((String)"renameResource", (Integer)userID);
        }
        catch (WorkspaceFolderException we) {
            flashMessage = FlashMessage.getNoSuchWorkspaceFolderExsists((String)"renameResource", folderID);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String getWorkspace(Integer userID) throws IOException {
        FlashMessage flashMessage = null;
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        if (user != null) {
            Workspace workspace = user.getWorkspace();
            flashMessage = new FlashMessage("getWorkspace", (Object)workspace.getWorkspaceDTO());
        } else {
            flashMessage = FlashMessage.getNoSuchUserExists((String)"getWorkspace", (Integer)userID);
        }
        return flashMessage.serializeMessage();
    }

    @Override
    public String getOrganisationsByUserRole(Integer userID, List<String> roleNames, Integer courseId, List<Integer> restrictToClassIds) throws IOException {
        FlashMessage flashMessage = null;
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        flashMessage = user != null ? (courseId == null ? new FlashMessage("getOrganisationsByUserRole", (Object)this.userMgmtService.getOrganisationsForUserByRole(user, roleNames)) : new FlashMessage("getOrganisationsByUserRole", (Object)this.userMgmtService.getOrganisationsForUserByRole(user, roleNames, courseId, restrictToClassIds))) : FlashMessage.getNoSuchUserExists((String)"getOrganisationsByUserRole", (Integer)userID);
        return flashMessage.serializeMessage();
    }

    @Override
    public String getUserOrganisation(Integer userID, Integer organisationId) throws IOException {
        OrganisationDTO orgDTO;
        FlashMessage flashMessage = null;
        User user = (User)this.baseDAO.find(User.class, (Serializable)userID);
        flashMessage = user != null ? ((orgDTO = this.userMgmtService.getOrganisationForUserWithRole(user, organisationId)) != null ? new FlashMessage("getUserOrganisation", (Object)orgDTO) : FlashMessage.getNoSuchOrganisationExists((String)"getUserOrganisation", (Integer)organisationId)) : FlashMessage.getNoSuchUserExists((String)"getOrganisationsByUserRole", (Integer)userID);
        return flashMessage.serializeMessage();
    }

    @Override
    public Vector<UserFlashDTO> getUsersFromOrganisationByRole(Integer organisationID, String roleName) {
        return this.userMgmtService.getUsersFromOrganisationByRole(organisationID, roleName, true, false);
    }
}

