/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserFlashDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.workspace.dto.FolderContentDTO;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceAction
extends LamsDispatchAction {
    protected Logger log = Logger.getLogger((String)WorkspaceAction.class.getName());
    public static final String RESOURCE_ID = "resourceID";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final String ROLE_DELIMITER = ",";
    public static final Integer BOOTSTRAP_FOLDER_ID = new Integer(-1);
    public static final Integer ORG_FOLDER_ID = new Integer(-2);
    public static final Integer ROOT_ORG_FOLDER_ID = new Integer(1);

    private Integer getUserId(HttpServletRequest request) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    public IWorkspaceManagementService getWorkspaceManagementService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IWorkspaceManagementService)webContext.getBean("workspaceManagementService");
    }

    private ActionForward returnWDDXPacket(FlashMessage flashMessage, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println(flashMessage.serializeMessage());
        return null;
    }

    private ActionForward returnWDDXPacket(String serializedFlashMessage, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println(serializedFlashMessage);
        return null;
    }

    private String checkResourceNotDummyValue(String methodName, Integer folderID, String resourceType) throws IOException {
        return this.checkResourceNotDummyValue(methodName, new Long(folderID.longValue()), resourceType);
    }

    private String checkResourceNotDummyValue(String methodName, Long folderID, String resourceType) throws IOException {
        if ("Folder".equals(resourceType) && (BOOTSTRAP_FOLDER_ID.equals(folderID) || ORG_FOLDER_ID.equals(folderID))) {
            FlashMessage msg = new FlashMessage(methodName, (Object)("FolderID " + folderID + " invalid for this call."), 1);
            return msg.serializeMessage();
        }
        return null;
    }

    public ActionForward createFolderForFlash(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer parentFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"parentFolderID"));
        String errorPacket = this.checkResourceNotDummyValue("createFolderForFlash", parentFolderID, "Folder");
        if (errorPacket != null) {
            return this.returnWDDXPacket(errorPacket, response);
        }
        String folderName = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
        Integer userID = this.getUserId(request);
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.createFolderForFlash(parentFolderID, folderName, userID);
        return this.returnWDDXPacket(wddxPacket, response);
    }

    public ActionForward getFolderContents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Integer folderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID"));
        Integer mode = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"mode"));
        Integer userID = this.getUserId(request);
        String methodKey = "getFolderContents";
        try {
            return this.returnWDDXPacket(new FlashMessage(methodKey, (Object)this.getFolderContents(folderID, mode, userID)), response);
        }
        catch (UserAccessDeniedException e) {
            return this.returnWDDXPacket(FlashMessage.getUserNotAuthorized((String)methodKey, (Integer)userID), response);
        }
        catch (WorkspaceFolderException e) {
            return this.returnWDDXPacket(new FlashMessage(methodKey, (Object)e.getMessage(), 1), response);
        }
        catch (Exception e) {
            this.log.error((Object)("getFolderContents: Exception occured. userID " + userID + " folderID " + folderID), (Throwable)e);
            return this.returnWDDXPacket(FlashMessage.getExceptionOccured((String)methodKey, (String)e.getMessage()), response);
        }
    }

    private Hashtable getFolderContents(Integer folderID, Integer mode, Integer userID) throws UserAccessDeniedException, WorkspaceFolderException, Exception {
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        Hashtable<String, Object> packet = null;
        String methodKey = "getFolderContents";
        if (BOOTSTRAP_FOLDER_ID.equals(folderID)) {
            MessageService msgService = workspaceManagementService.getMessageService();
            Vector<FolderContentDTO> folders = new Vector<FolderContentDTO>();
            FolderContentDTO userFolder = workspaceManagementService.getUserWorkspaceFolder(userID);
            if (userFolder != null) {
                folders.add(userFolder);
            }
            FolderContentDTO dummyOrgFolder = new FolderContentDTO(msgService.getMessage("organisations"), msgService.getMessage("folder"), null, null, "Folder", new Long(ORG_FOLDER_ID.longValue()), WorkspaceFolder.READ_ACCESS, null);
            folders.add(dummyOrgFolder);
            FolderContentDTO publicFolder = workspaceManagementService.getPublicWorkspaceFolder(userID);
            if (publicFolder != null) {
                folders.add(publicFolder);
            }
            packet = this.createFolderContentPacket(null, BOOTSTRAP_FOLDER_ID, folders);
        } else if (ORG_FOLDER_ID.equals(folderID)) {
            Vector folders = workspaceManagementService.getAccessibleOrganisationWorkspaceFolders(userID);
            if (folders.size() == 1) {
                FolderContentDTO folder = (FolderContentDTO)folders.firstElement();
                if (folder.resourceID.equals(new Long(ROOT_ORG_FOLDER_ID.intValue()))) {
                    return this.getFolderContents(new Integer(ROOT_ORG_FOLDER_ID), mode, userID);
                }
            }
            packet = this.createFolderContentPacket(BOOTSTRAP_FOLDER_ID, ORG_FOLDER_ID, folders);
        } else {
            WorkspaceFolder folder = workspaceManagementService.getWorkspaceFolder(folderID);
            if (folder != null) {
                WorkspaceFolder parentWorkspaceFolder;
                Vector<FolderContentDTO> items = workspaceManagementService.getFolderContentsExcludeHome(userID, folder, mode);
                packet = folder.getWorkspaceFolderId().equals(ROOT_ORG_FOLDER_ID) ? this.createFolderContentPacket(BOOTSTRAP_FOLDER_ID, ORG_FOLDER_ID, items) : this.createFolderContentPacket((parentWorkspaceFolder = folder.getParentWorkspaceFolder()) != null ? parentWorkspaceFolder.getWorkspaceFolderId() : null, folder.getWorkspaceFolderId(), items);
            } else {
                throw new WorkspaceFolderException(FlashMessage.getNoSuchWorkspaceFolderContentExsists((String)methodKey, (Long)new Long(folderID.longValue())).getMessageValue().toString());
            }
        }
        return packet;
    }

    private Hashtable<String, Object> createFolderContentPacket(Integer parentWorkspaceFolderID, Integer workspaceFolderID, Vector contents) {
        Hashtable<String, Object> packet = new Hashtable<String, Object>();
        if (parentWorkspaceFolderID != null) {
            packet.put("parentWorkspaceFolderID", parentWorkspaceFolderID);
        }
        if (workspaceFolderID != null) {
            packet.put("workspaceFolderID", workspaceFolderID);
        }
        if (contents != null) {
            packet.put("contents", contents);
        }
        return packet;
    }

    public ActionForward deleteResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long resourceID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)RESOURCE_ID));
        String resourceType = WebUtil.readStrParam((HttpServletRequest)request, (String)RESOURCE_TYPE);
        String errorPacket = this.checkResourceNotDummyValue("deleteResource", resourceID, "Folder");
        if (errorPacket != null) {
            return this.returnWDDXPacket(errorPacket, response);
        }
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        String wddxPacket = null;
        try {
            IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
            wddxPacket = workspaceManagementService.deleteResource(resourceID, resourceType, userID);
        }
        catch (Exception e) {
            this.log.error((Object)("deleteResource: Exception occured. userID " + userID + " folderID " + resourceID), (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"deleteResource", (String)e.getMessage());
            wddxPacket = flashMessage.serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward copyResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long resourceID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)RESOURCE_ID));
        String resourceType = WebUtil.readStrParam((HttpServletRequest)request, (String)RESOURCE_TYPE);
        Integer targetFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"targetFolderID"));
        String errorPacket = this.checkResourceNotDummyValue("copyResource", targetFolderID, "Folder");
        if (errorPacket != null) {
            return this.returnWDDXPacket(errorPacket, response);
        }
        String wddxPacket = null;
        Integer copyType = WebUtil.readIntParam((HttpServletRequest)request, (String)"copyType", (boolean)true);
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        try {
            IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
            wddxPacket = workspaceManagementService.copyResource(resourceID, resourceType, copyType, targetFolderID, userID);
        }
        catch (Exception e) {
            this.log.error((Object)("deleteResource: Exception occured. userID " + userID + " folderID " + resourceID), (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"deleteResource", (String)e.getMessage());
            wddxPacket = flashMessage.serializeMessage();
        }
        return this.returnWDDXPacket(wddxPacket, response);
    }

    public ActionForward moveResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Long resourceID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)RESOURCE_ID));
        String resourceType = WebUtil.readStrParam((HttpServletRequest)request, (String)RESOURCE_TYPE);
        Integer userID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Integer targetFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"targetFolderID"));
        String errorPacket = this.checkResourceNotDummyValue("copyResource", targetFolderID, "Folder");
        if (errorPacket != null) {
            return this.returnWDDXPacket(errorPacket, response);
        }
        IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
        String wddxPacket = workspaceManagementService.moveResource(resourceID, targetFolderID, resourceType, userID);
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward createWorkspaceFolderContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        Integer contentTypeID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"contentTypeID"));
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
        String description = WebUtil.readStrParam((HttpServletRequest)request, (String)"description");
        Integer workspaceFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"workspaceFolderID"));
        String mimeType = WebUtil.readStrParam((HttpServletRequest)request, (String)"mimeType");
        String path = WebUtil.readStrParam((HttpServletRequest)request, (String)"path");
        String errorPacket = this.checkResourceNotDummyValue("createWorkspaceFolderContent", workspaceFolderID, "Folder");
        if (errorPacket != null) {
            return this.returnWDDXPacket(errorPacket, response);
        }
        String wddxPacket = null;
        try {
            IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
            wddxPacket = workspaceManagementService.createWorkspaceFolderContent(contentTypeID, name, description, workspaceFolderID, mimeType, path);
        }
        catch (Exception e) {
            this.log.error((Object)("createWorkspaceFolderContent: Exception occured. contentTypeID " + contentTypeID + " name " + name + " workspaceFolderID " + workspaceFolderID), (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"createWorkspaceFolderContent", (String)e.getMessage());
            wddxPacket = flashMessage.serializeMessage();
        }
        return this.returnWDDXPacket(wddxPacket, response);
    }

    public ActionForward updateWorkspaceFolderContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, Exception {
        Long folderContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"folderContentID"));
        String path = WebUtil.readStrParam((HttpServletRequest)request, (String)"path");
        String wddxPacket = null;
        try {
            IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
            wddxPacket = workspaceManagementService.updateWorkspaceFolderContent(folderContentID, path);
        }
        catch (Exception e) {
            this.log.error((Object)("updateWorkspaceFolderContent: Exception occured. path " + path + " folderContentID " + folderContentID), (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"updateWorkspaceFolderContent", (String)e.getMessage());
            wddxPacket = flashMessage.serializeMessage();
        }
        return this.returnWDDXPacket(wddxPacket, response);
    }

    public ActionForward renameResource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String resourceType;
        Integer userID = this.getUserId(request);
        Long resourceID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)RESOURCE_ID));
        String errorPacket = this.checkResourceNotDummyValue("renameResource", resourceID, resourceType = WebUtil.readStrParam((HttpServletRequest)request, (String)RESOURCE_TYPE));
        if (errorPacket != null) {
            return this.returnWDDXPacket(errorPacket, response);
        }
        String name = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
        String wddxPacket = null;
        try {
            IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
            wddxPacket = workspaceManagementService.renameResource(resourceID, resourceType, name, userID);
        }
        catch (Exception e) {
            this.log.error((Object)("renameResource: Exception occured. userID " + userID + " resourceID " + resourceID + " resourceType " + resourceType), (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"renameResource", (String)e.getMessage());
            wddxPacket = flashMessage.serializeMessage();
        }
        return this.returnWDDXPacket(wddxPacket, response);
    }

    public ActionForward deleteContentWithVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long uuID = new Long(WebUtil.readIntParam((HttpServletRequest)request, (String)"uuID"));
        Long versionID = new Long(WebUtil.readIntParam((HttpServletRequest)request, (String)"versionID"));
        Long folderContentID = new Long(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderContentID"));
        String errorPacket = this.checkResourceNotDummyValue("deleteContentWithVersion", folderContentID, "Folder");
        if (errorPacket != null) {
            return this.returnWDDXPacket(errorPacket, response);
        }
        String wddxPacket = null;
        try {
            IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
            wddxPacket = workspaceManagementService.deleteContentWithVersion(uuID, versionID, folderContentID);
        }
        catch (Exception e) {
            this.log.error((Object)("deleteContentWithVersion: Exception occured. uuID " + uuID + " versionID " + versionID + " folderContentID " + folderContentID), (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"deleteContentWithVersion", (String)e.getMessage());
            wddxPacket = flashMessage.serializeMessage();
        }
        return this.returnWDDXPacket(wddxPacket, response);
    }

    public ActionForward getOrganisationsByUserRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer userID = this.getUserId(request);
        String roles_str = WebUtil.readStrParam((HttpServletRequest)request, (String)"roles");
        Object[] roles = roles_str.split(ROLE_DELIMITER);
        ArrayList<String> roleList = new ArrayList<String>();
        for (String string : roles) {
            roleList.add(string);
        }
        String wddxPacket = null;
        Integer courseId = null;
        Object[] classIdStrings = null;
        try {
            courseId = WebUtil.readIntParam((HttpServletRequest)request, (String)"courseID", (boolean)true);
            classIdStrings = request.getParameterValues("classID");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (classIdStrings != null) {
                for (Object str : classIdStrings) {
                    int classId = Integer.parseInt((String)str);
                    arrayList.add(new Integer(classId));
                }
            }
            IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
            wddxPacket = workspaceManagementService.getOrganisationsByUserRole(userID, roleList, courseId, arrayList);
        }
        catch (Exception exception) {
            String error = new ToStringBuilder((Object)this).append((Object)"").append("userID", (Object)userID).append("roles", roles).append("courseId", (Object)courseId).append("classIdStrings", classIdStrings).toString();
            this.log.error((Object)("getOrganisationsByUserRole: Exception occured. Request data " + error), (Throwable)exception);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"getOrganisationsByUserRole", (String)exception.getMessage());
            wddxPacket = flashMessage.serializeMessage();
        }
        return this.returnWDDXPacket(wddxPacket, response);
    }

    public ActionForward getUsersFromOrganisationByRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer organisationID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID"));
        String role = WebUtil.readStrParam((HttpServletRequest)request, (String)"role");
        FlashMessage flashMessage = null;
        try {
            IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
            Vector<UserFlashDTO> users = workspaceManagementService.getUsersFromOrganisationByRole(organisationID, role);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getUsersFromOrganisationByRole: organisationID=" + organisationID + " role=" + role + " users " + users));
            }
            flashMessage = new FlashMessage("getUsersFromOrganisationByRole", users);
        }
        catch (Exception e) {
            this.log.error((Object)("getUsersFromOrganisationByRole: Exception occured. organisationID " + organisationID + " role " + role), (Throwable)e);
            flashMessage = FlashMessage.getExceptionOccured((String)"getUsersFromOrganisationByRole", (String)e.getMessage());
        }
        String wddxPacket = flashMessage.serializeMessage();
        return this.returnWDDXPacket(wddxPacket, response);
    }

    public ActionForward getUserOrganisation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer userID = this.getUserId(request);
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID", (boolean)true);
        String wddxPacket = null;
        try {
            IWorkspaceManagementService workspaceManagementService = this.getWorkspaceManagementService();
            wddxPacket = workspaceManagementService.getUserOrganisation(userID, orgId);
        }
        catch (Exception e) {
            this.log.error((Object)("getUserOrganisation: Exception occured. userID " + userID + " organisationId " + orgId), (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"getOrganisationsByUserRole", (String)e.getMessage());
            wddxPacket = flashMessage.serializeMessage();
        }
        return this.returnWDDXPacket(wddxPacket, response);
    }
}

