/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import java.util.Date;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.Event;
import org.lamsfoundation.lams.events.EventNotificationService;

class Subscription {
    private Long uid;
    protected Long userId;
    protected Event event;
    protected Short deliveryMethodId;
    protected Long periodicity;
    protected Date lastOperationTime;
    protected String lastOperationMessage;
    protected AbstractDeliveryMethod deliveryMethod;

    public Subscription() {
    }

    protected Subscription(Long userId, AbstractDeliveryMethod deliveryMethod, Long periodicity) {
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method can not be null.");
        }
        this.userId = userId;
        this.deliveryMethod = deliveryMethod;
        this.setPeriodicity(periodicity);
        this.deliveryMethodId = deliveryMethod.getId();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        return other.getUserId().equals(this.getUserId()) && other.getDeliveryMethod().equals(this.getDeliveryMethod());
    }

    protected AbstractDeliveryMethod getDeliveryMethod() {
        if (this.deliveryMethod == null) {
            for (AbstractDeliveryMethod delivery : EventNotificationService.getInstance().getAvailableDeliveryMethods()) {
                if (delivery.getId() != this.deliveryMethodId.shortValue()) continue;
                this.deliveryMethod = delivery;
            }
        }
        return this.deliveryMethod;
    }

    protected String getLastOperationMessage() {
        return this.lastOperationMessage;
    }

    protected boolean getLastOperationSuccessful() {
        return this.lastOperationMessage == null;
    }

    protected Long getPeriodicity() {
        return this.periodicity;
    }

    protected Long getUserId() {
        return this.userId;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getUserId()).append((Object)this.getDeliveryMethod()).toHashCode();
    }

    protected boolean isEligibleForNotification() {
        return !this.getLastOperationSuccessful() || this.lastOperationTime == null || System.currentTimeMillis() - this.lastOperationTime.getTime() > this.periodicity;
    }

    protected void notifyUser(String subject, String message) {
        this.lastOperationTime = new Date();
        this.lastOperationMessage = this.deliveryMethod.send(this.userId, subject, message);
    }

    protected void setPeriodicity(Long periodicity) {
        this.periodicity = periodicity == null ? 0L : periodicity;
    }

    protected Short getDeliveryMethodId() {
        return this.deliveryMethodId;
    }

    protected Date getLastOperationTime() {
        return this.lastOperationTime;
    }

    protected void setDeliveryMethodId(Short deliveryMethodId) {
        this.deliveryMethodId = deliveryMethodId;
    }

    protected void setLastOperationTime(Date lastOperationTime) {
        this.lastOperationTime = lastOperationTime;
    }

    protected void setUserId(Long userId) {
        this.userId = userId;
    }

    private Long getUid() {
        return this.uid;
    }

    private void setUid(Long uid) {
        this.uid = uid;
    }

    public Object clone() {
        return new Subscription(this.userId, this.deliveryMethod, this.periodicity);
    }

    protected void setLastOperationMessage(String lastOperationMessage) {
        this.lastOperationMessage = lastOperationMessage;
    }
}

