/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.planner.dao.hibernate;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.lamsfoundation.lams.planner.PedagogicalPlannerNodeRole;
import org.lamsfoundation.lams.planner.PedagogicalPlannerSequenceNode;
import org.lamsfoundation.lams.planner.dao.PedagogicalPlannerDAO;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PedagogicalPlannerDAOHibernate
extends HibernateDaoSupport
implements PedagogicalPlannerDAO {
    private static final String FIND_ROOT_NODE = "FROM " + PedagogicalPlannerSequenceNode.class.getName() + " AS n WHERE n.parent=NULL";
    private static final String FIND_PARENT_TITLE = "SELECT n.parent.uid, n.title FROM " + PedagogicalPlannerSequenceNode.class.getName() + " AS n WHERE n.uid=?";
    private static final String FIND_MAX_ORDER_ID = "SELECT MAX(n.order) FROM " + PedagogicalPlannerSequenceNode.class.getName() + " AS n WHERE n.parent.uid=?";
    private static final String FIND_NEIGHBOUR_NODE_ASC = "FROM " + PedagogicalPlannerSequenceNode.class.getName() + " AS n WHERE ((? IS NULL AND n.parent=NULL) OR  n.parent.uid=?) AND n.order>=?";
    private static final String FIND_NEIGHBOUR_NODE_DESC = "FROM " + PedagogicalPlannerSequenceNode.class.getName() + " AS n WHERE ((? IS NULL AND n.parent=NULL) OR  n.parent.uid=?) AND n.order<=? ORDER BY n.order DESC";
    private static final String GET_PLANNER_NODE_ROLE = "FROM " + PedagogicalPlannerNodeRole.class.getName() + " AS r WHERE r.user.userId=? AND r.node.uid=? AND r.role.roleId=?";
    private static final String GET_PLANNER_NODE_ROLE_USERS = "SELECT p.user FROM " + PedagogicalPlannerNodeRole.class.getName() + " AS p WHERE p.node.uid=? AND p.role.roleId=?";

    @Override
    public PedagogicalPlannerSequenceNode getByUid(Long uid) {
        return (PedagogicalPlannerSequenceNode)this.getHibernateTemplate().get(PedagogicalPlannerSequenceNode.class, (Serializable)uid);
    }

    @Override
    public PedagogicalPlannerSequenceNode getRootNode() {
        List subnodeList = this.getHibernateTemplate().find(FIND_ROOT_NODE);
        PedagogicalPlannerSequenceNode rootNode = new PedagogicalPlannerSequenceNode();
        rootNode.setLocked(true);
        LinkedHashSet<PedagogicalPlannerSequenceNode> subnodeSet = new LinkedHashSet<PedagogicalPlannerSequenceNode>(subnodeList);
        rootNode.setSubnodes(subnodeSet);
        return rootNode;
    }

    @Override
    public List<String[]> getTitlePath(Long nodeUid) {
        Long currentUid = nodeUid;
        LinkedList<String[]> titlePath = new LinkedList<String[]>();
        while (currentUid != null) {
            List result = this.getHibernateTemplate().find(FIND_PARENT_TITLE, (Object)currentUid);
            if (result.size() > 0) {
                Object[] row = (Object[])result.get(0);
                if (!currentUid.equals(nodeUid)) {
                    String title = (String)row[1];
                    titlePath.addFirst(new String[]{currentUid.toString(), title});
                }
                currentUid = (Long)row[0];
                continue;
            }
            return null;
        }
        return titlePath;
    }

    @Override
    public void removeNode(PedagogicalPlannerSequenceNode node) {
        this.getHibernateTemplate().delete((Object)node);
        this.getHibernateTemplate().flush();
    }

    @Override
    public void saveOrUpdateNode(PedagogicalPlannerSequenceNode node) {
        this.getHibernateTemplate().saveOrUpdate((Object)node);
        this.getHibernateTemplate().flush();
    }

    @Override
    public Integer getNextOrderId(Long parentUid) {
        Integer maxOrderId = (Integer)this.getHibernateTemplate().find(FIND_MAX_ORDER_ID, (Object)parentUid).get(0);
        if (maxOrderId == null) {
            maxOrderId = 0;
        }
        return maxOrderId + 1;
    }

    @Override
    public PedagogicalPlannerSequenceNode getNeighbourNode(PedagogicalPlannerSequenceNode node, Integer orderDelta) {
        Integer order = node.getOrder() + orderDelta;
        Long parentUid = node.getParent() == null ? null : node.getParent().getUid();
        String query = orderDelta < 0 ? FIND_NEIGHBOUR_NODE_DESC : FIND_NEIGHBOUR_NODE_ASC;
        return (PedagogicalPlannerSequenceNode)this.getHibernateTemplate().find(query, new Object[]{parentUid, parentUid, order}).get(0);
    }

    private List getPlannerNodeRoles(Integer userId, Long nodeUid, Integer roleId) {
        return this.getHibernateTemplate().find(GET_PLANNER_NODE_ROLE, new Object[]{userId, nodeUid, roleId});
    }

    @Override
    public Boolean isEditor(Integer userId, Long nodeUid, Integer roleId) {
        PedagogicalPlannerSequenceNode node;
        List l = this.getPlannerNodeRoles(userId, nodeUid, roleId);
        if (l != null && l.size() > 0) {
            return true;
        }
        if (nodeUid != null && (node = this.getByUid(nodeUid)) != null) {
            PedagogicalPlannerSequenceNode parent = node.getParent();
            return this.isEditor(userId, parent != null ? parent.getUid() : null, roleId);
        }
        return false;
    }

    @Override
    public List getNodeUsers(Long nodeUid, Integer roleId) {
        return this.getHibernateTemplate().find(GET_PLANNER_NODE_ROLE_USERS, new Object[]{nodeUid, roleId});
    }

    @Override
    public Set getInheritedNodeUsers(Long nodeUid, Integer roleId) {
        HashSet users = new HashSet();
        PedagogicalPlannerSequenceNode node = this.getByUid(nodeUid);
        while (node.getParent() != null) {
            PedagogicalPlannerSequenceNode parent = node.getParent();
            users.addAll(this.getNodeUsers(parent.getUid(), roleId));
            node = parent;
        }
        return users;
    }

    @Override
    public void saveNodeRole(Integer userId, Long nodeUid, Integer roleId) {
        PedagogicalPlannerSequenceNode node = this.getByUid(nodeUid);
        User user = (User)this.getHibernateTemplate().get(User.class, (Serializable)userId);
        Role role = (Role)this.getHibernateTemplate().get(Role.class, (Serializable)roleId);
        PedagogicalPlannerNodeRole nodeRole = new PedagogicalPlannerNodeRole(node, user, role);
        this.getHibernateTemplate().saveOrUpdate((Object)nodeRole);
        this.getHibernateTemplate().flush();
    }

    @Override
    public void removeNodeRole(Integer userId, Long nodeUid, Integer roleId) {
        List l = this.getPlannerNodeRoles(userId, nodeUid, roleId);
        for (Object o : l) {
            this.getHibernateTemplate().delete(o);
        }
        this.getHibernateTemplate().flush();
    }
}

