/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.planner.dto;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.planner.PedagogicalPlannerSequenceNode;
import org.lamsfoundation.lams.planner.dao.PedagogicalPlannerDAO;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.web.session.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PedagogicalPlannerSequenceNodeDTO {
    private Long uid;
    private List<String[]> titlePath;
    private String title;
    private String briefDescription;
    private String fullDescription;
    private String fileName;
    private Boolean locked;
    private List<PedagogicalPlannerSequenceNodeDTO> subnodes;
    private Long parentUid;
    private Long learningDesignId;
    private Boolean edit = false;
    private Boolean createSubnode = false;
    private Boolean hasRole = true;
    private Boolean importNode = false;
    private List<PedagogicalPlannerSequenceNodeDTO> recentlyModifiedNodes;
    private Boolean displayAddRemoveEditorsLink = true;
    private static final String FULL_DESCRIPTION_NOT_EMPTY = "FULL";

    public PedagogicalPlannerSequenceNodeDTO() {
    }

    public PedagogicalPlannerSequenceNodeDTO(PedagogicalPlannerSequenceNode node, Set<PedagogicalPlannerSequenceNode> subnodes, Boolean isSysadmin, PedagogicalPlannerDAO dao) {
        this.uid = node.getUid();
        this.title = node.getTitle();
        this.briefDescription = node.getBriefDescription();
        this.fullDescription = node.getFullDescription();
        this.fileName = node.getFileName();
        this.locked = node.getLocked();
        if (node.getParent() != null) {
            this.parentUid = node.getParent().getUid();
        }
        this.subnodes = new LinkedList<PedagogicalPlannerSequenceNodeDTO>();
        if (subnodes != null) {
            HttpSession s = SessionManager.getSession();
            UserDTO u = (UserDTO)s.getAttribute("user");
            for (PedagogicalPlannerSequenceNode subnode : subnodes) {
                PedagogicalPlannerSequenceNodeDTO subnodeDTO = new PedagogicalPlannerSequenceNodeDTO();
                subnodeDTO.setTitle(subnode.getTitle());
                subnodeDTO.setBriefDescription(subnode.getBriefDescription());
                if (!StringUtils.isEmpty((String)subnode.getFullDescription())) {
                    subnodeDTO.setFullDescription(FULL_DESCRIPTION_NOT_EMPTY);
                }
                subnodeDTO.setLocked(subnode.getLocked());
                subnodeDTO.setFileName(subnode.getFileName());
                subnodeDTO.setUid(subnode.getUid());
                if (u != null) {
                    subnodeDTO.setDisplayAddRemoveEditorsLink(isSysadmin != false || dao.isEditor(u.getUserID(), subnode.getUid(), Role.ROLE_AUTHOR_ADMIN) != false);
                }
                this.subnodes.add(subnodeDTO);
            }
        }
    }

    public List<String[]> getTitlePath() {
        return this.titlePath;
    }

    public void setTitlePath(List<String[]> titlePath) {
        this.titlePath = titlePath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public void setBriefDescription(String briefDescription) {
        this.briefDescription = briefDescription;
    }

    public String getFullDescription() {
        return this.fullDescription;
    }

    public void setFullDescription(String fullDescription) {
        this.fullDescription = fullDescription;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<PedagogicalPlannerSequenceNodeDTO> getSubnodes() {
        return this.subnodes;
    }

    public void setSubnodes(List<PedagogicalPlannerSequenceNodeDTO> subnodes) {
        this.subnodes = subnodes;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public Long getParentUid() {
        return this.parentUid;
    }

    public void setParentUid(Long parentUid) {
        this.parentUid = parentUid;
    }

    public Boolean getEdit() {
        return this.edit;
    }

    public void setEdit(Boolean edit) {
        this.edit = edit;
    }

    public Boolean getCreateSubnode() {
        return this.createSubnode;
    }

    public void setCreateSubnode(Boolean createSubnode) {
        this.createSubnode = createSubnode;
    }

    public Boolean getHasRole() {
        return this.hasRole;
    }

    public void setHasRole(Boolean hasRole) {
        this.hasRole = hasRole;
    }

    public Boolean getImportNode() {
        return this.importNode;
    }

    public void setImportNode(Boolean importNode) {
        this.importNode = importNode;
    }

    public Long getLearningDesignId() {
        return this.learningDesignId;
    }

    public void setLearningDesignId(Long learningDesignId) {
        this.learningDesignId = learningDesignId;
    }

    public List<PedagogicalPlannerSequenceNodeDTO> getRecentlyModifiedNodes() {
        return this.recentlyModifiedNodes;
    }

    public void setRecentlyModifiedNodes(List<PedagogicalPlannerSequenceNodeDTO> recentlyModifiedNodes) {
        this.recentlyModifiedNodes = recentlyModifiedNodes;
    }

    public Boolean getDisplayAddRemoveEditorsLink() {
        return this.displayAddRemoveEditorsLink;
    }

    public void setDisplayAddRemoveEditorsLink(Boolean displayAddRemoveEditorsLink) {
        this.displayAddRemoveEditorsLink = displayAddRemoveEditorsLink;
    }
}

