/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class ChartUtil {
    static Logger log = Logger.getLogger(ChartUtil.class);
    private static final Integer SMALL_WIDTH = new Integer(400);
    private static final Integer SMALL_HEIGHT = new Integer(400);
    private static final Integer LARGE_WIDTH = new Integer(750);
    private static final Integer LARGE_HEIGHT = new Integer(550);
    public static final String CHART_TYPE_PIE = "pie";
    public static final String CHART_TYPE_BAR = "bar";

    public static void outputPieChart(HttpServletResponse response, OutputStream out, String title, DefaultPieDataset data) throws IOException {
        boolean useSmall = ChartUtil.determineSize(data.getKeys());
        JFreeChart chart = null;
        chart = ChartFactory.createPieChart3D((String)title, (PieDataset)data, (boolean)true, (boolean)true, (boolean)false);
        if (chart != null) {
            response.setContentType("image/png");
            if (useSmall) {
                ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)SMALL_WIDTH, (int)SMALL_HEIGHT);
            } else {
                ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)LARGE_WIDTH, (int)LARGE_HEIGHT);
            }
        } else {
            log.error((Object)("Unable to output chart. No chart returned by JFreeChart. Data " + data));
        }
    }

    public static void outputBarChart(HttpServletResponse response, OutputStream out, String title, DefaultCategoryDataset data, String categoryAxisLabel, String valueAxisLabel) throws IOException {
        boolean useSmall = ChartUtil.determineSize(data.getColumnKeys());
        JFreeChart chart = ChartFactory.createBarChart3D((String)title, (String)categoryAxisLabel, (String)valueAxisLabel, (CategoryDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        if (chart != null) {
            response.setContentType("image/png");
            if (useSmall) {
                ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)SMALL_WIDTH, (int)SMALL_HEIGHT);
            } else {
                ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)LARGE_WIDTH, (int)LARGE_HEIGHT);
            }
        } else {
            log.error((Object)("Unable to output chart. No chart returned by JFreeChart. Data " + data));
        }
    }

    private static boolean determineSize(Collection legendEntries) {
        int numLines = 0;
        int numInCurrentLine = 0;
        for (Object object : legendEntries) {
            int textLength = object.toString().length();
            if ((numInCurrentLine = numInCurrentLine + textLength + 3) <= 50) continue;
            numInCurrentLine = textLength;
            ++numLines;
        }
        return numLines < 4;
    }
}

