-- SQL statements to set the database/lams version at 2.3.4

-- Turn off autocommit, so nothing is committed if there is an error
SET AUTOCOMMIT = 0;			

-- LDEV-2515 backport of planner
CREATE TABLE lams_planner_recent_learning_designs (
     user_id  BIGINT(20) NOT NULL
   , learning_design_id BIGINT(20) NOT NULL
   , last_modified_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
   , CONSTRAINT FK_lams_planner_recent_learning_designs_1 FOREIGN KEY (user_id)
                  REFERENCES lams_user (user_id) ON DELETE CASCADE ON UPDATE CASCADE
   , CONSTRAINT FK_lams_planner_recent_learning_designs_2 FOREIGN KEY (learning_design_id)
                  REFERENCES lams_learning_design (learning_design_id) ON DELETE CASCADE ON UPDATE CASCADE
   , PRIMARY KEY (user_id,learning_design_id)
)TYPE=InnoDB;

CREATE TABLE lams_planner_node_role (
       uid BIGINT(20) NOT NULL AUTO_INCREMENT
     , node_uid BIGINT(20) NOT NULL
     , user_id BIGINT(20) NOT NULL
     , role_id INT(6) NOT NULL
     , PRIMARY KEY (uid)
     , UNIQUE KEY (node_uid, user_id, role_id)
     , CONSTRAINT FK_planner_node_role_user FOREIGN KEY (user_id) REFERENCES lams_user (user_id) ON DELETE CASCADE ON UPDATE NO ACTION
     , CONSTRAINT FK_planner_node_role_node FOREIGN KEY (node_uid) REFERENCES lams_planner_nodes (uid) ON DELETE CASCADE ON UPDATE NO ACTION
     , CONSTRAINT FK_planner_node_role_role FOREIGN KEY (role_id) REFERENCES lams_role (role_id) ON DELETE CASCADE ON UPDATE NO ACTION
)TYPE=InnoDB;

update lams_configuration set config_value='2.3.4' where config_key='Version';
update lams_configuration set config_value='2.3.4.201002190000' where config_key='LearnerClientVersion' OR config_key='ServerVersionNumber' OR config_key='MonitorClientVersion' OR config_key='AuthoringClientVersion';
update lams_configuration set config_value='2010-02-19' where config_key='DictionaryDateCreated';

-- If there were no errors, commit and restore autocommit to on
COMMIT;
SET AUTOCOMMIT = 1;