/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.CompetenceMapping;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.ConditionGateActivity;
import org.lamsfoundation.lams.learningdesign.FloatingActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.OptionsWithSequencesActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.SystemGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.learningdesign.dto.BranchActivityEntryDTO;
import org.lamsfoundation.lams.learningdesign.dto.PlannerActivityMetadataDTO;
import org.lamsfoundation.lams.util.HelpUtil;

public class AuthoringActivityDTO
extends BaseDTO {
    private Long activityID;
    private Integer activityUIID;
    private String description;
    private String activityTitle;
    private String helpText;
    private String helpURL;
    private Integer xCoord;
    private Integer yCoord;
    private Long parentActivityID;
    private Integer parentUIID;
    private Integer activityTypeID;
    private Long groupingID;
    private Integer groupingUIID;
    private Integer orderID;
    private Long learningDesignID;
    private Long learningLibraryID;
    private Date createDateTime;
    private Integer maxOptions;
    private Integer maxActivities;
    private Integer minOptions;
    private String optionsInstructions;
    private String toolSignature;
    private Long toolID;
    private Long toolContentID;
    private String toolDisplayName;
    private String toolVersion;
    private String authoringURL;
    private String monitoringURL;
    private String contributeURL;
    private String moderationURL;
    private String adminURL;
    private Integer activityCategoryID;
    private Integer gateActivityLevelID;
    private Boolean gateOpen;
    private Long gateStartTimeOffset;
    private Long gateEndTimeOffset;
    private Date gateStartDateTime;
    private Date gateEndDateTime;
    private Boolean gateActivityCompletionBased;
    private Boolean applyGrouping;
    private Integer groupingSupportType;
    private Integer groupingType;
    private String libraryActivityUIImage;
    private Long createGroupingID;
    private Integer createGroupingUIID;
    private Boolean readOnly;
    private Boolean initialised;
    private Boolean stopAfterActivity;
    private Long libraryActivityID;
    private String languageFile;
    private ArrayList<Integer> inputActivities;
    private ArrayList<String> competenceMappingTitles;
    private PlannerActivityMetadataDTO plannerMetadataDTO;
    private Integer toolActivityUIID;
    private List<String> evaluation;
    private Integer defaultActivityUIID;
    private Integer startXCoord;
    private Integer startYCoord;
    private Integer endXCoord;
    private Integer endYCoord;
    private String languageCode;
    private Boolean supportsOutputs;
    private String extLmsId;

    public AuthoringActivityDTO(Activity activity, ArrayList<BranchActivityEntryDTO> branchMappings, String languageCode) {
        this.activityID = activity.getActivityId();
        this.activityUIID = activity.getActivityUIID();
        this.description = activity.getDescription();
        this.activityTitle = activity.getTitle();
        this.helpText = activity.getHelpText();
        this.xCoord = activity.getXcoord();
        this.yCoord = activity.getYcoord();
        this.parentActivityID = activity.getParentActivity() != null ? activity.getParentActivity().getActivityId() : null;
        this.parentUIID = activity.getParentUIID();
        this.activityTypeID = activity.getActivityTypeId();
        this.groupingID = activity.getGrouping() != null ? activity.getGrouping().getGroupingId() : null;
        this.groupingUIID = activity.getGroupingUIID();
        this.orderID = activity.getOrderId();
        this.learningDesignID = activity.getLearningDesign() != null ? activity.getLearningDesign().getLearningDesignId() : null;
        this.learningLibraryID = activity.getLearningLibrary() != null ? activity.getLearningLibrary().getLearningLibraryId() : null;
        this.createDateTime = activity.getCreateDateTime();
        this.languageFile = activity.getLanguageFile();
        this.activityCategoryID = activity.getActivityCategoryID();
        this.libraryActivityUIImage = activity.getLibraryActivityUiImage();
        this.libraryActivityID = activity.getLibraryActivity() != null ? activity.getLibraryActivity().getActivityId() : null;
        this.applyGrouping = activity.getApplyGrouping();
        this.groupingSupportType = activity.getGroupingSupportType();
        this.readOnly = activity.getReadOnly();
        this.initialised = activity.isInitialised();
        this.stopAfterActivity = activity.isStopAfterActivity();
        this.inputActivities = activity.getInputActivityUIIDs();
        this.toolActivityUIID = activity.getToolInputActivityUIID();
        this.languageCode = languageCode;
        this.processActivityType(activity, branchMappings);
    }

    private void processActivityType(Activity activity, ArrayList<BranchActivityEntryDTO> branchMappings) {
        if (activity.isGroupingActivity()) {
            this.addGroupingActivityAttributes((GroupingActivity)activity);
        } else if (activity.isToolActivity()) {
            this.addToolActivityAttributes((ToolActivity)activity);
        } else if (activity.isGateActivity()) {
            this.addGateActivityAttributes(activity, branchMappings);
        } else {
            this.addComplexActivityAttributes(activity, branchMappings);
        }
    }

    private void addComplexActivityAttributes(Activity activity, ArrayList<BranchActivityEntryDTO> branchMappings) {
        ComplexActivity complex = (ComplexActivity)activity;
        if (complex.getDefaultActivity() != null) {
            this.defaultActivityUIID = complex.getDefaultActivity().getActivityUIID();
        }
        if (activity.isOptionsWithSequencesActivity()) {
            this.addOptionsWithSequencesActivityAttributes((OptionsWithSequencesActivity)activity);
        } else if (activity.isOptionsActivity()) {
            this.addOptionsActivityAttributes((OptionsActivity)activity);
        } else if (activity.isParallelActivity()) {
            this.addParallelActivityAttributes((ParallelActivity)activity);
        } else if (activity.isBranchingActivity()) {
            this.addBranchingActivityAttributes((BranchingActivity)activity);
        } else if (activity.isFloatingActivity()) {
            this.addFloatingActivityAttributes((FloatingActivity)activity);
        } else {
            this.addSequenceActivityAttributes((SequenceActivity)activity, branchMappings);
        }
    }

    private void addGroupingActivityAttributes(GroupingActivity groupingActivity) {
        Grouping grouping = groupingActivity.getCreateGrouping();
        this.createGroupingID = grouping.getGroupingId();
        this.createGroupingUIID = grouping.getGroupingUIID();
        this.adminURL = groupingActivity.getSystemTool().getAdminUrl();
    }

    private void addOptionsActivityAttributes(OptionsActivity optionsActivity) {
        this.maxOptions = optionsActivity.getMaxNumberOfOptions();
        this.minOptions = optionsActivity.getMinNumberOfOptions();
        this.optionsInstructions = optionsActivity.getOptionsInstructions();
    }

    private void addOptionsWithSequencesActivityAttributes(OptionsWithSequencesActivity optionsActivity) {
        this.addOptionsActivityAttributes(optionsActivity);
        this.startXCoord = optionsActivity.getStartXcoord();
        this.startYCoord = optionsActivity.getStartYcoord();
        this.endXCoord = optionsActivity.getEndXcoord();
        this.endYCoord = optionsActivity.getEndYcoord();
    }

    private void addParallelActivityAttributes(ParallelActivity activity) {
    }

    private void addBranchingActivityAttributes(BranchingActivity activity) {
        this.startXCoord = activity.getStartXcoord();
        this.startYCoord = activity.getStartYcoord();
        this.endXCoord = activity.getEndXcoord();
        this.endYCoord = activity.getEndYcoord();
    }

    private void addFloatingActivityAttributes(FloatingActivity floatingActivity) {
        this.maxActivities = floatingActivity.getMaxNumberOfActivities();
    }

    private void addSequenceActivityAttributes(SequenceActivity activity, ArrayList<BranchActivityEntryDTO> branchMappings) {
        Integer toolActivityUIID;
        Activity parentActivity = activity.getParentActivity();
        Integer n = toolActivityUIID = parentActivity == null ? null : parentActivity.getToolInputActivityUIID();
        if (activity.getBranchEntries() != null) {
            for (BranchActivityEntry ba : activity.getBranchEntries()) {
                branchMappings.add(ba.getBranchActivityEntryDTO(toolActivityUIID));
            }
        }
    }

    private void addToolActivityAttributes(ToolActivity toolActivity) {
        this.toolContentID = toolActivity.getToolContentId();
        this.toolID = toolActivity.getTool().getToolId();
        this.toolSignature = toolActivity.getTool().getToolSignature();
        this.authoringURL = toolActivity.getTool().getAuthorUrl();
        this.monitoringURL = toolActivity.getTool().getMonitorUrl();
        this.adminURL = toolActivity.getTool().getAdminUrl();
        this.toolDisplayName = toolActivity.getTool().getToolDisplayName();
        this.toolVersion = toolActivity.getTool().getToolVersion();
        this.supportsOutputs = toolActivity.getTool().getSupportsOutputs();
        this.extLmsId = toolActivity.getTool().getExtLmsId();
        this.helpURL = HelpUtil.constructToolURL(toolActivity.getTool().getHelpUrl(), this.toolSignature, "", this.languageCode);
        this.competenceMappingTitles = new ArrayList();
        if (toolActivity.getCompetenceMappings() != null) {
            Set<CompetenceMapping> competenceMappings = toolActivity.getCompetenceMappings();
            for (CompetenceMapping competenceMapping : competenceMappings) {
                String competenceMappingTitle = competenceMapping.getCompetence().getTitle();
                this.competenceMappingTitles.add(competenceMappingTitle);
            }
        }
        if (toolActivity.getEvaluation() != null) {
            this.evaluation = new ArrayList<String>();
            ActivityEvaluation eval = toolActivity.getEvaluation();
            this.evaluation.add(eval.getToolOutputDefinition());
            if (eval.getWeight() != null) {
                this.evaluation.add(String.valueOf(eval.getWeight()));
            }
        }
        this.plannerMetadataDTO = toolActivity.getPlannerMetadata() == null ? null : new PlannerActivityMetadataDTO(toolActivity.getPlannerMetadata());
    }

    private void addGateActivityAttributes(Object activity, ArrayList<BranchActivityEntryDTO> branchMappings) {
        if (activity instanceof SynchGateActivity) {
            this.addSynchGateActivityAttributes((SynchGateActivity)activity);
        } else if (activity instanceof PermissionGateActivity) {
            this.addPermissionGateActivityAttributes((PermissionGateActivity)activity);
        } else if (activity instanceof ConditionGateActivity) {
            this.addConditionGateActivityAttributes((ConditionGateActivity)activity, branchMappings);
        } else if (activity instanceof SystemGateActivity) {
            this.addSystemGateActivityAttributes((SystemGateActivity)activity);
        } else {
            this.addScheduleGateActivityAttributes((ScheduleGateActivity)activity);
        }
        GateActivity gateActivity = (GateActivity)activity;
        this.gateActivityLevelID = gateActivity.getGateActivityLevelId();
        this.gateOpen = gateActivity.getGateOpen();
        this.adminURL = gateActivity.getSystemTool().getAdminUrl();
    }

    private void addConditionGateActivityAttributes(ConditionGateActivity activity, ArrayList<BranchActivityEntryDTO> branchMappings) {
        if (activity.getBranchActivityEntries() != null) {
            for (BranchActivityEntry ba : activity.getBranchActivityEntries()) {
                branchMappings.add(ba.getBranchActivityEntryDTO(this.toolActivityUIID));
            }
        }
    }

    private void addSynchGateActivityAttributes(SynchGateActivity activity) {
    }

    private void addPermissionGateActivityAttributes(PermissionGateActivity activity) {
    }

    private void addSystemGateActivityAttributes(SystemGateActivity activity) {
    }

    private void addScheduleGateActivityAttributes(ScheduleGateActivity activity) {
        this.gateStartTimeOffset = activity.getGateStartTimeOffset();
        this.gateEndTimeOffset = activity.getGateEndTimeOffset();
        this.gateActivityCompletionBased = activity.getGateActivityCompletionBased();
    }

    public Integer getActivityCategoryID() {
        return this.activityCategoryID;
    }

    public Long getActivityID() {
        return this.activityID;
    }

    public Integer getActivityTypeID() {
        return this.activityTypeID;
    }

    public Integer getActivityUIID() {
        return this.activityUIID;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public Long getCreateGroupingID() {
        return this.createGroupingID;
    }

    public Integer getCreateGroupingUIID() {
        return this.createGroupingUIID;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getGateActivityLevelID() {
        return this.gateActivityLevelID;
    }

    public Date getGateEndDateTime() {
        return this.gateEndDateTime;
    }

    public Long getGateEndTimeOffset() {
        return this.gateEndTimeOffset;
    }

    public Boolean getGateOpen() {
        return this.gateOpen;
    }

    public Date getGateStartDateTime() {
        return this.gateStartDateTime;
    }

    public Long getGateStartTimeOffset() {
        return this.gateStartTimeOffset;
    }

    public Boolean getGateActivityCompletionBased() {
        return this.gateActivityCompletionBased;
    }

    public void setGateActivityCompletionBased(Boolean gateActivityCompletionBased) {
        this.gateActivityCompletionBased = gateActivityCompletionBased;
    }

    public Long getGroupingID() {
        return this.groupingID;
    }

    public Integer getGroupingUIID() {
        return this.groupingUIID;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public Long getLearningLibraryID() {
        return this.learningLibraryID;
    }

    public Long getLibraryActivityID() {
        return this.libraryActivityID;
    }

    public String getLibraryActivityUIImage() {
        return this.libraryActivityUIImage;
    }

    public Integer getMaxActivities() {
        return this.maxActivities;
    }

    public Integer getMaxOptions() {
        return this.maxOptions;
    }

    public Integer getMinOptions() {
        return this.minOptions;
    }

    public String getOptionsInstructions() {
        return this.optionsInstructions;
    }

    public Integer getOrderID() {
        return this.orderID;
    }

    public Long getParentActivityID() {
        return this.parentActivityID;
    }

    public Integer getParentUIID() {
        return this.parentUIID;
    }

    public String getActivityTitle() {
        return this.activityTitle;
    }

    public Long getToolContentID() {
        return this.toolContentID;
    }

    public Long getToolID() {
        return this.toolID;
    }

    public Integer getxCoord() {
        return this.xCoord;
    }

    public Integer getyCoord() {
        return this.yCoord;
    }

    public String getAuthoringURL() {
        return this.authoringURL;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public String getLanguageFile() {
        return this.languageFile;
    }

    public String getToolDisplayName() {
        return this.toolDisplayName;
    }

    public String getContributeURL() {
        return this.contributeURL;
    }

    public String getMonitoringURL() {
        return this.monitoringURL;
    }

    public String getModerationURL() {
        return this.moderationURL;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public String getToolSignature() {
        return this.toolSignature;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public Boolean getInitialised() {
        return this.initialised;
    }

    public Boolean getStopAfterActivity() {
        return this.stopAfterActivity;
    }

    public Boolean getApplyGrouping() {
        return this.applyGrouping;
    }

    public Integer getGroupingSupportType() {
        return this.groupingSupportType;
    }

    public Integer getGroupingType() {
        return this.groupingType;
    }

    public Integer getDefaultActivityUIID() {
        return this.defaultActivityUIID;
    }

    public Integer getEndXCoord() {
        return this.endXCoord;
    }

    public Integer getEndYCoord() {
        return this.endYCoord;
    }

    public Integer getStartXCoord() {
        return this.startXCoord;
    }

    public Integer getStartYCoord() {
        return this.startYCoord;
    }

    public void setActivityCategoryID(Integer activityCategoryID) {
        this.activityCategoryID = activityCategoryID;
    }

    public void setActivityID(Long activityId) {
        this.activityID = activityId;
    }

    public void setActivityTypeID(Integer activityTypeId) {
        this.activityTypeID = activityTypeId;
    }

    public void setActivityUIID(Integer activityUIID) {
        this.activityUIID = activityUIID;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    public void setCreateGroupingID(Long createGroupingID) {
        this.createGroupingID = createGroupingID;
    }

    public void setCreateGroupingUIID(Integer createGroupingUIID) {
        this.createGroupingUIID = createGroupingUIID;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGateActivityLevelID(Integer gateActivityLevelID) {
        this.gateActivityLevelID = gateActivityLevelID;
    }

    public void setGateEndDateTime(Date gateEndDateTime) {
        this.gateEndDateTime = gateEndDateTime;
    }

    public void setGateEndTimeOffset(Long gateEndTimeOffset) {
        this.gateEndTimeOffset = gateEndTimeOffset;
    }

    public void setGateOpen(Boolean gateOpen) {
        this.gateOpen = gateOpen;
    }

    public void setGateStartDateTime(Date gateStartDateTime) {
        this.gateStartDateTime = gateStartDateTime;
    }

    public void setGateStartTimeOffset(Long gateStartTimeOffset) {
        this.gateStartTimeOffset = gateStartTimeOffset;
    }

    public void setGroupingID(Long groupingID) {
        this.groupingID = groupingID;
    }

    public void setGroupingUIID(Integer groupingUIID) {
        this.groupingUIID = groupingUIID;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void setLearningDesignID(Long learningDesignID) {
        this.learningDesignID = learningDesignID;
    }

    public void setLearningLibraryID(Long learningLibraryID) {
        this.learningLibraryID = learningLibraryID;
    }

    public void setLibraryActivityID(Long libraryActivityID) {
        this.libraryActivityID = libraryActivityID;
    }

    public void setLibraryActivityUIImage(String libraryActivityUiImage) {
        this.libraryActivityUIImage = libraryActivityUiImage;
    }

    public void setMaxActivities(Integer maxActivities) {
        this.maxActivities = maxActivities;
    }

    public void setMaxOptions(Integer maxOptions) {
        this.maxOptions = maxOptions;
    }

    public void setMinOptions(Integer minOptions) {
        this.minOptions = minOptions;
    }

    public void setOptionsInstructions(String optionsInstructions) {
        this.optionsInstructions = optionsInstructions;
    }

    public void setOrderID(Integer orderID) {
        this.orderID = orderID;
    }

    public void setParentActivityID(Long parentActivityID) {
        this.parentActivityID = parentActivityID;
    }

    public void setParentUIID(Integer parentUIID) {
        this.parentUIID = parentUIID;
    }

    public void setActivityTitle(String title) {
        this.activityTitle = title;
    }

    public void setToolContentID(Long toolContentID) {
        this.toolContentID = toolContentID;
    }

    public void setToolID(Long toolID) {
        this.toolID = toolID;
    }

    public void setxCoord(Integer xcoord) {
        this.xCoord = xcoord;
    }

    public void setyCoord(Integer ycoord) {
        this.yCoord = ycoord;
    }

    public void setApplyGrouping(Boolean applyGrouping) {
        this.applyGrouping = applyGrouping;
    }

    public void setGroupingSupportType(Integer groupingSupportType) {
        this.groupingSupportType = groupingSupportType;
    }

    public void setGroupingType(Integer groupingType) {
        this.groupingType = groupingType;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setAuthoringURL(String toolAuthoringURL) {
        this.authoringURL = toolAuthoringURL;
    }

    public void setToolDisplayName(String toolDisplayName) {
        this.toolDisplayName = toolDisplayName;
    }

    public void setLanguageFile(String languageFile) {
        this.languageFile = languageFile;
    }

    public void setContributeURL(String contributeURL) {
        this.contributeURL = contributeURL;
    }

    public void setMonitoringURL(String monitoringURL) {
        this.monitoringURL = monitoringURL;
    }

    public void setModerationURL(String moderationURL) {
        this.moderationURL = moderationURL;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public void setToolSignature(String toolSignature) {
        this.toolSignature = toolSignature;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public void setInitialised(Boolean initialised) {
        this.initialised = initialised;
    }

    public void setStopAfterActivity(Boolean stopAfterActivity) {
        this.stopAfterActivity = stopAfterActivity;
    }

    public void setDefaultActivityUIID(Integer defaultActivityUIID) {
        this.defaultActivityUIID = defaultActivityUIID;
    }

    public void setEndXCoord(Integer endXCoord) {
        this.endXCoord = endXCoord;
    }

    public void setEndYCoord(Integer endYCoord) {
        this.endYCoord = endYCoord;
    }

    public void setStartXCoord(Integer startXCoord) {
        this.startXCoord = startXCoord;
    }

    public void setStartYCoord(Integer startYCoord) {
        this.startYCoord = startYCoord;
    }

    public String getAdminURL() {
        return this.adminURL;
    }

    public void setAdminURL(String adminURL) {
        this.adminURL = adminURL;
    }

    public ArrayList<Integer> getInputActivities() {
        return this.inputActivities;
    }

    public void setInputActivities(ArrayList<Integer> inputActivities) {
        this.inputActivities = inputActivities;
    }

    public Integer getToolActivityUIID() {
        return this.toolActivityUIID;
    }

    public void setToolActivityUIID(Integer toolActivityUIID) {
        this.toolActivityUIID = toolActivityUIID;
    }

    public Boolean getSupportsOutputs() {
        return this.supportsOutputs;
    }

    public void setSupportsOutputs(Boolean supportsOutputs) {
        this.supportsOutputs = supportsOutputs;
    }

    public String getExtLmsId() {
        return this.extLmsId;
    }

    public void setExtLmsId(String extLmsId) {
        this.extLmsId = extLmsId;
    }

    public ArrayList<String> getCompetenceMappingTitles() {
        return this.competenceMappingTitles;
    }

    public void setCompetenceMappingTitles(ArrayList<String> competenceMappingTitles) {
        this.competenceMappingTitles = competenceMappingTitles;
    }

    public List<String> getEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation(List<String> evaluation) {
        this.evaluation = evaluation;
    }

    public PlannerActivityMetadataDTO getPlannerMetadataDTO() {
        return this.plannerMetadataDTO;
    }

    public void setPlannerMetadataDTO(PlannerActivityMetadataDTO plannerActivityMetadata) {
        this.plannerMetadataDTO = plannerActivityMetadata;
    }
}

