/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupDAO;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.usermanagement.FavoriteOrganisation;
import org.lamsfoundation.lams.usermanagement.ForgotPasswordRequest;
import org.lamsfoundation.lams.usermanagement.IUserDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationGroup;
import org.lamsfoundation.lams.usermanagement.OrganisationGrouping;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IFavoriteOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dao.IRoleDAO;
import org.lamsfoundation.lams.usermanagement.dao.IUserOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserManageBean;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.HashUtil;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.imgscalr.ResizePictureUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UserManagementService
implements IUserManagementService {
    private Logger log = Logger.getLogger(UserManagementService.class);
    private static final String SEQUENCES_FOLDER_NAME_KEY = "runsequences.folder.name";
    private IBaseDAO baseDAO;
    private IGroupDAO groupDAO;
    private IRoleDAO roleDAO;
    private IOrganisationDAO organisationDAO;
    private IUserDAO userDAO;
    private IUserOrganisationDAO userOrganisationDAO;
    private IFavoriteOrganisationDAO favoriteOrganisationDAO;
    protected MessageService messageService;
    private static ILogEventService logEventService;
    private IToolContentHandler centralToolContentHandler;

    @Override
    public void save(Object object) {
        this.baseDAO.insertOrUpdate(object);
    }

    @Override
    public User saveUser(User user) {
        if (user != null) {
            WorkspaceFolder workspaceFolder;
            if (user.getUserId() == null) {
                this.baseDAO.insertOrUpdate(user);
                user = this.createWorkspaceFolderForUser(user);
            }
            if ((workspaceFolder = user.getWorkspaceFolder()) != null && !StringUtils.equals((String)user.getFullName(), (String)workspaceFolder.getName())) {
                workspaceFolder.setName(user.getFullName());
                this.save(workspaceFolder);
            }
            user.setModifiedDate(new Date());
            this.baseDAO.insertOrUpdate(user);
        }
        return user;
    }

    @Override
    public void saveOrganisationGrouping(OrganisationGrouping grouping, Collection<OrganisationGroup> newGroups) {
        if (grouping.getGroupingId() == null) {
            grouping.setGroups(new HashSet<OrganisationGroup>());
            this.baseDAO.insert(grouping);
        }
        if (newGroups != null) {
            HashSet<OrganisationGroup> obsoleteGroups = new HashSet<OrganisationGroup>(grouping.getGroups());
            for (OrganisationGroup newGroup : newGroups) {
                OrganisationGroup existingGroup = null;
                for (OrganisationGroup existingGroupCandidate : grouping.getGroups()) {
                    if (!existingGroupCandidate.equals(newGroup)) continue;
                    existingGroup = existingGroupCandidate;
                    break;
                }
                if (existingGroup == null) {
                    newGroup.setGroupingId(grouping.getGroupingId());
                    grouping.getGroups().add(newGroup);
                    this.baseDAO.insert(newGroup);
                    continue;
                }
                obsoleteGroups.remove(existingGroup);
                existingGroup.setName(newGroup.getName());
                existingGroup.setUsers(newGroup.getUsers());
                this.baseDAO.update(existingGroup);
            }
            for (OrganisationGroup obsoleteGroup : obsoleteGroups) {
                grouping.getGroups().remove(obsoleteGroup);
                this.baseDAO.delete(obsoleteGroup);
            }
        }
    }

    @Override
    public void delete(Object object) {
        this.baseDAO.delete(object);
    }

    @Override
    public void deleteAll(Collection objects) {
        this.baseDAO.deleteAll(objects);
    }

    @Override
    public void deleteById(Class clazz, Serializable id) {
        this.baseDAO.deleteById(clazz, id);
    }

    @Override
    public Object findById(Class clazz, Serializable id) {
        return this.baseDAO.find(clazz, id);
    }

    @Override
    public List findAll(Class clazz) {
        return this.baseDAO.findAll(clazz);
    }

    @Override
    public List findByProperty(Class clazz, String name, Object value) {
        return this.baseDAO.findByProperty(clazz, name, value);
    }

    @Override
    public List findByProperties(Class clazz, Map<String, Object> properties) {
        return this.baseDAO.findByProperties(clazz, properties);
    }

    @Override
    public List<User> getUsersFromOrganisation(Integer orgId) {
        String query = "select uo.user from UserOrganisation uo where uo.organisation.organisationId=" + orgId + " order by uo.user.login";
        return this.baseDAO.find(query);
    }

    @Override
    public Vector getUsersFromOrganisationByRole(Integer organisationID, String roleName, boolean getUser) {
        Vector<Serializable> users = null;
        users = getUser ? new Vector<Serializable>() : new Vector();
        String query = "SELECT uo.user FROM UserOrganisation uo INNER JOIN uo.userOrganisationRoles r WHERE uo.organisation.organisationId=" + organisationID + " AND r.role.name= '" + roleName + "'";
        List queryResult = this.baseDAO.find(query);
        for (User user : queryResult) {
            if (getUser) {
                users.add(user);
                continue;
            }
            users.add(user.getUserDTO());
        }
        return users;
    }

    @Override
    public List<Organisation> getFavoriteOrganisationsByUser(Integer userId) {
        return this.favoriteOrganisationDAO.getFavoriteOrganisationsByUser(userId);
    }

    @Override
    public boolean isOrganisationFavorite(Integer organisationId, Integer userId) {
        return this.favoriteOrganisationDAO.isOrganisationFavorite(organisationId, userId);
    }

    @Override
    public void toggleOrganisationFavorite(Integer orgId, Integer userId) {
        FavoriteOrganisation favoriteOrganisation = this.favoriteOrganisationDAO.getFavoriteOrganisation(orgId, userId);
        if (favoriteOrganisation == null) {
            User user = (User)this.findById(User.class, userId);
            Organisation organisation = (Organisation)this.findById(Organisation.class, orgId);
            favoriteOrganisation = new FavoriteOrganisation(user, organisation);
            this.save(favoriteOrganisation);
        } else {
            this.delete(favoriteOrganisation);
        }
    }

    @Override
    public Organisation getRootOrganisation() {
        return (Organisation)this.baseDAO.findByProperty(Organisation.class, "organisationType.organisationTypeId", OrganisationType.ROOT_TYPE).get(0);
    }

    @Override
    public boolean isUserInRole(Integer userId, Integer orgId, String roleName) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("userOrganisation.user.userId", userId);
        properties.put("userOrganisation.organisation.organisationId", orgId);
        properties.put("role.name", roleName);
        return this.baseDAO.findByProperties(UserOrganisationRole.class, properties).size() != 0;
    }

    @Override
    public List getOrganisationsByTypeAndStatus(Integer typeId, Integer stateId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("organisationType.organisationTypeId", typeId);
        properties.put("organisationState.organisationStateId", stateId);
        return this.baseDAO.findByProperties(Organisation.class, properties);
    }

    @Override
    public List<Organisation> getPagedCourses(Integer parentOrgId, Integer typeId, Integer stateId, int page, int size, String sortBy, String sortOrder, String searchString) {
        return this.organisationDAO.getPagedCourses(parentOrgId, typeId, stateId, page, size, sortBy, sortOrder, searchString);
    }

    @Override
    public int getCountCoursesByParentCourseAndTypeAndState(Integer parentOrgId, Integer typeId, Integer stateId, String searchString) {
        return this.organisationDAO.getCountCoursesByParentCourseAndTypeAndState(parentOrgId, typeId, stateId, searchString);
    }

    @Override
    public List getUserOrganisationRoles(Integer orgId, String login) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("userOrganisation.organisation.organisationId", orgId);
        properties.put("userOrganisation.user.login", login);
        return this.baseDAO.findByProperties(UserOrganisationRole.class, properties);
    }

    @Override
    public Map<Integer, Set<Integer>> getRolesForUser(Integer userId) {
        return this.findByProperty(UserOrganisation.class, "user.userId", userId).stream().collect(Collectors.toMap(userOrganisation -> userOrganisation.getOrganisation().getOrganisationId(), userOrganisation -> userOrganisation.getUserOrganisationRoles().stream().map(userOrganisationRole -> userOrganisationRole.getRole().getRoleId()).collect(Collectors.toSet())));
    }

    @Override
    public List getUserOrganisationsForUserByTypeAndStatus(String login, Integer typeId, Integer stateId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.login", login);
        properties.put("organisation.organisationType.organisationTypeId", typeId);
        properties.put("organisation.organisationState.organisationStateId", stateId);
        return this.baseDAO.findByProperties(UserOrganisation.class, properties);
    }

    @Override
    public List getUserOrganisationsForUserByTypeAndStatusAndParent(String login, Integer typeId, Integer stateId, Integer parentOrgId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.login", login);
        properties.put("organisation.organisationType.organisationTypeId", typeId);
        properties.put("organisation.organisationState.organisationStateId", stateId);
        properties.put("organisation.parentOrganisation.organisationId", parentOrgId);
        return this.baseDAO.findByProperties(UserOrganisation.class, properties);
    }

    @Override
    public User getUserByLogin(String login) {
        List results = this.baseDAO.findByProperty(User.class, "login", login);
        return results.isEmpty() ? null : (User)results.get(0);
    }

    @Override
    public void updatePassword(String login, String password) {
        try {
            User user = this.getUserByLogin(login);
            String salt = HashUtil.salt();
            user.setSalt(salt);
            user.setPassword(HashUtil.sha256(password, salt));
            this.baseDAO.update(user);
        }
        catch (Exception e) {
            this.log.debug((Object)e);
        }
    }

    @Override
    public UserOrganisation getUserOrganisation(Integer userId, Integer orgId) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("user.userId", userId);
        properties.put("organisation.organisationId", orgId);
        List results = this.baseDAO.findByProperties(UserOrganisation.class, properties);
        return results.isEmpty() ? null : (UserOrganisation)results.get(0);
    }

    private User createWorkspaceFolderForUser(User user) {
        WorkspaceFolder folder = new WorkspaceFolder(user.getFullName(), user.getUserId(), new Date(), new Date(), WorkspaceFolder.NORMAL);
        this.save(folder);
        user.setWorkspaceFolder(folder);
        return user;
    }

    private void createWorkspaceFoldersForOrganisation(Organisation organisation, Integer userID, Date createDateTime) {
        WorkspaceFolder workspaceFolder = new WorkspaceFolder(organisation.getName(), userID, createDateTime, createDateTime, WorkspaceFolder.NORMAL);
        workspaceFolder.setOrganisationID(organisation.getOrganisationId());
        this.save(workspaceFolder);
        String description = this.getRunSequencesFolderName(organisation.getName());
        WorkspaceFolder workspaceFolder2 = new WorkspaceFolder(description, userID, createDateTime, createDateTime, WorkspaceFolder.RUN_SEQUENCES);
        workspaceFolder2.setOrganisationID(organisation.getOrganisationId());
        workspaceFolder2.setParentWorkspaceFolder(workspaceFolder);
        this.save(workspaceFolder2);
        workspaceFolder.addChild(workspaceFolder2);
        this.save(workspaceFolder);
        HashSet<WorkspaceFolder> folders = new HashSet<WorkspaceFolder>();
        folders.add(workspaceFolder);
        folders.add(workspaceFolder2);
        organisation.setWorkspaceFolders(folders);
    }

    @Override
    public Organisation saveOrganisation(Organisation organisation, Integer userID) {
        User creator = (User)this.findById(User.class, userID);
        if (organisation.getOrganisationId() == null) {
            Date createDateTime = new Date();
            organisation.setCreateDate(createDateTime);
            organisation.setCreatedBy(creator);
            this.save(organisation);
            if (organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE)) {
                this.createWorkspaceFoldersForOrganisation(organisation, userID, createDateTime);
            }
            if (organisation.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE)) {
                Organisation pOrg = organisation.getParentOrganisation();
                HashSet<Organisation> children = pOrg.getChildOrganisations();
                if (children == null) {
                    children = new HashSet<Organisation>();
                }
                children.add(organisation);
                pOrg.setChildOrganisations(children);
                Vector managers = this.getUsersFromOrganisationByRole(pOrg.getOrganisationId(), "GROUP MANAGER", false);
                for (UserDTO m : managers) {
                    User user = (User)this.findById(User.class, m.getUserID());
                    UserOrganisation uo = new UserOrganisation(user, organisation);
                    this.log.debug((Object)("adding course manager: " + user.getUserId() + " as staff"));
                    UserOrganisationRole uor = new UserOrganisationRole(uo, (Role)this.findById(Role.class, Role.ROLE_MONITOR));
                    HashSet<UserOrganisationRole> uors = new HashSet<UserOrganisationRole>();
                    uors.add(uor);
                    uo.setUserOrganisationRoles(uors);
                    HashSet<UserOrganisation> uos = organisation.getUserOrganisations();
                    if (uos == null) {
                        uos = new HashSet<UserOrganisation>();
                    }
                    uos.add(uo);
                    organisation.setUserOrganisations(uos);
                    this.save(uo);
                }
            }
        } else {
            WorkspaceFolder folder = organisation.getNormalFolder();
            if (folder != null) {
                folder.setName(organisation.getName());
            }
            if ((folder = organisation.getRunSequencesFolder()) != null) {
                folder.setName(this.getRunSequencesFolderName(organisation.getName()));
            }
        }
        return organisation;
    }

    @Override
    public void updateOrganisationAndWorkspaceFolderNames(Organisation organisation) {
        this.baseDAO.update(organisation);
        WorkspaceFolder folder = organisation.getNormalFolder();
        folder.setName(organisation.getName());
        this.baseDAO.update(folder);
        folder = organisation.getRunSequencesFolder();
        folder.setName(this.getRunSequencesFolderName(organisation.getName()));
        this.baseDAO.update(folder);
    }

    private String getRunSequencesFolderName(String workspaceName) {
        String[] tokenisedLocale = LanguageUtil.getDefaultLangCountry();
        Locale serverLocale = new Locale(tokenisedLocale[0], tokenisedLocale[1]);
        String runSeqName = this.messageService.getMessageSource().getMessage(SEQUENCES_FOLDER_NAME_KEY, new Object[]{workspaceName}, serverLocale);
        if (runSeqName != null && runSeqName.startsWith("???")) {
            this.log.warn((Object)"Problem in the language file - can't find an entry for runsequences.folder.name. Creating folder as \"run sequences\" ");
            runSeqName = "run sequences";
        }
        return runSeqName;
    }

    @Override
    public List<UserManageBean> getUserManageBeans(Integer orgId) {
        String query = "select u.userId,u.login,u.title,u.firstName,u.lastName, r from User u left join u.userOrganisations as uo left join uo.userOrganisationRoles as uor left join uor.role as r where uo.organisation.organisationId=?";
        List list = this.baseDAO.find(query, (Object)orgId);
        HashMap<Integer, UserManageBean> beansMap = new HashMap<Integer, UserManageBean>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] data = (Object[])list.get(i);
            if (beansMap.containsKey(data[0])) {
                ((UserManageBean)beansMap.get(data[0])).getRoles().add((Role)data[5]);
                continue;
            }
            UserManageBean bean = new UserManageBean();
            bean.setUserId((Integer)data[0]);
            bean.setLogin((String)data[1]);
            bean.setTitle((String)data[2]);
            bean.setFirstName((String)data[3]);
            bean.setLastName((String)data[4]);
            bean.getRoles().add((Role)data[5]);
            beansMap.put((Integer)data[0], bean);
        }
        ArrayList<UserManageBean> userManageBeans = new ArrayList<UserManageBean>();
        userManageBeans.addAll(beansMap.values());
        return userManageBeans;
    }

    @Override
    public void removeUser(Integer userId) throws Exception {
        User user = (User)this.findById(User.class, userId);
        if (user != null) {
            if (this.userHasData(user).booleanValue()) {
                throw new Exception("Cannot remove User ID " + userId + ". User has data.");
            }
            this.log.debug((Object)("deleting user " + user.getLogin()));
            this.delete(user);
        } else {
            this.log.error((Object)("Requested delete of a user who does not exist. User ID " + userId));
        }
    }

    @Override
    public Boolean userHasData(User user) {
        if (user.getLearnerProgresses() != null && !user.getLearnerProgresses().isEmpty()) {
            this.log.debug((Object)("user has data, learnerProgresses: " + user.getLearnerProgresses().size()));
            return true;
        }
        if (user.getUserToolSessions() != null && !user.getUserToolSessions().isEmpty()) {
            this.log.debug((Object)("user has data, userToolSessions: " + user.getUserToolSessions().size()));
            return true;
        }
        if (user.getLearningDesigns() != null && !user.getLearningDesigns().isEmpty()) {
            this.log.debug((Object)("user has data, learningDesigns: " + user.getLearningDesigns().size()));
            return true;
        }
        if (user.getLessons() != null && !user.getLessons().isEmpty()) {
            this.log.debug((Object)("user has data, lessons: " + user.getLessons().size()));
            return true;
        }
        int numLessonGroups = this.groupDAO.getCountGroupsForUser(user.getUserId());
        if (numLessonGroups > 0) {
            this.log.debug((Object)("user has data, userGroups: " + numLessonGroups));
            return true;
        }
        return false;
    }

    @Override
    public void disableUser(Integer userId) {
        User user = (User)this.findById(User.class, userId);
        user.setDisabledFlag(true);
        Set uos = user.getUserOrganisations();
        Iterator iter = uos.iterator();
        while (iter.hasNext()) {
            UserOrganisation uo = (UserOrganisation)iter.next();
            this.log.debug((Object)("removing membership of: " + uo.getOrganisation().getName()));
            this.delete(uo);
            iter.remove();
        }
        this.log.debug((Object)("disabling user " + user.getLogin()));
        this.saveUser(user);
    }

    @Override
    public void setRolesForUserOrganisation(Integer userId, Integer organisationId, Set<Integer> roleIDList) {
        User user = (User)this.findById(User.class, userId);
        this.setRolesForUserOrganisation(user, organisationId, roleIDList.stream().map(String::valueOf).collect(Collectors.toList()));
    }

    @Override
    public void setRolesForUserOrganisation(User user, Integer organisationId, List<String> rolesList) {
        Organisation org = (Organisation)this.findById(Organisation.class, organisationId);
        this.setRolesForUserOrganisation(user, org, rolesList);
    }

    private void setRolesForUserOrganisation(User user, Organisation org, List<String> rolesList) {
        UserOrganisation uo = this.getUserOrganisation(user.getUserId(), org.getOrganisationId());
        if (uo == null) {
            uo = new UserOrganisation(user, org);
            this.save(uo);
            this.log.debug((Object)("added " + user.getLogin() + " to " + org.getName()));
            HashSet<UserOrganisation> uos = org.getUserOrganisations();
            if (uos == null) {
                uos = new HashSet<UserOrganisation>();
            }
            uos.add(uo);
        }
        if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) && this.getUserOrganisation(user.getUserId(), org.getParentOrganisation().getOrganisationId()) == null) {
            this.setRolesForUserOrganisation(user, org.getParentOrganisation(), rolesList);
        }
        ArrayList<String> rolesCopy = new ArrayList<String>();
        rolesCopy.addAll(rolesList);
        this.log.debug((Object)("rolesList.size: " + rolesList.size()));
        Set<UserOrganisationRole> uors = uo.getUserOrganisationRoles();
        HashSet<UserOrganisationRole> uorsCopy = new HashSet<UserOrganisationRole>();
        if (uors != null) {
            uorsCopy.addAll(uors);
            for (String roleId : rolesList) {
                for (UserOrganisationRole uor : uors) {
                    if (!uor.getRole().getRoleId().toString().equals(roleId)) continue;
                    rolesCopy.remove(roleId);
                    uorsCopy.remove(uor);
                }
            }
            this.log.debug((Object)("removing roles: " + uorsCopy));
            uors.removeAll(uorsCopy);
        } else {
            uors = new HashSet<UserOrganisationRole>();
        }
        for (String roleId : rolesCopy) {
            UserOrganisationRole uor;
            if (roleId == null) continue;
            Role role = (Role)this.findById(Role.class, Integer.valueOf(Integer.parseInt(roleId)));
            uor = new UserOrganisationRole(uo, role);
            this.save(uor);
            this.log.debug((Object)("setting role: " + role.getName() + " in organisation: " + org.getName()));
            uors.add(uor);
            if (!role.getName().equals("AUTHOR") && !role.getName().equals("SYSADMIN") || user.getWorkspaceFolder() != null) continue;
            this.createWorkspaceFolderForUser(user);
        }
        uo.setUserOrganisationRoles(uors);
        this.saveUser(user);
        this.checkGroupManager(user, org);
    }

    private void checkGroupManager(User user, Organisation org) {
        if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE)) {
            if (this.hasRoleInOrganisation(user, Role.ROLE_GROUP_MANAGER, org)) {
                this.setRolesForGroupManager(user, org.getChildOrganisations());
            }
        } else if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE) && this.hasRoleInOrganisation(user, Role.ROLE_GROUP_MANAGER, org.getParentOrganisation())) {
            this.setRolesForGroupManager(user, org.getParentOrganisation().getChildOrganisations());
        }
    }

    private void setRolesForGroupManager(User user, Set childOrgs) {
        for (Object o : childOrgs) {
            Organisation org = (Organisation)o;
            UserOrganisation uo = this.getUserOrganisation(user.getUserId(), org.getOrganisationId());
            if (uo == null) {
                uo = new UserOrganisation(user, org);
                this.save(uo);
                Set uos = org.getUserOrganisations();
                uos.add(uo);
                this.log.debug((Object)("added " + user.getLogin() + " to " + org.getName()));
                uo = this.setRoleForUserOrganisation(uo, (Role)this.findById(Role.class, Role.ROLE_MONITOR));
                uo = this.setRoleForUserOrganisation(uo, (Role)this.findById(Role.class, Role.ROLE_LEARNER));
                this.save(uo);
                return;
            }
            Set<UserOrganisationRole> uors = uo.getUserOrganisationRoles();
            if (uors == null || uors.isEmpty()) continue;
            boolean isMonitor = false;
            boolean isLearner = false;
            for (UserOrganisationRole uor : uors) {
                if (uor.getRole().getName().equals("MONITOR")) {
                    isMonitor = true;
                } else if (uor.getRole().getName().equals("LEARNER")) {
                    isLearner = true;
                }
                if (!isMonitor || !isLearner) continue;
                break;
            }
            if (!isMonitor) {
                uo = this.setRoleForUserOrganisation(uo, (Role)this.findById(Role.class, Role.ROLE_MONITOR));
            }
            if (!isLearner) {
                uo = this.setRoleForUserOrganisation(uo, (Role)this.findById(Role.class, Role.ROLE_LEARNER));
            }
            this.save(uo);
        }
    }

    private UserOrganisation setRoleForUserOrganisation(UserOrganisation uo, Role role) {
        UserOrganisationRole uor = new UserOrganisationRole(uo, role);
        this.save(uor);
        uo.addUserOrganisationRole(uor);
        this.log.debug((Object)("setting role: " + uor.getRole().getName() + " in organisation: " + uor.getUserOrganisation().getOrganisation().getName()));
        return uo;
    }

    @Override
    public List<Role> filterRoles(List<Role> rolelist, Boolean isSysadmin, OrganisationType orgType) {
        ArrayList<Role> allRoles = new ArrayList<Role>();
        allRoles.addAll(rolelist);
        Role role = new Role();
        if (!orgType.getOrganisationTypeId().equals(OrganisationType.ROOT_TYPE) || !isSysadmin.booleanValue()) {
            role.setRoleId(Role.ROLE_SYSADMIN);
            allRoles.remove(role);
        } else {
            role.setRoleId(Role.ROLE_AUTHOR);
            allRoles.remove(role);
            role.setRoleId(Role.ROLE_LEARNER);
            allRoles.remove(role);
            role.setRoleId(Role.ROLE_MONITOR);
            allRoles.remove(role);
        }
        if (!orgType.getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE)) {
            role.setRoleId(Role.ROLE_GROUP_MANAGER);
            allRoles.remove(role);
            if (!orgType.getOrganisationTypeId().equals(OrganisationType.ROOT_TYPE)) {
                role.setRoleId(Role.ROLE_GROUP_ADMIN);
                allRoles.remove(role);
            }
        }
        return allRoles;
    }

    @Override
    public boolean hasRoleInOrganisation(User user, Integer roleId) {
        return this.hasRoleInOrganisation(user, roleId, this.getRootOrganisation());
    }

    @Override
    public boolean hasRoleInOrganisation(User user, Integer roleId, Organisation organisation) {
        return this.roleDAO.getUserByOrganisationAndRole(user.getUserId(), roleId, organisation) != null;
    }

    @Override
    public void deleteChildUserOrganisations(User user, Organisation org) {
        if (!org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.COURSE_TYPE)) {
            return;
        }
        Set childOrgs = org.getChildOrganisations();
        for (Organisation childOrg : childOrgs) {
            Set childOrgUos = childOrg.getUserOrganisations();
            UserOrganisation uo = this.getUserOrganisation(user.getUserId(), childOrg.getOrganisationId());
            if (uo == null) continue;
            childOrgUos.remove(uo);
            childOrg.setUserOrganisations(childOrgUos);
            this.save(childOrg);
            Set userUos = user.getUserOrganisations();
            userUos.remove(uo);
            user.setUserOrganisations(userUos);
            this.log.debug((Object)("removed userId=" + user.getUserId() + " from orgId=" + childOrg.getOrganisationId()));
        }
    }

    @Override
    public void deleteUserOrganisation(User user, Organisation org) {
        UserOrganisation uo = this.getUserOrganisation(user.getUserId(), org.getOrganisationId());
        if (uo != null) {
            org.getUserOrganisations().remove(uo);
            this.save(org);
            user.getUserOrganisations().remove(uo);
            this.log.debug((Object)("Removed user " + user.getUserId() + " from organisation " + org.getOrganisationId()));
            if (org.getOrganisationType().equals(OrganisationType.COURSE_TYPE)) {
                this.deleteChildUserOrganisations(user, org);
            }
        }
    }

    private Integer getRequestorId() {
        UserDTO userDTO = (UserDTO)SessionManager.getSession().getAttribute("user");
        return userDTO != null ? userDTO.getUserID() : null;
    }

    @Override
    public boolean isUserGlobalGroupAdmin() {
        Integer rootOrgId = this.getRootOrganisation().getOrganisationId();
        Integer requestorId = this.getRequestorId();
        return requestorId != null ? this.isUserInRole(requestorId, rootOrgId, "GROUP ADMIN") : false;
    }

    @Override
    public boolean isUserSysAdmin() {
        Integer rootOrgId = this.getRootOrganisation().getOrganisationId();
        Integer requestorId = this.getRequestorId();
        return requestorId != null ? this.isUserInRole(requestorId, rootOrgId, "SYSADMIN") : false;
    }

    @Override
    public Integer getCountRoleForOrg(Integer orgId, Integer[] roleIds, String searchPhrase) {
        Integer count = this.roleDAO.getCountRoleForOrg(roleIds, orgId, searchPhrase);
        if (count != null) {
            return count;
        }
        return new Integer(0);
    }

    @Override
    public Integer getCountRoleForOrg(Integer orgId, Integer roleId, String searchPhrase) {
        return this.getCountRoleForOrg(orgId, new Integer[]{roleId}, searchPhrase);
    }

    @Override
    public Theme getDefaultTheme() {
        String htmlName = Configuration.get(ConfigurationKeys.DEFAULT_THEME);
        List list = this.findByProperty(Theme.class, "name", "defaultHTML");
        return list != null ? (Theme)list.get(0) : null;
    }

    @Override
    public void logPasswordChanged(User user, User modifiedBy) {
        Object[] args = new String[]{user.getLogin() + "(" + user.getUserId() + ")"};
        String message = this.messageService.getMessage("audit.user.password.change", args);
        this.getLogEventService().logEvent(13, modifiedBy != null ? modifiedBy.getUserId() : null, user.getUserId(), null, null, message);
    }

    @Override
    public void logUserCreated(User user, User createdBy) {
        Object[] args = new String[]{user.getLogin() + "(" + user.getUserId() + ")", user.getFullName()};
        String message = this.messageService.getMessage("audit.user.create", args);
        this.getLogEventService().logEvent(11, createdBy != null ? createdBy.getUserId() : null, user.getUserId(), null, null, message);
    }

    @Override
    public void logUserCreated(User user, UserDTO createdBy) {
        Object[] args = new String[]{user.getLogin() + "(" + user.getUserId() + ")", user.getFullName()};
        String message = this.messageService.getMessage("audit.user.create", args);
        this.getLogEventService().logEvent(11, createdBy != null ? createdBy.getUserID() : null, user.getUserId(), null, null, message);
    }

    @Override
    public Integer getCountUsers() {
        String query = "SELECT count(u) FROM User u";
        return this.getFindIntegerResult(query);
    }

    @Override
    public int getCountUsers(String searchString) {
        return this.userDAO.getCountUsers(searchString);
    }

    @Override
    public Integer getCountUsers(Integer authenticationMethodId) {
        String query = "select count(u) from User u where u.authenticationMethod.authenticationMethodId=" + authenticationMethodId;
        return this.getFindIntegerResult(query);
    }

    private Integer getFindIntegerResult(String query) {
        List list = this.baseDAO.find(query);
        if (list != null && list.size() > 0) {
            return ((Number)list.get(0)).intValue();
        }
        return null;
    }

    @Override
    public List<OrganisationDTO> getActiveCoursesByUser(Integer userId, boolean isSysadmin, int page, int size, String searchString) {
        return this.organisationDAO.getActiveCoursesByUser(userId, isSysadmin, page, size, searchString);
    }

    @Override
    public int getCountActiveCoursesByUser(Integer userId, boolean isSysadmin, String searchString) {
        return this.organisationDAO.getCountActiveCoursesByUser(userId, isSysadmin, searchString);
    }

    @Override
    public List<User> findUsers(String searchPhrase) {
        return this.userDAO.findUsers(searchPhrase);
    }

    @Override
    public List<User> findUsers(String searchPhrase, Integer filteredOrgId) {
        return this.userDAO.findUsers(searchPhrase, filteredOrgId);
    }

    @Override
    public List<User> findUsers(String searchPhrase, Integer orgId, Integer filteredOrgId) {
        return this.userDAO.findUsers(searchPhrase, orgId, filteredOrgId);
    }

    @Override
    public List<User> findUsers(String searchPhrase, Integer orgId, boolean includeChildOrgs) {
        return this.userDAO.findUsers(searchPhrase, orgId, includeChildOrgs);
    }

    @Override
    public List<User> getAllUsers() {
        return this.userDAO.getAllUsers();
    }

    @Override
    public List<UserDTO> getAllUsers(Integer page, Integer size, String sortBy, String sortOrder, String searchString) {
        return this.userDAO.getAllUsersPaged(page, size, sortBy, sortOrder, searchString);
    }

    @Override
    public List<UserDTO> getAllUsers(Integer organisationID, String[] roleNames, Integer page, Integer size, String sortBy, String sortOrder, String searchString) {
        return this.userDAO.getAllUsersPaged(organisationID, roleNames, page, size, sortBy, sortOrder, searchString);
    }

    @Override
    public List<User> getAllUsers(Integer filteredOrgId) {
        return this.userDAO.findUsers(filteredOrgId);
    }

    @Override
    public List<User> getAllUsersWithEmail(String email) {
        return this.userDAO.findUsersWithEmail(email);
    }

    @Override
    public boolean canEditGroup(Integer userId, Integer orgId) {
        if (this.isUserSysAdmin() || this.isUserGlobalGroupAdmin()) {
            return true;
        }
        Organisation org = (Organisation)this.findById(Organisation.class, orgId);
        if (org != null) {
            Integer groupId = orgId;
            if (org.getOrganisationType().getOrganisationTypeId().equals(OrganisationType.CLASS_TYPE)) {
                groupId = org.getParentOrganisation().getOrganisationId();
            }
            return this.isUserInRole(userId, groupId, "GROUP ADMIN") || this.isUserInRole(userId, groupId, "GROUP MANAGER");
        }
        return false;
    }

    @Override
    public ForgotPasswordRequest getForgotPasswordRequest(String key) {
        List results = this.baseDAO.findByProperty(ForgotPasswordRequest.class, "requestKey", key);
        return results.isEmpty() ? null : (ForgotPasswordRequest)results.get(0);
    }

    @Override
    public int removeUserFromOtherGroups(Integer userId, Integer orgId) {
        List uos = this.userOrganisationDAO.userOrganisationsNotById(userId, orgId);
        this.deleteAll(uos);
        return uos.size();
    }

    @Override
    public User getUserDTOByOpenidURL(String openidURL) {
        List results = this.baseDAO.findByProperty(User.class, "openidURL", openidURL);
        return results.isEmpty() ? null : (User)results.get(0);
    }

    @Override
    public String[] getPortraitSQL(String userIdString) {
        String[] retValue = new String[]{", luser.portrait_uuid portraitId ", " JOIN lams_user luser ON luser.user_id = " + userIdString};
        return retValue;
    }

    @Override
    public List<String> uploadPortraits(Integer minUserId, Integer maxUserId, String prefix) throws IOException {
        File tmpDir = new File("/tmp/portraits");
        if (!tmpDir.canRead()) {
            throw new IOException("/tmp/portraits is not readable");
        }
        LinkedList<String> uploadedPortraits = new LinkedList<String>();
        Integer prefixLength = StringUtils.isBlank((String)prefix) ? null : Integer.valueOf(prefix.length() + 1);
        for (int userId = minUserId.intValue(); userId <= maxUserId; ++userId) {
            try {
                File portraitFile;
                User user = (User)this.baseDAO.find(User.class, Integer.valueOf(userId));
                if (user == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("User " + userId + " not found when batch uploading portraits, skipping"));
                    continue;
                }
                String login = user.getLogin();
                if (prefixLength != null) {
                    if (!login.startsWith(prefix)) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("User " + userId + " login \"" + login + "\" does not start with the required prefix \"" + prefix + "\" when batch uploading portraits"));
                        continue;
                    }
                    login = login.substring(prefixLength);
                }
                if (!(portraitFile = new File(tmpDir, login + ".jpg")).canRead() && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Portrait for user " + userId + " with login \"" + login + "\" was not found or can not be read when batch uploading portraits"));
                    continue;
                }
                FileInputStream is = new FileInputStream(portraitFile);
                String fileNameWithoutExt = login;
                NodeKey originalFileNode = this.centralToolContentHandler.uploadFile((InputStream)is, fileNameWithoutExt + "_original.jpg", "image/jpeg");
                is.close();
                this.log.debug((Object)("Saved original portrait with uuid: " + originalFileNode.getUuid() + " and version: " + originalFileNode.getVersion()));
                is = new FileInputStream(portraitFile);
                InputStream modifiedPortraitInputStream = ResizePictureUtil.resize(is, 200);
                NodeKey node = this.centralToolContentHandler.updateFile(originalFileNode.getUuid(), modifiedPortraitInputStream, fileNameWithoutExt + "_large.jpg", "image/jpeg");
                modifiedPortraitInputStream.close();
                is.close();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Saved large portrait with uuid: " + node.getUuid() + " and version: " + node.getVersion()));
                }
                is = new FileInputStream(portraitFile);
                modifiedPortraitInputStream = ResizePictureUtil.resize(is, 80);
                node = this.centralToolContentHandler.updateFile(node.getUuid(), modifiedPortraitInputStream, fileNameWithoutExt + "_medium.jpg", "image/jpeg");
                modifiedPortraitInputStream.close();
                is.close();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Saved medium portrait with uuid: " + node.getUuid() + " and version: " + node.getVersion()));
                }
                is = new FileInputStream(portraitFile);
                modifiedPortraitInputStream = ResizePictureUtil.resize(is, 35);
                node = this.centralToolContentHandler.updateFile(node.getUuid(), modifiedPortraitInputStream, fileNameWithoutExt + "_small.jpg", "image/jpeg");
                modifiedPortraitInputStream.close();
                is.close();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Saved small portrait with uuid: " + node.getUuid() + " and version: " + node.getVersion()));
                }
                if (user.getPortraitUuid() != null) {
                    this.centralToolContentHandler.deleteFile(user.getPortraitUuid());
                }
                user.setPortraitUuid(originalFileNode.getUuid());
                this.saveUser(user);
                this.log.info((Object)("Uploaded portrait for user " + userId + " with login \"" + login + "\""));
                uploadedPortraits.add(login);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"Error while batch uploading portraits", (Throwable)e);
            }
        }
        return uploadedPortraits;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setGroupDAO(IGroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setRoleDAO(IRoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setOrganisationDAO(IOrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setUserDAO(IUserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setUserOrganisationDAO(IUserOrganisationDAO userOrganisationDAO) {
        this.userOrganisationDAO = userOrganisationDAO;
    }

    public void setFavoriteOrganisationDAO(IFavoriteOrganisationDAO favoriteOrganisationDAO) {
        this.favoriteOrganisationDAO = favoriteOrganisationDAO;
    }

    private ILogEventService getLogEventService() {
        if (logEventService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)SessionManager.getServletContext());
            logEventService = (ILogEventService)ctx.getBean("logEventService");
        }
        return logEventService;
    }

    public void setCentralToolContentHandler(IToolContentHandler centralToolContentHandler) {
        this.centralToolContentHandler = centralToolContentHandler;
    }
}

