/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.support.OpenSessionInViewFilter;

public class CustomizedOpenSessionInViewFilter
extends OpenSessionInViewFilter {
    protected Session openSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        try {
            Session session = sessionFactory.openSession();
            session.setFlushMode(FlushMode.AUTO);
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
    }

    protected void closeSession(Session session) {
        session.flush();
        SessionFactoryUtils.closeSession((Session)session);
    }
}

