/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class VersionUtil {
    public static Long[] extractSystemVersionParts() throws NumberFormatException {
        return VersionUtil.extractVersionParts(Configuration.get(ConfigurationKeys.SERVER_VERSION_NUMBER));
    }

    public static Long[] extractVersionParts(String versionString) throws NumberFormatException {
        String[] split;
        Long[] versionParts = new Long[4];
        if (versionString != null && (split = versionString.split("[\\.]")).length > 0) {
            versionParts[0] = Long.parseLong(split[0]);
            if (split.length > 1) {
                versionParts[1] = Long.parseLong(split[1]);
                if (split.length > 2) {
                    versionParts[2] = Long.parseLong(split[2]);
                }
            }
        }
        return versionParts;
    }

    public static boolean isSameOrLaterVersion(String versionOneString, String versionTwoString) throws NumberFormatException {
        Long[] versionOne;
        Long[] versionTwo = VersionUtil.extractVersionParts(versionTwoString);
        int compareRes = VersionUtil.checkVersionPart(versionTwo[0], (versionOne = VersionUtil.extractVersionParts(versionOneString))[0]);
        if (compareRes < 0) {
            return false;
        }
        if (compareRes > 0) {
            return true;
        }
        compareRes = VersionUtil.checkVersionPart(versionTwo[1], versionOne[1]);
        if (compareRes < 0) {
            return false;
        }
        if (compareRes > 0) {
            return true;
        }
        compareRes = VersionUtil.checkVersionPart(versionTwo[2], versionOne[2]);
        return compareRes >= 0;
    }

    public static boolean isSameOrLaterVersionAsServer(String versionString) throws NumberFormatException {
        String serverVersion = Configuration.get(ConfigurationKeys.SERVER_VERSION_NUMBER);
        return VersionUtil.isSameOrLaterVersion(versionString, serverVersion);
    }

    private static int checkVersionPart(Long version1, Long version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 != null && version2 == null) {
            return 1;
        }
        return version1.compareTo(version2);
    }
}

