/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityTitleComparator;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.monitoring.web.BranchingAction;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.util.LastNameAlphabeticComparator;
import org.lamsfoundation.lams.util.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChosenBranchingAJAXAction
extends BranchingAction {
    public static final String PARAM_BRANCH_ID = "branchID";
    public static final String PARAM_MEMBERS = "members";

    public ActionForward assignBranch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        BranchingActivity activity = (BranchingActivity)monitoringService.getActivityById(activityID, BranchingActivity.class);
        if (activity.isChosenBranchingActivity()) {
            request.setAttribute("activityID", (Object)activityID);
            request.setAttribute("lessonID", (Object)lessonId);
            request.setAttribute("title", (Object)activity.getTitle());
            request.setAttribute("languageXML", (Object)this.getLanguageXML());
            request.setAttribute("viewMode", (Object)Boolean.FALSE);
            boolean usersStartedBranching = monitoringService.isActivityAttempted((Activity)activity);
            request.setAttribute("mayDelete", (Object)(!usersStartedBranching ? 1 : 0));
            return mapping.findForward("chosenSelection");
        }
        return this.viewBranching(activity, lessonId, false, mapping, request, monitoringService);
    }

    public ActionForward getBranches(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        BranchingActivity activity = (BranchingActivity)monitoringService.getActivityById(activityID);
        TreeSet<Activity> sortedBranches = new TreeSet<Activity>((Comparator<Activity>)new ActivityTitleComparator());
        sortedBranches.addAll(activity.getActivities());
        String branchesOutput = this.buildBranchStringXML(sortedBranches, monitoringService);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBranches activity id " + activityID + " returning " + branchesOutput));
        }
        this.writeAJAXResponse(response, branchesOutput);
        return null;
    }

    public ActionForward getClassMembersNotGrouped(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        SortedSet<User> users = monitoringService.getClassMembersNotGrouped(lessonID, activityID, false);
        String groupOutput = this.buildUserStringXML(-1L, users);
        this.writeAJAXResponse(response, groupOutput);
        return null;
    }

    public ActionForward getBranchMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long branchID = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_BRANCH_ID);
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        SequenceActivity branch = (SequenceActivity)monitoringService.getActivityById(branchID);
        Group group = branch.getSoleGroupForBranch();
        String userOutput = "";
        if (group != null) {
            TreeSet<User> sortedUsers = new TreeSet<User>((Comparator<User>)new LastNameAlphabeticComparator());
            sortedUsers.addAll(group.getUsers());
            userOutput = this.buildUserStringXML(branchID, sortedUsers);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBranchMembers branch id " + branchID + " returning " + userOutput));
        }
        this.writeAJAXResponse(response, userOutput);
        return null;
    }

    private String buildUserString(SortedSet<User> sortedUsers) {
        String userOutput = "";
        boolean first = true;
        for (User user : sortedUsers) {
            Integer userID = user.getUserId();
            String lastName = user.getLastName();
            String firstName = user.getFirstName();
            if (!first) {
                userOutput = userOutput + ";";
            } else {
                first = false;
            }
            userOutput = userOutput + userID + "," + lastName + "," + firstName;
        }
        return userOutput;
    }

    private String buildUserStringXML(long branchId, SortedSet<User> sortedUsers) {
        String userOutput = "<xml>";
        userOutput = userOutput + "<branchID>" + branchId + "</branchID>";
        userOutput = userOutput + "<users>";
        for (User user : sortedUsers) {
            Integer userID = user.getUserId();
            String lastName = user.getLastName();
            String firstName = user.getFirstName();
            userOutput = userOutput + "<user>";
            userOutput = userOutput + "<id>" + userID + "</id>";
            userOutput = userOutput + "<firstName>" + firstName + "</firstName>";
            userOutput = userOutput + "<lastName>" + lastName + "</lastName>";
            userOutput = userOutput + "<displayName>" + firstName + " " + lastName + "</displayName>";
            userOutput = userOutput + "</user>";
        }
        userOutput = userOutput + "</users></xml>";
        return userOutput;
    }

    private String buildBranchString(TreeSet<Activity> sortedBranches, IMonitoringService monitoringService) {
        String branchesOutput = "";
        boolean first = true;
        for (Activity childActivity : sortedBranches) {
            SequenceActivity branch = (SequenceActivity)monitoringService.getActivityById(childActivity.getActivityId(), SequenceActivity.class);
            Long branchId = branch.getActivityId();
            String name = branch.getTitle();
            int numberOfMembers = 0;
            Group group = branch.getSoleGroupForBranch();
            if (group != null) {
                numberOfMembers = group.getUsers().size();
            }
            if (!first) {
                branchesOutput = branchesOutput + ";";
            } else {
                first = false;
            }
            branchesOutput = branchesOutput + branchId + "," + name + "," + numberOfMembers;
        }
        return branchesOutput;
    }

    private String buildBranchStringXML(TreeSet<Activity> sortedBranches, IMonitoringService monitoringService) {
        String branchOutput = "<xml><branches>";
        for (Activity childActivity : sortedBranches) {
            SequenceActivity branch = (SequenceActivity)monitoringService.getActivityById(childActivity.getActivityId(), SequenceActivity.class);
            Long branchId = branch.getActivityId();
            String name = branch.getTitle();
            int numberOfMembers = 0;
            Group group = branch.getSoleGroupForBranch();
            if (group != null) {
                numberOfMembers = group.getUsers().size();
            }
            branchOutput = branchOutput + "<branch>";
            branchOutput = branchOutput + "<id>" + branchId + "</id>";
            branchOutput = branchOutput + "<name>" + name + "</name>";
            branchOutput = branchOutput + "<numberOfMembers>" + numberOfMembers + "</numberOfMembers>";
            branchOutput = branchOutput + "</branch>";
        }
        branchOutput = branchOutput + "</branches></xml>";
        return branchOutput;
    }

    public ActionForward addMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long branchID = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_BRANCH_ID);
        String members = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_MEMBERS, (boolean)true);
        if (members != null) {
            String[] membersSplit = members.split(",");
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.addUsersToBranch(branchID, membersSplit);
        }
        this.writeAJAXOKResponse(response);
        return null;
    }

    public ActionForward removeMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long branchID = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_BRANCH_ID);
        String members = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_MEMBERS, (boolean)true);
        if (members != null) {
            String[] membersSplit = members.split(",");
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.removeUsersFromBranch(branchID, membersSplit);
        }
        this.writeAJAXOKResponse(response);
        return null;
    }
}

