/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InitializeLessonServlet
extends AbstractStoreWDDXPacketServlet {
    private static Logger log = Logger.getLogger(InitializeLessonServlet.class);
    private static final long serialVersionUID = 6474150792777819606L;
    private static IAuditService auditService;

    protected String process(String lessonPackage, HttpServletRequest request) throws Exception {
        Integer userID;
        auditService = this.getAuditService();
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Integer n = userID = user != null ? user.getUserID() : null;
        if (userID == null) {
            log.error((Object)"Can not find valid login user information");
            FlashMessage flashMessage = new FlashMessage("createLesson", (Object)"Can not find valid login user information", 1);
            return flashMessage.serializeMessage();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("InitializeLessonServlet process received packet " + lessonPackage));
        }
        try {
            IMonitoringService monitoringService = this.getMonitoringService();
            return monitoringService.initializeLesson(userID, lessonPackage);
        }
        catch (Exception e) {
            log.error((Object)"Exception thrown while creating lesson class.", (Throwable)e);
            FlashMessage flashMessage = FlashMessage.getExceptionOccured((String)"initializeLesson", (String)e.getMessage());
            auditService.log(InitializeLessonServlet.class.getName(), e.getMessage());
            return flashMessage.serializeMessage();
        }
    }

    protected String getMessageKey(String packet, HttpServletRequest request) {
        return "initializeLesson";
    }

    public IMonitoringService getMonitoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IMonitoringService)webContext.getBean("monitoringService");
    }

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }
}

