/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MonitoringAction
extends LamsDispatchAction {
    private static final String PREVIEW_DELETED_REPORT_SCREEN = "previewdeleted";
    private static final String NOT_SUPPORTED_SCREEN = "notsupported";
    private static final String TIME_CHART_SCREEN = "timeChart";
    private static final String ERROR = "error";
    public static final String NUM_DELETED = "numDeleted";
    private static IAuditService auditService;

    private Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    private FlashMessage handleException(Exception e, String methodKey, IMonitoringService monitoringService) {
        log.error((Object)("Exception thrown " + methodKey), (Throwable)e);
        auditService = this.getAuditService();
        auditService.log(MonitoringAction.class.getName() + ":" + methodKey, e.toString());
        if (e instanceof UserAccessDeniedException) {
            return new FlashMessage(methodKey, (Object)monitoringService.getMessageService().getMessage("error.user.noprivilege"), 1);
        }
        Object[] msg = new String[]{e.getMessage()};
        return new FlashMessage(methodKey, (Object)monitoringService.getMessageService().getMessage("error.system.error", msg), 2);
    }

    private FlashMessage handleCriticalError(String methodKey, String messageKey, IMonitoringService monitoringService) {
        String message = monitoringService.getMessageService().getMessage(messageKey);
        log.error((Object)("Error occured " + methodKey + " error "));
        auditService = this.getAuditService();
        auditService.log(MonitoringAction.class.getName() + ":" + methodKey, message);
        return new FlashMessage(methodKey, (Object)message, 2);
    }

    private ActionForward redirectToURL(ActionMapping mapping, HttpServletResponse response, String url) throws IOException {
        if (url != null) {
            String fullURL = WebUtil.convertToFullURL((String)url);
            response.sendRedirect(response.encodeRedirectURL(fullURL));
            return null;
        }
        return mapping.findForward(NOT_SUPPORTED_SCREEN);
    }

    public ActionForward initializeLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            String desc;
            String title = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonName");
            if (title == null) {
                title = "lesson";
            }
            if ((desc = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonDescription", (boolean)true)) == null) {
                desc = "description";
            }
            Integer organisationId = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID", (boolean)true);
            long ldId = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID");
            Boolean learnerExportAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerExportPortfolio", (boolean)false);
            Boolean learnerPresenceAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerPresenceAvailable", (boolean)false);
            Boolean learnerImAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerImAvailable", (boolean)false);
            Boolean liveEditEnabled = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"liveEditEnabled", (boolean)false);
            Lesson newLesson = monitoringService.initializeLesson(title, desc, learnerExportAvailable, ldId, organisationId, this.getUserId(), null, learnerPresenceAvailable, learnerImAvailable, liveEditEnabled);
            flashMessage = new FlashMessage("initializeLesson", (Object)newLesson.getLessonId());
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "initializeLesson", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward startLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            monitoringService.startLesson(lessonId, this.getUserId());
            flashMessage = new FlashMessage("startLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "startLesson", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward startOnScheduleLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            String dateStr = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonStartDate");
            Date startDate = DateUtil.convertFromLAMSFlashFormat((String)dateStr);
            Integer timeZoneIdx = WebUtil.readIntParam((HttpServletRequest)request, (String)"scheduleTimeZoneIdx", (boolean)true);
            monitoringService.startLessonOnSchedule(lessonId, startDate, this.getUserId(), timeZoneIdx);
            flashMessage = new FlashMessage("startOnScheduleLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "startOnScheduleLesson", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward finishOnScheduleLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            String dateStr = WebUtil.readStrParam((HttpServletRequest)request, (String)"lessonFinishDate");
            Date finishDate = DateFormat.getInstance().parse(dateStr);
            monitoringService.finishLessonOnSchedule(lessonId, finishDate, this.getUserId());
            flashMessage = new FlashMessage("finishOnScheduleLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "finishOnScheduleLesson", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward archiveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            monitoringService.archiveLesson(lessonId, this.getUserId());
            flashMessage = new FlashMessage("archiveLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "archiveLesson", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward unarchiveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            monitoringService.unarchiveLesson(lessonId, this.getUserId());
            flashMessage = new FlashMessage("unarchiveLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "unarchiveLesson", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward suspendLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            monitoringService.suspendLesson(lessonId, this.getUserId());
            flashMessage = new FlashMessage("suspendLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "suspendLesson", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward unsuspendLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            monitoringService.unsuspendLesson(lessonId, this.getUserId());
            flashMessage = new FlashMessage("unsuspendLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "unsuspendLesson", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward removeLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            monitoringService.removeLesson(lessonId, this.getUserId());
            flashMessage = new FlashMessage("removeLesson", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "removeLesson", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward forceComplete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        FlashMessage flashMessage = null;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityId = null;
        String actId = request.getParameter("activityID");
        if (actId != null) {
            try {
                activityId = new Long(Long.parseLong(actId));
            }
            catch (Exception e) {
                activityId = null;
            }
        }
        try {
            long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            Integer learnerId = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"learnerID"));
            Integer requesterId = this.getUserId();
            String message = monitoringService.forceCompleteLessonByUser(learnerId, requesterId, lessonId, activityId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Force complete for learner " + learnerId + " lesson " + lessonId + ". " + message));
            }
            flashMessage = new FlashMessage("forceComplete", (Object)message);
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "forceComplete", monitoringService);
        }
        String message = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(message);
        return null;
    }

    public ActionForward getLessonDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            wddxPacket = monitoringService.getLessonDetails(lessonID, this.getUserId());
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getLessonDetails", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getLessonLearners(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            wddxPacket = monitoringService.getLessonLearners(lessonID, this.getUserId());
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getLessonLearners", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getLessonStaff(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            wddxPacket = monitoringService.getLessonStaff(lessonID, this.getUserId());
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getLessonStaff", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getLearningDesignDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            wddxPacket = monitoringService.getLearningDesignDetails(lessonID);
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getLearningDesignDetails", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getAllLearnersProgress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)false);
            wddxPacket = monitoringService.getAllLearnersProgress(lessonID, this.getUserId(), false);
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getAllLearnersProgress", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getDictionaryXML(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        MessageService messageService = monitoringService.getMessageService();
        String module = WebUtil.readStrParam((HttpServletRequest)request, (String)"module", (boolean)false);
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)true);
        String orgName = null;
        if (orgId != null) {
            orgName = monitoringService.getOrganisationName(orgId);
        }
        ArrayList<String> languageCollection = new ArrayList<String>();
        if (module.equals("wizard")) {
            languageCollection.add(new String("sys.error.msg.start"));
            languageCollection.add(new String("sys.error"));
            languageCollection.add(new String("wizardTitle.x.lbl"));
            languageCollection.add(new String("finish.btn"));
            languageCollection.add(new String("title.lbl"));
            languageCollection.add(new String("desc.lbl"));
            languageCollection.add(new String("learner.lbl"));
            languageCollection.add(new String("staff.lbl"));
            languageCollection.add(new String("al.alert"));
            languageCollection.add(new String("al.ok"));
            languageCollection.add(new String("al.validation.msg1"));
            languageCollection.add(new String("al.validation.msg2"));
            languageCollection.add(new String("al.validation.msg3.2"));
            languageCollection.add(new String("al.validation.schtime"));
            languageCollection.add(new String("learners.group.name"));
            languageCollection.add(new String("staff.group.name"));
            languageCollection.add(new String("wizard.splitLearners.splitSum"));
            languageCollection.add(new String("wizard.splitLearners.LearnersPerLesson.lbl"));
            languageCollection.add(new String("wizard.splitLearners.cb.lbl"));
            languageCollection.add(new String("wizard.learner.expp.cb.lbl"));
            languageCollection.add(new String("wizard.learner.enLiveEdit.cb.lbl"));
            languageCollection.add(new String("wizard.learner.enpres.cb.lbl"));
            languageCollection.add(new String("wizard.wkspc.date.modified.lbl"));
            languageCollection.add(new String("summery.desc.lbl"));
            languageCollection.add(new String("error.system.error"));
            languageCollection.add(new String("button.ok"));
            languageCollection.add(new String("add.lesson.panel.title"));
            languageCollection.add(new String("lesson.tab.label"));
            languageCollection.add(new String("class.tab.label"));
            languageCollection.add(new String("advanced.tab.label"));
            languageCollection.add(new String("lesson.tab.heading.label"));
            languageCollection.add(new String("add.now.button.label"));
            languageCollection.add(new String("advanced.tab.form.advanced.options.label"));
            languageCollection.add(new String("advanced.tab.form.enable.im.label"));
            languageCollection.add(new String("advanced.tab.form.scheduling.label"));
            languageCollection.add(new String("advanced.tab.form.enable.label"));
            languageCollection.add(new String("advanced.tab.form.validation.no.learners.error"));
            languageCollection.add(new String("advanced.tab.form.item.split.lessons.label"));
            languageCollection.add(new String("advanced.tab.form.details.label"));
            languageCollection.add(new String("class.tab.available.label"));
            languageCollection.add(new String("class.tab.selected.label"));
            languageCollection.add(new String("class.tab.print.name.label"));
            languageCollection.add(new String("class.tab.heading.label"));
            languageCollection.add(new String("advanced.tab.form.validation.schedule.date.error"));
        } else if (module.equals("timechart")) {
            languageCollection.add(new String("sys.error"));
            languageCollection.add(new String("chart.btn.activity.split"));
            languageCollection.add(new String("chart.btn_completion.rate"));
            languageCollection.add(new String("chart.series.completed.time"));
            languageCollection.add(new String("chart.series.average.time"));
            languageCollection.add(new String("chart.series.duration"));
            languageCollection.add(new String("chart.legend.average"));
            languageCollection.add(new String("show.average.checkbox"));
            languageCollection.add(new String("search.learner.textbox"));
            languageCollection.add(new String("chart.learner.linear.axis.title"));
            languageCollection.add(new String("chart.learner.category.axis.title"));
            languageCollection.add(new String("chart.learner.datatip.average"));
            languageCollection.add(new String("label.learner"));
            languageCollection.add(new String("time.chart.panel.title"));
            languageCollection.add(new String("chart.time.format.hours"));
            languageCollection.add(new String("chart.time.format.minutes"));
            languageCollection.add(new String("chart.time.format.seconds"));
            languageCollection.add(new String("label.completed"));
            languageCollection.add(new String("advanced.tab.form.validation.schedule.date.error"));
            languageCollection.add(new String("alert.no.learner.data"));
        }
        String languageOutput = "<xml><language>";
        for (int i = 0; i < languageCollection.size(); ++i) {
            languageOutput = languageOutput + "<entry key='" + (String)languageCollection.get(i) + "'><name>" + messageService.getMessage((String)languageCollection.get(i)) + "</name></entry>";
        }
        if (module.equals("wizard")) {
            String[] ids = User.timezoneList;
            int idx = 0;
            for (String id : ids) {
                languageOutput = languageOutput + "<entry key='timezoneID" + idx + "'><name>" + id + "</name><data>" + TimeZone.getTimeZone(id).getRawOffset() + "</data></entry>";
                ++idx;
            }
            if (orgName != null) {
                languageOutput = languageOutput + "<entry key='orgName'><name>" + orgName + "</name></entry>";
            }
        }
        languageOutput = languageOutput + "</language></xml>";
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().print(languageOutput);
        return null;
    }

    public ActionForward getAllCompletedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)false);
            Long learnerID = WebUtil.readLongParam((HttpServletRequest)request, (String)"learnerID", (boolean)true);
            wddxPacket = monitoringService.getAllCompletedActivities(lessonID, learnerID, this.getUserId());
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getAllLearnersProgress", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getInitialLearnersProgress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)false);
            wddxPacket = monitoringService.getInitialLearnersProgress(lessonID, this.getUserId());
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getInitialLearnersProgress", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getAdditionalLearnersProgress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String wddxPacket;
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)false);
            Integer lastUserID = WebUtil.readIntParam((HttpServletRequest)request, (String)"lastUserID", (boolean)false);
            wddxPacket = monitoringService.getAdditionalLearnersProgress(lessonID, lastUserID, this.getUserId());
        }
        catch (Exception e) {
            wddxPacket = this.handleException(e, "getAdditionalLearnersProgress", monitoringService).serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getAllContributeActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String wddxPacket = null;
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            wddxPacket = monitoringService.getAllContributeActivities(lessonID);
        }
        catch (Exception e) {
            FlashMessage flashMessage = this.handleException(e, "getAllContributeActivities", monitoringService);
            wddxPacket = flashMessage.serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward getLearnerActivityURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Integer learnerUserID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"userID"));
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String url = monitoringService.getLearnerActivityURL(lessonID, activityID, learnerUserID, this.getUserId());
        return this.redirectToURL(mapping, response, url);
    }

    public ActionForward getActivityMonitorURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        String url = monitoringService.getActivityMonitorURL(lessonID, activityID, contentFolderID, this.getUserId());
        return this.redirectToURL(mapping, response, url);
    }

    public ActionForward getActivityDefineLaterURL(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, LamsToolServiceException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
        Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
        String url = monitoringService.getActivityDefineLaterURL(lessonID, activityID, this.getUserId());
        return this.redirectToURL(mapping, response, url);
    }

    public ActionForward moveLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String wddxPacket = null;
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            Integer userID = this.getUserId();
            Integer targetWorkspaceFolderID = new Integer(WebUtil.readIntParam((HttpServletRequest)request, (String)"folderID"));
            wddxPacket = monitoringService.moveLesson(lessonID, targetWorkspaceFolderID, userID);
        }
        catch (Exception e) {
            FlashMessage flashMessage = this.handleException(e, "moveLesson", monitoringService);
            wddxPacket = flashMessage.serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward renameLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String wddxPacket = null;
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            Integer userID = this.getUserId();
            String name = WebUtil.readStrParam((HttpServletRequest)request, (String)"name");
            wddxPacket = monitoringService.renameLesson(lessonID, name, userID);
        }
        catch (Exception e) {
            FlashMessage flashMessage = this.handleException(e, "renameLesson", monitoringService);
            wddxPacket = flashMessage.serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward checkGateStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String wddxPacket = null;
        try {
            Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            wddxPacket = monitoringService.checkGateStatus(activityID, lessonID);
        }
        catch (Exception e) {
            FlashMessage flashMessage = this.handleException(e, "checkGateStatus", monitoringService);
            wddxPacket = flashMessage.serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward releaseGate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        String wddxPacket = null;
        try {
            Long activityID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID"));
            wddxPacket = monitoringService.releaseGate(activityID);
        }
        catch (Exception e) {
            FlashMessage flashMessage = this.handleException(e, "releaseGate", monitoringService);
            wddxPacket = flashMessage.serializeMessage();
        }
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward startPreviewLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            Integer userID = this.getUserId();
            long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            if (new Long(lessonID) != null) {
                monitoringService.createPreviewClassForLesson(userID, lessonID);
                monitoringService.startLesson(lessonID, this.getUserId());
                flashMessage = new FlashMessage("startPreviewSession", (Object)new Long(lessonID));
            } else {
                flashMessage = this.handleCriticalError("startPreviewSession", "error.system.error", monitoringService);
            }
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "startPreviewSession", monitoringService);
        }
        PrintWriter writer = response.getWriter();
        writer.println(flashMessage.serializeMessage());
        return null;
    }

    public ActionForward deleteOldPreviewLessons(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        int numDeleted = monitoringService.deleteAllOldPreviewLessons();
        request.setAttribute(NUM_DELETED, (Object)Integer.toString(numDeleted));
        return mapping.findForward(PREVIEW_DELETED_REPORT_SCREEN);
    }

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }

    public ActionForward learnerExportPortfolioAvailable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            Integer userID = this.getUserId();
            Boolean learnerExportPortfolioAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerExportPortfolio", (boolean)false);
            monitoringService.setLearnerPortfolioAvailable(lessonID, userID, learnerExportPortfolioAvailable);
            flashMessage = new FlashMessage("learnerExportPortfolioAvailable", (Object)"learnerExportPortfolioAvailable");
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "renameLesson", monitoringService);
        }
        String wddxPacket = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward presenceAvailable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            Integer userID = this.getUserId();
            Boolean presenceAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"presenceAvailable", (boolean)false);
            monitoringService.setPresenceAvailable(lessonID, userID, presenceAvailable);
            if (!presenceAvailable.booleanValue()) {
                monitoringService.setPresenceImAvailable(lessonID, userID, false);
            }
            flashMessage = new FlashMessage("presenceAvailable", (Object)"presenceAvailable");
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "presenceAvailable", monitoringService);
        }
        String wddxPacket = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward presenceImAvailable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            Integer userID = this.getUserId();
            Boolean presenceImAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"presenceImAvailable", (boolean)false);
            monitoringService.setPresenceImAvailable(lessonID, userID, presenceImAvailable);
            flashMessage = new FlashMessage("presenceImAvailable", (Object)"presenceImAvailable");
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "presenceImAvailable", monitoringService);
        }
        String wddxPacket = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward liveEditAvailable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        FlashMessage flashMessage = null;
        try {
            Long lessonID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID"));
            Integer userID = this.getUserId();
            Boolean liveEditAvailable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"liveEditAvailable", (boolean)false);
            monitoringService.setLiveEditEnabled(lessonID, userID, liveEditAvailable);
            flashMessage = new FlashMessage("liveEditAvailable", (Object)"liveEditAvailable");
        }
        catch (Exception e) {
            flashMessage = this.handleException(e, "liveEditAvailable", monitoringService);
        }
        String wddxPacket = flashMessage.serializeMessage();
        PrintWriter writer = response.getWriter();
        writer.println(wddxPacket);
        return null;
    }

    public ActionForward viewTimeChart(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        try {
            long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
            monitoringService.openTimeChart(lessonID, this.getUserId());
            request.setAttribute("lessonID", (Object)lessonID);
            request.setAttribute("learnerID", (Object)WebUtil.readLongParam((HttpServletRequest)request, (String)"learnerID", (boolean)true));
        }
        catch (Exception e) {
            request.setAttribute("errorName", (Object)"MonitoringAction");
            request.setAttribute("errorMessage", (Object)e.getMessage());
            return mapping.findForward(ERROR);
        }
        return mapping.findForward(TIME_CHART_SCREEN);
    }
}

