/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.service;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.exception.LearningDesignProcessorException;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceException;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.util.MessageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IMonitoringService {
    public MessageService getMessageService();

    public Lesson initializeLesson(String var1, String var2, Boolean var3, long var4, Integer var6, Integer var7, String var8, Boolean var9, Boolean var10, Boolean var11);

    public String initializeLesson(Integer var1, String var2) throws Exception;

    public Lesson initializeLessonForPreview(String var1, String var2, long var3, Integer var5, String var6, Boolean var7, Boolean var8, Boolean var9);

    public String createLessonClassForLessonWDDX(Integer var1, String var2) throws UserAccessDeniedException;

    public Lesson createLessonClassForLesson(long var1, Organisation var3, String var4, List<User> var5, String var6, List<User> var7, Integer var8) throws UserAccessDeniedException;

    public void startLesson(long var1, Integer var3) throws UserAccessDeniedException;

    public Integer startSystemActivity(Activity var1, Integer var2, Date var3, String var4);

    public ScheduleGateActivity runGateScheduler(ScheduleGateActivity var1, Date var2, String var3);

    public void startLessonOnSchedule(long var1, Date var3, Integer var4, Integer var5) throws UserAccessDeniedException;

    public void finishLessonOnSchedule(long var1, Date var3, Integer var4) throws UserAccessDeniedException;

    public void finishLesson(long var1, Integer var3) throws UserAccessDeniedException;

    public Boolean setLearnerPortfolioAvailable(long var1, Integer var3, Boolean var4);

    public Boolean setPresenceAvailable(long var1, Integer var3, Boolean var4);

    public Boolean setPresenceImAvailable(long var1, Integer var3, Boolean var4);

    public Boolean setLiveEditEnabled(long var1, Integer var3, Boolean var4);

    public String forceCompleteLessonByUser(Integer var1, Integer var2, long var3, Long var5);

    public void archiveLesson(long var1, Integer var3) throws UserAccessDeniedException;

    public void unarchiveLesson(long var1, Integer var3);

    public void suspendLesson(long var1, Integer var3) throws UserAccessDeniedException;

    public void unsuspendLesson(long var1, Integer var3) throws UserAccessDeniedException;

    public void removeLesson(long var1, Integer var3) throws UserAccessDeniedException;

    public GateActivity openGate(Long var1);

    public GateActivity openGateForSingleUser(Long var1, Integer var2);

    public GateActivity closeGate(Long var1);

    public String getLessonDetails(Long var1, Integer var2) throws IOException;

    public String getLessonLearners(Long var1, Integer var2) throws IOException;

    public String getLessonStaff(Long var1, Integer var2) throws IOException;

    public String getLearningDesignDetails(Long var1) throws IOException;

    public String getAllLearnersProgress(Long var1, Integer var2, Boolean var3) throws IOException;

    public String getAllCompletedActivities(Long var1, Long var2, Integer var3) throws IOException;

    public String getInitialLearnersProgress(Long var1, Integer var2) throws IOException;

    public String getAdditionalLearnersProgress(Long var1, Integer var2, Integer var3) throws IOException;

    public String getAllContributeActivities(Long var1) throws IOException, LearningDesignProcessorException;

    public String getLearnerActivityURL(Long var1, Long var2, Integer var3, Integer var4) throws IOException, LamsToolServiceException;

    public String getActivityDefineLaterURL(Long var1, Long var2, Integer var3) throws IOException, LamsToolServiceException;

    public String getActivityMonitorURL(Long var1, Long var2, String var3, Integer var4) throws IOException, LamsToolServiceException;

    public String moveLesson(Long var1, Integer var2, Integer var3) throws IOException;

    public String renameLesson(Long var1, String var2, Integer var3) throws IOException;

    public Activity getActivityById(Long var1);

    public Activity getActivityById(Long var1, Class var2);

    public GroupingActivity getGroupingActivityById(Long var1);

    public String checkGateStatus(Long var1, Long var2) throws IOException;

    public String releaseGate(Long var1) throws IOException;

    public void performChosenGrouping(GroupingActivity var1, List var2) throws LessonServiceException;

    public Lesson createPreviewClassForLesson(int var1, long var2) throws UserAccessDeniedException;

    public void deletePreviewLesson(long var1);

    public int deleteAllOldPreviewLessons();

    public SortedSet<User> getClassMembersNotGrouped(Long var1, Long var2, boolean var3);

    public Group addGroup(Long var1, String var2, boolean var3) throws LessonServiceException, MonitoringServiceException;

    public void removeGroup(Long var1, Long var2) throws LessonServiceException;

    public void addUsersToGroup(Long var1, Long var2, String[] var3) throws LessonServiceException;

    public void removeUsersFromGroup(Long var1, Long var2, String[] var3) throws LessonServiceException;

    public void addUsersToBranch(Long var1, String[] var2) throws LessonServiceException;

    public void removeUsersFromBranch(Long var1, String[] var2) throws LessonServiceException;

    public boolean isActivityAttempted(Activity var1) throws LessonServiceException;

    public void addGroupToBranch(Long var1, String[] var2) throws LessonServiceException;

    public void removeGroupFromBranch(Long var1, String[] var2) throws LessonServiceException;

    public SortedSet<Group> getGroupsNotAssignedToBranch(Long var1) throws LessonServiceException;

    public List<User> getLearnersHaveAttemptedActivity(Activity var1) throws LessonServiceException;

    public LearnerProgress getLearnerProgress(Integer var1, Long var2);

    public List<Long> initializeAndCreateLessons(Integer var1, String var2) throws Exception;

    public void setGroupName(Long var1, String var2);

    public Boolean openTimeChart(long var1, Integer var3) throws UserAccessDeniedException;
}

