/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.monitoring.ContributeActivityDTO;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexLearnerProgressAction
extends Action {
    private static Logger log = Logger.getLogger(ComplexLearnerProgressAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID", (boolean)false);
        Long lessonID = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID", (boolean)false);
        Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)false);
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        Activity activity = monitoringService.getActivityById(activityID);
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (activity.isParallelActivity()) {
            ArrayList<String> urls = new ArrayList<String>();
            ParallelActivity parallelActivity = (ParallelActivity)activity;
            Set parallels = parallelActivity.getActivities();
            for (Activity a : parallels) {
                urls.add(monitoringService.getLearnerActivityURL(lessonID, a.getActivityId(), userID, user.getUserID()));
            }
            request.setAttribute("parallelUrls", urls);
            return mapping.findForward("parallelProgress");
        }
        HashMap<Long, Byte> statusMap = new HashMap<Long, Byte>();
        HashMap<Long, String> urlMap = new HashMap<Long, String>();
        LearnerProgress learnerProgress = monitoringService.getLearnerProgress(userID, lessonID);
        request.setAttribute("hasSequenceActivity", (Object)false);
        ArrayList<ContributeActivityDTO> subActivities = new ArrayList<ContributeActivityDTO>();
        if (activity.isOptionsActivity() || activity.isBranchingActivity()) {
            ComplexActivity complexActivity = (ComplexActivity)activity;
            for (Activity aNext : complexActivity.getActivities()) {
                Activity a = monitoringService.getActivityById(aNext.getActivityId());
                ContributeActivityDTO dto = new ContributeActivityDTO(a);
                subActivities.add(dto);
                Byte status = learnerProgress.getProgressState(a);
                statusMap.put(a.getActivityId(), status);
                if (a.isSequenceActivity()) {
                    request.setAttribute("hasSequenceActivity", (Object)true);
                    SequenceActivity sequenceActivity = (SequenceActivity)a;
                    dto.setChildActivities(new Vector<ContributeActivityDTO>());
                    this.processSequenceChildren(lessonID, userID, monitoringService, user, statusMap, urlMap, learnerProgress, sequenceActivity, dto, null);
                    continue;
                }
                if (!status.equals((byte)2) && !status.equals((byte)1)) continue;
                urlMap.put(a.getActivityId(), monitoringService.getLearnerActivityURL(lessonID, a.getActivityId(), userID, user.getUserID()));
            }
        } else if (activity.isSequenceActivity()) {
            SequenceActivity sequenceActivity = (SequenceActivity)activity;
            this.processSequenceChildren(lessonID, userID, monitoringService, user, statusMap, urlMap, learnerProgress, sequenceActivity, null, subActivities);
        } else {
            log.error((Object)("ComplexLearnerProgress trying to deal with a activity type it doesn't expect. Activity is " + activity));
            return null;
        }
        request.setAttribute("urlMap", urlMap);
        request.setAttribute("statusMap", statusMap);
        request.setAttribute("subActivities", subActivities);
        request.setAttribute("activityTitle", (Object)activity.getTitle());
        return mapping.findForward("complexProgress");
    }

    private void processSequenceChildren(Long lessonID, Integer userID, IMonitoringService monitoringService, UserDTO user, HashMap<Long, Byte> statusMap, HashMap<Long, String> urlMap, LearnerProgress learnerProgress, SequenceActivity sequenceActivity, ContributeActivityDTO parentContributeActivityDTO, List<ContributeActivityDTO> subActivities) throws IOException {
        Activity child = sequenceActivity.getDefaultActivity();
        while (child != null) {
            Byte status = learnerProgress.getProgressState(child);
            statusMap.put(child.getActivityId(), status);
            if (status.equals((byte)2) || status.equals((byte)1)) {
                urlMap.put(child.getActivityId(), monitoringService.getLearnerActivityURL(lessonID, child.getActivityId(), userID, user.getUserID()));
            }
            ContributeActivityDTO dto = new ContributeActivityDTO(child);
            if (subActivities != null) {
                subActivities.add(dto);
            }
            if (parentContributeActivityDTO != null) {
                parentContributeActivityDTO.getChildActivities().add(dto);
            }
            if (child.getTransitionFrom() != null) {
                child = child.getTransitionFrom().getToActivity();
                continue;
            }
            child = null;
        }
    }
}

