/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityTitleComparator;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.monitoring.service.MonitoringServiceProxy;
import org.lamsfoundation.lams.monitoring.web.BranchingAction;
import org.lamsfoundation.lams.util.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupBasedBranchingAJAXAction
extends BranchingAction {
    private static final String GROUPED_SELECTION_SCREEN = "groupedSelection";
    public static final String PARAM_BRANCH_ID = "branchID";
    public static final String PARAM_MAY_DELETE = "mayDelete";
    public static final String PARAM_GROUPS = "groups";

    public ActionForward assignBranch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lessonID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        BranchingActivity activity = (BranchingActivity)monitoringService.getActivityById(activityID, BranchingActivity.class);
        if (activity.isGroupBranchingActivity()) {
            request.setAttribute("activityID", (Object)activityID);
            request.setAttribute("lessonID", (Object)lessonId);
            request.setAttribute("title", (Object)activity.getTitle());
            boolean usersStartedBranching = monitoringService.isActivityAttempted((Activity)activity);
            request.setAttribute(PARAM_MAY_DELETE, (Object)(!usersStartedBranching ? 1 : 0));
            return mapping.findForward(GROUPED_SELECTION_SCREEN);
        }
        return this.viewBranching(activity, lessonId, false, mapping, request, monitoringService);
    }

    public ActionForward getBranches(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        BranchingActivity activity = (BranchingActivity)monitoringService.getActivityById(activityID);
        TreeSet sortedBranches = new TreeSet(new ActivityTitleComparator());
        sortedBranches.addAll(activity.getActivities());
        String branchesOutput = "";
        boolean first = true;
        for (Activity childActivity : sortedBranches) {
            int numberOfGroups;
            SequenceActivity branch = (SequenceActivity)monitoringService.getActivityById(childActivity.getActivityId(), SequenceActivity.class);
            Long branchId = branch.getActivityId();
            String name = branch.getTitle();
            SortedSet groups = branch.getGroupsForBranch();
            int n = numberOfGroups = groups != null ? groups.size() : 0;
            if (!first) {
                branchesOutput = branchesOutput + ";";
            } else {
                first = false;
            }
            branchesOutput = branchesOutput + branchId + "," + name + "," + numberOfGroups;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBranches activity id " + activityID + " returning " + branchesOutput));
        }
        this.writeAJAXResponse(response, branchesOutput);
        return null;
    }

    public ActionForward getGroupsNotAssignedToBranch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long activityID = WebUtil.readLongParam((HttpServletRequest)request, (String)"activityID");
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        SortedSet<Group> groups = monitoringService.getGroupsNotAssignedToBranch(activityID);
        String groupOutput = this.buildGroupString(groups);
        this.writeAJAXResponse(response, groupOutput);
        return null;
    }

    public ActionForward getBranchGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Long branchID = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_BRANCH_ID);
        IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
        SequenceActivity branch = (SequenceActivity)monitoringService.getActivityById(branchID);
        SortedSet groups = branch.getGroupsForBranch();
        String groupOutput = this.buildGroupString(groups);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getBranchGroups branch id " + branchID + " returning " + groupOutput));
        }
        this.writeAJAXResponse(response, groupOutput);
        return null;
    }

    private String buildGroupString(SortedSet<Group> groups) {
        String groupOutput = "";
        boolean first = true;
        for (Group group : groups) {
            if (!first) {
                groupOutput = groupOutput + ";";
            } else {
                first = false;
            }
            groupOutput = groupOutput + group.getGroupId() + "," + group.getGroupName();
        }
        return groupOutput;
    }

    public ActionForward addGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long branchID = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_BRANCH_ID);
        String groups = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_GROUPS, (boolean)true);
        if (groups != null) {
            String[] groupsSplit = groups.split(",");
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.addGroupToBranch(branchID, groupsSplit);
        }
        this.writeAJAXOKResponse(response);
        return null;
    }

    public ActionForward removeGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LessonServiceException {
        Long branchID = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_BRANCH_ID);
        String groups = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_GROUPS, (boolean)true);
        if (groups != null) {
            String[] groupsSplit = groups.split(",");
            IMonitoringService monitoringService = MonitoringServiceProxy.getMonitoringService(this.getServlet().getServletContext());
            monitoringService.removeGroupFromBranch(branchID, groupsSplit);
        }
        this.writeAJAXOKResponse(response);
        return null;
    }
}

