/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.monitoring.web;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InitializeAndCreateLessonsServlet
extends AbstractStoreWDDXPacketServlet {
    private static Logger log = Logger.getLogger(InitializeAndCreateLessonsServlet.class);
    private static final long serialVersionUID = 2349582345234543680L;
    private static IAuditService auditService;
    private static String messageKey;

    protected String process(String lessonPackage, HttpServletRequest request) throws Exception {
        FlashMessage flashMessage;
        Integer userID;
        auditService = this.getAuditService();
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Integer n = userID = user != null ? user.getUserID() : null;
        if (userID == null) {
            log.error((Object)"Can not find valid login user information");
            FlashMessage flashMessage2 = new FlashMessage(messageKey, (Object)"Can not find valid login user information", 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("StartLessonsServlet process received packet " + lessonPackage));
        }
        try {
            IMonitoringService monitoringService = this.getMonitoringService();
            List<Long> lessonIds = monitoringService.initializeAndCreateLessons(userID, lessonPackage);
            flashMessage = lessonIds != null && lessonIds.size() > 0 ? new FlashMessage(messageKey, lessonIds) : new FlashMessage(messageKey, (Object)"");
        }
        catch (Exception e) {
            log.error((Object)"Exception thrown while starting lessons.", (Throwable)e);
            flashMessage = FlashMessage.getExceptionOccured((String)messageKey, (String)e.getMessage());
            auditService.log(InitializeAndCreateLessonsServlet.class.getName(), e.getMessage());
        }
        return flashMessage.serializeMessage();
    }

    protected String getMessageKey(String packet, HttpServletRequest request) {
        return messageKey;
    }

    public IMonitoringService getMonitoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IMonitoringService)webContext.getBean("monitoringService");
    }

    private IAuditService getAuditService() {
        if (auditService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            auditService = (IAuditService)ctx.getBean("auditService");
        }
        return auditService;
    }

    static {
        messageKey = "initializeAndCreateLessons";
    }
}

